<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>折扣_产品+价格组</title>
    <t:base type="jquery,easyui,tools,actPrice"></t:base>
    <style>
        #content {
            padding :0!important;
        }
        .layout-split-north {
            border-bottom: 1px solid #ffffff;
        }
    </style>
</head>
<body class="easyui-layout">
<input type="hidden" id="startTime" value="${startTime}">
<div data-options="region:'north',split:true" style="height:180px;">
    <input id="budgetCode" name="budgetCode" type="hidden" value="${budgetCode}" required="false" >
    <t:formvalid action="null" layout="div"
                 dialog="true" formid="buyProductForm" beforeSubmit="saveDataEnd()">
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}_discountGroupProductForm">
            <t:dgFormColumn field="categoriesCode" hidden="true" defaultVal="${categoriesCode}" formClass="form" labelName="categoriesCode" optionType="input" required="false"/>
            <t:dgFormColumn field="actSubclassName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动细类" optionType="choseDialog" required="true"
                            onclick="selectActSubClass()" />
            <t:dgFormColumn field="actSubclassCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动细类" optionType="input" required="true"
            />
            <t:dgFormColumn field="isMultipleAudit"  formClass="form" labelName="是否允许多次核销" optionType="input" hidden="true" required="true"
                            defaultVal="${vo.isMultipleAudit}" />
            <t:dgFormColumn field="priceGroup" hidden="false" formClass="biz-col-33 mb5 form" labelName="价格组" optionType="select" required="true"
                             typeGroupCode="price_group" />
            <t:dgFormColumn field="isStack" hidden="false" formClass="form" labelName="是否叠加" optionType="radio" typeGroupCode="is_no" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="form" labelName="备注" optionType="textarea"  required="false"
                            rows="3" cols="5"   style="width: 1106px; height: 53px;"/>
            <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar1" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar2" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar3" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar4" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar5" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar6" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar6" optionType="optionType" required="false"
                            defaultVal=""/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="productDetailList" checkbox="true" fitColumns="false" idField="id" fit="true" singleSelect="false"
                queryMode="group"
                actionUrl=""
                pagination="false" autoLoadData="false"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="商品编码" field="productInfoCode"   width="150"/>
        <t:dgCol title="商品名称" field="productInfoName" width="250"/>
        <t:dgCol title="标准价" field="standPrice" width="100"/>
        <t:dgCol title="折扣比例" field="discountScale" editor="{type:'numberbox',options:{min:0.01,max:1,value:'',missingMessage:'折扣比例必填',required:'true'}}" width="100"/>
        <t:dgCol title="预计销量" field="forecastSalesNum" editor="{type:'numberbox',options:{min:0,value:'',missingMessage:'预计销量必填',required:'true'}}" width="100"/>
        <t:dgCol title="预计销售额" field="forecastSalesAmount" width="100"/>
        <t:dgCol title="申请费用金额" field="amount" width="100"/>
        <t:dgCol title="比例" field="scale"  width="100"/>
        <t:dgToolBar title="选择商品" funname="selectProductCheck" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" funname="updateProductDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" funname="delProductDetail" icon="icon-remove"
                     url=""></t:dgToolBar>
    </t:datagrid>
</div>
</body>

</html>

<script>

    $('input[name=isStack][value="0"]').attr("checked",true);
    $(function () {
        $('#productDetailList').datagrid({
            onDblClickCell: function(index,field,value){
                if(field=="forecastSalesNum"){
                    initEditor(index);
                }else if(field=="discountScale"){
                    initEditor(index);
                }else{
                    endEidtProductDetail();
                    forecastSalesNumblurAll();
                }

            }
        });
        var edit = '${edit}';
        if(edit=="0"){
            var rows = parent.getPaData();
            setValueForPage(rows);
            $("#actSubclassName").val(rows[0].actSubclassName);
            $("#actSubclassCode").val(rows[0].actSubclassCode);
            $("#isMultipleAudit").val(rows[0].isMultipleAudit);
            $("#productNum").val(rows[0].productNum);
            $("#giftNum").val(rows[0].giftNum);
            $("#giftCostPrice").val(rows[0].giftCostPrice);
            $("#customerName").val(rows[0].customerName);
            $("#customerCode").val(rows[0].customerCode);
            $("#terminalName").val(rows[0].terminalName);
            $("#terminalCode").val(rows[0].terminalCode);
            $('input[name=isStack][value="' + rows[0].isStack + '"]').attr("checked",true);
            var giftJson = rows[0].giftJson;
            $('#productDetailList').datagrid('insertRow',{
                index: 0,
                row: {
                    id:rows[0].id,
                    productInfoCode: rows[0].productCode,
                    productInfoName: rows[0].productName,
                    standPrice:rows[0].standPrice,
                    forecastSalesNum:rows[0].forecastSalesNum,
                    forecastSalesAmount:rows[0].forecastSalesAmount,
                    amount:rows[0].amount,
                    discountScale:rows[0].discountScale,
                    scale:rows[0].scale
                }
            });
            editorAll();
        }

    });
    //提前请求，获取一次
    var tableType = "act_price";
    var categoriesCode = $("#categoriesCode").val();
    var budgetCode = $("#budgetCode").val();
    var tableType = "act_price";
    var triggerId = "actSubclassCode";
    var triggerName = "actSubclassName";
    $.ajax({
        type: "GET",
        url: "/budget/ttApiFineController/getActFineList?enableStatus=009&tableType="+tableType+"&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode,
        data: {"budgetCode": budgetCode},
        dataType: "json",
        success: function (data) {
            //如果只有一条，则直接带出
            if(data.length === 1) {
                $("#" + triggerId).val(data[0].fineCode);
                $("#" + triggerName).val(data[0].fineName);
                $("#isMultipleAudit").val(data[0].isMultipleAudit);
                $("#actSubclassName").focus();
            }
        }});
    //选择活动细类
    function selectActSubClass(){
        var tableType = "act_price";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/page/ttApiFineController/goApiActFineMain?tableType="+tableType+"&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'addProductDetailDialog',
            id:'addProductDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#" + triggerId).val(myobj[0].fineCode);
                        $("#" + triggerName).val(myobj[0].fineName);
                        $("#isMultipleAudit").val(myobj[0].isMultipleAudit);
                        $("#actSubclassName").focus();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //选择产品
    function selectProductCheck() {
        selectProduct();
    }

    function selectProduct(){
        var startTime = $("#startTime").val();
        var dictValue = '${dictValue}';
        var rowsDatas = $('#productDetailList').datagrid('getRows');
        var priceGroup = $("#priceGroup").val();
        if (priceGroup == "") {
            tip("请选择价格组");
            return;
        }
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiWareController/goWareListMain?check=false&priceGroup="+priceGroup+"&budgetCode="+budgetCode+"&startTime="+startTime;
        width = 1000;
        height = 450;
        id = "wareList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'selectProductDialog',
            id:'selectProductDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        //检查选择的数据价格是否存在
                        var priceParamVo = new Object();
                        /**价格定价组*/
                        priceParamVo.priceGroup = priceGroup;
                        /**客户编码*/
                        priceParamVo.custCode = "";
                        var productCodes = new Array();
                        for(var i=0;i<rowsData.length;i++){
                            productCodes.push(rowsData[i].wareCode);
                        }
                        priceParamVo.productCodes = productCodes;
                        priceParamVo.priceDate = $("#startTime").val();
                        var map = getpriceForMap(priceParamVo);
                        if(map==null){
                            return true;
                        }
                        var msg = "";
                        if (dictValue == "Y") {
                            for(var i=0;i<rowsData.length;i++){
                                if(map.has(rowsData[i].wareCode)&&map.get(rowsData[i].wareCode)!=""){
                                    $('#productDetailList').datagrid('insertRow',{
                                        index: 0,
                                        row: {
                                            id:generateUUID(),
                                            productInfoCode: rowsData[i].wareCode,
                                            productInfoName: rowsData[i].wareName,
                                            standPrice: map.get(rowsData[i].wareCode)
                                        }
                                    });
                                }else {
                                    msg += rowsData[i].wareCode+",";
                                }

                            }
                        }else{
                            rowsData.forEach(function(item,index){
                                if(!isContain(item,rowsDatas)){
                                    if(map.has(rowsData[index].wareCode)&&map.get(rowsData[index].wareCode)!=""){
                                        $('#productDetailList').datagrid('insertRow',{
                                            index: 0,
                                            row: {
                                                id:generateUUID(),
                                                productInfoCode: rowsData[index].wareCode,
                                                productInfoName: rowsData[index].wareName,
                                                standPrice: map.get(rowsData[index].wareCode)
                                            }
                                        });
                                    }else {
                                        msg += rowsData[index].wareCode+",";
                                    }
                                }
                            });
                        }
                        if(msg!=""){
                            msg = "价格不存在,商品编码为：<br>"+msg;
                            tip(msg);
                        }
                        editorAll();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    function isContain(obj,arr2) {
        let contain = false;
        arr2.forEach(function(item2){
            if(obj.wareCode==item2.productInfoCode){
                contain = true;
                return false;
            }
        })
        return contain;
    }

    //初始化编辑
    function initEditor(index) {
        $("#productDetailList").datagrid('beginEdit',index);
        var forecastSalesNumEd = $('#productDetailList').datagrid('getEditor', {index:index,field:'forecastSalesNum'});
        forecastSalesNumEd.target.numberbox({
            onChange:function(newValue,oldValue){
                forecastSalesNumblur(index,newValue);
            }
        });
        var discountScaleNumEd = $('#productDetailList').datagrid('getEditor', {index:index,field:'discountScale'});
        $(discountScaleNumEd.target).on("change",function(){
            var newValue = $(this).val()
            if (newValue != "") {
                var re=/^(1|0(\.\d{1,2})?)$/;
                if(!re.test(newValue)){
                    tip("请输入0-1之间数字，保留两位小数");
                    $(this).val("");
                    $(this).css("border-color","red");
                }else{
                    discountScaleNumblur(index,newValue);
                    $(this).css("border-color","rgb(149, 184, 231)");
                }
            }
        })

    }

    function forecastSalesNumblurAll() {
        var rows = $('#productDetailList').datagrid('getRows');
        for(var i=0;i<rows.length;i++){
            var index = i;
            var row = rows[index];
            //标准价
            var standPrice = row.standPrice;
            //折扣比例
            var discountScale = row.discountScale;
            //预计销量
            var forecastSalesNum = row.forecastSalesNum;
            //预计销售额
            var forecastSalesAmount = numMulti(numMulti(standPrice,forecastSalesNum),discountScale);
            $('#productDetailList').datagrid('endEdit' ,index);
            if (!isEmpty(discountScale)&&!isEmpty(forecastSalesNum)) {
                //申请费用金额(标准价*（1-打折比例）*预计销量)
                var amount = numMulti(numMulti(standPrice,accSub(1,discountScale)),forecastSalesNum);
                //比例（申请费用金额/预计销售额）
                var scale = numDiv(amount,forecastSalesAmount);
                scale = returnFloatThree(scale);
                $('#productDetailList').datagrid('updateRow',{
                    index: index,
                    row: {
                        amount:amount,
                        forecastSalesAmount:forecastSalesAmount,
                        scale:scale
                    }
                });
            }
        }
        editorAll();
    }

    function forecastSalesNumblur(index,newValue) {
        if(isEmpty(newValue)){
            return;
        }
        endEidtProductDetail();
        forecastSalesNumblurAll();

    }

    function discountScaleNumblur(index,newValue) {
        if(isEmpty(newValue)){
            return;
        }
        endEidtProductDetail();
        forecastSalesNumblurAll();
    }

    //修改产品
    function updateProductDetail() {
        var rowsData = $('#productDetailList').datagrid('getSelections');
        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            for(var i=0;i<rowsData.length;i++){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                initEditor(index);
            }
        }
    }

    //删除产品
    function delProductDetail() {
        var rowsData = $('#productDetailList').datagrid('getSelections');
        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            for(var i=rowsData.length-1;i>=0;i--){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                $("#productDetailList").datagrid("deleteRow",index);
            }
        }
    }

    //选择客户
    function selectCustomer(){
        triggerId = "customerCode";
        triggerName = "customerName";
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiCustomerController/goActCustomerListMain?budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'addCustomerDialog',
            id:'addCustomerDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#customerCode").val(myobj[0].customerCode);
                        $("#customerName").val(myobj[0].customerName);
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //选择门店
    function selectTerminal(){
        var customerCode=$("#customerCode").val();
        if (customerCode ==undefined || customerCode==''){
            tip("请选择客户");
            return ;
        }
        url = "/page/tmApiTerminalController/goTerminalListMain?clickFunctionId=${clickFunctionId}&customerCode="+customerCode;
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'addTerminalDialog',
            id:'addTerminalDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#terminalCode").val(myobj[0].terminalCode);
                        $("#terminalName").val(myobj[0].terminalName);
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //减法
    function accSub(arg1, arg2) {
        var r1, r2, m, n;
        try { r1 = arg1.toString().split(".")[1].length } catch (e) { r1 = 0}
        try { r2 = arg2.toString().split(".")[1].length } catch (e) { r2 = 0}
        m = Math.pow(10, Math.max(r1, r2));
        n = (r1 >= r2) ? r1 : r2;
        return ((arg1 * m - arg2 * m) / m).toFixed(n);
    }
    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };
    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    /**
     * 保留两位小数
     * @param value
     * @returns {number}
     */
    function returnFloat(value){
        var value = Math.round(parseFloat(value) * 100) / 100;
        var s = value.toString().split(".");
        if(s.length== 1){
            value = value.toString() + ".00";
            return value;
        }
        if (s.length > 1) {
            if (s[1].length < 2) {
                value = value.toString() + "0";
            }
            return value;
        }
    }

    /**
     * 保留三位小数
     * @param value
     * @returns {number}
     */
    function returnFloatThree(value){
        var value = Math.round(parseFloat(value) * 1000) / 1000;
        return value.toFixed(3);
    }
    function getpriceForMap(priceParamVo) {

        var map = new Map();
        for(var i=0;i<priceParamVo.productCodes.length;i++){
            map.set(priceParamVo.productCodes[i],"");
        }
        $.ajax({
            url: "/kernel/mdmWareController/getWareStandPriceCommon",
            type: "post",
            dataType: "json",
            async : false,
            data: JSON.stringify(priceParamVo),
            contentType: "application/json",
            complete: function () {
            },
            success: function (res) {
                if (res.success) {
                    if(res.objList){
                        for(var i=0;i<res.objList.length;i++){
                            if(map.has(res.objList[i].wareCode)){
                                map.set(res.objList[i].wareCode,res.objList[i].priceAmount);
                            }
                        }
                    }
                    return map;
                } else {
                    tip(res.msg);
                }
            },
            error: function () {
            }
        });
        return map;
    }
</script>