<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>返利活动</title>
    <t:base type="jquery,easyui,tools" extendUrlKey="TtActRebateForm"></t:base>
    <style>
        #content {
            height: auto !important;
            padding: 0px !important;
        }

        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }

        .layout-split-south {
            border-top: 1px solid #ffffff;
        }

        #actName {
            width: 100% !important;
        }

        .form-group {
            padding: 0px;
        }
    </style>
</head>

<body class="easyui-layout" fit="true" id="globallayout">
<div data-options="region:'north',split:true" style="height:200px;">
    <div class="form-group" id="app">
        <%--关键指标html开始--%>
        <target-table ref="targetTable" :id="id" :page="page" :show-target="isActiviti" :view-status="viewStatus"
                      @refresh="handleRefresh"></target-table>
        <%--关键指标html结束--%>
    </div>
    <t:formvalid action="/act/ttActRebateController/saveOrUpdate" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}" expandParam="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="needShare" hidden="true" formClass="form" labelName="needShare" optionType="input"
                            required="false"
                            defaultVal="${vo.needShare }"/>
            <t:dgFormColumn field="actType" hidden="true" formClass="biz-col-50 mb5 form" labelName="活动类型`" optionType="input"
                            required="false"
                            defaultVal="${vo.actType}"/>
            <t:dgFormColumn field="actCode" hidden="true" formClass="form" labelName="actCode" optionType="input"
                            required="false" defaultVal="${vo.actCode }"/>
            <t:dgFormColumn field="tempUuid" hidden="true" defaultVal="${tempUuid}" formClass="form" labelName="tempUuid" optionType="input"
                            required="false"/>
            <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar1"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar1 }"/>
            <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar2"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar2 }"/>
            <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar3"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar3 }"/>
            <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar4"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar4 }"/>
            <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar5"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar5 }"/>
            <t:dgFormColumn field="extChar6" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar6"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar6 }"/>
            <t:dgFormColumn field="extChar7" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar7"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar7 }"/>
            <t:dgFormColumn field="extChar8" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar8"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar8 }"/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-100 mb5 form" labelName="活动名称"
                            optionType="input" required="true" defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="workFlowKey" hidden="true" formClass="form" labelName="workFlowKey" optionType="input"
                            required="false" defaultVal="${vo.workFlowKey}"/>
            <t:dgFormColumn field="workFlowName" hidden="true" formClass="form" labelName="workFlowName" optionType="input"
                            required="false" defaultVal="${vo.workFlowName}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="预算选择"
                            optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}"/>
            <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目编码" optionType="input"
                            required="false"
                            defaultVal="${vo.budgetSubjectsCode}"/>
            <t:dgFormColumn field="budgetSubjectsName" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目名称" optionType="input"
                            required="false"
                            defaultVal="${vo.budgetSubjectsName}"/>
            <t:dgFormColumn field="categoriesName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动大类"
                            optionType="choseDialog" required="true"
                            onclick="selectCategories()" defaultVal="${vo.categoriesName}"/>
            <t:dgFormColumn field="categoriesCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动大类名称"
                            optionType="input" required="false"
                            defaultVal="${vo.categoriesCode }"/>
            <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false"
                            formClass="biz-col-33 mb5 form" labelName="起止时间" optionType="date_begin_end" required="true"
                            defaultVal="${vo.beginDate}"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 form " labelName="备注" optionType="textarea"
                            required="false"
                            rows="3" cols="5" defaultVal="${vo.remarks}" style="width: 100%; height: 53px;"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="rebateActDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                queryMode="group"
                actionUrl="/act/ttActRebateController/findTtActRebateDetailPage?actCode=${vo.actCode}"
                pagination="false" tagConf="${clickFunctionId}_rebateActDetailList"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="活动细类" field="actDetailCode" hidden="true"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false" width="100"/>
        <t:dgCol title="活动细类编码" field="actSubclassCode" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="政策名称" field="policyName" sortable="false" width="100"/>
        <t:dgCol title="政策编码" field="policyCode" sortable="false" width="100"/>
        <t:dgCol title="客户" field="customerName" sortable="false" width="100"/>
        <t:dgCol title="客户" field="customerCode" hidden="true" sortable="false" width="200"/>
        <t:dgCol title="预估销售额" field="forecastSalesAmount" sortable="false" width="100"/>
        <t:dgCol title="费率" hidden="true" field="feeRate" sortable="false" width="100"/>
        <t:dgCol title="申请费用金额" field="amount" sortable="false" width="100"/>
        <t:dgCol title="返利活动明细类型" field="policyActDetailType" hidden="true" sortable="false" width="200"/>
        <t:dgCol title="核销资料" field="fineName" width="73" sortable="false"/>
        <t:dgCol title="核销资料" field="fineStr" width="73" hidden="true" sortable="false"/>
        <t:dgCol title="支付方式" field="payType" width="100" sortable="false"/>
        <t:dgCol title="资料修改人" field="fineUpdateBy" width="73" sortable="false"/>
        <t:dgCol title="资料修改时间" field="fineUpdateDate" formatter="yyyy-MM-dd HH:mm:ss" width="100" sortable="false"/>
        <t:dgToolBar title="新增按客户" detail="false" funname="addDetailCust" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="新增按政策" detail="false" funname="addDetailPolicy" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="查看" detail="false" funname="lookDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" detail="false" funname="updateDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" detail="false" funname="deleteALLSelectSelf" icon="icon-remove"
                     url="/act/ttActRebateController/delDetail"></t:dgToolBar>
        <c:if test="${isDisplay == '1' }">
            <t:dgToolBar title="导入" detail="false" icon="icon-dataIn" onclick="detailExcel()"></t:dgToolBar>
        </c:if>
        <c:if test="${not empty isdetail}">
            <t:dgToolBar title="核销资料" funname="actfineDetail" detail="true" icon="icon-edit"
                         url=""></t:dgToolBar>
        </c:if>
    </t:datagrid>
</div>
</body>
</html>

<script type="text/javascript">

    //关键指标js开始
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                id: "${vo.id}",
                page: "flhd",
                viewStatus: "${viewStatus}",
                isActiviti: "${isActiviti}"
            }
        },
        methods: {
            handleRefresh: function (target) {
                let this_ = this;
                canSubmit = true;
                let data = createData();
                if (canSubmit) {
                    let postParams = data;
                    $.ajax({
                        url: "/act/ttActRebateController/refresh",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify(postParams),
                        contentType: "application/json",
                        complete: function () {
                        },
                        success: function (res) {
                            closeProgressTop();
                            if (res.success) {
                                this_.$refs.targetTable.setTargetData(res.obj);
                            } else {
                                tip(res.msg);
                            }
                        },
                        error: function () {
                            closeProgressTop();
                        }
                    })
                }
            },
        }
    })

    //关键指标js结束

    function addProductLayout() {
        $('#globallayout').layout('add', {
            region: 'south',
            height: 250,
            split: true,
            collapsible: false
        });
        $('#globallayout').layout("panel", "south").panel({href: "/page/ttActRebateController/goActProductForm"});
    }

    function collapseProductLayout() {
        $("#needShare").val("N");
        $('#globallayout').layout('remove', 'south');
    }

    /*编辑活动明细*/
    function updateDetail() {
        var budgetCode = $("#budgetCode").val();
        var rows = $('#rebateActDetailList').datagrid('getSelections');
        if (rows.length != 1) {
            tip("请选择一条数据操作");
            return;
        }
        var categoriesCode = $("#categoriesCode").val();
        if (categoriesCode == "") {
            tip("请先选择预算");
            return;
        }
        var actSubclassCode = rows[0].actSubclassCode;
        var policyActDetailType = rows[0].policyActDetailType;
        var id = rows[0].id;
        var addurl = "";
        if (policyActDetailType == 1) {
            addurl = "/page/ttActRebateController/goTtActRebateCust?1=1&edit=0&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&id=" + id + "&actSubclassCode=" + actSubclassCode;
        } else {
            addurl = "/page/ttActRebateController/goTtActRebatePolicy?1=1&edit=0&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&id=" + id + "&actSubclassCode=" + actSubclassCode;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'addDetailDialog',
            id: 'addDetailDialogId',
            cache: false,
        };
        if (typeof (options) == "undefined" || typeof (options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    if (policyActDetailType == 1) {
                        iframe = this.iframe.contentWindow;
                        var data = iframe.createData();
                        insertDetailCustData(data);
                        return true;
                    } else {
                        iframe = this.iframe.contentWindow;
                        var data = iframe.createData();
                        insertDetailPolicyData(data);
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    function lookDetail() {
        var budgetCode = $("#budgetCode").val();
        var rows = $('#rebateActDetailList').datagrid('getSelections');
        if (rows.length != 1) {
            tip("请选择一条数据操作");
            return;
        }
        var categoriesCode = $("#categoriesCode").val();
        if (categoriesCode == "") {
            tip("请先选择预算");
            return;
        }
        var policyActDetailType = rows[0].policyActDetailType;
        var actSubclassCode = rows[0].actSubclassCode;
        var id = rows[0].id;
        var addurl = "";
        if (policyActDetailType == 1) {
            addurl = "/page/ttActRebateController/goTtActRebateCust?1=1&load=detail&edit=0&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&id=" + id + "&actSubclassCode=" + actSubclassCode;
        } else {
            addurl = "/page/ttActRebateController/goTtActRebatePolicy?1=1&load=detail&edit=0&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&id=" + id + "&actSubclassCode=" + actSubclassCode;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'lookDetailDialog',
            id: 'lookDetailDialogId',
            cache: false,
        };
        if (typeof (options) == "undefined" || typeof (options.button) == "undefined") {
            $.extend(myOptions, {
                ok: false,
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    /**新增按客户*/
    function addDetailCust() {
        var budgetCode = $("#budgetCode").val();
        var categoriesCode = $("#categoriesCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return;
        }
        var beginDate = $("#beginDate").val();
        if (beginDate == "") {
            tip("请先选择活动开始时间");
            return;
        }
        var addurl = "/page/ttActRebateController/goTtActRebateCust?1=1&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&actBeginDate=" + beginDate + "&clickFunctionId=${clickFunctionId}";
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1200,
            height: 500,
            title: '新增',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'addDetailDialog',
            id: 'addDetailDialogId',
            cache: false,
        };
        if (typeof (options) == "undefined" || typeof (options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.createData();
                    if (data.productDetailRows.length == 0) {
                        return false;
                    }
                    insertDetailCustData(data);
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    function addDetailPolicy() {
        var budgetCode = $("#budgetCode").val();
        var categoriesCode = $("#categoriesCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return;
        }
        var beginDate = $("#beginDate").val();
        if (beginDate == "") {
            tip("请先选择活动开始时间");
            return;
        }
        var addurl = "/page/ttActRebateController/goTtActRebatePolicy?1=1&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&actBeginDate=" + beginDate + "&clickFunctionId=${clickFunctionId}"
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1200,
            height: 500,
            title: '新增',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'addDetailDialog',
            id: 'addDetailDialogId',
            cache: false,
        };
        if (typeof (options) == "undefined" || typeof (options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.createData();
                    if (data.productDetailRows.length == 0) {
                        return false;
                    }
                    insertDetailPolicyData(data);
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }


    /*插入明细数据 根据客户新增*/
    function insertDetailCustData(data) {
        var productDetailRows = data.productDetailRows;
        if (productDetailRows.length == 0) {
            return;
        }
        var rebateDetailListOldRows = $('#rebateActDetailList').datagrid('getRows');
        var rebateDetailListOldObj = [];
        for (var i = 0; i < rebateDetailListOldRows.length; i++) {
            rebateDetailListOldObj.push(rebateDetailListOldRows[i].id);
        }
        var head = data.head;
        var obj = getFineStr(head.actSubclassCode);
        //收集活动细类编码
        for (var i = 0; i < productDetailRows.length; i++) {
            if (rebateDetailListOldObj.includes(productDetailRows[i].id)) {
                $('#rebateActDetailList').datagrid('updateRow', {
                    index: getIndex(productDetailRows[i].id),
                    row: {
                        actSubclassName: head.actSubclassName,
                        actSubclassCode: head.actSubclassCode,
                        customerName: head.customerName,
                        customerCode: head.customerCode,
                        payType: head.payType,
                        fineStr: obj.fineStr,
                        fineName: obj.fineName,
                        policyName: productDetailRows[i].policyName,
                        policyCode: productDetailRows[i].policyCode,
                        forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                        policyActDetailType: 1,
                        feeRate: productDetailRows[i].feeRate,
                        amount: productDetailRows[i].amount
                    }
                });
            } else {
                $('#rebateActDetailList').datagrid('insertRow', {
                    index: 0,
                    row: {
                        id: productDetailRows[i].id,
                        actSubclassName: head.actSubclassName,
                        actSubclassCode: head.actSubclassCode,
                        customerName: head.customerName,
                        customerCode: head.customerCode,
                        payType: head.payType,
                        fineStr: obj.fineStr,
                        fineName: obj.fineName,
                        policyName: productDetailRows[i].policyName,
                        policyCode: productDetailRows[i].policyCode,
                        forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                        policyActDetailType: 1,
                        feeRate: productDetailRows[i].feeRate,
                        amount: productDetailRows[i].amount
                    }
                });
            }
        }
    }

    /*插入明细数据 根据政策新增*/
    function insertDetailPolicyData(data) {
        var productDetailRows = data.productDetailRows;
        if (productDetailRows.length == 0) {
            return;
        }
        var rebateDetailListOldRows = $('#rebateActDetailList').datagrid('getRows');
        var rebateDetailListOldObj = [];
        for (var i = 0; i < rebateDetailListOldRows.length; i++) {
            rebateDetailListOldObj.push(rebateDetailListOldRows[i].id);
        }
        var head = data.head;
        var obj = getFineStr(head.actSubclassCode);
        //收集活动细类编码
        for (var i = 0; i < productDetailRows.length; i++) {
            if (rebateDetailListOldObj.includes(productDetailRows[i].id)) {
                $('#rebateActDetailList').datagrid('updateRow', {
                    index: getIndex(productDetailRows[i].id),
                    row: {
                        actSubclassName: head.actSubclassName,
                        actSubclassCode: head.actSubclassCode,
                        policyName: head.policyName,
                        policyCode: head.policyCode,
                        payType: head.payType,
                        fineStr: obj.fineStr,
                        fineName: obj.fineName,
                        customerName: productDetailRows[i].customerName,
                        customerCode: productDetailRows[i].customerCode,
                        forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                        policyActDetailType: 2,
                        feeRate: productDetailRows[i].feeRate,
                        amount: productDetailRows[i].amount
                    }
                });
            } else {
                $('#rebateActDetailList').datagrid('insertRow', {
                    index: 0,
                    row: {
                        id: productDetailRows[i].id,
                        actSubclassName: head.actSubclassName,
                        actSubclassCode: head.actSubclassCode,
                        policyName: head.policyName,
                        policyCode: head.policyCode,
                        payType: head.payType,
                        fineStr: obj.fineStr,
                        fineName: obj.fineName,
                        customerName: productDetailRows[i].customerName,
                        customerCode: productDetailRows[i].customerCode,
                        forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                        policyActDetailType: 2,
                        feeRate: productDetailRows[i].feeRate,
                        amount: productDetailRows[i].amount
                    }
                });
            }
        }
    }

    function getIndex(id) {
        var tempRows = $('#rebateActDetailList').datagrid('getRows');
        var index = 0;
        for (var i = 0; i < tempRows.length; i++) {
            if (tempRows[i].id == id) {
                index = $("#rebateActDetailList").datagrid("getRowIndex", tempRows[i]);
                break;
            }
        }
        return index;
    }

    /* 提交数据构建 */
    function saveData() {
        var data = createData();
        var actName = $("#actName").val();
        if (actName == "") {
            tip("请填写活动名称");
            return false;
        }
        if (data.details.length == 0) {
            tip("请新增活动明细");
            return false;
        }
        var beginDate = $("#beginDate").val();
        var endDate = $("#endDate").val();
        if ($("#beginDate[dataType]").length > 0) {
            if (beginDate == "") {
                tip("活动开始时间必填");
                return false;
            }
        }
        if ($("#endDate[dataType]").length > 0) {
            if (endDate == "") {
                tip("活动结束时间必填");
                return false;
            }
        }

        $.ajax({
            type: "POST",
            url: "/act/ttActRebateController/saveOrUpdate",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            complete: function () {
                closeProgressTop();
            },
            success: function (data) {
                closeProgressTop();
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.rebatelistsearch();
                    api.close();
                } else {
                    tip(data.msg);
                }
            }
        });
    }

    function createData() {
        var data = {};
        var target = vm.$refs.targetTable.getTargetData();
        data.target = vm.$refs.targetTable.getTargetData();
        if ("${isActiviti}" == "1") {
            $("#headTarget").val(JSON.stringify(target.headTarget));
            $("#itemTarget").val(JSON.stringify(target.itemTarget));
            $("#workFlowKey").val(target.processKey);
        }
        data.id = $("#id").val();
        var head = {};
        head.id = $("#id").val();
        head.workFlowKey = $("#workFlowKey").val();
        head.workFlowName = $("#workFlowName").val();
        head.actCode = $("#actCode").val();
        head.actName = $("#actName").val();
        head.tempUuid = $("#tempUuid").val();
        head.budgetCode = $("#budgetCode").val();
        head.budgetSubjectsCode = $("#budgetSubjectsCode").val();
        head.budgetSubjectsName = $("#budgetSubjectsName").val();
        head.categoriesCode = $("#categoriesCode").val();
        head.categoriesName = $("#categoriesName").val();
        head.beginDate = $("#beginDate").val();
        head.endDate = $("#endDate").val();
        head.remarks = $("#remarks").val();
        head.extChar1 = $("#extChar1").val();
        head.extChar2 = $("#extChar2").val();
        head.extChar3 = $("#extChar3").val();
        head.extChar4 = $("#extChar4").val();
        head.extChar5 = $("#extChar5").val();
        head.extChar6 = $("#extChar6").val();
        head.extChar7 = $("#extChar7").val();
        head.extChar8 = $("#extChar8").val();
        data.head = head;
        var budgetsArr = [];
        var budgets = {}
        budgets.budgetCode = $("#budgetCode").val();
        budgets.actCode = $("#actCode").val();
        budgetsArr.push(budgets);
        data.budgets = budgetsArr;
        var RebateProductListRows = [];
        if (document.getElementById("tabsContent")) {
            RebateProductListRows = generateShareData();
        }
        data.products = RebateProductListRows;
        var RebateDetailListRows = $('#rebateActDetailList').datagrid('getRows');
        data.details = RebateDetailListRows;
        for (var i = -0; i < data.details.length; i++) {
            var giftJson = data.details[i].giftJson;
            if (!isEmpty(giftJson)) {
                var gifts = JSON.parse(giftJson);
                data.details[i].gifts = gifts
            }
        }
        return data;
    }

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        var beginDate = $("#beginDate").val();//开始时间
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/page/ttApiBudgetController/goApiBudgetMain?clickFunctionId=${clickFunctionId}&tableType=act_rebate&beginDate="+beginDate;
        width = 1300;
        height = 500;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#budgetSubjectsCode").val(myobj[0].budgetSubjectsCode);
                    $("#budgetSubjectsName").val(myobj[0].budgetSubjectsName);
                    var budgetCode = myobj[0].budgetCode;
                    $.ajax({
                        url: "/budget/ttApiCostTypeCategoriesController/getCategoriesListByBudgetCode?budgetCode=" + budgetCode + "&clickFunctionId=${clickFunctionId}",
                        dataType: 'json',
                        type: 'post',
                        async: false,
                        success: function (data) {
                            if (data.length == 1) {
                                $("#categoriesCode").val(data[0].categoriesCode);
                                $("#categoriesName").val(data[0].categoriesName);
                            } else {
                                $("#categoriesCode").val("");
                                $("#categoriesName").val("");
                            }
                        }
                    })
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectCategories() {
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        triggerId = "categoriesCode";
        triggerName = "categoriesName";
        url = "/page/ttApiCostTypeCategoriesController/goApiActSelectCategoriesMain?budgetCode=" + budgetCode;
        width = 600;
        height = 500;
        id = "categoriesList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#categoriesCode").focus();
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].categoriesCode);
                    $("#" + triggerName).val(myobj[0].categoriesName);
                    $("#categoriesName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };

    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    function deleteALLSelectSelf(title, url, gname, deleteCallback) {
        gridname = gname;
        var ids = [];
        var rows = $("#rebateActDetailList").datagrid('getSelections');
        if (rows.length > 0) {
            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'json',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        success: function (data) {
                            var msg = data.msg;
                            if (data.success) {
                                ids = '';
                                for (var i = rows.length - 1; i >= 0; i--) {
                                    var index = $("#rebateActDetailList").datagrid("getRowIndex", rows[i]);
                                    $("#rebateActDetailList").datagrid("deleteRow", index);
                                }
                            } else {
                                tip(msg, 'error');

                            }
                        },
                        error: function () {
                            tip("客户端请求错误", 'error');
                            return false;
                        }
                    });
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }

    var tempId = "";

    function detailExcel() {
        tempId = generateUUID();
        var budgetCode = $("#budgetCode").val();
        var categoriesName = $("#categoriesName").val();
        var categoriesCode = $("#categoriesCode").val();
        var clickFunctionId = '${clickFunctionId}';
        var beginDate = $("#beginDate").val();
        if (budgetCode == '') {
            tip("请选择预算");
            return false;
        } else if (categoriesName == '') {
            tip("请选择活动大类");
            return false;
        } else {
            <c:if test="${not empty importUploadUrl}">
            var data = ${importUploadUrl};
            data.strExtend1 = tempId;
            data.strExtend2 = categoriesCode;
            data.strExtend3 = budgetCode;
            data.strExtend4 = clickFunctionId;
            data.strExtend5 = beginDate;
            importExcel(data, impot)
            </c:if>
        }

    }

    function impot() {
        $.ajax({
            url: "/act/ttActRebateController/findExcelDetail",
            type: "post",
            dataType: "json",
            data: "tempId=" + tempId,
            success: function (res) {
                if (res.success) {
                    tempId = generateUUID();
                    var list = res.objList;
                    if (list && list.length > 0) {
                        for (var i = 0; i < list.length; i++) {
                            $('#rebateActDetailList').datagrid('insertRow', {
                                index: 0,
                                row: list[i]
                            });
                        }
                    }
                } else {
                    tip(res.msg);
                }
            }
        });
    }

    function getFineStr(actSubclassCode) {
        var obj = new Object();
        //ttActQuotaController/getFineStr
        $.ajax({
            url: "/act/ttActQuotaController/getFineStr?actSubclassCode=" + actSubclassCode,
            async: false,
            type: "post",
            dataType: "json",
            contentType: "application/json",
            complete: function () {
            },
            success: function (res) {
                if (res.success) {
                    obj.fineStr = res.obj.fineStr;
                    obj.fineName = res.obj.fineName;
                }
            },
            error: function () {
            }
        })
        return obj;
    }

    //选择核销资料
    function actfineDetail() {
        var rowsData = $('#rebateActDetailList').datagrid('getSelections');
        if (rowsData == null || rowsData.length == 0 || rowsData.length > 1) {
            tip("请选择一条数据");
            return false;
        } else {
            var actSubclassCode = rowsData[0].actSubclassCode;
            var actCode = $("#actCode").val();
            var fineStr = rowsData[0].fineStr;
            var id_ = rowsData[0].id;
            id = "rebateActDetailList";
            var clickFunctionId = '${clickFunctionId}';
            gridname = id;
            $.dialog.setting.zIndex = 99999;
            var addurl = "/page/ttActQuotaController/goActFineForm?actCode=" + actCode + "&actSubclassCode=" + actSubclassCode + "&id=" + id_ + "&actType=7&fineStr=" + fineStr;
            // createwindowExt_("编辑", addurl, 400, 400, {});
            if("${vo.bpmStatus}" =="2"){
                createwindowExt_("编辑", addurl, 400, 400, {});
            }else {
                createdetailwindow("查看", addurl, 400, 400);
            }

        }
    }

    function createwindowExt_(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof (options) == "undefined" || typeof (options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.saveDataForRebate();
                    if (data.success) {
                        var rowsData = $('#rebateActDetailList').datagrid('getSelections');
                        var index = $("#rebateActDetailList").datagrid("getRowIndex", rowsData[0]);
                        $('#rebateActDetailList').datagrid('updateRow', {
                            index: index,
                            row: {
                                fineStr: data.obj.fineStr,
                                fineName: data.obj.fineName,
                                fineUpdateDate: data.obj.fineUpdateDate,
                                fineUpdateBy: data.obj.fineUpdateBy
                            }
                        });
                        return true;
                    } else {
                        iframe.tip(data.msg);
                        return false;
                    }

                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

</script>

