<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>实物费用明细添加</title>
    <t:base type="jquery,easyui,tools,choseSelect" extendUrlKey="TtActPhysicalDetailForm"></t:base>

</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/act/ttActPhysicalController/saveOrUpdateDetail" layout="div" beforeSubmit="canleDisable"
             dialog="true" formid="detailId">
    <t:dgFormList tagConf="${clickFunctionId}_TtActPhysicalDetailForm">
        <t:dgFormColumn field="id" hidden="true" defaultVal="${vo.id}" formClass="form" labelName="id"
                        optionType="input" required="false"/>
        <t:dgFormColumn field="budgetCode" hidden="true" defaultVal="${budgetCode}" formClass="form"
                        labelName="budgetCode" optionType="input" required="false"/>
        <t:dgFormColumn field="tempUuid" hidden="true" defaultVal="${tempUuid}" formClass="form" labelName="id"
                        optionType="input" required="false"/>
        <t:dgFormColumn field="categoriesCode" hidden="true" defaultVal="${categoriesCode}" formClass="form"
                        labelName="categoriesCode" optionType="input" required="false"/>
        <t:dgFormColumn field="actSubclassName" hidden="false" formClass="form" labelName="活动细类"
                        optionType="choseDialog" required="true"
                        onclick="selectActSubClass()" defaultVal="${vo.actSubclassName}" dataType="*"/>
        <t:dgFormColumn field="actSubclassCode" formClass="form" labelName="活动细类编码" optionType="input" hidden="true"
                        required="true"
                        defaultVal="${vo.actSubclassCode}"/>
        <t:dgFormColumn field="isMultipleAudit" formClass="form" labelName="是否允许多次核销" optionType="input" hidden="true"
                        required="false"
                        defaultVal="${vo.isMultipleAudit}"/>
        <input id="subjectsGroupCode" value="${ttFeeBudgetEntity.subjectsGroupCode}" type="hidden">
        <c:choose>
            <c:when test="${ttFeeBudgetEntity.subjectsGroupCode == 'cust_budget'}">
                <t:dgFormColumn field="customerName" hidden="false" formClass="form" labelName="客户名称"
                                optionType="choseDialog" required="true"
                                onclick="selectCustomer()" defaultVal="${vo.customerName}"/>
                <t:dgFormColumn field="customerCode" formClass="form" labelName="客户编码" optionType="input" hidden="true"
                                required="false"
                                defaultVal="${vo.customerCode}"/>
            </c:when>
            <c:when test="${ttFeeBudgetEntity.subjectsGroupCode == 'org_budget'}">
                <t:dgFormColumn field="custJson" hidden="true" formClass="form" labelName="客户json" optionType="input"
                                required="false"/>
                <t:dgFormColumn field="custCodes_1" hidden="false" formClass="form" labelName="客户" optionType="tags"
                                required="false"
                                formTags="${vo.custFormTags}" onclick="selectCustomerTag();"/>
            </c:when>
            <c:otherwise>
                <t:dgFormColumn field="customerName" hidden="false" formClass="form" labelName="客户名称"
                                optionType="choseDialog" required="true"
                                onclick="selectCustomer()" defaultVal="${vo.customerName}" dataType="*"/>
                <t:dgFormColumn field="customerCode" formClass="form" labelName="客户编码" optionType="input" hidden="true"
                                required="true"
                                defaultVal="${vo.customerCode}"/>
            </c:otherwise>
        </c:choose>
        <t:dgFormColumn field="terminalName" hidden="false" formClass="form" labelName="门店名称" optionType="choseDialog"
                        required="false"
                        onclick="selectTerminal()" defaultVal="${vo.terminalName}"/>
        <t:dgFormColumn field="terminalCode" formClass="form" labelName="门店编码" optionType="input" hidden="true"
                        required="false"
                        defaultVal="${vo.terminalCode}"/>
        <t:dgFormColumn field="maktx" hidden="false" formClass="form" labelName="物料名称" optionType="choseDialog"
                        required="true"
                        onclick="selectProductInfo()" defaultVal="${vo.maktx}" dataType="*"/>
        <t:dgFormColumn field="matnr" formClass="form" labelName="物料编码" optionType="input" hidden="true" required="true"
                        defaultVal="${vo.matnr}"/>
        <t:dgFormColumn field="unitConversion" formClass="form" labelName="单位换算系数" optionType="input" hidden="true"
                        required="false"
                        defaultVal=""/>


        <t:dgFormColumn field="price" hidden="${price}" formClass="form" labelName="费用单价" optionType="input"
                        required="false"
                        defaultVal="${vo.price}"/>
        <t:dgFormColumn field="productNum" hidden="false" formClass="form" labelName="数量" optionType="input"
                        required="true"
                        defaultVal="${vo.productNum}"
                        dataType="/^(([1-9][0-9]*)|(([0]\.\d{1,2}|[1-9][0-9]*\.\d{1,2})))$/"/>
        <t:dgFormColumn field="unit" hidden="true" readOnly="true" formClass="form" labelName="单位" optionType="select"
                        required="false"
                        typeGroupCode="basic_unit" defaultVal="${vo.unit}" dataType="*"/>
        <t:dgFormColumn field="unitValue" hidden="false" readOnly="true" formClass="form" labelName="单位"
                        optionType="input" required="true"
                        defaultVal="${vo.unitValue}" dataType="*"/>

        <t:dgFormColumn field="miniPack" hidden="${miniPack}" formClass="form" labelName="最小包装量" optionType="input"
                        required="false"
                        defaultVal="${vo.miniPack}"/>
        <t:dgFormColumn field="extChar1" hidden="true" formClass="form" labelName="扩展字段1" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar1}"/>
        <t:dgFormColumn field="extChar2" hidden="true" formClass="form" labelName="扩展字段2" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar2}"/>
        <t:dgFormColumn field="extChar3" hidden="true" formClass="form" labelName="扩展字段3" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar3}"/>
        <t:dgFormColumn field="amount" hidden="${amount}" formClass="form" labelName="申请金额" optionType="input"
                        required="false"
                        defaultVal="${vo.amount}" readOnly="true"/>
        <t:dgFormColumn field="remarks" hidden="false" cols="4" rows="3" formClass="form" labelName="备注"
                        optionType="textarea" required="false"
                        defaultVal="${vo.remarks }"/>
    </t:dgFormList>
    <div>

    </div>
</t:formvalid>
<script>
    var id = '${vo.id}';
    if (!isEmpty(id)) {
        var actSubclassCode = '${vo.actSubclassCode}';
        checkAndDeal(actSubclassCode);
    } else {
        //设置默认客户
        var budgetCode = $("#budgetCode").val();
        if (!isEmpty(budgetCode)) {
            if (isExitsFunction("initSelect")) {
                initSelect(budgetCode);
            } else {
                initCust(budgetCode);
            }
        }
    }

    function initCust(budgetCode) {
        $.ajax({
            type: "GET",
            url: "/budget/ttFeeBudgetController/getEntity",
            data: {"budgetCode": budgetCode},
            dataType: "json",
            success: function (data) {
                if (data.success) {
                    var obj = data.obj;
                    if (obj) {
                        var custCode = obj.custCode;
                        var custName = obj.custName;
                        if (!isEmpty(custCode)) {
                            $("#customerCode").val(custCode);
                            $("#customerName").val(custName);
                            // $("#customerName").removeAttr("onclick");阿其把这个放开就是
                        }

                    }
                }
            }
        });
    }

    $(function () {
        $("#custCodes_1").on('click', '.biz-tag-close', function () {
            $(this).parent().remove();
        });
    });

    //禁用单位下拉框，由选择物料控制
    $("#unit").attr("disabled", "disabled");

    //提交之前取消select禁用
    function canleDisable() {
        $("#unit").removeAttr("disabled");
        var subjectsGroupCode = $("#subjectsGroupCode").val();
        if (subjectsGroupCode == "org_budget") {
            var tags = getTags("custCodes_1");
            if (tags.length == 0) {
                tip("请选择客户");
                return false;
            }
            $("#custJson").val(JSON.stringify(tags));
        }
    }

    //选择细类
    function selectActSubClass(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        var tableType = "phyis";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/page/ttApiFineController/goApiActFineMain?tableType=" + tableType + "&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].fineCode);
                    $("#" + triggerName).val(myobj[0].fineName);
                    $("#isMultipleAudit").val(myobj[0].isMultipleAudit);
                    checkAndDeal(myobj[0].fineCode);
                    $("#actSubclassName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "customerCode";
        triggerName = "customerName";
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiCustomerController/goActCustomerListMain?clickFunctionId=${clickFunctionId}&budgetCode=" + budgetCode;
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].customerCode);
                    $("#" + triggerName).val(myobj[0].customerName);
                    $("#customerName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectCustomerTag(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "customerCode";
        triggerName = "customerName";
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiCustomerController/goActCustomerListMain?clickFunctionId=${clickFunctionId}&check=true&singleSelect=false&budgetCode=" + budgetCode;
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    var tagArray = [];
                    $(myobj).each(function (index, item) {
                        var tag = {};
                        tag["name"] = item.customerName;
                        tag["code"] = item.customerCode;
                        tagArray.push(tag);
                    });

                    renderTag("custCodes_1", tagArray);
                    var tags = getTags("custCodes_1");
                    $("#custJson").val(JSON.stringify(tags));
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        var customerCode = "";
        var custList = "";
        var subjectsGroupCode = $("#subjectsGroupCode").val();
        if (subjectsGroupCode == "org_budget") {
            var tags = getTags("custCodes_1");
            if (tags.length == 0) {
                tip("请选择客户");
                return false;
            }
            for (var i = 0; i < tags.length; i++) {
                custList += tags[i].code + ",";
            }
        } else {
            customerCode = $("#customerCode").val();
            if (customerCode == undefined || customerCode == '') {
                tip("请选择客户");
                return;
            }
        }

        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/page/tmApiTerminalController/goTerminalListMain?clickFunctionId=${clickFunctionId}&customerCode=" + customerCode + "&enableStatus=009&custList=" +
            custList.substring(0, custList.length - 1);
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    $("#terminalName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }


    function setProductInfo(basicUnit) {
        //异步获取销售单位的数据字典值
        var key = 'basic_unit';
        $.ajax({
            url: "/kernel/kernel-api/knlApiDictController/getDictByParamObj",
            data: {
                dictTypeCode: key,
                dictCode: basicUnit
            },
            dataType: 'json',
            type: 'post',
            async: false,
            success: function (data) {
                if (data.success) {
                    if (data.obj != null) {
                        $("#unitValue").val(data.obj.dictValue);
                    } else {
                        $("#unit").val("");
                        tip("获取到数据字典[" + key + "]单位[" + basicUnit + "]配置数据为空!");
                    }
                } else {
                    tip(data.msg);
                    $("#unit").val("");
                }
            }
        })

        var unitConversion = $("#unitConversion").val();
        if (unitConversion == "" || typeof (unitConversion) == "undefined") {
            tip("该物料尚未配置单位换算系数，无法计算申请金额");
        }
        var productNum = $("#productNum").val();
        if (productNum != "" && unitConversion != "") {
            if (isExitsFunction('calculationAmount')) {
                calculationAmount(productNum, unitConversion, $("#price").val());
            } else {
                //金额=数量*物料单位转换系数 *成本价
                $("#amount").val(numMulti(numMulti(productNum, unitConversion), $("#price").val()));
            }
        } else {
            $("#amount").val("");
        }
    }

    //选择产品
    function selectProductInfo() {
        //查询成本价大于0的产品，costPriceGreaterZero为成本价大于0查询字段
        var url = "/page/tmApiProductInfoController/goProductInfoAndCostPriceListMain?check=true&costPriceGreaterZero=true&clickFunctionId=${clickFunctionId}";
        var width = 1000;
        var height = 450;
        id = "productinfoList";
        var gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myObj = eval(rowsData);
                    $("#matnr").val(myObj[0].productInfoCode);
                    $("#maktx").val(myObj[0].productInfoName);
                    $("#unit").val(myObj[0].basicUnit);
                    $("#price").val(myObj[0].costPrice);
                    //单位换算系数
                    $("#unitConversion").val(myObj[0].unitConversion);
                    var basicUnit = myObj[0].basicUnit;
                    setProductInfo(basicUnit);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    $("#productNum").blur(function () {
        var productNum = $("#productNum").val();
        var price = $("#price").val();
        var matnr = $("#matnr").val();
        $.ajax({
            url: "/kernel/mdmProductInfoController/getProductInfoByIdOrCode",
            data: {
                code: matnr
            },
            dataType: 'json',
            type: 'post',
            async: false,
            success: function (data) {
                $("#unitConversion").val(data.obj.unitConversion);
            }
        })
        var unitConversion = $("#unitConversion").val();
        if (price != "" && unitConversion != "" && productNum != "") {
            //扩展计算申请金额js方法
            if (isExitsFunction('calculationAmount')) {
                calculationAmount(productNum, unitConversion, $("#price").val());
            } else {
                $("#amount").val(numMulti(numMulti(productNum, unitConversion), price));
            }
        } else {
            $("#amount").val("");
        }
    })

    var needStatus = 0;
    var needShare = 0;

    function checkAndDeal(actSubclassCode) {
        needStatus = 0;
        needShare = 0;
        if (actSubclassCode == null || actSubclassCode == undefined || actSubclassCode == "") {
            tip("活动细类为空！");
            return;
        }
        $.ajax({
            url: "/budget/ttApiCostTypeFineController/checkfindCostTypeCons",
            type: 'post',
            data: {"actSubclassCode": actSubclassCode},
            cache: false,
            success: function (data) {
                if (data.success) {
                    debugger;
                    needStatus = 0;
                    var attributes = data.attributes;
                    if (attributes) {
                        needShare = attributes.needShare;
                        needStatus = attributes.needStatus;
                        $("#needShare").val(needShare);
                        $("#needStatus").val(needStatus);
                    }
                    //1 发布需要到客户，2 到终端，3 客户与终端都满足
                    if (needStatus == 1) {
                        $("#terminalName").parent().parent().parent().hide();
                        var subjectsGroupCode = $("#subjectsGroupCode").val();
                        if (subjectsGroupCode == "org_budget") {
                            $("#custCodes_1").parent().parent().show();
                        } else {
                            $("#customerName").attr("datatype", "*");
                            $("#customerName").parent().parent().parent().show();
                        }
                    } else if (needStatus == 2) {
                        $("#terminalName").attr("datatype", "*");
                        $("#terminalName").parent().parent().parent().show();
                        var subjectsGroupCode = $("#subjectsGroupCode").val();
                        if (subjectsGroupCode == "org_budget") {
                            $("#custCodes_1").parent().parent().hide();
                        } else {
                            $("#customerName").parent().parent().parent().hide();
                        }
                    } else if (needStatus == 3) {
                        $("#terminalName").attr("datatype", "*");
                        $("#terminalName").parent().parent().parent().show();
                        var subjectsGroupCode = $("#subjectsGroupCode").val();
                        if (subjectsGroupCode == "org_budget") {
                            $("#custCodes_1").parent().parent().show();
                        } else {
                            $("#customerName").attr("datatype", "*");
                            $("#customerName").parent().parent().parent().show();
                        }
                    }

                } else {
                    tip(data.msg);
                }
            }
        });
    }

    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };

    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    /**
     * 保留两位小数
     * @param value
     * @returns {number}
     */
    function returnFloat(value) {
        var value = Math.round(parseFloat(value) * 100) / 100;
        var s = value.toString().split(".");
        if (s.length == 1) {
            value = value.toString() + ".00";
            return value;
        }
        if (s.length > 1) {
            if (s[1].length < 2) {
                value = value.toString() + "0";
            }
            return value;
        }
    }

    // 先调用一次；如果是一条数据的话，则直接写入；
    actSubclassNamekeyopInput('check')

    // 输入
    function actSubclassNamekeyopInput(event) {
        // var that = event.currentTarget;
        // var value = $(that).val();
        var that;
        var value;
        if (typeof event === 'object') {
            that = event.currentTarget;
            value = $(that).val();
        }
        var tableType = "phyis";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        var paramObj = {
            list: [], // 接口返回的数据
            nameList: ['fineName'],  //option上所要显示的数据字段
            valList: [{'key': 'fineCode', 'id': 'actSubclassCode'}], // 其他表单所需要的数据,key为表单展示的值,id为所需展示的表单的id
            hideList: ['fineCode'], // 需要隐藏显示的数据字段
        }
        $.ajax({
            type: "POST",
            url: '/budget/ttApiFineController/getActFineList?enableStatus=009&tableType=' + tableType + '&categoriesCode=' + categoriesCode + '&budgetCode=' + budgetCode,
            async: true,
            data: {'fineName': value},
            success: function (msg) {
                if (msg.length === 1) {
                    // 如果是只有一条；
                    $('#actSubclassName').val(msg[0].fineName);
                    $('#actSubclassCode').val(msg[0].fineCode);
                    checkAndDeal(msg[0].fineCode);
                    return;
                }
                paramObj.list = msg;
                ajaxInput($(that), paramObj);
            }
        });
    }

    function maktxkeyopInput(event) {
        var that = event.currentTarget;
        var value = $(that).val();
        var paramObj = {
            list: [], // 接口返回的数据
            nameList: ['productInfoName'],  //option上所要显示的数据字段
            valList: [{'key': 'productInfoCode', 'id': 'matnr'}, {
                'key': 'basicUnit',
                'id': 'unit'
            }, {'key': 'costPrice', 'id': 'price'}, {'key': 'unitConversion', 'id': 'unitConversion'}], // 其他表单所需要的数据,key为表单展示的值,id为所需展示的表单的id
            hideList: ['productInfoCode', 'basicUnit', 'unitConversion', 'costPrice'], // 需要隐藏显示的数据字段
        }
        $.ajax({
            type: "POST",
            url: '/kernel/mdmProductInfoController/findProductInfoByPage?costPriceGreaterZero=true',
            async: true,
            data: {'productInfoName': value, 'page': '1', 'rows': '20'},
            success: function (msg) {
                paramObj.list = msg.rows;
                ajaxInput($(that), paramObj);
            }
        });
    }


    // 选择
    function chooseOption(event) {
        var that = event.currentTarget;
        var inputVal = $(that).closest('.selectList').siblings('.inputComponent').find('.input');
        inputVal.val($.trim($(that).text()));
        $(that).closest('.selectList').hide();
        var valList = JSON.parse($(that).attr('data-valList'));
        if (valList && valList.length) {
            for (var k = 0; k < valList.length; k++) {
                var value = $(that).attr('data-' + valList[k].key);
                $('#' + valList[k].id).val(value);
            }
        }
        if (inputVal.attr("id") == "actSubclassName") {
            checkAndDeal($("#actSubclassCode").val());
        }
        if (inputVal.attr("id") == "maktx") {
            var basicUnit = $("#unit").val();
            setProductInfo(basicUnit);
        }
        onblurFlag = false;
    }

    function terminalNamekeyopInput(event) {
        var that = event.currentTarget;
        var value = $(that).val();
        var paramObj = {
            list: [], // 接口返回的数据
            nameList: ['terminalName'],  //option上所要显示的数据字段
            valList: [{'key': 'terminalCode', 'id': 'terminalCode'}], // 其他表单所需要的数据,key为表单展示的值,id为所需展示的表单的id
            hideList: ['terminalCode'], // 需要隐藏显示的数据字段
        }
        var customerCode = "";
        var custList = "";
        var budgetCode = $("#budgetCode").val();
        var subjectsGroupCode = $("#subjectsGroupCode").val();
        if (subjectsGroupCode == "org_budget") {
            var tags = getTags("custCodes_1");
            if (tags.length == 0) {
                tip("请选择客户");
                return false;
            }
            for (var i = 0; i < tags.length; i++) {
                custList += tags[i].code + ",";
            }
        } else {
            customerCode = $("#customerCode").val();
            if (customerCode == undefined || customerCode == '') {
                tip("请选择客户");
                return;
            }
        }
        var budgetCode = $("#budgetCode").val();
        $.ajax({
            type: "POST",
            url: '/mdm-api/mdmApi/terminalController/findTmApiTerminalPage?customerCode=' + customerCode + '&custList=' + custList.substring(0, custList.length - 1) + '&budgetCode=' + budgetCode,
            async: true,
            data: {'terminalName': value, 'page': '1', 'rows': '20'},
            success: function (msg) {
                paramObj.list = msg.rows;
                ajaxInput($(that), paramObj);
            }
        });
    }
</script>
</body>
</html>