<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="projectActMain"></t:base>
<div id="quota_list" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="projectlist"  tagConf="${clickFunctionId}" controllerTarget="actProjectController" methedTarget="findActProjectListPage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/act/actProjectController/findActProjectListPage" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar1" field="extChar1"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar2" field="extChar2"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar3" field="extChar3"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar4" field="extChar4"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar5" field="extChar5"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar6" field="extChar6"  hidden="true"></t:dgCol>
            <t:dgCol title="活动编号" field="actCode" query="true"></t:dgCol>
            <t:dgCol title="活动名称" field="actName" query="true"></t:dgCol>
            <t:dgCol title="申请人" field="applyUserName"></t:dgCol>
            <t:dgCol title="申请时间" field="createDateStr" ></t:dgCol>
            <t:dgCol title="申请金额" field="amount"></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="审批状态" field="bpmStatus" dictionary="bpm_status" query="true"></t:dgCol>
            <t:dgCol title="流程编号" field="processKey" query="true"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" width="1000" height="500" url=""
                         funname="addDetail"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit"  width="1000" height="500" url=""
                         funname="updateDetail" callBackBefor="checkData"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-edit"  width="1000" height="500" url=""
                         funname="detailPage"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/act/actProjectController/deleteHead"
                         funname="deleteProjectSelectList" callBackBefor="checkData"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/act/commonExcelController/excel" excelName="项目活动" excelSheetName="项目活动" funname="excelCommonExport"></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                         onclick="importExcel(${importUploadUrl},impot)"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="提交流程" operationCode="commit" icon="icon-edit" width="1400" height="600" url=""
                         funname="commit"></t:dgToolBar>
            <%--<t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/kernel/knlLogController/goShowLog"--%>
                         <%--width="1000" height="500"     funname="detail"></t:dgToolBar>--%>
            <t:dgToolBar operationCode="bpmLog" title="流程日志" icon="icon-log" url="/page/knlLogController/goAuditTaskLogs"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script>

    var pageCode = "xmhd";

    function checkData() {
        var rowsDatas = $('#projectlist').datagrid('getSelections');
        if(rowsDatas.length>0){
            for(var i=0;i<rowsDatas.length;i++){
                if(rowsDatas[i].bpmStatus=='2'||rowsDatas[i].bpmStatus=='3'){
                    tip("流程数据不能操作");
                    return false;
                }
            }
        }
        return true;
    }

    function deleteProjectSelectList(title, url, gname, params) {
        if(!checkData()){
            return;
        }
        gridname = gname;
        var ids = [];
        var rows = $("#" + gname).datagrid('getSelections');
        if (rows.length > 0) {

            if (!checkAndExecallBack_before(params, rows)) {
                return;
            }

            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    startDoALLSelectList(gname, url, rows, params);
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }

    /**提交工作流页面**/
    function commit(width,height) {
        if(isExitsFunction('commitextend')){
            commitextend();
            return;
        }
        var rowsDatas = $('#projectlist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据操作");
            return;
        }
        if(rowsDatas[0].bpmStatus=='2'||rowsDatas[0].bpmStatus=='3'){
            tip("该条数据不能再次提交审批");
            return;
        }
        commitSub(width,height,pageCode, rowsDatas[0].id);
    }
    /**执行提交**/
    function docommit(data){
        openProgressTop("正在提交.......");
        var rowsDatas = $('#projectlist').datagrid('getSelections');
        //封装参数
        data.businessObjId = rowsDatas[0].id;
        data.funcid = "${clickFunctionId}";
        $.ajax({
            type: "POST",
            url: "/act/actProjectController/subActiviti",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            success: function(data){
                if(data.success){
                    $.dialog({id: "activitiSubId"}).close();
                    projectlistsearch();
                    tip(data.msg);
                }else{
                    $.dialog({id: "activitiSubId"}).content.tip(data.msg);
                }
            },
            complete:function () {
                closeProgressTop();
            }
        });
    }
    /**新增*/
    function addDetail(title, url, id, width, height, params) {
            title = "新增";
            url="/page/actProjectController/goSaveUpdate?clickFunctionId=${clickFunctionId}";
            height="600";
            width="1200";
            var _char ="&";
            url += _char;
            createwindowSmallOverAdd(title, url, width, height);
        }
    /**编辑*/
    function updateDetail(title, url, id, width, height, params) {
        if(!checkData()){
            return;
        }
        var rowsDatas = $('#projectlist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据！");
            return;
        }
        title = "编辑";
        url="/page/actProjectController/goSaveUpdate?clickFunctionId=${clickFunctionId}&id="+rowsDatas[0].id;
        height="600";
        width="1200";
        var _char ="&";
        url += _char;
        createwindowSmallOverAdd(title, url, width, height);
    }
    /*查看*/
    function detailPage(title, url, id, width, height, params) {
        var rowsDatas = $('#projectlist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据！");
            return;
        }
        title = "查看";
        url="/page/actProjectController/goSaveUpdate?id="+rowsDatas[0].id+"&clickFunctionId=${clickFunctionId}&load=detail";
        height="600";
        width="1200";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }
        url += _char;
        createwindowSmallOverDetail(title, url, width, height);
    }


    /* 新增编辑弹窗 */
    function createwindowSmallOverAdd(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'projectlistDialog',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.saveData();
                    return false;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        $.dialog(myOptions);
    }
    /* 查看弹窗 */
    function createwindowSmallOverDetail(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'projectlistDialog',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        $.dialog(myOptions);
    }

    function impot() {
        projectlistsearch();
    }

</script>