<%@ page language="java" import="java.util.*"
         contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>公告信息表</title>
    <t:base type="jquery,easyui,tools,DatePicker,ckeditor5,ckfinder"></t:base>
    <script src="/resources/tools/downloadCommon.js"></script>
</head>
<body class="easyui-layout" fit="true" id="region">
<div data-options="region:'center'" style="padding:5px;" fit="true">
        <t:formvalid formid="formobj" dialog="true"  layout="div"
                     action="/kernel/knlNoticeController/saveOrUpdate" beforeSubmit="installItem();">
            <t:dgFormList layoutStyle="horizontal" >
                <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                                defaultVal="${vo.id }"/>
                <t:dgFormColumn field="fileJson" hidden="true" formClass="form" labelName="fileJson" optionType="input" required="false"
                                defaultVal=""/>
                <t:dgFormColumn field="receivingOrgCode" hidden="true" formClass="form" labelName="receivingOrgCode" optionType="input" required="false"
                                defaultVal="${vo.receivingOrgCode }"/>
                <t:dgFormColumn field="noticeTitle" hidden="false" formClass="biz-col-100 mb5 form" labelName="公告标题" optionType="input"  required="true"
                                defaultVal="${vo.noticeTitle}"/>

                <t:dgFormColumn field="noticeContent" formClass="biz-col-100 mb5 form" labelName="公告内容" optionType="rich_text" required="true"
                                style="width: 100%; height: 120px;" rows="3" cols="5" defaultVal="${vo.noticeContent }"
                />
                <t:dgFormColumn field="receivingOrgName" formClass="biz-col-100 mb5 form" labelName="发布范围" readOnly="true" optionType="textarea"  required="true"
                                style="width: 92%; height: 73px;" rows="3" cols="5" defaultVal="${vo.receivingOrgName }"/>
                <t:dgFormColumn field="noticeType" hidden="false" formClass="biz-col-33 mb5 form" labelName="公告类型"
                                optionType="select" typeGroupCode="notice_type" required="true"
                                defaultVal="${vo.noticeType }"/>
                <t:dgFormColumn field="beginDate" hidden="false" formClass="biz-col-33 mb5 form" labelName="开始时间"
                                optionType="date" required="true"
                                defaultVal="${vo.beginDate }"/>
                <t:dgFormColumn field="endDate" hidden="false" formClass="biz-col-33 mb5 form" labelName="结束时间"
                                optionType="date" required="true"
                                defaultVal="${vo.endDate }"/>
            </t:dgFormList>
        </t:formvalid>

</div>

<div data-options="region:'south'" style="padding:5px;height: 300px" fit="true">
    <t:datagrid name="attachmentList" tagConf="${clickFunctionId}" idField="id" queryMode="group"
                actionUrl="/kernel/knlAttachmentController/findAttachmentList?businessKey=${vo.id }" pagination="true">
        <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
        <t:dgCol title="附件名称" field="fileName" width="120"></t:dgCol>
        <t:dgCol title="附件物理路径" field="realPath"  hidden="true"></t:dgCol>
        <t:dgCol title="附件物理绝对路径" field="absPath" hidden="true"></t:dgCol>
        <t:dgCol title="访问url路径" field="urlPath" hidden="true"></t:dgCol>
        <t:dgCol title="扩展名" field="extend" hidden="true"></t:dgCol>
        <t:dgCol title="操作" field="opt" width="120"></t:dgCol>
        <t:dgCol title="操作" field="opt" width="120" ></t:dgCol>
        <t:dgFunOpt funname="downloadFile(id,fileName)" title="下载"></t:dgFunOpt>
        <c:if test="${load ne 'detail'}">
            <t:dgFunOpt funname="deleteFile(id,fileName)" title="删除"></t:dgFunOpt>
        </c:if>
        <t:dgToolBar title="上传附件" detail="false" icon="icon-add" url="" funname="upload" width="400" height="180"></t:dgToolBar>
    </t:datagrid>
</div>
</body>
<%--<link href="/resources/umeditor/themes/default/css/umeditor.css" type="text/css" rel="stylesheet">--%>
<%--<script type="text/javascript" charset="utf-8" src="/resources/ueditor/ueditor.config.js"></script>--%>
<%--<script type="text/javascript" charset="utf-8" src="/resources/ueditor/ueditor.all.min.js"></script>--%>
<%--<script type="text/javascript" src="/resources/umeditor/lang/zh-cn/zh-cn.js"></script>--%>
<script type="text/javascript">
    var noticeId = '${vo.id }';

    function installItem(){
        var rows = $('#attachmentList').datagrid('getRows');
        $("#fileJson").val(JSON.stringify(rows));
    }

    $(function () {
        $('#receivingOrgName').attr("readonly","readonly");
        if("detail"!="${load}"){
            $("#receivingOrgName").after("<a href='#' class='easyui-linkbutton l-btn l-btn-plain' plain='true' icon='icon-search' onclick='goOrg();' id='receivingOrgName_'><span class='l-btn-left'><span class='l-btn-text'><span class='l-btn-empty icon-search'>&nbsp;</span></span></span></a>")
        }
   });


    function goOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "receivingOrgCode";
        triggerName = "receivingOrgName";
        // url = "/page/tmApiOrganController/goOrgListMain?noticeId="+noticeId;
        url = "/page/tmApiOrgController/goOrgListMainPage?singleSelect=false&clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "orgListMain";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    var receivingOrgCode = "";
                    var receivingOrgName = "";
                    console.log(myobj);
                    $(myobj).each(function(index,item){
                        receivingOrgCode += item.orgCode + ",";
                        receivingOrgName += item.orgName + ",";
                    });
                    $("#" + triggerId).val(receivingOrgCode);
                    $("#" + triggerName).val(receivingOrgName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }


    var files = {};
    var deleteIndex = -1;
    var initPage = true;

    //上传附件
    function upload() {

        var url="/upload/uploadController/uploadFileold?1=1";
        importAttach({uploadUrl:url,muilt:true,parent:"attachmentDialogId"},function (res) {
            console.log($.dialog({id: "uploadDialog"}))
            $.dialog({id: "uploadDialog"}).close();
            $.each(res, function (index, value) {
                var fileName = value.obj[0].fileName;
                //默认重传的文件覆盖前面的文件
                var target = files[fileName];
                $('#attachmentList').datagrid('insertRow',{
                    index: 0,
                    row: {
                        id: value.obj[0].id,
                        fileName: value.obj[0].fileName,
                        realPath:value.obj[0].realPath,
                        absPath:value.obj[0].vurlPath,
                        urlPath:value.obj[0].urlPath,
                        extend:value.obj[0].extend
                    }
                });
            });
        });
    }

    //下载附件
    function downloadFile(id,fileName) {
        commonDownload(id);
    }

    //删除附件
    function deleteFile(id,fileName) {
        getIndex(fileName);
        if (deleteIndex == -1){
            return;
        }
        $("#attachmentList").datagrid("deleteRow",deleteIndex);
    }

    function getIndex(fileName) {
        var rows = $("#attachmentList").datagrid("getRows");
        $.each(rows, function (index, value) {
            if (fileName == value.fileName) {
                deleteIndex = index;
            }
        });
        if (deleteIndex == -1){
            return false;
        }
    }
</script>