<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1.0, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>审批详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            font-size: 14px;
            background: #f3f3f3;
        }

        .tabbar {
            box-sizing: border-box;
            border-bottom: 1px solid #ddd;
            height: 40px;
        }

        .tabbar-item span {
            box-sizing: content-box;
            display: inline-block;
            border-bottom-width: 2px;
            border-bottom-style: solid;
            border-bottom-color: transparent;
        }

        .tabbar-item span.active {
            color: #1890ff;
            border-bottom-color: #1890ff;
        }

        .basic-content {
            box-sizing: border-box;
            padding: 10px;
        }

        .approve-info {
            font-size: 14px;
        }

        .approve-textarea {
            width: 100%;
            box-sizing: border-box;
            border-radius: 5px;
            resize: none;
            font-size: 14px;
        }

        .approve-btn {
            background: #1890ff;
            color: #fff;
            padding: 5px 10px;
            outline: none;
            border: none;
            border-radius: 5px;
            font-size: 14px;
        }

        .approve-btn:active {
            opacity: .8;
        }

        .list-content {
            list-style: none;
            padding: 0;
            margin: 0;
            box-sizing: border-box;
        }

        .list-item {
            margin-bottom: 10px;
            padding: 10px;
            font-size: 14px;
            color: #333333;
            background: #ffffff;
            border-radius: 5px;
        }

        .list-item-title {
            width: 100%;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            font-weight: 600;
        }

        .item-label {
            font-weight: 600;
        }

        .item-value {
            color: #666666;
        }

        .iframe-business {
            width: 100%;
            height: calc(100vh - 40px);
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="tabbar flex flex-align-items-center">
        <div class="tabbar-item flex-1 text-center">
            <span @click="handleTab('summary')" class="p5" :class="active==='summary'?'active':''">摘要</span>
        </div>
        <div class="tabbar-item flex-1 text-center p5">
            <span @click="handleTab('basic')" class="p5" :class="active==='basic'?'active':''">基本信息</span>
        </div>
        <div class="tabbar-item flex-1 text-center p5">
            <span @click="handleTab('business')" class="p5" :class="active==='business'?'active':''">业务数据</span>
        </div>
    </div>
    <div v-show="active==='summary'">
        <list-info title="流程名称" :value="process.processDefinitionName"></list-info>
        <list-info title="申请人" :value="process.createUserName"></list-info>
        <list-info title="流程编号" :value="process.processInstanceId"></list-info>
        <list-info title="部门" :value="process.orgName"></list-info>
        <list-info title="创建时间" :value="process.createTime"></list-info>
        <list-info title="主题" :value="process.processTitle"></list-info>
        <list-info title="详情" :value="process.processDetail" type="textarea"></list-info>
    </div>
    <div class="basic-content" v-show="active==='basic'">
        <div class="flex flex-align-items-center">
            <div class="flex-1 text-center">
                <span class="approve-info">申请人：{{process.createUserName}}</span>
            </div>
            <div class="flex-1 text-center">
                <span class="approve-info">提交时间：{{process.createTime|formatDate}}</span>
            </div>
        </div>
        <div class="mt10">
            <ul class="list-content">
                <li class="list-item" v-for="item in dynamicObj.items" :key="item.id">
                    <div class="pv5" v-for="head in dynamicObj.head" :key="head.id">
                        <span class="item-label">{{head.name}}：</span>
                        <span class="item-value">{{item[head.filed]}}</span>
                    </div>
                </li>
            </ul>
        </div>
        <div class="approve-advice">
            <div class="flex flex-align-items-center flex-justify-content-between pv10">
                <button class="approve-btn" @click="handleCommunicate" v-if="showBtn2&&!booView">沟通</button>
                <button class="approve-btn" @click="handleCc" v-if="showBtn3&&!booView">传阅</button>
                <button class="approve-btn" @click="handleRedirect" v-if="showBtn4&&!booView">转办</button>
                <button class="approve-btn" @click="handleConfirm" v-if="showBtn5">确认沟通</button>
            </div>
            <div v-if="!booView">
                <textarea v-model="comment" class="approve-textarea" rows="5" placeholder="请填写审批意见"></textarea>
            </div>
            <div class="flex flex-align-items-center flex-justify-content-between pv10">
                <div v-if="showCheckbox">
                    <label class="flex flex-align-items-center">
                        是否返回本节点：<input type="checkbox" v-model="returnThisNode">
                    </label>
                </div>
                <div v-if="showBtn6&&!booView">
                    <select v-model="rejectNode">
                        <option value="">选择驳回节点</option>
                        <option v-for="node in nodes" :value="node.id" :key="node.id">{{node.name}}</option>
                    </select>
                </div>
            </div>
            <div class="flex flex-align-items-center flex-justify-content-between pv10">
                <button class="approve-btn" @click="handleApprove" v-if="showBtn1&&!booView">审批通过</button>
                <button class="approve-btn" @click="handleReject" v-if="showBtn6&&!booView">驳回</button>
                <button class="approve-btn" @click="handleRejectSend" v-if="showBtn7&&!booView">驳回发起人</button>
            </div>
        </div>
        <ul class="list-content">
            <li class="list-item" v-for="(log,index) in logs" :key="index">
                <div class="pv5">
                    <span class="item-label">审批人：</span>
                    <span class="item-value">{{log.account}}</span>
                </div>
                <div class="pv5 flex flex-align-items-center">
                    <div class="flex-1">
                        <span class="item-label">时间：</span>
                        <span class="item-value">{{log.createDate}}</span>
                    </div>
                    <div class="flex-1">
                        <span class="item-label">类型：</span>
                        <span class="item-value">{{log.type}}</span>
                    </div>
                </div>
                <div class="pv5">
                    <span class="item-label">审批意见：</span>
                    <span class="item-value">{{log.content}}</span>
                </div>
            </li>
        </ul>
    </div>
    <div v-show="active==='business'">
        <%--<iframe v-if="dataView" :src="dataView" frameborder="0" class="iframe-business"></iframe>--%>
    </div>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>

<script>
    function onJsJumpWithUrl(url) {
        js.onJsJumpWithUrl(url);
    }

    function pop(step) {
        js.pop(step);
    }

    function backPop(step) {
        var u = navigator.userAgent;
        var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
        if (isAndroid) {
            pop(step);
        }
        if (isiOS) {
            window.webkit.messageHandlers.pop.postMessage(step);
        }
    }

    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                token: "",
                taskId: "",
                processInstanceId: "",
                active: "basic",
                booView:false,
                dataView: "",
                process: {},
                communicateId: "",
                rejectNode: "",//选择的返回节点
                returnThisNode: false,//是否返回本节点
                dynamicObj: {
                    head: [],
                    items: []
                },
                comment: "",//审批意见
                showBtn1: false,//审批通过
                showBtn2: false,//沟通
                showBtn3: false,//转办
                showBtn4: false,//传阅
                showBtn5: false,//确认沟通
                showBtn6: false,//驳回
                showBtn7: false,//驳回发起人
                showCheckbox: false,//是否返回本节点
                logs: [],//记录
                nodes: [],//驳回节点
            }
        },
        created: function () {
            this.booView = getParameterByName("isView")||false;
            this.token = getParameterByName("token");
            this.taskId = getParameterByName("taskId");
            this.processInstanceId = getParameterByName("processInstanceId");
            this.loadData();
        },
        filters: {
            formatDate: function (date) {
                if (!date) return;
                date = date.replace(/-/g, "/");
                date = new Date(date);
                let year = date.getFullYear();
                let month = date.getMonth() + 1;
                let day = date.getDate();
                month = month + '';
                month = month[1] ? month : '0' + month;
                day = day + '';
                day = day[1] ? day : '0' + day;
                return [year, month, day].join("-");
            }
        },
        methods: {
            handleTab: function (type) {
                this.active = type
            },
            loadData: function () {
                let this_ = this;
                $.ajax({
                    url: "/activiti/taTaskMobileController/getTaskDetail",
                    type: "post",
                    dataType: "json",
                    data: {
                        booView: this.booView,
                        taskId: this.taskId,
                        processInstanceId: this.processInstanceId,
                        isCommunicate: "N"
                    },
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            this_.booView = res.obj.booView;
                            this_.dataView = res.obj.dataView;
                            this_.process = res.obj.processVo;
                            this_.dynamicObj = res.obj.object || {
                                head: [],
                                items: []
                            };
                            this_.communicateId = res.obj.communicateId;
                            this_.logs = res.obj.log || [];
                            this_.node = res.obj.processNode || [];
                            this_.showBtn1 = res.obj.nodeAuth.btn1 === "Y";
                            this_.showBtn2 = res.obj.nodeAuth.btn2 === "Y";
                            this_.showBtn3 = res.obj.nodeAuth.btn3 === "Y";
                            this_.showBtn4 = res.obj.nodeAuth.btn4 === "Y";
                            this_.showBtn5 = res.obj.isCommunicate === "Y";
                            this_.showBtn6 = res.obj.nodeAuth.btn7 === "Y";
                            this_.showBtn7 = (!res.obj.booView) && res.obj.nodeAuth.btn8 === "Y";
                            this_.showCheckbox = res.obj.hasRejectNodes && res.obj.nodeAuth.btn6 === "Y";
                        } else {
                            showError(res.msg)
                        }
                    }
                })
            },
            //沟通
            handleCommunicate: function () {
                let url = "/page/sfaWebController/memberList?taskId=" + this.taskId + "&type=communicate&processInstanceId=" + this.processInstanceId;
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if (isAndroid) {
                    onJsJumpWithUrl(url);
                }
                if (isiOS) {
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            },
            //传阅
            handleCc: function () {
                let url = "/page/sfaWebController/memberList?taskId=" + this.taskId + "&type=cc&processInstanceId=" + this.processInstanceId;
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if (isAndroid) {
                    onJsJumpWithUrl(url);
                }
                if (isiOS) {
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            },
            //转办
            handleRedirect: function () {
                let url = "/page/sfaWebController/redirectList?taskId=" + this.taskId;
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if (isAndroid) {
                    onJsJumpWithUrl(url);
                }
                if (isiOS) {
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            },
            //确认沟通
            handleConfirm: function () {
                let this_ = this;
                if (!this.comment.trim()) {
                    showError("请输入意见");
                    return;
                }
                var formData = {
                    content: this.comment,
                    communicateId: this.communicateId
                };
                $.ajax({
                    async: false,
                    cache: false,
                    type: 'POST',
                    data: formData,
                    datatype: 'json',
                    url: "'/activiti/taCommunicateController/saveSureCommunicate",// 请求的action路径
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (data) {
                        if (data.success) {
                            vm.loadData();
                        } else {
                            showError(data.msg);
                        }
                    }
                });
            },
            //同意审批
            handleApprove: function () {
                let this_ = this;
                var formData = {
                    taskId: this.taskId,
                    comment: this.comment ? this.comment : "同意",
                    processInstanceId: this.processInstanceId
                };
                $.ajax({
                    async: false,
                    cache: false,
                    type: 'POST',
                    data: formData,
                    datatype: 'json',
                    url: "/activiti/taTaskController/saveComplete",// 请求的action路径
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (data) {
                        if (data.success) {
                            backPop(1);
                        } else {
                            showError(data.msg);
                        }
                    }
                });
            },
            //驳回
            handleReject: function () {
                let this_ = this;
                var returnThisNode = $("input:checkbox:checked").val();
                if (!this.comment) {
                    showError("请填写意见");
                    return;
                }
                if (!this.rejectNode) {
                    showError("请选择驳回节点");
                    return;
                }
                var formData = {
                    taskId: this.taskId,
                    comment: this.comment,
                    processInstanceId: this.processInstanceId,
                    taskDefKey: node,
                    returnThisNode: returnThisNode ? "Y" : "N"
                };
                $.ajax({
                    type: "post",
                    data: formData,
                    url: "/activiti/taTaskController/saveReject",
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (data) {
                        if (data.success) {
                            backPop(1);
                        } else {
                            showError(data.msg);
                        }
                    }
                });
            },
            //驳回发起人
            handleRejectSend: function () {
                let this_ = this;
                if (!this.comment.trim()) {
                    showError("请输入意见");
                    return;
                }
                var formData = {
                    taskId: this.taskId,
                    comment: this.comment,
                    processInstanceId: this.processInstanceId
                };
                $.ajax({
                    async: false,
                    cache: false,
                    type: 'POST',
                    data: formData,
                    datatype: 'json',
                    url: "/activiti/taTaskController/saveRejectToApply",
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (data) {
                        if (data.success) {
                            backPop(1);
                        } else {
                            showError(data.msg);
                        }
                    }
                });
            },
        }
    })
</script>
</body>

</html>