<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<script type="text/javascript">
    //流程对象
    var line = workflow.getLine(nodeid);
    //author:zhangdaihao date:20140802 for:去掉空格
    if (line.condition != null && line.condition != "") {
        line.condition = line.condition.replace(/(^\s*)|(\s*$)/g, "");
    }


    //获取执行监听器id
    function getOldListenerIds() {
        var listeners = line.listeners;
        var listenersIds = [];
        for (var i = 0; i < listeners.getSize(); i++) {
            var listener = listeners.get(i);
            listenersIds.push(listener.getId());
        }
        return listenersIds.join(",");
    }

    //添加执行监听器
    function addListener(id, event, serviceType, value) {
        var ls = line.getListener(id);
        if (!ls) {
            var listener = new draw2d.DecoratedConnection.Listener();
            listener.id = id;
            listener.event = event;
            listener.serviceType = serviceType;
            listener.serviceClass = value;
            listener.serviceExpression = value;
            line.addListener(listener);
        }
    }

    //删除执行监听器
    function removeListener(id) {
        line.deleteListener(id);
    }

    function resetListeners() {
        line.setListeners(new draw2d.ArrayList());
    }

    //属性表格定义
    rows = [
        {"name": "ID", "group": "节点属性", "value": line.lineId, "field": "id", "editor": "text"},
        {"name": "Lable", "group": "节点属性", "value": line.lineName, "field": "name", "editor": "text"},
        {"name": "表达式", "group": "分支条件", "value": line.condition, "field": "condition", "editor": "text"},
        {"name": "默认流转", "group": "节点属性", "value": line.defaultFlow, "field": "defaultFlow","editor": "text"}

    ];

    //保存属性
    function saveFlowProperties() {
        line.lineId = rows[0].value;
        line.lineName = rows[1].value;
        line.condition = rows[2].value;
        line.defaultFlow = rows[3].value;
        line.setLabel(rows[1].value);
    }

    //构建属性表格数据
    function populateFlowProperites() {
        rows[0].value = line.lineId;
        rows[1].value = line.lineName;
        rows[2].value = line.condition;
        rows[3].value = line.defaultFlow;
        flowpropertygrid();
    }

    //加载属性表格数据
    function flowpropertygrid() {
        $('#flow-properties').propertygrid('loadData', rows);
    }

    $(function () {
//创建属性表格
        $('#flow-properties').propertygrid({
            width: 'auto',
            height: 'auto',
            showGroup: true,
            scrollbarSize: 0,
            border: 0,
            columns: [[
                {field: 'name', title: '属性名', width: 30, resizable: false},
                {field: 'value', title: '属性值', width: 100, resizable: false}
            ]],
            onAfterEdit: function () {
                saveFlowProperties();//自动保存
            }
        });
        flowpropertygrid();
    });
</script>
<div id="flow-properties-layout" class="easyui-layout" fit="true">
    <div id="flow-properties-panel" region="center" border="true">
        <div id="flow-properties-accordion" class="easyui-accordion" fit="true" border="false">
            <div id="flow" style="padding: 1px;" title="流程属性面板" class="properties-menu">
                <table id="flow-properties">
                </table>
            </div>
            <div id="flowlisteners" title="执行监听器" style="overflow: hidden; padding: 1px;">
                <t:datagrid title="添加删除操作,需点击保存" name="flowlistenerList" fitColumns="true"
                            actionUrl="${activitiRoot}taListenerController/findSelectedListenerList?1=1"
                            extendParams="queryParams:{ids:getOldListenerIds()}" pagination="false" idField="id">
                    <t:dgCol title="id" hidden="true" field="id"></t:dgCol>
                    <t:dgCol title="名称" field="listenerName" width="30"></t:dgCol>
                    <t:dgCol title="事件" field="listenerEvent" width="30"></t:dgCol>
                    <t:dgCol title="类型" field="listenerType" width="30"></t:dgCol>
                    <t:dgCol title="执行内容" field="listenerValue" width="50"></t:dgCol>
                    <t:dgCol title="操作" field="opt" width="30"></t:dgCol>
                    <t:dgFunOpt funname="delRow(id)" title="删除"></t:dgFunOpt>
                </t:datagrid>
                <div id="flowlistenerListtb" style="padding:3px; height: 25px">
                    <div style="float: left;">
                        <div class="form">
                            <input name="listenerId" type="hidden" id="listenerId">
                            <input name="listenerName" type="hidden" id="listenerName">
                            <input name="listenerEvent" type="hidden" id="listenerEvent">
                            <input name="listenerType" type="hidden" id="listenerType">
                            <input name="listenerValue" type="hidden" id="listenerValue">
                            <t:choose hiddenName="listenerId" hiddenid="id" fun="saveFlowListener"
                                      url="/page/taListenerController/goListenerListPage?typeId=1"
                                      textname="listenerName,listenerEvent,listenerType,listenerValue"
                                      name="listenerList" icon="icon-add" title="监听列表"/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    //保存监听
    function saveFlowListener(obj) {
        var listenerIds = obj.listenerId;
        var listenerEvents = obj.listenerEvent;
        var listenerTypes = obj.listenerType;
        var listenerValues = obj.listenerValue;
        var listenerNames = obj.listenerName;

        for (var i = 0; i < listenerIds.length; i++) {
            var ls = line.getListener(listenerIds[i]);
            if (!ls) {
                $('#flowlistenerList').datagrid('appendRow', {
                    id: listenerIds[i],
                    listenerName: listenerNames[i],
                    listenerEvent: listenerEvents[i],
                    listenerType: listenerTypes[i],
                    listenerValue: listenerValues[i]
                });
            }
        }

        // 依据当前的表格,重置listener.
        resetListeners();
        var dataRowListeners = $('#flowlistenerList').datagrid('getData').rows;

        for (var i = 0; i < dataRowListeners.length; ++i) {
            var row = dataRowListeners[i];
            //console.log(JSON.stringify(row));
            addListener(row.id, row.listenerEvent, row.listenerType, row.listenerValue);
        }
    }

    //删除流程监听
    function delRow(rowid, idx) {
        $('#flowlistenerList').datagrid('deleteRow', idx);
        removeListener(rowid);
    }
</script>
