<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>附件上传</title>
<t:base type="jquery,easyui,tools"></t:base>
</head>
<body class="easyui-layout" fit="true">
    <div>
        <t:formvalid formid="formobj" layout="div" dialog="true" refresh="true" action="/act/ttActAttachmentController/saveUploadFile">
            <div id="attachmentForm" style="display:none;">

            </div>
            <input type="hidden" id="businessKey" name="businessKey" value="${businessKey}">
            <input type="hidden" id="attachmentType" name="attachmentType" value="${attachmentType}">
        </t:formvalid>
    </div>
    <div region="center" style="padding: 1px;">
        <t:datagrid name="attachmentList" tagConf="${clickFunctionId}" idField="id" queryMode="group"
                    actionUrl="/act/ttActAttachmentController/findAttachmentList?businessKey=${businessKey}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="附件名称" field="attachmentTitle" width="120"></t:dgCol>
            <t:dgCol title="附件物理路径" field="realPath"  hidden="true"></t:dgCol>
            <t:dgCol title="附件物理绝对路径" field="absPath" hidden="true"></t:dgCol>
            <t:dgCol title="访问url路径" field="urlPath" hidden="true"></t:dgCol>
            <t:dgCol title="扩展名" field="extend" hidden="true"></t:dgCol>
            <t:dgCol title="操作" field="opt" width="120"></t:dgCol>
            <t:dgFunOpt funname="downloadFile(id,attachmentTitle)" title="下载"></t:dgFunOpt>
            <t:dgFunOpt funname="deleteFile(id,attachmentTitle)" title="删除"></t:dgFunOpt>
            <t:dgToolBar title="上传附件" detail="false" icon="icon-add" url="" funname="upload" width="400" height="180"></t:dgToolBar>
        </t:datagrid>
    </div>
    <a id="a-upload"></a>
</body>
</html>
<script type="text/javascript">
    var files = {};
    var rowIndex = 0;
    var deleteIndex = -1;
    var initPage = true;

    //上传附件
    function upload() {

        //写历史数据
        if (initPage){
            var row = $("#attachmentList").datagrid('getRows');
            $.each(row, function (index, value) {
                files[value.attachmentTitle] = index;
                rowIndex ++;
            });
            initPage = false;
        }

        var url="/upload/uploadController/uploadFileold?1=1";
        importAttach({uploadUrl:url,muilt:true,zIndex:4000,parent:"attachmentDialogId"},function (res) {
            console.log($.dialog({id: "uploadDialog"}));
            $.dialog({id: "uploadDialog"}).close();
            $.each(res, function (index, value) {
                var fileName = value.obj[0].fileName;
                //默认重传的文件覆盖前面的文件
                var target = files[fileName];
                if (target != undefined){
                    getIndex(fileName);
                    $("#attachmentList").datagrid("deleteRow",deleteIndex);
                    delete files[fileName];
                    deleteIndex = -1;
                }
                files[fileName] = rowIndex;
                $('#attachmentList').datagrid('insertRow',{
                    index: rowIndex,
                    row: {
                        id: value.obj[0].id,
                        attachmentTitle: value.obj[0].fileName,
                        realPath:value.obj[0].realPath,
                        absPath:value.obj[0].vurlPath,
                        urlPath:value.obj[0].urlPath,
                        extend:value.obj[0].extend
                    }
                });
                rowIndex++;
            });
        });
    }

    //下载附件
    function downloadFile(id,attachmentTitle) {
        var link = document.getElementById('a-upload');
        var url = "/upload/downLoadController/commonDownloadFile?1=1&id="+id;
        $(link).attr("href", url);
        $(link).attr("download", attachmentTitle);
        link.click();

    }

    //删除附件
    function deleteFile(id,attachmentTitle) {
        getIndex(attachmentTitle);
        if (deleteIndex == -1){
            return;
        }
        var url = '/act/ttActAttachmentController/removeUploadFile';
        $.ajax({
            type: "post",
            url: url,
            data: {"id":id},
            success: function(data){
                if(data.success){
                    $("#attachmentList").datagrid("deleteRow",deleteIndex);
                    delete files[attachmentTitle];
                    deleteIndex = -1;
                    tip(data.msg);
                }else{
                    tip(data.msg);
                }
            }
        });

    }

    function getIndex(fileName) {
        var rows = $("#attachmentList").datagrid("getRows");
        $.each(rows, function (index, value) {
            if (fileName == value.attachmentTitle) {
                deleteIndex = index;
            }
        });
        if (deleteIndex == -1){
            return false;
        }
    }

    //提交前准备
    function spliceForm(){
        $("#attachmentForm").html("");
        var attachmentRows = $("#attachmentList").datagrid("getRows");
        for(var i = 0;i<attachmentRows.length;i++){
            var id = attachmentRows[i]["id"];
            var attachmentTitle = attachmentRows[i]["attachmentTitle"];
            var realPath = attachmentRows[i]["realPath"];
            var absPath = attachmentRows[i]["absPath"];
            var urlPath = attachmentRows[i]["urlPath"];
            var extend = attachmentRows[i]["extend"];

            $("#attachmentForm").append('<input type="text" name="list['+i+'].id" value="'+id+'" />');
            $("#attachmentForm").append('<input type="text" name="list['+i+'].attachmentTitle" value="'+attachmentTitle+'" />');
            $("#attachmentForm").append('<input type="text" name="list['+i+'].realPath" value="'+realPath+'" />');
            $("#attachmentForm").append('<input type="text" name="list['+i+'].absPath" value="'+absPath+'" />');
            $("#attachmentForm").append('<input type="text" name="list['+i+'].urlPath" value="'+urlPath+'" />');
            $("#attachmentForm").append('<input type="text" name="list['+i+'].extend" value="'+extend+'" />');

        }
    }

</script>