<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools"/>

<div id="leaveMain" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;" id="process-panelss">
        <t:datagrid name="leaveList" fitColumns="true" fit="true" queryMode="group"
                    actionUrl="findLeaveList?1=1" idField="id">
            <t:dgCol title="请假id" field="id" hidden="true"/>
            <t:dgCol title="单据名称" field="processTitle" query="true" width="120"/>
            <t:dgCol title="请假内容" field="content" query="true" width="150"/>
            <t:dgCol title="流程Key" field="processKey" query="true" width="100"/>
            <t:dgCol title="业务配置ID" field="configId" hidden="true"/>
            <t:dgCol title="状态" field="runDes" width="100"/>
            <t:dgCol hidden="true" title="状态ID(该字段隐藏)" field="runState"/>
            <t:dgToolBar title="添加" icon="icon-add" url="${activitiRoot}leaveController/goLeaveForm"
                         funname="addLeave"/>
            <t:dgToolBar title="修改" icon="icon-edit" url="${activitiRoot}leaveController/goLeaveForm?1=1"
                         funname="updateLeave"/>
            <t:dgToolBar title="删除" icon="icon-remove" url="${activitiRoot}leaveController/deleteLeave"
                         funname="deleteLeave"/>
            <t:dgToolBar title="提交申请" icon="icon-add"
                         url="${activitiRoot}taProcessInstanceController/startBusinessProcess?1=1"
                         funname="submitLeave"/>
            <t:dgToolBar title="历史版本" icon="icon-look" url="${activitiRoot}leaveController/goLeaveHisMain?1=1"
                         funname="detail"/>
        </t:datagrid>
    </div>
</div>

<script type="text/javascript">

    function addLeave(title, url, gridname) {
        add(title, url, gridname, 700, 400);
    }

    function updateLeave(title, url, gridname) {
        var rowsData = $('#' + gridname).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择修改项目');
            return;
        }
        if (!rowsData || rowsData[0].runState == 'doing' || rowsData[0].runState == 'completed') {
            tip('已进入流程，不能修改');
            return;
        }
        update(title, url, gridname, 700, 400);
    }

    function deleteLeave(title, url, gridname) {
        var rowsData = $('#' + gridname).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择删除项目');
            return;
        }
        url = url + '?id=' + rowsData[0].id;
        delObj(url, gridname);
    }

    function submitLeave(title, url, name) {
        gridname = name;
        var rowsData = $('#' + gridname).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择提交项目');
            return;
        }
        url = url + "&businessObjId=" + rowsData[0].id + "&id=" + rowsData[0].configId;

        createdialog('确认', '确定提交该记录吗 ?', url, name);
    }

</script>