<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'north',split:true" style="height:180px;">
    <t:formvalid action="/pay/ttActAdvanceController/saveTtActAdvance" layout="div" beforeSubmit="doSave()"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id}"/>
            <t:dgFormColumn field="tempActUuid" hidden="true" formClass="form" labelName="tempActUuid" optionType="input" required="false"
                            defaultVal="${ttActVo.tempUuid}"/>
            <t:dgFormColumn field="tempUuid" hidden="true" formClass="form" labelName="tempUuid" optionType="input" required="false"
                            defaultVal="${tempUuid}"/>
            <t:dgFormColumn field="updatedJsonData" hidden="true" formClass="form" labelName="updatedJsonData" optionType="input" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="actCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="actCode" optionType="input" required="false"
                            defaultVal="${ttActVo.actCode}" readOnly="false"/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动名称" optionType="choseDialog"  required="true"
                            defaultVal="${ttActVo.actName}" onclick="selectAct();" />
            <t:dgFormColumn field="beginDate" extendField="endDate"  hidden="false" formClass="biz-col-50 mb5 form" labelName="起止时间" optionType="date_begin_end"  required="true"
                            defaultVal="${ttActVo.beginDate}" extendFieldVal="${ttActVo.endDate}"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                            rows="3" cols="5"    defaultVal="${ttActVo.remarks}" style="width: 80%"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="ttActAdvanceDetaillist"   idField="id" queryMode="group" fit="true" fitColumns="true"
                actionUrl="/pay/ttActAdvanceDetailController/findTtActAdvanceDetailPage?tempUuid=${tempUuid}" pagination="false">
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false"/>
        <t:dgCol title="客户" field="customerName" sortable="false"/>
        <t:dgCol title="门店" field="terminalName" sortable="false" />
        <t:dgCol title="支付方式" field="payType" dictionary="pay_type" sortable="false"/>
        <t:dgCol title="申请金额" field="applyPrice" sortable="false"/>
        <t:dgCol title="预付金额" field="advancePrice" sortable="false" editor="{type:'numberbox',options:{min:0,value:''}}" />
        <t:dgCol title="预付原因" field="advanceDesc" sortable="false" editor="text"/>
        <t:dgCol title="凭证号" field="voucherNo" sortable="false"/>
        <t:dgToolBar title="选择明细" detail="false" icon="icon-add" funname="selectActDetail" width="1000" height="400"
                     url="/page/ttApiActDetailController/goApiActDetailMain"></t:dgToolBar>
        <t:dgToolBar title="删除" detail="false" funname="deleteALLSelect" icon="icon-remove"
                     url="/pay/ttActAdvanceDetailController/delActAdvanceDetail"></t:dgToolBar>
        <t:dgToolBar title="导入" detail="false" funname="add" icon="icon-dataIn"
                     url=""></t:dgToolBar>
    </t:datagrid>
    <t:formvalid action=""  layout="div"  dialog="true" formid="productId">
        <div class="p10">
            <table id="templeteTable" style="width: 100%;" cellpadding="0" cellspacing="1"
                   class="formtable">
                <tbody>
                <tr id='trId___'>
                </tr>
                </tbody>
            </table>
            <div class="p5">
            </div>
            <table id="showTable" class="table-dynamic">
                <thead>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </t:formvalid>
</div>


<script type="text/javascript">
    $(document.body).css({
        "overflow-x":"auto",
        "overflow-y":"auto"
    });
    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        $('#templeteTable').hide();
    });

    function selectAct(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "actCode";
        triggerName = "actName";
        url = "/page/ttApiActController/goApiActAdvanceMain";
        width = 1000;
        height = 500;
        id = "actAdvanceList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].actCode);
                    $("#" + triggerName).val(myobj[0].actName);
                    $("#beginDate").val(myobj[0].beginDate);
                    $("#endDate").val(myobj[0].endDate);
                    $("#tempActUuid").val(myobj[0].tempUuid);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectActDetail(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var tempActUuid = $("#tempActUuid").val();
        if (tempActUuid == "") {
            tip("请选择活动！");
            return false;
        }
        var tempUuid = '${tempUuid}';
        url = "/page/ttApiActDetailController/goApiActDetailMain?tempUuid="+tempActUuid;
        width = 1000;
        height = 500;
        id = "actDetail2Selectlist";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    //提交数据到后台表里
                    $.ajax({
                        url : "/pay/ttActAdvanceDetailController/saveActAdvanceDetail",
                        type : 'post',
                        data : {"tempUuid":tempUuid,"acts":JSON.stringify(rowsData)},
                        cache : false,
                        success : function(data) {
                            tip(data.msg);
                            if (!data.success) {
                                tip(data.msg);
                                return false;
                            }
                            $('#ttActAdvanceDetaillist').datagrid('reload');
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    $(document).ready(function(){
        //初始化编码器，及添加单击行事件开始编辑
        $("#ttActAdvanceDetaillist").datagrid({
            onClickRow:function(rowIndex, rowData){
                $(this).datagrid('beginEdit', rowIndex);
                //
                var editors=$(this).datagrid('getEditors',rowIndex);

            }
        });
    });

    //保存修改操作
    function doSave(){
        var b=false;
        if(formName_detailId.check()){
            var rows=$("#ttActAdvanceDetaillist").datagrid("getRows");
            $.each(rows,function (index,row){
                var rowIndex=$("#ttActAdvanceDetaillist").datagrid("getRowIndex",row);
                $("#ttActAdvanceDetaillist").datagrid('endEdit', rowIndex);
            });
            if (!(rows==null || rows==undefined|| rows.length==0)){  //有修改时需要提交一次方法
                // alert(JSON.stringify(rows));
                $("#updatedJsonData").val(JSON.stringify(rows));
                b=sub();
            }else{
                $("#updatedJsonData").val('[]');
                b=sub();
            }
        }
        return b;
    }

    function sub(){
        var b=true;
        return b;
    }

</script>
</body>
</html>