<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>工作历史总结</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/css/mescroll.min.css">
    <link rel="stylesheet" href="/resources/sfa/fontawesome/css/font-awesome.min.css">

    <style>
        body {
            background: #f3f3f3;
        }

        .search-bar {
            height: 40px;
            padding: 0 15px;
            margin: 10px 0;
            width: 100%;
            box-sizing: border-box;
            position: absolute;
            top: 0;
            z-index: 50;
        }

        .search-input {
            width: 100%;
            position: relative;
        }

        .search-input > input {
            width: 100%;
            box-sizing: border-box;
            border: 1px solid #eee;
            height: 35px;
            line-height: 35px;
            border-radius: 5px;
            font-size: 14px;
            padding: 0 10px 0 30px;
            outline: none;
        }

        .search-icon {
            position: absolute;
            left: 10px;
            top: 7px;
        }

        .search-icon > span {
            color: #aaa;
        }

        .history-list {
            padding: 0 15px;
            box-sizing: border-box;
        }

        .history-list-item {
            background: #fff;
            border-radius: 5px;
        }

        .history-item-title {
            height: 45px;
            border-bottom: 1px solid #ddd;
            padding: 0 15px;
        }

        .history-item-type {
            font-size: 18px;
            color: #1678E3;
        }

        .color-date {
            color: #1678E3;
        }

        .color-week {
            color: #1678E3;
        }

        .color-month {
            color: #1678E3;
        }

        .history-item-date {
            color: #999999;
            font-size: 14px;
        }

        .history-item-content p {
            margin: 0;
            padding: 0;
            color: #999999;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .history-item-content p.title {
            margin: 5px 0;
            color: #333;
        }

        .history-item-content p.content {
            margin-top: 10px;
            background: #F8F8F8;
            padding: 10px;
            border-radius: 5px;
        }

        .mescroll {
            position: fixed;
            top: 55px;
            bottom: 0;
            height: auto;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="search-bar">
        <form @submit.prevent="handleSearch">
            <div class="search-input">
                <input type="text" v-model="currentContent" placeholder="请输入关键字">
                <div class="search-icon">
                    <span class="fa fa-search"></span>
                </div>
            </div>
        </form>
    </div>
    <div ref="wrapper" class="mescroll">
        <div class="history-list">
            <div class="history-list-item mb15" v-for="h in historyList" :key="h.id" @click="clickItem(h)">
                <div class="history-item-title flex flex-align-items-center flex-justify-content-between">
                    <div class="history-item-type" :class="getColorClass(h.summaryType)">
                        <span>{{h.summaryTypeStr}}</span></div>
                    <div class="history-item-date"><span>{{h.createName}}</span><span
                            class="ml10">{{h.createDate|formatDate}}</span></div>
                </div>
                <div class="history-item-content p15">
                    <p class="title" v-if="h.summaryType==0">今日工作总结：</p>
                    <p class="title" v-if="h.summaryType==1">本周工作总结：</p>
                    <p class="title" v-if="h.summaryType==2">本月工作总结：</p>
                    <p class="content">{{h.currentContent}}</p>
                    <p class="title" v-if="h.summaryType==0">明日工作计划：</p>
                    <p class="title" v-if="h.summaryType==1">下周工作计划：</p>
                    <p class="title" v-if="h.summaryType==2">下月工作计划：</p>
                    <p class="content">{{h.nextContent}}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>
<script src="/resources/sfa/js/mescroll.min.js"></script>

<script>
    function onJsJumpWithUrl(url) {
        js.onJsJumpWithUrl(url);
    }

    var vm = new Vue({
        el: "#app",
        name: "HistoryList",
        data: function () {
            return {
                currentContent: "",
                page: 1,
                rows: 10,
                token: "",
                historyList: [],
                scroll: null
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.loadData();
        },
        mounted: function () {
            let this_ = this;
            setTimeout(function () {
                this_.scroll = new MeScroll(this_.$refs.wrapper, {
                    down: {
                        callback: this_.downCallback
                    },
                    up: {
                        callback: this_.upCallback,
                        scrollbar: false
                    }
                });
            }, 20)
        },
        computed: {},
        filters:{
            formatDate:function(date){
                if (!date) return;
                date = date.replace(/-/g,"/");
                date = new Date(date);
                let year = date.getFullYear();
                let month = date.getMonth() + 1;
                let day = date.getDate();
                month = month + '';
                month = month[1] ? month : '0' + month;
                day = day + '';
                day = day[1] ? day : '0' + day;
                return [year, month, day].join("-");
            }
        },
        methods: {
            downCallback: function () {
                this.page = 1;
                this.loadData();
            },
            upCallback: function (page, mescroll) {
                this.page = page.num;
                this.loadData()
            },
            handleSearch: function () {
                this.page = 1;
                this.loadData();
            },
            loadData: function () {
                var this_ = this;
                $.ajax({
                    url: SERVER +
                    "/sfaapi/sfaApi/tsWorkSummaryApiController/findHistoryList?page=" +
                    this_.page + "&rows=" + this_.rows,
                    type: "post",
                    data: JSON.stringify({
                        currentContent: this_.currentContent
                    }),
                    dataType: "json",
                    contentType: "application/json",
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            if (this_.page>1) {
                                this_.historyList = this_.historyList.concat(res.obj.list ||
                                    []);
                                this_.scroll && this_.scroll.endByPage(res
                                    .obj.list.length, res.obj.total)
                            } else {
                                this_.historyList = res.obj.list || []
                                this_.scroll && this_.scroll.endByPage(res
                                    .obj.list.length, res.obj.total)
                            }
                        } else {
                            showError(res.msg)
                            this_.scroll && this_.scroll.endErr();
                        }
                    },
                    error: function (error) {
                        this_.scroll && this_.scroll.endErr();
                    }
                })
            },
            clickItem: function (item) {
                let url = "/page/sfaWebController/historyDetail?id=" + item.id;
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if (isAndroid) {
                    onJsJumpWithUrl(url);
                }
                if (isiOS) {
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            },
            getColorClass: function (type) {
                let color = ""
                switch (type) {
                    case "0":
                        color = "color-date";
                        break;
                    case "1":
                        color = "color-week";
                        break;
                    case "2":
                        color = "color-month";
                        break;
                }
                return color;
            },
        }
    })
</script>
</body>

</html>