/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.estimate.service.impl;

import com.biz.eisp.act.act.TtActDetailFeign;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.estimate.dao.TtEstimateExtractDao;
import com.biz.eisp.estimate.service.TtEstimateExtractService;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.pool.TtFeePoolFeign;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.estimate.entity.TtEstimateExtractEntity;
import com.biz.eisp.pay.estimate.vo.TtEstimateExtractVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttEstimateExtractService")
@Transactional
public class TtEstimateExtractServiceImpl
extends BaseServiceImpl<TtEstimateExtractEntity>
implements TtEstimateExtractService {
    @Autowired
    private TtEstimateExtractDao ttEstimateExtractDao;
    @Autowired
    private TtActDetailFeign ttActDetailFeign;
    @Autowired
    private TtFeePoolFeign ttFeePoolFeign;

    @Override
    public PageInfo<TtEstimateExtractVo> findTtEstimateExtractPage(TtEstimateExtractVo entity, Page page) {
        Example example = new Example(TtEstimateExtractEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEstimateType())) {
            criteria.andEqualTo("estimateType", (Object)entity.getEstimateType());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEstimateCode())) {
            criteria.andEqualTo("estimateCode", (Object)entity.getEstimateCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getYear())) {
            criteria.andEqualTo("year", (Object)entity.getYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActYear())) {
            criteria.andEqualTo("actYear", (Object)entity.getActYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActCode())) {
            criteria.andEqualTo("actCode", (Object)entity.getActCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActDetailCode())) {
            criteria.andEqualTo("actDetailCode", (Object)entity.getActDetailCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActName())) {
            criteria.andEqualTo("actName", (Object)entity.getActName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgName())) {
            criteria.andEqualTo("orgName", (Object)entity.getOrgName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgCode())) {
            criteria.andEqualTo("orgCode", (Object)entity.getOrgCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            criteria.andEqualTo("custCode", (Object)entity.getCustCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustName())) {
            criteria.andEqualTo("custName", (Object)entity.getCustName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsCode())) {
            criteria.andEqualTo("budgetSubjectsCode", (Object)entity.getBudgetSubjectsCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsName())) {
            criteria.andEqualTo("budgetSubjectsName", (Object)entity.getBudgetSubjectsName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCategoriesCode())) {
            criteria.andEqualTo("categoriesCode", (Object)entity.getCategoriesCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCategoriesName())) {
            criteria.andEqualTo("categoriesName", (Object)entity.getCategoriesName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getFineCode())) {
            criteria.andEqualTo("fineCode", (Object)entity.getFineCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getFineName())) {
            criteria.andEqualTo("fineName", (Object)entity.getFineName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductLevelCode())) {
            criteria.andEqualTo("productLevelCode", (Object)entity.getProductLevelCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductLevelName())) {
            criteria.andEqualTo("productLevelName", (Object)entity.getProductLevelName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBeginTime())) {
            criteria.andEqualTo("beginTime", (Object)entity.getBeginTime());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEndTime())) {
            criteria.andEqualTo("endTime", (Object)entity.getEndTime());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getPayType())) {
            criteria.andEqualTo("payType", (Object)entity.getPayType());
        }
        if (StringUtil.isNotEmpty((Object)entity.getActAmount())) {
            criteria.andEqualTo("actAmount", (Object)entity.getActAmount());
        }
        if (StringUtil.isNotEmpty((Object)entity.getEstimateAmount())) {
            criteria.andEqualTo("estimateAmount", (Object)entity.getEstimateAmount());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttEstimateExtractDao.selectByExample(example), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtEstimateExtractServiceImpl.class)
    public boolean delete(String id) {
        int i = this.ttEstimateExtractDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public TtEstimateExtractEntity getTtEstimateExtractEntity(String id) {
        return (TtEstimateExtractEntity)this.ttEstimateExtractDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtEstimateExtractServiceImpl.class)
    public void save(TtEstimateExtractVo vo) {
        TtEstimateExtractEntity entity = null;
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(vo);
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
            this.insertSelective(entity);
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtEstimateExtractServiceImpl.class)
    public void update(TtEstimateExtractVo vo) {
        TtEstimateExtractEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(vo);
            this.updateByPrimaryKeySelective(entity);
        }
    }

    private TtEstimateExtractEntity getEntity(TtEstimateExtractVo vo) {
        TtEstimateExtractEntity entity = new TtEstimateExtractEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setActAmount(vo.getActAmount());
        entity.setActCode(vo.getActCode());
        entity.setActDetailCode(vo.getActDetailCode());
        entity.setActName(vo.getActName());
        entity.setActYear(vo.getActYear());
        entity.setBeginTime(vo.getBeginTime());
        entity.setBudgetSubjectsCode(vo.getBudgetSubjectsCode());
        entity.setBudgetSubjectsName(vo.getBudgetSubjectsName());
        entity.setCategoriesCode(vo.getCategoriesCode());
        entity.setCategoriesName(vo.getCategoriesName());
        entity.setCustCode(vo.getCustCode());
        entity.setCustName(vo.getCustName());
        entity.setEndTime(vo.getEndTime());
        entity.setEstimateAmount(vo.getEstimateAmount());
        entity.setEstimateCode(vo.getEstimateCode());
        entity.setEstimateType(vo.getEstimateType());
        entity.setFineCode(vo.getFineCode());
        entity.setFineName(vo.getFineName());
        entity.setOrgCode(vo.getOrgCode());
        entity.setOrgName(vo.getOrgName());
        entity.setPayType(vo.getPayType());
        entity.setProductLevelCode(vo.getProductLevelCode());
        entity.setProductLevelName(vo.getProductLevelName());
        entity.setYear(vo.getYear());
        entity.setProductCode(vo.getProductCode());
        entity.setProductName(vo.getProductName());
        return entity;
    }

    @Override
    public boolean feePoolAmountEstimate() {
        List entities = this.ttFeePoolFeign.getFeePoolDetailForEstimate().getObjList();
        ArrayList<TtEstimateExtractEntity> ttEstimateExtractEntities = new ArrayList<TtEstimateExtractEntity>();
        for (TtFeePoolDetailEntity entity : entities) {
            TtEstimateExtractEntity ttEstimateExtractEntity = new TtEstimateExtractEntity();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            ttEstimateExtractEntity.setYear(sdf.format(new Date()));
            ttEstimateExtractEntity.setEstimateType(ConstantEnum.EstimateExtractEnum.FORTY.getValue());
            ttEstimateExtractEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            ttEstimateExtractEntity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
            ttEstimateExtractEntity.setCustCode(entity.getCustCode());
            ttEstimateExtractEntity.setCustName(entity.getCustName());
            ttEstimateExtractEntities.add(ttEstimateExtractEntity);
        }
        int i = this.ttEstimateExtractDao.insertList(ttEstimateExtractEntities);
        return i > 0;
    }

    @Override
    public boolean applyEstimate() {
        TtActDetailVo vo = new TtActDetailVo();
        List ttActDetailVos = this.ttActDetailFeign.findTtActDetailListForEstimate(vo).getObjList();
        ArrayList<TtEstimateExtractEntity> ttEstimateExtractEntities = new ArrayList<TtEstimateExtractEntity>();
        for (TtActDetailVo ttActDetailVo : ttActDetailVos) {
            TtEstimateExtractEntity ttEstimateExtractEntity = new TtEstimateExtractEntity();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            ttEstimateExtractEntity.setYear(sdf.format(new Date()));
            ttEstimateExtractEntity.setEstimateType(ConstantEnum.EstimateExtractEnum.TEN.getValue());
            ttEstimateExtractEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            ttEstimateExtractEntity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
            ttEstimateExtractEntity.setCustCode(ttActDetailVo.getCustomerCode());
            ttEstimateExtractEntity.setCustName(ttActDetailVo.getCustomerName());
            ttEstimateExtractEntity.setProductCode(ttActDetailVo.getProductCode());
            ttEstimateExtractEntity.setProductName(ttActDetailVo.getProductName());
            ttEstimateExtractEntity.setPayType(ttActDetailVo.getPayType());
            ttEstimateExtractEntity.setOrgName(ttActDetailVo.getOrgName());
            ttEstimateExtractEntity.setOrgCode(ttActDetailVo.getOrgCode());
            ttEstimateExtractEntity.setFineCode(ttActDetailVo.getActSubclassCode());
            ttEstimateExtractEntity.setFineName(ttActDetailVo.getActSubclassName());
            ttEstimateExtractEntity.setBeginTime(ttActDetailVo.getBeginTime());
            ttEstimateExtractEntity.setEndTime(ttActDetailVo.getEndTime());
            ttEstimateExtractEntity.setActDetailCode(ttActDetailVo.getActDetailCode());
            ttEstimateExtractEntity.setActCode(ttActDetailVo.getActCode());
            ttEstimateExtractEntity.setActName(ttActDetailVo.getActName());
            ttEstimateExtractEntity.setActAmount(ttActDetailVo.getAmount());
            ttEstimateExtractEntity.setActYear(ttActDetailVo.getBeginTime().substring(0, 4));
            ttEstimateExtractEntity.setBudgetSubjectsCode(ttActDetailVo.getBudgetSubjectsCode());
            ttEstimateExtractEntity.setBudgetSubjectsName(ttActDetailVo.getBudgetSubjectsName());
            ttEstimateExtractEntity.setCategoriesCode(ttActDetailVo.getCategoriesCode());
            ttEstimateExtractEntity.setCategoriesName(ttActDetailVo.getCategoriesName());
            ttEstimateExtractEntities.add(ttEstimateExtractEntity);
        }
        int i = this.ttEstimateExtractDao.insertList(ttEstimateExtractEntities);
        return i > 0;
    }

    @Override
    public boolean contractCostEstimate() {
        Object j = null;
        if (j.isSuccess()) {
            int i;
            List ttEstimateExtractVos = j.getObjList();
            ArrayList<TtEstimateExtractEntity> ttEstimateExtractEntities = new ArrayList<TtEstimateExtractEntity>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)ttEstimateExtractVos)) {
                for (TtEstimateExtractVo ttEstimateExtractVo : ttEstimateExtractVos) {
                    TtEstimateExtractEntity ttEstimateExtractEntity = new TtEstimateExtractEntity();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                    ttEstimateExtractEntity.setYear(sdf.format(new Date()));
                    ttEstimateExtractEntity.setEstimateType(ConstantEnum.EstimateExtractEnum.TWENTY.getValue());
                    ttEstimateExtractEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                    ttEstimateExtractEntity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
                    ttEstimateExtractEntity.setCustCode(ttEstimateExtractVo.getCustCode());
                    ttEstimateExtractEntity.setCustName(ttEstimateExtractVo.getCustName());
                    ttEstimateExtractEntity.setProductCode(ttEstimateExtractVo.getProductCode());
                    ttEstimateExtractEntity.setProductName(ttEstimateExtractVo.getProductName());
                    ttEstimateExtractEntity.setPayType(ttEstimateExtractVo.getPayType());
                    ttEstimateExtractEntity.setOrgName(ttEstimateExtractVo.getOrgName());
                    ttEstimateExtractEntity.setOrgCode(ttEstimateExtractVo.getOrgCode());
                    ttEstimateExtractEntity.setFineCode(ttEstimateExtractVo.getFineCode());
                    ttEstimateExtractEntity.setFineName(ttEstimateExtractVo.getFineName());
                    ttEstimateExtractEntity.setBeginTime(ttEstimateExtractVo.getBeginTime());
                    ttEstimateExtractEntity.setEndTime(ttEstimateExtractVo.getEndTime());
                    ttEstimateExtractEntity.setActDetailCode(ttEstimateExtractVo.getActDetailCode());
                    ttEstimateExtractEntity.setActCode(ttEstimateExtractVo.getActCode());
                    ttEstimateExtractEntity.setActName(ttEstimateExtractVo.getActName());
                    ttEstimateExtractEntity.setActAmount(ttEstimateExtractVo.getActAmount());
                    ttEstimateExtractEntity.setActYear(ttEstimateExtractVo.getBeginTime().substring(0, 4));
                    ttEstimateExtractEntity.setBudgetSubjectsCode(ttEstimateExtractVo.getBudgetSubjectsCode());
                    ttEstimateExtractEntity.setBudgetSubjectsName(ttEstimateExtractVo.getBudgetSubjectsName());
                    ttEstimateExtractEntity.setCategoriesCode(ttEstimateExtractVo.getCategoriesCode());
                    ttEstimateExtractEntity.setCategoriesName(ttEstimateExtractVo.getCategoriesName());
                    ttEstimateExtractEntities.add(ttEstimateExtractEntity);
                }
            }
            return (i = this.ttEstimateExtractDao.insertList(ttEstimateExtractEntities)) > 0;
        }
        return false;
    }
}

