/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.controller;

import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.act.ActData;
import com.biz.eisp.pay.audit.service.TtAuditActService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/auditActController"})
public class AuditActController {
    private static final Logger log = LoggerFactory.getLogger(AuditActController.class);
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtAuditActService ttAuditActService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;

    @PostMapping(value={"saveActData"})
    public AjaxJson saveActData(@RequestBody ActData actData) {
        AjaxJson ajaxJson = new AjaxJson();
        this.auditActService.saveActData(actData);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtActPage"})
    public DataGrid findTtActPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> info = null;
        vo.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        if (StringUtil.isNotEmpty((CharSequence)vo.getIsAuditStr())) {
            ArrayList<String> actTypes = new ArrayList<String>();
            String[] is_audit = vo.getIsAuditStr().split(",");
            if (is_audit != null && is_audit.length > 0) {
                for (int i = 0; i < is_audit.length; ++i) {
                    actTypes.add(is_audit[i]);
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(actTypes)) {
                vo.setActTypes(actTypes);
            }
        }
        info = this.auditActService.findTtActSelectPage(vo, (Page)page);
        return new DataGrid(info);
    }

    @RequestMapping(value={"findTtActDetailPage"})
    public List<TtActDetailVo> findTtActDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        EuPage page = new EuPage(request);
        PageInfo info = new PageInfo();
        ArrayList<TtActDetailVo> ttActDetailVos = new ArrayList<TtActDetailVo>();
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        List actEntities = this.ttAuditActService.selectExample(example);
        List<String> actCodes = new ArrayList<String>();
        actCodes.add("_");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actEntities)) {
            actCodes = actEntities.stream().map(TtAuditActEntity::getActCode).collect(Collectors.toList());
        }
        List<TtActDetailVo> ttActDetails = this.auditActService.getActDetailByTempUuid(vo.getTempUuid(), vo);
        info.setList(ttActDetails);
        info.setTotal((long)ttActDetails.size());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            info.getList().forEach(item -> {
                TtCostTypeFineEntity ttCostTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, item.getActSubclassCode()).getObj();
                if (ttCostTypeFineEntity != null && StringUtil.isNotEmpty((CharSequence)ttCostTypeFineEntity.getActMethodCode()) && (StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.DDFY.getValue()) || StringUtils.equals((CharSequence)ttCostTypeFineEntity.getActMethodCode(), (CharSequence)ConstantEnum.ActMethodEnum.HFFY.getValue()))) {
                    item.setCategoriesCode(ttCostTypeFineEntity.getCategoriesCode());
                    item.setCategoriesName(ttCostTypeFineEntity.getCategoriesName());
                    String isMultipleAudit = StringUtil.isEmpty((String)ttCostTypeFineEntity.getIsMultipleAudit()) ? "0" : ttCostTypeFineEntity.getIsMultipleAudit();
                    item.setIsMultipleAudit(isMultipleAudit);
                    ttActDetailVos.add((TtActDetailVo)item);
                }
            });
        }
        return ttActDetailVos;
    }
}

