/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.estimate.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.act.act.TtActDetailFeign;
import com.biz.eisp.act.act.TtActProductFeign;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.vo.ActDetailListPartReq;
import com.biz.eisp.act.vo.ActListReq;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.audit.dto.ListAuditDetailDto;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.vo.CacheEntityVo;
import com.biz.eisp.base.vo.WithholdingVo;
import com.biz.eisp.estimate.dao.TtEstimateExtractDao;
import com.biz.eisp.estimate.service.TtEstimateExtractService;
import com.biz.eisp.estimate.util.TtEstimateExtractUtil;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.pool.TtFeePoolDetailFeign;
import com.biz.eisp.fee.pool.TtFeePoolFeign;
import com.biz.eisp.fee.vo.TtFeePoolDetailApiListReq;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.estimate.entity.TtEstimateExtractEntity;
import com.biz.eisp.pay.estimate.vo.TtEstimateExtractVo;
import com.biz.eisp.pay.withholding.CacheEntity;
import com.biz.eisp.pay.withholding.TtWithholdingReq;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.biz.eisp.websocket.WithHoldingFeign;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttEstimateExtractService")
@Transactional
public class TtEstimateExtractServiceImpl
extends BaseServiceImpl<TtEstimateExtractEntity>
implements TtEstimateExtractService {
    @Autowired
    private TtEstimateExtractDao ttEstimateExtractDao;
    @Autowired
    private TtActDetailFeign ttActDetailFeign;
    @Autowired
    private TtFeePoolFeign ttFeePoolFeign;
    @Autowired
    private TtFeePoolDetailFeign ttFeePoolDetailFeign;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private TtActProductFeign ttActProductFeign;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private WithHoldingFeign withHoldingFeign;

    @Override
    public PageInfo<TtEstimateExtractVo> findTtEstimateExtractPage(TtEstimateExtractVo entity, Page page) {
        Example example = new Example(TtEstimateExtractEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEstimateType())) {
            criteria.andEqualTo("estimateType", (Object)entity.getEstimateType());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEstimateCode())) {
            criteria.andEqualTo("estimateCode", (Object)entity.getEstimateCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getYear())) {
            criteria.andEqualTo("year", (Object)entity.getYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActYear())) {
            criteria.andEqualTo("actYear", (Object)entity.getActYear());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActCode())) {
            criteria.andEqualTo("actCode", (Object)entity.getActCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActDetailCode())) {
            criteria.andEqualTo("actDetailCode", (Object)entity.getActDetailCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActName())) {
            criteria.andEqualTo("actName", (Object)entity.getActName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgName())) {
            criteria.andEqualTo("orgName", (Object)entity.getOrgName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getOrgCode())) {
            criteria.andEqualTo("orgCode", (Object)entity.getOrgCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            criteria.andEqualTo("custCode", (Object)entity.getCustCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustName())) {
            criteria.andEqualTo("custName", (Object)entity.getCustName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsCode())) {
            criteria.andEqualTo("budgetSubjectsCode", (Object)entity.getBudgetSubjectsCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsName())) {
            criteria.andEqualTo("budgetSubjectsName", (Object)entity.getBudgetSubjectsName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCategoriesCode())) {
            criteria.andEqualTo("categoriesCode", (Object)entity.getCategoriesCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCategoriesName())) {
            criteria.andEqualTo("categoriesName", (Object)entity.getCategoriesName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getFineCode())) {
            criteria.andEqualTo("fineCode", (Object)entity.getFineCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getFineName())) {
            criteria.andEqualTo("fineName", (Object)entity.getFineName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductLevelCode())) {
            criteria.andEqualTo("productLevelCode", (Object)entity.getProductLevelCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductLevelName())) {
            criteria.andEqualTo("productLevelName", (Object)entity.getProductLevelName());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBeginTime())) {
            criteria.andEqualTo("beginTime", (Object)entity.getBeginTime());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEndTime())) {
            criteria.andEqualTo("endTime", (Object)entity.getEndTime());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getPayType())) {
            criteria.andEqualTo("payType", (Object)entity.getPayType());
        }
        if (StringUtil.isNotEmpty((Object)entity.getActAmount())) {
            criteria.andEqualTo("actAmount", (Object)entity.getActAmount());
        }
        if (StringUtil.isNotEmpty((Object)entity.getEstimateAmount())) {
            criteria.andEqualTo("estimateAmount", (Object)entity.getEstimateAmount());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttEstimateExtractDao.selectByExample(example), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtEstimateExtractServiceImpl.class)
    public boolean delete(String id) {
        int i = this.ttEstimateExtractDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public TtEstimateExtractEntity getTtEstimateExtractEntity(String id) {
        return (TtEstimateExtractEntity)this.ttEstimateExtractDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtEstimateExtractServiceImpl.class)
    public void save(TtEstimateExtractVo vo) {
        TtEstimateExtractEntity entity = null;
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(vo);
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
            this.insertSelective(entity);
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtEstimateExtractServiceImpl.class)
    public void update(TtEstimateExtractVo vo) {
        TtEstimateExtractEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(vo);
            this.updateByPrimaryKeySelective(entity);
        }
    }

    private TtEstimateExtractEntity getEntity(TtEstimateExtractVo vo) {
        TtEstimateExtractEntity entity = new TtEstimateExtractEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setActAmount(vo.getActAmount());
        entity.setActCode(vo.getActCode());
        entity.setActDetailCode(vo.getActDetailCode());
        entity.setActName(vo.getActName());
        entity.setActYear(vo.getActYear());
        entity.setBeginTime(vo.getBeginTime());
        entity.setBudgetSubjectsCode(vo.getBudgetSubjectsCode());
        entity.setBudgetSubjectsName(vo.getBudgetSubjectsName());
        entity.setCategoriesCode(vo.getCategoriesCode());
        entity.setCategoriesName(vo.getCategoriesName());
        entity.setCustCode(vo.getCustCode());
        entity.setCustName(vo.getCustName());
        entity.setEndTime(vo.getEndTime());
        entity.setEstimateAmount(vo.getEstimateAmount());
        entity.setEstimateCode(vo.getEstimateCode());
        entity.setEstimateType(vo.getEstimateType());
        entity.setFineCode(vo.getFineCode());
        entity.setFineName(vo.getFineName());
        entity.setOrgCode(vo.getOrgCode());
        entity.setOrgName(vo.getOrgName());
        entity.setPayType(vo.getPayType());
        entity.setProductLevelCode(vo.getProductLevelCode());
        entity.setProductLevelName(vo.getProductLevelName());
        entity.setYear(vo.getYear());
        entity.setProductCode(vo.getProductCode());
        entity.setProductName(vo.getProductName());
        return entity;
    }

    @Override
    public boolean feePoolAmountEstimate() {
        List entities = this.ttFeePoolFeign.getFeePoolDetailForEstimate().getObjList();
        ArrayList<TtEstimateExtractEntity> ttEstimateExtractEntities = new ArrayList<TtEstimateExtractEntity>();
        for (TtFeePoolDetailEntity entity : entities) {
            TtEstimateExtractEntity ttEstimateExtractEntity = new TtEstimateExtractEntity();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            ttEstimateExtractEntity.setYear(sdf.format(new Date()));
            ttEstimateExtractEntity.setEstimateType(ConstantEnum.EstimateExtractEnum.FORTY.getValue());
            ttEstimateExtractEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            ttEstimateExtractEntity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
            ttEstimateExtractEntity.setCustCode(entity.getCustCode());
            ttEstimateExtractEntity.setCustName(entity.getCustName());
            ttEstimateExtractEntities.add(ttEstimateExtractEntity);
        }
        int i = this.ttEstimateExtractDao.insertList(ttEstimateExtractEntities);
        return i > 0;
    }

    @Override
    public boolean applyEstimate() {
        TtActDetailVo vo = new TtActDetailVo();
        List ttActDetailVos = this.ttActDetailFeign.findTtActDetailListForEstimate(vo).getObjList();
        ArrayList<TtEstimateExtractEntity> ttEstimateExtractEntities = new ArrayList<TtEstimateExtractEntity>();
        for (TtActDetailVo ttActDetailVo : ttActDetailVos) {
            TtEstimateExtractEntity ttEstimateExtractEntity = new TtEstimateExtractEntity();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            ttEstimateExtractEntity.setYear(sdf.format(new Date()));
            ttEstimateExtractEntity.setEstimateType(ConstantEnum.EstimateExtractEnum.TEN.getValue());
            ttEstimateExtractEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            ttEstimateExtractEntity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
            ttEstimateExtractEntity.setCustCode(ttActDetailVo.getCustomerCode());
            ttEstimateExtractEntity.setCustName(ttActDetailVo.getCustomerName());
            ttEstimateExtractEntity.setProductCode(ttActDetailVo.getProductCode());
            ttEstimateExtractEntity.setProductName(ttActDetailVo.getProductName());
            ttEstimateExtractEntity.setPayType(ttActDetailVo.getPayType());
            ttEstimateExtractEntity.setOrgName(ttActDetailVo.getOrgName());
            ttEstimateExtractEntity.setOrgCode(ttActDetailVo.getOrgCode());
            ttEstimateExtractEntity.setFineCode(ttActDetailVo.getActSubclassCode());
            ttEstimateExtractEntity.setFineName(ttActDetailVo.getActSubclassName());
            ttEstimateExtractEntity.setBeginTime(ttActDetailVo.getBeginTime());
            ttEstimateExtractEntity.setEndTime(ttActDetailVo.getEndTime());
            ttEstimateExtractEntity.setActDetailCode(ttActDetailVo.getActDetailCode());
            ttEstimateExtractEntity.setActCode(ttActDetailVo.getActCode());
            ttEstimateExtractEntity.setActName(ttActDetailVo.getActName());
            ttEstimateExtractEntity.setActAmount(ttActDetailVo.getAmount());
            ttEstimateExtractEntity.setActYear(ttActDetailVo.getBeginTime());
            ttEstimateExtractEntity.setBudgetSubjectsCode(ttActDetailVo.getBudgetSubjectsCode());
            ttEstimateExtractEntity.setBudgetSubjectsName(ttActDetailVo.getBudgetSubjectsName());
            ttEstimateExtractEntity.setCategoriesCode(ttActDetailVo.getCategoriesCode());
            ttEstimateExtractEntity.setCategoriesName(ttActDetailVo.getCategoriesName());
            ttEstimateExtractEntities.add(ttEstimateExtractEntity);
        }
        int i = this.ttEstimateExtractDao.insertList(ttEstimateExtractEntities);
        return i > 0;
    }

    @Override
    public boolean contractCostEstimate() {
        Object j = null;
        if (j.isSuccess()) {
            int i;
            List ttEstimateExtractVos = j.getObjList();
            ArrayList<TtEstimateExtractEntity> ttEstimateExtractEntities = new ArrayList<TtEstimateExtractEntity>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)ttEstimateExtractVos)) {
                for (TtEstimateExtractVo ttEstimateExtractVo : ttEstimateExtractVos) {
                    TtEstimateExtractEntity ttEstimateExtractEntity = new TtEstimateExtractEntity();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                    ttEstimateExtractEntity.setYear(sdf.format(new Date()));
                    ttEstimateExtractEntity.setEstimateType(ConstantEnum.EstimateExtractEnum.TWENTY.getValue());
                    ttEstimateExtractEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                    ttEstimateExtractEntity.setEstimateCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name()));
                    ttEstimateExtractEntity.setCustCode(ttEstimateExtractVo.getCustCode());
                    ttEstimateExtractEntity.setCustName(ttEstimateExtractVo.getCustName());
                    ttEstimateExtractEntity.setProductCode(ttEstimateExtractVo.getProductCode());
                    ttEstimateExtractEntity.setProductName(ttEstimateExtractVo.getProductName());
                    ttEstimateExtractEntity.setPayType(ttEstimateExtractVo.getPayType());
                    ttEstimateExtractEntity.setOrgName(ttEstimateExtractVo.getOrgName());
                    ttEstimateExtractEntity.setOrgCode(ttEstimateExtractVo.getOrgCode());
                    ttEstimateExtractEntity.setFineCode(ttEstimateExtractVo.getFineCode());
                    ttEstimateExtractEntity.setFineName(ttEstimateExtractVo.getFineName());
                    ttEstimateExtractEntity.setBeginTime(ttEstimateExtractVo.getBeginTime());
                    ttEstimateExtractEntity.setEndTime(ttEstimateExtractVo.getEndTime());
                    ttEstimateExtractEntity.setActDetailCode(ttEstimateExtractVo.getActDetailCode());
                    ttEstimateExtractEntity.setActCode(ttEstimateExtractVo.getActCode());
                    ttEstimateExtractEntity.setActName(ttEstimateExtractVo.getActName());
                    ttEstimateExtractEntity.setActAmount(ttEstimateExtractVo.getActAmount());
                    ttEstimateExtractEntity.setActYear(ttEstimateExtractVo.getBeginTime().substring(0, 4));
                    ttEstimateExtractEntity.setBudgetSubjectsCode(ttEstimateExtractVo.getBudgetSubjectsCode());
                    ttEstimateExtractEntity.setBudgetSubjectsName(ttEstimateExtractVo.getBudgetSubjectsName());
                    ttEstimateExtractEntity.setCategoriesCode(ttEstimateExtractVo.getCategoriesCode());
                    ttEstimateExtractEntity.setCategoriesName(ttEstimateExtractVo.getCategoriesName());
                    ttEstimateExtractEntities.add(ttEstimateExtractEntity);
                }
            }
            return (i = this.ttEstimateExtractDao.insertList(ttEstimateExtractEntities)) > 0;
        }
        return false;
    }

    @Override
    public void withholding(TtWithholdingReq ttWithholdingReq) {
        List caches = this.redisTemplate.opsForList().range((Object)TtEstimateExtractUtil.getRedisKey(), 0L, -1L);
        ArrayList types = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)caches)) {
            types = ttWithholdingReq.getTypes();
        } else {
            for (Integer voType : ttWithholdingReq.getTypes()) {
                CacheEntity cacheEntity = TtEstimateExtractUtil.findFromCache(caches, TtEstimateExtractUtil.transTypeFromVo(voType));
                if (null == cacheEntity) {
                    types.add(voType);
                    continue;
                }
                if (cacheEntity.getComplateFlag().intValue() != CacheEntity.COMPLATEFLAG.OVER.getCode().intValue() && (cacheEntity.getComplateFlag().intValue() != CacheEntity.COMPLATEFLAG.ING.getCode().intValue() || DateUtils.getDate().getTime() - cacheEntity.getStartTime() <= 10800000L)) continue;
                types.add(voType);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)types)) {
            ttWithholdingReq.setTypes(types);
            this.withholdingDetail(ttWithholdingReq);
        }
    }

    @Override
    public List<CacheEntity> getProgress() {
        List caches = this.redisTemplate.opsForList().range((Object)TtEstimateExtractUtil.getRedisKey(), 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)caches)) {
            return new ArrayList<CacheEntity>();
        }
        ArrayList<CacheEntity> reList = new ArrayList<CacheEntity>();
        for (Object obj : caches) {
            reList.add((CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class));
        }
        return reList;
    }

    private void initCacheTotal(String key, String type, Long total, Long startTime) {
        CacheEntity cacheEntity = new CacheEntity();
        cacheEntity.setComplateFlag(CacheEntity.COMPLATEFLAG.ING.getCode());
        cacheEntity.setComplateNum(Long.valueOf(Long.parseLong("0")));
        cacheEntity.setTotal(total);
        cacheEntity.setStartTime(startTime);
        cacheEntity.setType(type);
        List caches = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        ArrayList<String> newCaches = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)caches)) {
            newCaches.add(JSON.toJSONString((Object)cacheEntity));
        } else {
            for (Object obj : caches) {
                CacheEntity oldCacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
                if (oldCacheEntity.getType().equals(type)) continue;
                newCaches.add(JSON.toJSONString((Object)oldCacheEntity));
            }
            newCaches.add(JSON.toJSONString((Object)cacheEntity));
        }
        this.redisTemplate.delete((Object)key);
        newCaches.stream().forEach(cache -> this.redisTemplate.opsForList().rightPush((Object)key, cache));
        this.sendWebSocket();
    }

    private void updateCacheTotal(String key, String type, Long num, CacheEntity.COMPLATEFLAG complateflag) {
        if (null == num) {
            num = Long.parseLong("0");
        }
        List caches = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        ArrayList<String> newCaches = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)caches)) {
            for (Object obj : caches) {
                CacheEntity oldCacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
                if (!oldCacheEntity.getType().equals(type)) {
                    newCaches.add(JSON.toJSONString((Object)oldCacheEntity));
                    continue;
                }
                CacheEntity cacheEntity = oldCacheEntity;
                oldCacheEntity.setComplateFlag(complateflag.getCode());
                if (complateflag.getCode().intValue() == CacheEntity.COMPLATEFLAG.OVER.getCode().intValue()) {
                    oldCacheEntity.setComplateNum(oldCacheEntity.getTotal());
                } else {
                    oldCacheEntity.setComplateNum(Long.valueOf(null == oldCacheEntity.getComplateNum() ? num : num + oldCacheEntity.getComplateNum()));
                }
                newCaches.add(JSON.toJSONString((Object)oldCacheEntity));
            }
        }
        this.redisTemplate.delete((Object)key);
        newCaches.stream().forEach(cache -> this.redisTemplate.opsForList().rightPush((Object)key, cache));
        this.sendWebSocket();
    }

    private void sendWebSocket() {
        WithholdingVo withholdingVo = new WithholdingVo();
        ArrayList<Object> list = new ArrayList<Object>(4);
        List caches = this.redisTemplate.opsForList().range((Object)TtEstimateExtractUtil.getRedisKey(), 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)caches)) {
            for (Object obj : caches) {
                CacheEntity cacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
                if (cacheEntity.getTotal() == 0L) {
                    cacheEntity.setRate(Integer.valueOf(100));
                    list.add(JSON.parseObject((String)JSON.toJSONString((Object)cacheEntity), CacheEntityVo.class));
                    continue;
                }
                BigDecimal a = BigDecimal.valueOf(cacheEntity.getComplateNum());
                BigDecimal b = BigDecimal.valueOf(cacheEntity.getTotal());
                BigDecimal c = a.multiply(BigDecimal.valueOf(100L)).divide(b, 0, 4);
                cacheEntity.setRate(Integer.valueOf(c.intValue()));
                list.add(JSON.parseObject((String)JSON.toJSONString((Object)cacheEntity), CacheEntityVo.class));
            }
        }
        withholdingVo.setList(list);
        withholdingVo.setSid("withholding");
        this.withHoldingFeign.pushExcelMessage(withholdingVo);
    }

    public void withholdingDetail(TtWithholdingReq ttWithholdingReq) {
        List productEntities = this.mdmApiFeign.list().getObjList();
        int computationNum = 1000;
        for (Integer type : ttWithholdingReq.getTypes()) {
            switch (type) {
                case 0: {
                    this.withholdingCostPool(computationNum, productEntities);
                    break;
                }
                case 1: {
                    this.withholdingApplyNoExamine(computationNum);
                    break;
                }
                case 2: {
                    this.withholdingExamineNobooks(computationNum);
                    break;
                }
                case 3: {
                    this.withholdingPartExamineNobooks(computationNum);
                    break;
                }
            }
        }
    }

    private void deleteByMonthAndType(String month, String type) {
        TtEstimateExtractEntity condition = new TtEstimateExtractEntity();
        condition.setYear(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        condition.setEstimateType(TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode());
        this.ttEstimateExtractDao.delete(condition);
    }

    private void withholdingCostPool(Integer num, List<TmProductEntity> productEntities) {
        TtFeePoolDetailApiListReq totalReq = new TtFeePoolDetailApiListReq();
        totalReq.setPageSize("1");
        totalReq.setPageNum("1");
        PageInfo pageInfoForTotal = this.ttFeePoolDetailFeign.list(totalReq);
        this.initCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode(), pageInfoForTotal.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            TtFeePoolDetailApiListReq ttFeePoolDetailApiListReq = new TtFeePoolDetailApiListReq();
            ttFeePoolDetailApiListReq.setPageSize(num.toString());
            ttFeePoolDetailApiListReq.setPageNum(pageNum.toString());
            PageInfo pageInfo = this.ttFeePoolDetailFeign.list(ttFeePoolDetailApiListReq);
            List feeList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)feeList)) {
                this.dealWithholdingCostPool(feeList, productEntities);
            } else {
                flag = false;
            }
            this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode(), CollectionUtils.isEmpty((Collection)feeList) ? Long.parseLong("0") : new Long(feeList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealWithholdingCostPool(List<TtFeePoolDetailEntity> feeList, List<TmProductEntity> productEntities) {
        ArrayList<TtEstimateExtractEntity> entities = new ArrayList<TtEstimateExtractEntity>(feeList.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)feeList.size());
        int i = 0;
        for (TtFeePoolDetailEntity entity : feeList) {
            String code = (String)codeList.get(i);
            if (StringUtils.isEmpty((CharSequence)entity.getPayType())) continue;
            if (entity.getPayType().equals("10")) {
                entities.add(TtEstimateExtractUtil.packageEntities(entity, code, entity.getFeeUsableAmount()));
            } else if (entity.getPayType().equals("30")) {
                TmProductEntity tmProductEntity = TtEstimateExtractUtil.findProductByPeoductLevelCode(productEntities, entity.getProductLevel());
                BigDecimal balance = TtEstimateExtractUtil.calBalanceCostPool(entity, tmProductEntity);
                entities.add(TtEstimateExtractUtil.packageEntities(entity, code, balance));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.ttEstimateExtractDao.insertList(entities);
        }
    }

    private void withholdingApplyNoExamine(Integer num) {
        ActListReq totalReq = new ActListReq();
        totalReq.setPageSize("1");
        totalReq.setPageNum("1");
        PageInfo pageInfoForTotal = this.ttActProductFeign.list(totalReq);
        this.initCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.APPLYNOEXAMINE.getCode(), pageInfoForTotal.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtEstimateExtractEntity.ESTIMATETYPE.APPLYNOEXAMINE.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            ActListReq actListReq = new ActListReq();
            actListReq.setPageSize(num.toString());
            actListReq.setPageNum(pageNum.toString());
            PageInfo pageInfo = this.ttActProductFeign.list(actListReq);
            List applyNoExamineList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)applyNoExamineList)) {
                this.dealApplyNoExamine(applyNoExamineList);
            } else {
                flag = false;
            }
            this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.APPLYNOEXAMINE.getCode(), CollectionUtils.isEmpty((Collection)applyNoExamineList) ? Long.parseLong("0") : new Long(applyNoExamineList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.APPLYNOEXAMINE.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealApplyNoExamine(List<TtActDetailEntity> applyNoExamineList) {
        ArrayList<TtEstimateExtractEntity> entities = new ArrayList<TtEstimateExtractEntity>(applyNoExamineList.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)applyNoExamineList.size());
        int i = 0;
        for (TtActDetailEntity entity : applyNoExamineList) {
            String code = (String)codeList.get(i);
            if (!StringUtils.isEmpty((CharSequence)entity.getPayType()) && (entity.getPayType().equals("10") || entity.getPayType().equals("20"))) {
                entities.add(TtEstimateExtractUtil.packageEntities(entity, code, entity.getAmount()));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.ttEstimateExtractDao.insertList(entities);
        }
    }

    private void withholdingExamineNobooks(Integer num) {
        PageInfo<TtAuditActDetailEntity> totalPageInfo = this.ttAuditActDetailService.list(1, 1);
        this.initCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.EXAMINENOBOOKS.getCode(), totalPageInfo.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtEstimateExtractEntity.ESTIMATETYPE.EXAMINENOBOOKS.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            PageInfo<TtAuditActDetailEntity> pageInfo = this.ttAuditActDetailService.list(pageNum, num);
            List examineNobooksList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)examineNobooksList)) {
                this.dealExamineNobooks(examineNobooksList);
            } else {
                flag = false;
            }
            this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.EXAMINENOBOOKS.getCode(), CollectionUtils.isEmpty((Collection)examineNobooksList) ? Long.parseLong("0") : new Long(examineNobooksList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.EXAMINENOBOOKS.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealExamineNobooks(List<TtAuditActDetailEntity> ttAuditActDetailEntities) {
        ArrayList<TtEstimateExtractEntity> entities = new ArrayList<TtEstimateExtractEntity>(ttAuditActDetailEntities.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)ttAuditActDetailEntities.size());
        int i = 0;
        for (TtAuditActDetailEntity entity : ttAuditActDetailEntities) {
            String code = (String)codeList.get(i);
            if (!StringUtils.isEmpty((CharSequence)entity.getPayType()) && (entity.getPayType().equals("10") || entity.getPayType().equals("20")) && entity.getCurrentAmount() != null && entity.getAmount() != null) {
                entities.add(TtEstimateExtractUtil.packageEntities(entity, code, entity.getCurrentAmount().subtract(entity.getAmount())));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.ttEstimateExtractDao.insertList(entities);
        }
    }

    private void withholdingPartExamineNobooks(Integer num) {
        ActDetailListPartReq totalReq = new ActDetailListPartReq();
        totalReq.setPageNum("1".toString());
        totalReq.setPageSize("1");
        PageInfo pageInfoForTotal = this.ttActProductFeign.listPart(totalReq);
        this.initCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.PARTEXAMINENOBOOKS.getCode(), pageInfoForTotal.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtEstimateExtractEntity.ESTIMATETYPE.PARTEXAMINENOBOOKS.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            ActDetailListPartReq req = new ActDetailListPartReq();
            req.setPageNum(pageNum.toString());
            req.setPageSize(num.toString());
            PageInfo pageInfo = this.ttActProductFeign.listPart(req);
            List examineNobooksList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)examineNobooksList)) {
                this.dealPartExamineNobooks(examineNobooksList);
            } else {
                flag = false;
            }
            this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.PARTEXAMINENOBOOKS.getCode(), CollectionUtils.isEmpty((Collection)examineNobooksList) ? Long.parseLong("0") : new Long(examineNobooksList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(TtEstimateExtractUtil.getRedisKey(), TtEstimateExtractEntity.ESTIMATETYPE.PARTEXAMINENOBOOKS.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealPartExamineNobooks(List<TtActDetailEntity> ttActDetailEntities) {
        ArrayList<TtEstimateExtractEntity> entities = new ArrayList<TtEstimateExtractEntity>(ttActDetailEntities.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)ttActDetailEntities.size());
        int i = 0;
        ArrayList<String> codes = new ArrayList<String>(ttActDetailEntities.size());
        for (TtActDetailEntity entity : ttActDetailEntities) {
            if (StringUtils.isEmpty((CharSequence)entity.getActDetailCode())) continue;
            codes.add(entity.getActDetailCode());
        }
        List<ListAuditDetailDto> amonts = this.ttAuditActDetailService.listAuditDetail(codes);
        for (TtActDetailEntity entity : ttActDetailEntities) {
            String code = (String)codeList.get(i);
            if (!StringUtils.isEmpty((CharSequence)entity.getPayType()) && (entity.getPayType().equals("10") || entity.getPayType().equals("20"))) {
                BigDecimal money = TtEstimateExtractUtil.findAuditByActDetailCode(amonts, entity.getActDetailCode());
                if (money == null) {
                    // empty if block
                }
                if (entity.getAmount() == null) {
                    // empty if block
                }
                entities.add(TtEstimateExtractUtil.packageEntitiesForPart(entity, code, entity.getAmount().subtract(money)));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.ttEstimateExtractDao.insertList(entities);
        }
    }
}

