/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.service.impl;

import com.biz.eisp.act.dao.AuditActDao;
import com.biz.eisp.act.dao.AuditActDetailDao;
import com.biz.eisp.act.dao.AuditActDetailGiftDao;
import com.biz.eisp.act.dao.AuditActProductDao;
import com.biz.eisp.act.dao.AuditActbudgetDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.ActfindTtActSelectPageExtend;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.act.ActData;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class AuditActServiceImpl
implements AuditActService {
    @Autowired
    private AuditActbudgetDao auditActbudgetDao;
    @Autowired
    private AuditActDao auditActDao;
    @Autowired
    private AuditActDetailDao auditActDetailDao;
    @Autowired
    private AuditActDetailGiftDao auditActDetailGiftDao;
    @Autowired
    private AuditActProductDao auditActProductDao;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired(required=false)
    private ActfindTtActSelectPageExtend actfindTtActSelectPageExtend;

    @Override
    public void saveActData(ActData actData) {
        if (actData.getHead() != null) {
            this.auditActDao.insertSelective(actData.getHead());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actData.getDetails())) {
            this.auditActDetailDao.insertList(actData.getDetails());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actData.getBudgets())) {
            this.auditActbudgetDao.insertList(actData.getBudgets());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actData.getGifts())) {
            this.auditActDetailGiftDao.insertList(actData.getGifts());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actData.getProducts())) {
            this.auditActProductDao.insertList(actData.getProducts());
        }
    }

    @Override
    public PageInfo<TtActVo> findTtActSelectPage(TtActVo vo, Page page) {
        List authEntities;
        StringBuffer buffer = new StringBuffer();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        Object flag = null;
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.SELECTACT), (boolean)true)))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.SELECTACT), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String temp;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap auMap = new HashMap();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put(parentId, list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"tta.org_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append(" tta.org_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("position")) {
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("40")) {
                            List posCode = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAllPosCodeByUser(userRedis.getId(), userRedis.getUsername(), Integer.valueOf(1)), (boolean)true);
                            if (!CollectionUtil.listNotEmptyNotSizeZero((List)posCode)) {
                                posCode.add("_");
                            }
                            temp = SqlUtil.setSqlIn500((List)posCode, (String)"tta.position_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            buffer.append("  tta.position_code = '" + userRedis.getPosCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (this.actfindTtActSelectPageExtend != null) {
                        String expandSql = this.actfindTtActSelectPageExtend.findTtActSelectPage();
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.auditActDao.findTtActSelectPage(vo, aUsql), (Page)page);
    }

    @Override
    public List<TtActDetailVo> getActDetailByTempUuid(String uuid, TtActDetailVo vo) {
        ArrayList<TtActDetailVo> detailVos = this.auditActDetailDao.getActDetailByTempUuid(uuid, vo);
        detailVos = detailVos == null ? new ArrayList<TtActDetailVo>() : detailVos;
        return detailVos;
    }

    @Override
    public TtActEntity getActEntity(String id, String code) {
        return (TtActEntity)this.auditActDao.selectByPrimaryKey(id);
    }

    @Override
    public List<TtActDetailEntity> getDetailList(List<String> codes) {
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actDetailCode", codes);
        return this.auditActDetailDao.selectByExample(example);
    }

    @Override
    public TtActDetailEntity getActDetailEntity(String id, String code) {
        if (StringUtil.isNotBlank((CharSequence)id)) {
            return (TtActDetailEntity)this.auditActDetailDao.selectByPrimaryKey(id);
        }
        Example example = new Example(TtActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actDetailCode", (Object)code);
        return (TtActDetailEntity)this.auditActDetailDao.selectOneByExample(example);
    }

    @Override
    public AjaxJson saveAuditAmountForAct(String actDetailCode, BigDecimal auditAmount, String auditStatus, String status) {
        AjaxJson ajaxJson = new AjaxJson();
        String string = auditStatus = StringUtil.isBlank((CharSequence)auditStatus) ? ConstantEnum.YesNoEnum.ZERO.getValue() : auditStatus;
        if (StringUtil.isBlank((CharSequence)actDetailCode) || auditAmount == null || StringUtil.isBlank((CharSequence)status)) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtActDetailEntity entity = this.getActDetailEntity(null, actDetailCode);
        if (entity == null) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        if (ConstantEnum.YesNoEnum.ONE.getValue().equals(status)) {
            ajaxJson = this.checkActDetail(actDetailCode, auditAmount);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
            auditStatus = this.checkActDetailAuditStatus(ajaxJson, auditStatus, entity, auditAmount);
        } else {
            auditStatus = ConstantEnum.YesNoEnum.ZERO.getValue();
            auditAmount = auditAmount.multiply(new BigDecimal(-1));
        }
        BigDecimal amount = entity.getAuditAmount().add(auditAmount);
        TtActDetailEntity updateEntity = new TtActDetailEntity();
        updateEntity.setAuditAmount(amount);
        updateEntity.setId(entity.getId());
        updateEntity.setAuditStatus(auditStatus);
        this.auditActDetailDao.updateByPrimaryKeySelective(updateEntity);
        return ajaxJson;
    }

    private String checkActDetailAuditStatus(AjaxJson ajaxJson, String auditStatus, TtActDetailEntity entity, BigDecimal auditAmount) {
        if (ConstantEnum.YesNoEnum.ZERO.getValue().equals(auditStatus)) {
            Map attributes = ajaxJson.getAttributes();
            TtCostTypeFineEntity costTypeFineEntity = (TtCostTypeFineEntity)attributes.get("costTypeFineEntity");
            if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)costTypeFineEntity.getIsMultipleAudit())) {
                auditStatus = ConstantEnum.YesNoEnum.ONE.getValue();
            } else {
                BigDecimal amount;
                BigDecimal maxAmount = (BigDecimal)attributes.get("maxAmount");
                if (maxAmount.compareTo(amount = entity.getAuditAmount().add(auditAmount)) == 0) {
                    auditStatus = ConstantEnum.YesNoEnum.ONE.getValue();
                }
            }
        }
        return auditStatus;
    }

    public AjaxJson checkActDetail(String actDetailCode, BigDecimal auditAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TtActDetailEntity entity = this.getActDetailEntity(null, actDetailCode);
        TtCostTypeFineEntity costTypeFineEntity = (TtCostTypeFineEntity)this.ttCostTypeFeign.getFineEntity(null, entity.getActSubclassCode()).getObj();
        String isMultipleAudit = costTypeFineEntity.getIsMultipleAudit();
        if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ZERO.getValue(), (String)isMultipleAudit) && StringUtil.equals((String)entity.getAuditStatus(), (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
            throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + "\u53ea\u80fd\u6838\u9500\u4e00\u6b21");
        }
        ArrayList<String> rules = new ArrayList<String>();
        rules.add(ConstantEnum.FIELD_NAME.above_audit.name());
        Map map = this.ttCostTypeFeign.findCostTypeCons(actDetailCode, rules).getMapT();
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal amount = entity.getAuditAmount() == null ? BigDecimal.ZERO : entity.getAuditAmount();
        amount = amount.add(auditAmount);
        if (map.isEmpty() || !map.containsKey(ConstantEnum.FIELD_NAME.above_audit.name())) {
            maxAmount = entity.getAmount();
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        } else {
            BigDecimal extraAuditRatio = costTypeFineEntity.getExtraAuditRatio();
            extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
            maxAmount = entity.getAmount().multiply(extraAuditRatio).divide(new BigDecimal(100)).add(entity.getAmount());
            if (amount.compareTo(maxAmount) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\uff1a" + actDetailCode + " \u5df2\u7ecf\u6838\u9500\u91d1\u989d" + entity.getAuditAmount() + "\u672c\u6b21\u6838\u9500\u91d1\u989d" + auditAmount + " \u8d85\u8fc7\u6700\u5927\u53ef\u6838\u9500\u91d1\u989d" + maxAmount);
            }
        }
        attributes.put("costTypeFineEntity", costTypeFineEntity);
        attributes.put("maxAmount", maxAmount);
        ajaxJson.setAttributes(attributes);
        return ajaxJson;
    }
}

