/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.controller;

import com.biz.eisp.act.act.TtActFeign;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActFineEntity;
import com.biz.eisp.attachment.entity.TtAuditActAttachment;
import com.biz.eisp.attachment.entity.TtAuditAttachmentEntity;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.fee.TtFeeBudgetFeign;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.service.TtAuditActAttachmentService;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditAttachmentService;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/ttAuditActDetailController"})
public class TtAuditActDetailController {
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtActFeign ttActFeign;
    @Autowired
    private TtFeeBudgetFeign ttFeeBudgetFeign;
    @Autowired
    private TtAuditActAttachmentService ttAuditActAttachmentService;
    @Autowired
    private TtAuditAttachmentService ttAuditAttachmentService;

    @PostMapping(value={"insertList"})
    public AjaxJson insertList(@RequestBody List<TtAuditActDetailEntity> auditActDetailEntities) {
        AjaxJson ajaxJson = new AjaxJson();
        Integer i = this.ttAuditActDetailService.insertList(auditActDetailEntities);
        if (i < 0) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6dfb\u52a0\u6838\u9500\u6d3b\u52a8\u660e\u7ec6\u8868\u5931\u8d25");
        }
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"findTtAuditActDetailPage"})
    public DataGrid findTtAuditActDetailPage(HttpServletRequest request, TtAuditActDetailVo vo) {
        List<TtAuditActDetailEntity> info = this.ttAuditActDetailService.findTtAuditActDetailList(vo);
        return new DataGrid(info, null);
    }

    @ResponseBody
    @RequestMapping(value={"findAuditDetailSelectPage"})
    public DataGrid findAuditDetailSelectPage(HttpServletRequest request, TtAuditActDetailEntity entity) {
        EuPage page = new EuPage(request);
        List list = DictUtil.getDictList((String)"act_apply_audit_acount");
        ArrayList actTypes = new ArrayList();
        list.forEach(item -> {
            Map extendMap = item.getExtendMap();
            if (!extendMap.isEmpty()) {
                String actTypeEnum = extendMap.get("actTypeEnum").toString();
                String isAcount = extendMap.get("isAcount").toString();
                if (StringUtil.equals((String)isAcount, (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
                    actTypes.add(actTypeEnum);
                }
            }
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(actTypes)) {
            entity.setActTypes(actTypes);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        PageInfo<TtAuditActDetailEntity> info = this.ttAuditActDetailService.findAuditDetailSelectPage(entity, (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            List dictDataEntities = DictUtil.getDictList((String)"pay_type");
            for (Object item2 : dictDataEntities) {
                if (item2.getExtendMap() != null && item2.getExtendMap().containsKey("pay_type_code") && item2.getExtendMap().get("pay_type_code") != null) {
                    map.put(item2.getDictCode(), item2.getExtendMap().get("pay_type_code").toString());
                    continue;
                }
                map.put(item2.getDictCode(), "");
            }
            List<String> actDetailCodes = new ArrayList<String>();
            for (TtAuditActDetailEntity auditActDetailEntity : info.getList()) {
                actDetailCodes.add(auditActDetailEntity.getActDetailCode());
                BigDecimal feeUsed = auditActDetailEntity.getFeeUsed() == null ? BigDecimal.ZERO : auditActDetailEntity.getFeeUsed();
                auditActDetailEntity.setFeeUseable(auditActDetailEntity.getCurrentAmount().subtract(feeUsed));
                if (map.containsKey(auditActDetailEntity.getPayType())) {
                    auditActDetailEntity.setPayTypeCode((String)map.get(auditActDetailEntity.getPayType()));
                    continue;
                }
                auditActDetailEntity.setPayTypeCode("");
            }
            List actEntities = this.ttActFeign.getActEntitysByDetailCode(actDetailCodes = actDetailCodes.stream().distinct().collect(Collectors.toList())).getObjList();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)actEntities)) {
                HashMap<String, TtActEntity> actMap = new HashMap<String, TtActEntity>();
                ArrayList<String> budgetCodes = new ArrayList<String>();
                for (TtActEntity actEntity : actEntities) {
                    budgetCodes.add(actEntity.getBudgetCode());
                    actMap.put(actEntity.getActCode(), actEntity);
                }
                List budgetEntities = this.ttFeeBudgetFeign.getEntityByCodes(budgetCodes).getObjList();
                budgetEntities = budgetEntities == null ? new ArrayList() : budgetEntities;
                Map<String, TtFeeBudgetEntity> budgetMap = budgetEntities.stream().collect(Collectors.toMap(TtFeeBudgetEntity::getBudgetCode, item -> item));
                for (TtAuditActDetailEntity auditActDetailEntity : info.getList()) {
                    String actCode = auditActDetailEntity.getActCode();
                    TtActEntity temp = (TtActEntity)actMap.get(actCode);
                    if (!actMap.containsKey(actCode)) continue;
                    auditActDetailEntity.setBeginDate(temp.getBeginDate());
                    auditActDetailEntity.setEndDate(temp.getEndDate());
                    if (!budgetMap.containsKey(temp.getBudgetCode())) continue;
                    auditActDetailEntity.setBudgetSubjectsCode(budgetMap.get(temp.getBudgetCode()).getBudgetSubjectsCode());
                    auditActDetailEntity.setBudgetSubjectsName(budgetMap.get(temp.getBudgetCode()).getBudgetSubjectsName());
                }
            }
        }
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"saveAuditActDetail"})
    public AjaxJson saveAuditActDetail(HttpServletRequest request, String tempUuid, String acts) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActDetailService.saveAuditActDetail(tempUuid, acts);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"updateAuditActDetail"})
    public AjaxJson updateAuditActDetail(String saveJsonData) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActDetailService.updateAuditActDetail(saveJsonData);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"delActDetail"})
    public AjaxJson delActDetail(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.ttAuditActDetailService.delByIds(ids);
        }
        return j;
    }

    @PostMapping(value={"getCodes"})
    public AjaxJson<TtAuditActDetailEntity> getCodes(@RequestBody List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> list = this.ttAuditActDetailService.getCodes(codes);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @GetMapping(value={"updateUsedAmount"})
    public AjaxJson updateUsedAmount(@RequestParam(value="auditDetailCode") String auditDetailCode, @RequestParam(value="accountAmount") BigDecimal accountAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        this.ttAuditActDetailService.updateUsedAmount(auditDetailCode, accountAmount);
        return ajaxJson;
    }

    @PostMapping(value={"saveOrUpdateDetailUpload"})
    AjaxJson<TtActFineEntity> saveOrUpdateActFine(@RequestBody List<TtAuditActAttachment> actAttachments) {
        AjaxJson ajaxJson = new AjaxJson();
        for (TtAuditActAttachment actAttachment : actAttachments) {
            this.ttAuditActAttachmentService.clearData(actAttachment);
            this.ttAuditActAttachmentService.insertSelective(actAttachment);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)actAttachment.getAttachs())) continue;
            actAttachment.getAttachs().forEach(item -> item.setBusinessKey(actAttachment.getId()));
            this.ttAuditAttachmentService.insertList(actAttachment.getAttachs());
        }
        return ajaxJson;
    }

    @GetMapping(value={"deleteDetailAttachment"})
    public AjaxJson deleteDetailAttachment(@RequestParam(value="id") String id) {
        AjaxJson j = new AjaxJson();
        this.ttAuditAttachmentService.deleteByPrimaryKey(id);
        return j;
    }

    @PostMapping(value={"getActAttachment"})
    public AjaxJson<TtAuditActAttachment> getActAttachment(@RequestBody TtAuditActAttachment actAttachment) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtAuditActAttachment.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actDetailCode", (Object)actAttachment.getActDetailCode());
        criteria.andEqualTo("actSubclassCode", (Object)actAttachment.getActSubclassCode());
        List list = this.ttAuditActAttachmentService.selectExample(example);
        this.buildAttachment(list);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    private void buildAttachment(List<TtAuditActAttachment> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                Example example = new Example(TtAuditAttachmentEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("businessKey", (Object)item.getId());
                item.setAttachs(this.ttAuditAttachmentService.selectExample(example));
            });
        }
    }

    @GetMapping(value={"/getAuditActDetail"})
    public AjaxJson<TtAuditActDetailEntity> getAuditActDetail(@RequestParam(value="id", required=false) String id, @RequestParam(value="auditDetailCode", required=false) String auditDetailCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditActDetailEntity detailEntity = this.ttAuditActDetailService.getAuditActDetail(id, auditDetailCode);
        ajaxJson.setObj((Object)detailEntity);
        return ajaxJson;
    }
}

