/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.act.TtActFeign;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.api.feign.TmRoleFeign;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.audit.vo.TtAuditVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.dao.TtAuditActDao;
import com.biz.eisp.pay.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.pay.audit.dao.TtAuditDao;
import com.biz.eisp.pay.audit.service.AuditFindTtAuditPageExtend;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditActivitiCallExtend;
import com.biz.eisp.pay.audit.service.TtAuditService;
import com.biz.eisp.pay.saledata.service.TtRealSalesDataService;
import com.biz.eisp.role.TmRoleVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditServiceImpl
extends BaseServiceImpl<TtAuditEntity>
implements TtAuditService {
    @Autowired
    private TtAuditDao ttAuditDao;
    @Autowired
    private TtAuditActDao ttAuditActDao;
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private TtActFeign ttActFeign;
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;
    @Autowired(required=false)
    private TtAuditActivitiCallExtend ttAuditActivitiCallExtend;
    @Autowired
    private TmRoleFeign tmRoleFeign;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private AuditFindTtAuditPageExtend auditFindTtAuditPageExtend;

    @Override
    public PageInfo<TtAuditVo> findTtAuditPage(TtAuditVo vo, Page page) {
        List authEntities;
        List roleVos;
        Map<String, Object> roleValMap;
        String funId = ThreadLocalUtil.getVal();
        StringBuffer buffer = new StringBuffer();
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && (!(roleValMap = (roleVos = ApiResultUtil.listResult((AjaxJson)this.tmRoleFeign.getRolesByPos(userRedis.getPosId(), userRedis.getPosCode()), (boolean)true)).stream().collect(Collectors.toMap(TmRoleVo::getRoleCode, getRoleCode -> getRoleCode))).containsKey(Globals.Admin_Name) || !Globals.Admin_Name.equals(userRedis.getUsername())) && CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true)))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String expandSql;
                    String temp;
                    List codes;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"a.org_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append("  a.org_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("position")) {
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("40")) {
                            codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAllPosCodeByUser(userRedis.getId(), userRedis.getUsername(), Integer.valueOf(1)), (boolean)true);
                            if (!CollectionUtil.listNotEmptyNotSizeZero((List)codes)) {
                                codes.add("_");
                            }
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"a.position_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            buffer.append("  a.position_code = '" + userRedis.getPosCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (this.auditFindTtAuditPageExtend != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.auditFindTtAuditPageExtend.findTtAuditPage(auMap, userRedis, flagOr, buffer)))) {
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditDao.findTtAuditList(vo, aUsql), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtAuditServiceImpl.class)
    public void saveAudit(TtAuditVo vo) {
        TtAuditEntity entity = new TtAuditEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtAuditEntity)this.selectByPrimaryKey(vo.getId());
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            this.updateByPrimaryKeySelective(entity);
        } else {
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setAuditCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_head.name()));
            this.insertSelective(entity);
        }
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actlist = this.ttAuditActDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)actlist)) {
            throw new RuntimeException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8!");
        }
        String auditCode = entity.getAuditCode();
        actlist.stream().filter(act -> StringUtils.isBlank((CharSequence)act.getAuditCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
        });
        this.ttAuditActDao.updateBatchByPrimaryKeySelective(actlist);
        this.updateAuditActDetail(vo.getUpdatedJsonData());
        Example exampleDetail = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actDetaillist = this.ttAuditActDetailDao.selectByExample(exampleDetail);
        if (CollectionUtil.listEmpty((List)actlist)) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8\u660e\u7ec6!");
        }
        ArrayList fineCodeList = new ArrayList();
        actDetaillist.forEach(item -> fineCodeList.add(item.getActSubclassCode()));
        List ttCostTypeFineList = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeFeign.findFineListByCodes(fineCodeList));
        HashMap fineExtraAuditRatioMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttCostTypeFineList)) {
            ttCostTypeFineList.forEach(item -> fineExtraAuditRatioMap.put(item.getFineCode(), null != item.getExtraAuditRatio() ? item.getExtraAuditRatio() : BigDecimal.ZERO));
        }
        int lineNo = 1;
        HashMap<String, BigDecimal> actDetailMap = new HashMap<String, BigDecimal>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetaillist)) {
            ArrayList<String> actDetailCode = new ArrayList();
            actDetailCode = actDetaillist.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toList());
            List<TtActDetailEntity> detailEntity = this.auditActService.getDetailList(actDetailCode);
            for (TtActDetailEntity item2 : detailEntity) {
                BigDecimal tempAmount = item2.getAuditAmount() == null ? BigDecimal.ZERO : item2.getAuditAmount();
                actDetailMap.put(item2.getActDetailCode(), tempAmount);
            }
        }
        for (TtAuditActDetailEntity item3 : actDetaillist) {
            BigDecimal extraAuditRatio = (BigDecimal)fineExtraAuditRatioMap.get(item3.getActSubclassCode());
            extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
            BigDecimal maxAuditAmount = BigDecimal.ONE.add(extraAuditRatio.divide(new BigDecimal("100"))).multiply(item3.getAmount()).setScale(2, 1);
            if (!actDetailMap.containsKey(item3.getActDetailCode())) {
                throw new BusinessException(item3.getActDetailCode() + "\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            BigDecimal auditAmount = (BigDecimal)actDetailMap.get(item3.getActDetailCode());
            BigDecimal bigDecimal = auditAmount = auditAmount == null ? BigDecimal.ZERO : auditAmount;
            if (maxAuditAmount.compareTo(auditAmount.add(item3.getCurrentAmount())) < 0) {
                throw new BusinessException("\u7b2c" + lineNo + "\u884c,\u672c\u6b21\u6838\u9500\u91d1\u989d+\u5df2\u6838\u9500\u91d1\u989d,\u5df2\u5927\u4e8e\u6700\u5927\u6838\u9500\u91d1\u989d.");
            }
            ++lineNo;
        }
        actDetaillist.stream().filter(ad -> StringUtils.isBlank((CharSequence)ad.getAuditDetailCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
            item.setAuditDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_detail.name()));
        });
        this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(actDetaillist);
    }

    @Override
    public void doAuditCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        String id = activitiCallBackVo.getBusinessObjId();
        this.updateAuditBpmStatus(activitiCallBackVo.getBpmStatus(), id);
        if (!StringUtils.equals((CharSequence)activitiCallBackVo.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.PASS.getValue())) {
            this.backSubAuditAndUpdateAct(id);
        }
        if (this.ttAuditActivitiCallExtend != null) {
            this.ttAuditActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    @Override
    public void updateAuditBpmStatus(String status, String id) {
        TtAuditEntity entity = new TtAuditEntity();
        entity.setId(id);
        entity.setBpmStatus(status);
        this.ttAuditDao.updateByPrimaryKeySelective(entity);
    }

    public void updateAuditActDetail(String saveDatas) {
        JSONArray jsonArray;
        if (StringUtils.isNotBlank((CharSequence)saveDatas) && (jsonArray = JSON.parseArray((String)saveDatas)) != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActDetailEntity> list = new ArrayList<TtAuditActDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtAuditActDetailVo vo = (TtAuditActDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtAuditActDetailVo.class);
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38");
                }
                list.add(entity);
            }
            this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(list);
        }
    }

    @Override
    public AjaxJson checkSubAuditAndUpdateAct(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> entityList = this.ttAuditActDetailService.getDetailsByCodeAndId(null, id);
        entityList.forEach(item -> {
            this.auditActService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "1");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
            String ymonth = formatter.format(new Date());
            item.setYmonth(ymonth);
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
            this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(entityList);
        }
        List detailCodes = entityList.stream().map(TtAuditActDetailEntity::getActDetailCode).distinct().collect(Collectors.toList());
        ajaxJson = this.ttActFeign.updateAuditStatus(detailCodes);
        return ajaxJson;
    }

    @Override
    public void backSubAuditAndUpdateAct(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> entityList = this.ttAuditActDetailService.getDetailsByCodeAndId(null, id);
        entityList.forEach(item -> this.auditActService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "0"));
        List detailCodes = entityList.stream().map(TtAuditActDetailEntity::getActDetailCode).distinct().collect(Collectors.toList());
        this.ttActFeign.updateAuditStatus(detailCodes);
    }

    @Override
    public TtAuditEntity getEntity(String id, String auditCode) {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (TtAuditEntity)this.ttAuditDao.selectByPrimaryKey(id);
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            Example example = new Example(TtAuditEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("auditCode", (Object)auditCode);
            List list = this.ttAuditDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                return (TtAuditEntity)list.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getTargetData(String id) {
        String json = "[]";
        return json;
    }
}

