/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.controller;

import com.biz.eisp.act.act.TtActDetailFeign;
import com.biz.eisp.act.act.TtActFeign;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.entity.TtActFineEntity;
import com.biz.eisp.attachment.entity.TtAuditActAttachment;
import com.biz.eisp.attachment.entity.TtAuditAttachmentEntity;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseIdEntity;
import com.biz.eisp.budget.auditinfo.TtAuditInfoFeign;
import com.biz.eisp.budget.auditinfo.entity.TtAuditInfoEntity;
import com.biz.eisp.budget.fee.TtFeeBudgetFeign;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.controller.ActSubclass;
import com.biz.eisp.pay.audit.controller.TtAuditActDetailUploadPageData;
import com.biz.eisp.pay.audit.service.TtAuditActAttachmentService;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditAttachmentService;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/ttAuditActDetailController"})
public class TtAuditActDetailController {
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtActFeign ttActFeign;
    @Autowired
    private TtActDetailFeign ttActDetailFeign;
    @Autowired
    private TtAuditInfoFeign ttAuditInfoFeign;
    @Autowired
    private TtFeeBudgetFeign ttFeeBudgetFeign;
    @Autowired
    private TtAuditActAttachmentService ttAuditActAttachmentService;
    @Autowired
    private TtAuditAttachmentService ttAuditAttachmentService;

    @PostMapping(value={"insertList"})
    public AjaxJson insertList(@RequestBody List<TtAuditActDetailEntity> auditActDetailEntities) {
        AjaxJson ajaxJson = new AjaxJson();
        Integer i = this.ttAuditActDetailService.insertList(auditActDetailEntities);
        if (i < 0) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6dfb\u52a0\u6838\u9500\u6d3b\u52a8\u660e\u7ec6\u8868\u5931\u8d25");
        }
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"findTtAuditActDetailPage"})
    public DataGrid findTtAuditActDetailPage(HttpServletRequest request, TtAuditActDetailVo vo) {
        List<TtAuditActDetailEntity> info = this.ttAuditActDetailService.findTtAuditActDetailList(vo);
        return new DataGrid(info, null);
    }

    @ResponseBody
    @RequestMapping(value={"findAuditDetailSelectPage"})
    public DataGrid findAuditDetailSelectPage(HttpServletRequest request, TtAuditActDetailEntity entity) {
        EuPage page = new EuPage(request);
        List list = DictUtil.getDictList((String)"act_apply_audit_acount");
        ArrayList actTypes = new ArrayList();
        list.forEach(item -> {
            Map extendMap = item.getExtendMap();
            if (!extendMap.isEmpty()) {
                String actTypeEnum = extendMap.get("actTypeEnum").toString();
                String isAcount = extendMap.get("isAcount").toString();
                if (StringUtil.equals((String)isAcount, (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
                    actTypes.add(actTypeEnum);
                }
            }
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(actTypes)) {
            entity.setActTypes(actTypes);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        PageInfo<TtAuditActDetailEntity> info = this.ttAuditActDetailService.findAuditDetailSelectPage(entity, (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            List dictDataEntities = DictUtil.getDictList((String)"pay_type");
            for (Object item2 : dictDataEntities) {
                if (item2.getExtendMap() != null && item2.getExtendMap().containsKey("pay_type_code") && item2.getExtendMap().get("pay_type_code") != null) {
                    map.put(item2.getDictCode(), item2.getExtendMap().get("pay_type_code").toString());
                    continue;
                }
                map.put(item2.getDictCode(), "");
            }
            List<String> actDetailCodes = new ArrayList<String>();
            for (TtAuditActDetailEntity auditActDetailEntity : info.getList()) {
                actDetailCodes.add(auditActDetailEntity.getActDetailCode());
                BigDecimal feeUsed = auditActDetailEntity.getFeeUsed() == null ? BigDecimal.ZERO : auditActDetailEntity.getFeeUsed();
                auditActDetailEntity.setFeeUseable(auditActDetailEntity.getCurrentAmount().subtract(feeUsed));
                if (map.containsKey(auditActDetailEntity.getPayType())) {
                    auditActDetailEntity.setPayTypeCode((String)map.get(auditActDetailEntity.getPayType()));
                    continue;
                }
                auditActDetailEntity.setPayTypeCode("");
            }
            List actEntities = this.ttActFeign.getActEntitysByDetailCode(actDetailCodes = actDetailCodes.stream().distinct().collect(Collectors.toList())).getObjList();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)actEntities)) {
                HashMap<String, TtActEntity> actMap = new HashMap<String, TtActEntity>();
                ArrayList<String> budgetCodes = new ArrayList<String>();
                for (TtActEntity actEntity : actEntities) {
                    budgetCodes.add(actEntity.getBudgetCode());
                    actMap.put(actEntity.getActCode(), actEntity);
                }
                List budgetEntities = this.ttFeeBudgetFeign.getEntityByCodes(budgetCodes).getObjList();
                budgetEntities = budgetEntities == null ? new ArrayList() : budgetEntities;
                Map<String, TtFeeBudgetEntity> budgetMap = budgetEntities.stream().collect(Collectors.toMap(TtFeeBudgetEntity::getBudgetCode, item -> item));
                for (TtAuditActDetailEntity auditActDetailEntity : info.getList()) {
                    String actCode = auditActDetailEntity.getActCode();
                    TtActEntity temp = (TtActEntity)actMap.get(actCode);
                    if (!actMap.containsKey(actCode)) continue;
                    auditActDetailEntity.setBeginDate(temp.getBeginDate());
                    auditActDetailEntity.setEndDate(temp.getEndDate());
                    if (!budgetMap.containsKey(temp.getBudgetCode())) continue;
                    auditActDetailEntity.setBudgetSubjectsCode(budgetMap.get(temp.getBudgetCode()).getBudgetSubjectsCode());
                    auditActDetailEntity.setBudgetSubjectsName(budgetMap.get(temp.getBudgetCode()).getBudgetSubjectsName());
                }
            }
        }
        if (info != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ResponseBody
    @RequestMapping(value={"saveAuditActDetail"})
    public AjaxJson saveAuditActDetail(HttpServletRequest request, String tempUuid, String acts) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActDetailService.saveAuditActDetail(tempUuid, acts);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"updateAuditActDetail"})
    public AjaxJson updateAuditActDetail(String saveJsonData) {
        AjaxJson j = new AjaxJson();
        this.ttAuditActDetailService.updateAuditActDetail(saveJsonData);
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"delActDetail"})
    public AjaxJson delActDetail(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.ttAuditActDetailService.delByIds(ids);
        }
        return j;
    }

    @PostMapping(value={"getCodes"})
    public AjaxJson<TtAuditActDetailEntity> getCodes(@RequestBody List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> list = this.ttAuditActDetailService.getCodes(codes);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @GetMapping(value={"updateUsedAmount"})
    public AjaxJson updateUsedAmount(@RequestParam(value="auditDetailCode") String auditDetailCode, @RequestParam(value="accountAmount") BigDecimal accountAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        this.ttAuditActDetailService.updateUsedAmount(auditDetailCode, accountAmount);
        return ajaxJson;
    }

    @GetMapping(value={"getTtAuditActDetailUploadPageData"})
    @ResponseBody
    public AjaxJson<TtAuditActDetailUploadPageData> getTtAuditActDetailUploadPageData(@RequestParam(required=true) String ids, @RequestParam(defaultValue="true") boolean editable, @RequestParam(required=true) String tempUuid) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditActDetailUploadPageData data = new TtAuditActDetailUploadPageData();
        data.setIds(ids);
        data.setEditable(editable);
        data.setTempUuid(tempUuid);
        ajaxJson.setData((Object)data);
        if (StringUtils.isBlank((CharSequence)ids)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg("\u8bf7\u6307\u5b9a\u6838\u9500\u6d3b\u52a8\u660e\u7ec6\u3002");
            return ajaxJson;
        }
        HashSet setIds = Sets.newHashSet((Object[])(ids = ids.replaceAll(" ", "")).split(","));
        List<TtAuditActDetailEntity> ttAuditActDetailEntitys = this.ttAuditActDetailService.getAuditActDetailByIds(setIds, null);
        Set actDetailCodes = ttAuditActDetailEntitys.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toSet());
        List ttActDetailEntitys = this.ttActDetailFeign.findDetailByCodes((List)Lists.newArrayList(actDetailCodes)).getObjList();
        if (CollectionUtils.isEmpty((Collection)ttActDetailEntitys)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg("\u6ca1\u6709\u83b7\u53d6\u5230\u6d3b\u52a8\u7ec6\u7c7b\u6570\u636e\u3002");
            return ajaxJson;
        }
        Map<String, String> actSubclassCodeMapName = ttActDetailEntitys.stream().collect(Collectors.toMap(TtActDetailEntity::getActSubclassCode, item -> item.getActSubclassName(), (val1, val2) -> val2));
        Map<String, List<TtActDetailEntity>> actSubclassCodeMapEntity = ttActDetailEntitys.stream().collect(Collectors.groupingBy(TtActDetailEntity::getActSubclassCode));
        HashMap actSubclassCodeMapFineStr = Maps.newHashMap();
        HashSet fineStrTotal = Sets.newHashSet();
        for (Map.Entry<String, List<TtActDetailEntity>> entry : actSubclassCodeMapEntity.entrySet()) {
            List<TtActDetailEntity> vals = entry.getValue();
            if (CollectionUtils.isEmpty((Collection)ttActDetailEntitys)) continue;
            HashSet fineStrSet = Sets.newHashSet();
            for (TtActDetailEntity ttActDetailEntity : vals) {
                String getFineStr = ttActDetailEntity.getFineStr();
                if (StringUtils.isBlank((CharSequence)getFineStr)) continue;
                fineStrSet.addAll(Lists.newArrayList((Object[])getFineStr.split(",")));
            }
            actSubclassCodeMapFineStr.put(entry.getKey(), fineStrSet);
            fineStrTotal.addAll(fineStrSet);
        }
        List demoFilesTotal = this.ttAuditInfoFeign.getTtAuditInfoEntitysByFineCodes((Set)fineStrTotal).getObjList();
        Map<String, TtAuditInfoEntity> demoFilesCodeMap = demoFilesTotal.stream().collect(Collectors.toMap(TtAuditInfoEntity::getCode, item -> item));
        Map<String, TtAuditActAttachment> auditAttsMap = this.loadAuditAttsMap(tempUuid);
        ArrayList actSubclassList = Lists.newArrayList();
        for (Map.Entry entry : actSubclassCodeMapFineStr.entrySet()) {
            ActSubclass actSubclass = new ActSubclass();
            String actSubclassCodeTemp = (String)entry.getKey();
            actSubclass.setActSubclassCode(actSubclassCodeTemp);
            actSubclass.setActSubclassName(actSubclassCodeMapName.get(actSubclassCodeTemp));
            HashMap uploadFilesMapping = Maps.newHashMap();
            ArrayList demoFiles = Lists.newArrayList();
            Set fineStrs = (Set)entry.getValue();
            fineStrs.stream().forEach(item -> {
                if (demoFilesCodeMap.containsKey(item)) {
                    demoFiles.add(demoFilesCodeMap.get(item));
                }
                uploadFilesMapping.put(item, auditAttsMap.get(actSubclassCodeTemp + "-" + item));
            });
            actSubclass.setDemoFiles(demoFiles);
            actSubclass.setUploadFilesMapping(uploadFilesMapping);
            actSubclassList.add(actSubclass);
        }
        data.setActSubclassList(actSubclassList);
        return ajaxJson;
    }

    private Map<String, TtAuditActAttachment> loadAuditAttsMap(String tempUuid) {
        List<TtAuditActAttachment> auditAtts = this.loadTtAuditActAttachmentByUuid(tempUuid);
        Set ttAuditActAttachmentids = auditAtts.stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(ttAuditActAttachmentids)) {
            return Maps.newHashMap();
        }
        Example example = new Example(TtAuditAttachmentEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("businessKey", ttAuditActAttachmentids);
        Map<String, List<TtAuditAttachmentEntity>> attFiles = this.ttAuditAttachmentService.selectExample(example).stream().collect(Collectors.groupingBy(TtAuditAttachmentEntity::getBusinessKey));
        auditAtts.stream().forEach(item -> item.setAttachs((List)attFiles.get(item.getId())));
        Map<String, TtAuditActAttachment> auditAttsMap = auditAtts.stream().collect(Collectors.toMap(item -> item.getActSubclassCode() + "-" + item.getExampleCode(), item -> item));
        return auditAttsMap;
    }

    private List<TtAuditActAttachment> loadTtAuditActAttachmentByUuid(String tempUuid) {
        Example example = new Example(TtAuditActAttachment.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        List auditAtts = this.ttAuditActAttachmentService.selectExample(example);
        return auditAtts;
    }

    @PostMapping(value={"saveTtAuditActDetailUploadPageData"})
    AjaxJson<TtActFineEntity> saveTtAuditActDetailUploadPageData(@RequestBody TtAuditActDetailUploadPageData data) {
        this.ttAuditActAttachmentService.saveTtAuditActDetailUploadPageData(data);
        return new AjaxJson();
    }

    @PostMapping(value={"saveOrUpdateDetailUpload"})
    AjaxJson<TtActFineEntity> saveOrUpdateActFine(@RequestBody List<TtAuditActAttachment> actAttachments) {
        AjaxJson ajaxJson = new AjaxJson();
        String uuid = null;
        if (CollectionUtil.listNotEmptyNotSizeZero(actAttachments) && StringUtils.isBlank((CharSequence)(uuid = actAttachments.get(0).getTempUuid()))) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg("\u672a\u83b7\u53d6\u5230TEMPUUID");
            return ajaxJson;
        }
        this.ttAuditActAttachmentService.clearDataByTempUUID(uuid);
        for (TtAuditActAttachment actAttachment : actAttachments) {
            this.ttAuditActAttachmentService.insertSelective(actAttachment);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)actAttachment.getAttachs())) continue;
            actAttachment.getAttachs().forEach(item -> item.setBusinessKey(actAttachment.getId()));
            this.ttAuditAttachmentService.insertList(actAttachment.getAttachs());
        }
        return ajaxJson;
    }

    @GetMapping(value={"deleteDetailAttachment"})
    public AjaxJson deleteDetailAttachment(@RequestParam(value="id") String id) {
        AjaxJson j = new AjaxJson();
        this.ttAuditAttachmentService.deleteByPrimaryKey(id);
        return j;
    }

    @PostMapping(value={"getActAttachment"})
    public AjaxJson<TtAuditActAttachment> getActAttachment(@RequestBody TtAuditActAttachment actAttachment) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtAuditActAttachment.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("actDetailCode", (Object)actAttachment.getActDetailCode());
        criteria.andEqualTo("actSubclassCode", (Object)actAttachment.getActSubclassCode());
        List list = this.ttAuditActAttachmentService.selectExample(example);
        this.buildAttachment(list);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    private void buildAttachment(List<TtAuditActAttachment> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                Example example = new Example(TtAuditAttachmentEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("businessKey", (Object)item.getId());
                item.setAttachs(this.ttAuditAttachmentService.selectExample(example));
            });
        }
    }

    @GetMapping(value={"/getAuditActDetail"})
    public AjaxJson<TtAuditActDetailEntity> getAuditActDetail(@RequestParam(value="id", required=false) String id, @RequestParam(value="auditDetailCode", required=false) String auditDetailCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditActDetailEntity detailEntity = this.ttAuditActDetailService.getAuditActDetail(id, auditDetailCode);
        ajaxJson.setObj((Object)detailEntity);
        return ajaxJson;
    }

    @GetMapping(value={"/getAuditActDetailByIds"})
    public AjaxJson<List<TtAuditActDetailEntity>> getAuditActDetailByIds(@RequestParam(value="ids", required=false) Set<String> ids, @RequestParam(value="auditDetailCode", required=false) String auditDetailCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtAuditActDetailEntity> detailEntitys = this.ttAuditActDetailService.getAuditActDetailByIds(ids, auditDetailCode);
        ajaxJson.setObj(detailEntitys);
        return ajaxJson;
    }
}

