/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.service.impl;

import com.biz.eisp.attachment.entity.TtAuditActAttachment;
import com.biz.eisp.attachment.entity.TtAuditAttachmentEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.glob.entity.BaseIdEntity;
import com.biz.eisp.pay.audit.controller.ActSubclass;
import com.biz.eisp.pay.audit.controller.TtAuditActDetailUploadPageData;
import com.biz.eisp.pay.audit.dao.TtAuditActAttachmentDao;
import com.biz.eisp.pay.audit.service.TtAuditActAttachmentService;
import com.biz.eisp.pay.audit.service.TtAuditAttachmentService;
import com.biz.eisp.service.BaseServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtAuditActAttachmentServiceImpl
extends BaseServiceImpl<TtAuditActAttachment>
implements TtAuditActAttachmentService {
    @Autowired
    private TtAuditActAttachmentDao ttAuditActAttachmentDao;
    @Autowired
    private TtAuditAttachmentService ttAuditAttachmentService;

    @Override
    public void clearData(TtAuditActAttachment actAttachment) {
        String tempUuid = actAttachment.getTempUuid();
        String actDetailCode = actAttachment.getActSubclassCode();
        String exampleCode = actAttachment.getActSubclassCode();
        if (StringUtil.isBlank((CharSequence)exampleCode) && StringUtil.isBlank((CharSequence)actDetailCode)) {
            return;
        }
        Example example = new Example(TtAuditActAttachment.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        criteria.andEqualTo("actDetailCode", (Object)actDetailCode);
        criteria.andEqualTo("exampleCode", (Object)exampleCode);
        this.ttAuditActAttachmentDao.deleteByExample(example);
    }

    @Override
    public void clearDataByTempUUID(String uuid) {
        if (StringUtil.isBlank((CharSequence)uuid)) {
            return;
        }
        this.clearOldFiles(uuid);
        Example example = new Example(TtAuditActAttachment.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)uuid);
        this.ttAuditActAttachmentDao.deleteByExample(example);
    }

    @Override
    public void saveTtAuditActDetailUploadPageData(TtAuditActDetailUploadPageData data) {
        String uuid = data.getTempUuid();
        if (StringUtils.isBlank((CharSequence)uuid)) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1atempUuid");
        }
        this.clearDataByTempUUID(uuid);
        List<ActSubclass> actSubclassList = data.getActSubclassList();
        if (CollectionUtils.isEmpty(actSubclassList)) {
            return;
        }
        List<TtAuditActAttachment> actAttachments = this.resolveTtAuditActAttachment(actSubclassList);
        if (CollectionUtils.isEmpty(actAttachments)) {
            return;
        }
        this.insertList(actAttachments);
        List<TtAuditAttachmentEntity> newAttachs = this.resolveNewAttachs(actAttachments);
        if (CollectionUtils.isEmpty(newAttachs)) {
            return;
        }
        this.ttAuditAttachmentService.insertList(newAttachs);
    }

    private void clearOldFiles(String uuid) {
        List<TtAuditActAttachment> auditAtts = this.getTtAuditActAttachmentByUuid(uuid);
        Set<String> businessKeys = auditAtts.stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        this.ttAuditAttachmentService.clearByBusinessKeys(businessKeys);
    }

    private List<TtAuditAttachmentEntity> resolveNewAttachs(List<TtAuditActAttachment> actAttachments) {
        ArrayList newAttachs = Lists.newArrayList();
        actAttachments.stream().forEach(item -> {
            List attachsTemp = item.getAttachs();
            if (!CollectionUtils.isEmpty((Collection)actAttachments)) {
                attachsTemp.stream().forEach(auditAttachment -> {
                    auditAttachment.setBusinessKey(item.getId());
                    String fileName = auditAttachment.getFileName();
                    if (StringUtils.isNotBlank((CharSequence)fileName)) {
                        auditAttachment.setExtend(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()));
                    }
                    newAttachs.add(auditAttachment);
                });
            }
        });
        return newAttachs;
    }

    private List<TtAuditActAttachment> resolveTtAuditActAttachment(List<ActSubclass> actSubclassList) {
        ArrayList actAttachments = Lists.newArrayList();
        actSubclassList.stream().forEach(item -> {
            Map<String, TtAuditActAttachment> itemActAttachments = item.getUploadFilesMapping();
            if (!CollectionUtils.isEmpty(itemActAttachments)) {
                for (Map.Entry<String, TtAuditActAttachment> entry : itemActAttachments.entrySet()) {
                    TtAuditActAttachment itemFineActAttachments = entry.getValue();
                    if (null == itemFineActAttachments) continue;
                    actAttachments.add(itemFineActAttachments);
                }
            }
        });
        return actAttachments;
    }

    @Override
    @Transactional(readOnly=true)
    public List<TtAuditActAttachment> getTtAuditActAttachmentByUuid(String tempUuid) {
        Example example = new Example(TtAuditActAttachment.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)tempUuid);
        List auditAtts = this.selectExample(example);
        return auditAtts;
    }
}

