/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.estimate.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.estimate.service.TtEstimateExtractService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.estimate.entity.TtEstimateExtractEntity;
import com.biz.eisp.pay.estimate.vo.TtEstimateExtractVo;
import com.biz.eisp.pay.withholding.TtWithholdingReq;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttEstimateExtractController"})
@Api(value="\u9884\u63d0", tags={"\u9884\u63d0"})
public class TtEstimateExtractController
extends ImpExpController {
    private static final Logger log = LoggerFactory.getLogger(TtEstimateExtractController.class);
    @Autowired
    private TtEstimateExtractService ttEstimateExtractService;

    @GetMapping(value={"getTtEstimateExtractEntity"})
    public AjaxJson<TtEstimateExtractEntity> getTtEstimateExtractEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtEstimateExtractEntity entity = this.ttEstimateExtractService.getTtEstimateExtractEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtEstimateExtractPage"})
    @ResponseBody
    public DataGrid findTtEstimateExtractPage(HttpServletRequest request, TtEstimateExtractVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtEstimateExtractVo> TtEstimateExtractVoPageInfo = this.ttEstimateExtractService.findTtEstimateExtractPage(vo, (Page)page);
        if (TtEstimateExtractVoPageInfo != null) {
            return new DataGrid(TtEstimateExtractVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(TtEstimateExtractVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
                this.ttEstimateExtractService.update(vo);
            } else {
                vo.setEstimateType(TtEstimateExtractEntity.ESTIMATETYPE.MANUAL.getCode());
                this.ttEstimateExtractService.save(vo);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTtEstimateExtract"})
    public AjaxJson deleteTtEstimateExtract(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"feePoolAmountEstimate"})
    @ResponseBody
    public AjaxJson feePoolAmountEstimate() {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.feePoolAmountEstimate()) {
                j.setSuccess(false);
                j.setMsg("\u9884\u63d0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"applyEstimate"})
    @ResponseBody
    public AjaxJson applyEstimate() {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.applyEstimate()) {
                j.setSuccess(false);
                j.setMsg("\u9884\u63d0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"contractCostEstimate"})
    @ResponseBody
    public AjaxJson contractCostEstimate() {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttEstimateExtractService.contractCostEstimate()) {
                j.setSuccess(false);
                j.setMsg("\u9884\u63d0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    @ApiOperation(value="\u9884\u63d0\u6b3e\u9879")
    @RequestMapping(value={"withholding"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public AjaxJson withholding(@RequestBody TtWithholdingReq ttWithholdingReq) {
        AjaxJson j = new AjaxJson();
        CollectionUtils.isEmpty((Collection)ttWithholdingReq.getTypes());
        if (CollectionUtils.isEmpty((Collection)ttWithholdingReq.getTypes())) {
            j.setSuccess(false);
            j.setMsg("\u8bf7\u9009\u62e9\u7c7b\u578b");
            return j;
        }
        try {
            this.ttEstimateExtractService.withholding(ttWithholdingReq);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u9884\u63d0\u5931\u8d25");
        }
        return j;
    }

    @ApiOperation(value="\u67e5\u8be2\u9884\u63d0\u8fdb\u5ea6")
    @RequestMapping(value={"getProgress"}, method={RequestMethod.GET}, produces={"application/json"})
    public AjaxJson getProgress() {
        AjaxJson j = new AjaxJson();
        j.setList(this.ttEstimateExtractService.getProgress());
        return j;
    }

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        return null;
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        return null;
    }
}

