/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.withholding.util;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.audit.dto.ListAuditDetailDto;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.params.Constant;
import com.biz.eisp.pay.withholding.CacheEntity;
import com.biz.eisp.pay.withholding.entity.TtWithholding;
import com.biz.eisp.pay.withholding.vo.ManualReq;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import com.biz.eisp.tools.CodeRuleUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class WithhodingUtil {
    public static String redisTaskKeyPre = "withholding";

    public static String getRedisKey() {
        return redisTaskKeyPre + DateUtils.format((Date)DateUtils.getDate(), (String)"yyyyMM");
    }

    public static CacheEntity findFromCache(List<Object> caches, String type) {
        if (CollectionUtils.isEmpty(caches)) {
            return null;
        }
        for (Object obj : caches) {
            CacheEntity cacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
            if (!cacheEntity.getType().equals(type)) continue;
            return cacheEntity;
        }
        return null;
    }

    public static TtWithholding voToEntity(ManualReq manualReq) {
        TtWithholding entity = new TtWithholding();
        entity.setType(TtWithholding.TYPE.MANUAL.getCode());
        entity.setCode((String)CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)1).get(0));
        entity.setWithholdingDate(manualReq.getWithholdingDate());
        entity.setActDate(manualReq.getActDate());
        entity.setActCode(manualReq.getActCode());
        entity.setActDetailCode(manualReq.getActDetailCode());
        entity.setActName(manualReq.getActName());
        entity.setOrgCode(manualReq.getOrgCode());
        entity.setOrgName(manualReq.getOrgName());
        entity.setCustCode(manualReq.getCustCode());
        entity.setCustName(manualReq.getCustName());
        entity.setBudgetSubjectsCode(manualReq.getBudgetSubjectsCode());
        entity.setBudgetSubjectsName(manualReq.getBudgetSubjectsName());
        entity.setCategoriesCode(manualReq.getCategoriesCode());
        entity.setCategoriesName(manualReq.getCategoriesName());
        entity.setFineCode(manualReq.getFineCode());
        entity.setFineName(manualReq.getFineName());
        entity.setProductLevelCode(manualReq.getProductLevelCode());
        entity.setProductLevelName(manualReq.getProductLevelName());
        entity.setProductCode(manualReq.getProductCode());
        entity.setProductName(manualReq.getProductName());
        entity.setBeginTime(manualReq.getBeginTime());
        entity.setEndTime(manualReq.getEndTime());
        entity.setPayType(manualReq.getPayType());
        entity.setActAmount(manualReq.getActAmount());
        entity.setAmount(manualReq.getFinalAmount());
        entity.setFinalAmount(manualReq.getFinalAmount());
        entity.setManualFlag(TtWithholding.MANUALFLAG.NO.getCode());
        entity.setCalProcessDetail(TtWithholding.CALPROCESSDETAIL.MANUAL.getCode());
        entity.setStatus(Constant.enableStatus.able.getValue());
        return entity;
    }

    public static TtWithholding packageEntities(TtFeePoolDetailEntity other, String code, BigDecimal estimateAmount) {
        TtWithholding entity = new TtWithholding();
        entity.setType(TtWithholding.TYPE.COSTPOOL.getCode());
        entity.setCode(code);
        entity.setWithholdingDate(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setActDate(other.getYmonth());
        entity.setActDetailCode(other.getActDetailCode());
        entity.setActName(other.getActName());
        entity.setCustCode(other.getCustCode());
        entity.setCustName(other.getCustName());
        entity.setBudgetSubjectsCode(other.getSubjectCode());
        entity.setBudgetSubjectsName(other.getSubjectName());
        entity.setCategoriesCode(other.getCategoriesCode());
        entity.setCategoriesName(other.getCategoriesName());
        entity.setFineCode(other.getFineCode());
        entity.setFineName(other.getFineName());
        entity.setProductLevelCode(other.getProductLevel());
        entity.setProductLevelName(other.getProductLevelName());
        entity.setPoolDetailCode(other.getPoolDetailCode());
        entity.setPayType(other.getPayType());
        entity.setAmount(estimateAmount);
        entity.setFinalAmount(estimateAmount);
        entity.setManualFlag(TtWithholding.MANUALFLAG.NO.getCode());
        entity.setCalProcessDetail(TtWithholding.CALPROCESSDETAIL.MANUAL.getCode());
        entity.setStatus(Constant.enableStatus.able.getValue());
        return entity;
    }

    public static TmProductEntity findProductByPeoductLevelCode(List<TmProductEntity> list, String productLevelCode) {
        if (com.biz.eisp.tk.utils.CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)productLevelCode)) {
            return null;
        }
        TmProductEntity tmProductEntity = null;
        for (TmProductEntity entity : list) {
            if (StringUtils.isEmpty((Object)entity.getProductLevel()) || !entity.getProductLevel().equals(productLevelCode)) continue;
            tmProductEntity = entity;
        }
        if (null == tmProductEntity) {
            return null;
        }
        while (StringUtils.isEmpty((Object)tmProductEntity.getCostRate())) {
            if ("1".equals(tmProductEntity.getParentId())) {
                return null;
            }
            if (null != (tmProductEntity = WithhodingUtil.findProductByParentId(list, tmProductEntity.getParentId()))) continue;
            return null;
        }
        return tmProductEntity;
    }

    public static TmProductEntity findProductByParentId(List<TmProductEntity> list, String parentId) {
        for (TmProductEntity tmProductEntity : list) {
            if (StringUtils.isEmpty((Object)tmProductEntity.getId()) || !tmProductEntity.getId().equals(parentId)) continue;
            return tmProductEntity;
        }
        return null;
    }

    public static BigDecimal calBalanceCostPool(TtFeePoolDetailEntity ttFeePoolDetailEntity, TmProductEntity tmProductEntity) {
        if (ttFeePoolDetailEntity.getFeeUsableAmount() == null) {
            return null;
        }
        if (null == tmProductEntity || StringUtils.isEmpty((Object)tmProductEntity.getCostRate())) {
            return null;
        }
        return ttFeePoolDetailEntity.getFeeUsableAmount().multiply(new BigDecimal(tmProductEntity.getCostRate()));
    }

    public static TtWithholding packageEntities(TtActDetailEntity other, String code, BigDecimal estimateAmount) {
        TtWithholding entity = new TtWithholding();
        entity.setType(TtWithholding.TYPE.APPLYNOEXAMINE.getCode());
        entity.setCode(code);
        entity.setWithholdingDate(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setActDate(other.getActYearMonth());
        entity.setActDetailCode(other.getActDetailCode());
        entity.setActName(other.getActName());
        entity.setCustCode(other.getCustomerCode());
        entity.setCustName(other.getCustomerName());
        entity.setCategoriesCode(other.getCategoriesCode());
        entity.setCategoriesName(other.getCategoriesName());
        entity.setFineCode(other.getActSubclassCode());
        entity.setFineName(other.getActSubclassName());
        entity.setPayType(other.getPayType());
        entity.setAmount(estimateAmount);
        entity.setFinalAmount(estimateAmount);
        entity.setManualFlag(TtWithholding.MANUALFLAG.NO.getCode());
        entity.setCalProcessDetail(TtWithholding.CALPROCESSDETAIL.MANUAL.getCode());
        entity.setStatus(Constant.enableStatus.able.getValue());
        return entity;
    }

    public static TtWithholding packageEntities(TtAuditActDetailEntity other, String code, BigDecimal estimateAmount) {
        TtWithholding entity = new TtWithholding();
        entity.setType(TtWithholding.TYPE.EXAMINENOBOOKS.getCode());
        entity.setCode(code);
        entity.setWithholdingDate(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setActDetailCode(other.getActDetailCode());
        entity.setActName(other.getActName());
        entity.setCustCode(other.getCustomerCode());
        entity.setCustName(other.getCustomerName());
        entity.setCategoriesCode(other.getCategoriesCode());
        entity.setCategoriesName(other.getCategoriesName());
        entity.setFineCode(other.getActSubclassCode());
        entity.setFineName(other.getActSubclassName());
        entity.setAuditDetailCode(other.getAuditDetailCode());
        entity.setPayType(other.getPayType());
        entity.setAmount(estimateAmount);
        entity.setFinalAmount(estimateAmount);
        entity.setManualFlag(TtWithholding.MANUALFLAG.NO.getCode());
        entity.setCalProcessDetail(TtWithholding.CALPROCESSDETAIL.MANUAL.getCode());
        entity.setStatus(Constant.enableStatus.able.getValue());
        return entity;
    }

    public static BigDecimal findAuditByActDetailCode(List<ListAuditDetailDto> amonts, String actDetailCode) {
        if (com.biz.eisp.tk.utils.CollectionUtils.isEmpty(amonts) || StringUtils.isEmpty((Object)actDetailCode)) {
            return null;
        }
        for (ListAuditDetailDto entity : amonts) {
            if (StringUtils.isEmpty((Object)entity.getActDetailCode()) || !entity.getActDetailCode().equals(actDetailCode)) continue;
            return entity.getAmount();
        }
        return null;
    }

    public static TtWithholding packageEntitiesForPart(TtActDetailEntity other, String code, BigDecimal estimateAmount) {
        TtWithholding entity = new TtWithholding();
        entity.setType(TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode());
        entity.setCode(code);
        entity.setWithholdingDate(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setActDetailCode(other.getActDetailCode());
        entity.setActName(other.getActName());
        entity.setCustCode(other.getCustomerCode());
        entity.setCustName(other.getCustomerName());
        entity.setCategoriesCode(other.getCategoriesCode());
        entity.setCategoriesName(other.getCategoriesName());
        entity.setFineCode(other.getActSubclassCode());
        entity.setFineName(other.getActSubclassName());
        entity.setPayType(other.getPayType());
        entity.setAmount(estimateAmount);
        entity.setFinalAmount(estimateAmount);
        entity.setManualFlag(TtWithholding.MANUALFLAG.NO.getCode());
        entity.setCalProcessDetail(TtWithholding.CALPROCESSDETAIL.MANUAL.getCode());
        entity.setStatus(Constant.enableStatus.able.getValue());
        return entity;
    }
}

