/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.vo.TtAuditActVo;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.dao.TtAuditActDao;
import com.biz.eisp.pay.audit.service.TtAuditActService;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditActServiceImpl
extends BaseServiceImpl<TtAuditActEntity>
implements TtAuditActService {
    @Autowired
    private TtAuditActDao ttAuditActDao;
    @Autowired
    private AuditActService auditActService;

    @Override
    public PageInfo<TtAuditActVo> findTtAuditActPage(TtAuditActVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditActDao.findAuditActList(vo), (Page)page);
    }

    @Override
    public void saveAuditAct(String tempUuid, String acts) {
        if (StringUtils.isBlank((CharSequence)tempUuid)) {
            throw new RuntimeException("\u6d3b\u52a8\u6570\u636e\u51fa\u9519\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff01");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)acts);
        if (jsonArray != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActEntity> list = new ArrayList<TtAuditActEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                TtActEntity ttActEntity = this.auditActService.getActEntity(object.getString("id"), null);
                Example example = new Example(TtAuditActEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("actCode", (Object)ttActEntity.getActCode());
                criteria.andEqualTo("tempUuid", (Object)tempUuid);
                List tempList = this.ttAuditActDao.selectByExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)tempList)) continue;
                TtAuditActEntity entity = new TtAuditActEntity();
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                entity.setTempUuid(tempUuid);
                entity.setApplyTime(ttActEntity.getApplyTime());
                entity.setActCode(ttActEntity.getActCode());
                entity.setApplyUserBy(ttActEntity.getApplyUserBy());
                entity.setApplyUserName(ttActEntity.getApplyUserName());
                entity.setRemarks(ttActEntity.getRemarks());
                entity.setActName(ttActEntity.getActName());
                entity.setActType(ttActEntity.getActType());
                entity.setActBeginDate(ttActEntity.getBeginDate());
                entity.setActEndDate(ttActEntity.getEndDate());
                list.add(entity);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                this.insertList(list);
            }
        }
    }
}

