/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.dao.AuditActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.api.feign.TmRoleFeign;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.vo.ListAuditActVo;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.audit.vo.TtAuditVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.fee.TtBudgetDetailFeign;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.dao.TtAuditActDao;
import com.biz.eisp.pay.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.pay.audit.dao.TtAuditDao;
import com.biz.eisp.pay.audit.service.AuditFindTtAuditPageExtend;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditActivitiCallExtend;
import com.biz.eisp.pay.audit.service.TtAuditService;
import com.biz.eisp.pay.saledata.service.TtRealSalesDataService;
import com.biz.eisp.role.TmRoleVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tk.utils.CollectionUtils;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditServiceImpl
extends BaseServiceImpl<TtAuditEntity>
implements TtAuditService {
    @Autowired
    private TtAuditDao ttAuditDao;
    @Autowired
    private TtAuditActDao ttAuditActDao;
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;
    @Autowired(required=false)
    private TtAuditActivitiCallExtend ttAuditActivitiCallExtend;
    @Autowired
    private TmRoleFeign tmRoleFeign;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private AuditFindTtAuditPageExtend auditFindTtAuditPageExtend;
    @Autowired
    private TtBudgetDetailFeign ttBudgetDetailFeign;
    @Autowired
    private AuditActDetailDao auditActDetailDao;

    @Override
    public PageInfo<TtAuditVo> findTtAuditPage(TtAuditVo vo, Page page) {
        List authEntities;
        List roleVos;
        Map<String, Object> roleValMap;
        String funId = ThreadLocalUtil.getVal();
        StringBuffer buffer = new StringBuffer();
        UserRedis userRedis = UserUtils.getUser();
        if (!(!StringUtil.isNotBlank((CharSequence)funId) || userRedis == null || Globals.Admin_Name.equals(userRedis.getUsername()) || (roleValMap = (roleVos = ApiResultUtil.listResult((AjaxJson)this.tmRoleFeign.getRolesByPos(userRedis.getPosId(), userRedis.getPosCode()), (boolean)true)).stream().collect(Collectors.toMap(TmRoleVo::getRoleCode, getRoleCode -> getRoleCode))).containsKey(Globals.Admin_Name) && Globals.Admin_Name.equals(userRedis.getUsername()) || !CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true))))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String expandSql;
                    String temp;
                    List codes;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"a.org_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append("  a.org_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("position")) {
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("40")) {
                            codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAllPosCodeByUser(userRedis.getId(), userRedis.getUsername(), Integer.valueOf(1)), (boolean)true);
                            if (!CollectionUtil.listNotEmptyNotSizeZero((List)codes)) {
                                codes.add("_");
                            }
                            temp = SqlUtil.setSqlIn500((List)codes, (String)"a.position_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            buffer.append("  a.position_code = '" + userRedis.getPosCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (this.auditFindTtAuditPageExtend != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.auditFindTtAuditPageExtend.findTtAuditPage(auMap, userRedis, flagOr, buffer)))) {
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditDao.findTtAuditList(vo, aUsql), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtAuditServiceImpl.class)
    public void saveAudit(TtAuditVo vo) {
        TtAuditEntity entity = new TtAuditEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtAuditEntity)this.selectByPrimaryKey(vo.getId());
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            this.updateByPrimaryKeySelective(entity);
        } else {
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setAuditCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_head.name()));
            this.insertSelective(entity);
        }
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actlist = this.ttAuditActDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)actlist)) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8!");
        }
        String auditCode = entity.getAuditCode();
        actlist.stream().filter(act -> StringUtils.isBlank((CharSequence)act.getAuditCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
        });
        this.ttAuditActDao.updateBatchByPrimaryKeySelective(actlist);
        this.updateAuditActDetail(vo.getUpdatedJsonData());
        Example exampleDetail = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actDetaillist = this.ttAuditActDetailDao.selectByExample(exampleDetail);
        if (CollectionUtil.listEmpty((List)actDetaillist)) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8\u660e\u7ec6!");
        }
        ArrayList fineCodeList = new ArrayList();
        actDetaillist.forEach(item -> fineCodeList.add(item.getActSubclassCode()));
        List ttCostTypeFineList = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeFeign.findFineListByCodes(fineCodeList));
        HashMap fineExtraAuditRatioMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttCostTypeFineList)) {
            ttCostTypeFineList.forEach(item -> fineExtraAuditRatioMap.put(item.getFineCode(), null != item.getExtraAuditRatio() ? item.getExtraAuditRatio() : BigDecimal.ZERO));
        }
        int lineNo = 1;
        HashMap<String, BigDecimal> actDetailMap = new HashMap<String, BigDecimal>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetaillist)) {
            ArrayList<String> actDetailCode = new ArrayList();
            actDetailCode = actDetaillist.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toList());
            List<TtActDetailEntity> detailEntity = this.auditActService.getDetailList(actDetailCode);
            for (TtActDetailEntity item2 : detailEntity) {
                BigDecimal tempAmount = item2.getAuditAmount() == null ? BigDecimal.ZERO : item2.getAuditAmount();
                actDetailMap.put(item2.getActDetailCode(), tempAmount);
            }
        }
        for (TtAuditActDetailEntity item3 : actDetaillist) {
            BigDecimal extraAuditRatio = (BigDecimal)fineExtraAuditRatioMap.get(item3.getActSubclassCode());
            extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
            BigDecimal maxAuditAmount = BigDecimal.ONE.add(extraAuditRatio.divide(new BigDecimal("100"))).multiply(item3.getAmount()).setScale(2, 1);
            if (!actDetailMap.containsKey(item3.getActDetailCode())) {
                throw new BusinessException(item3.getActDetailCode() + "\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            BigDecimal auditAmount = (BigDecimal)actDetailMap.get(item3.getActDetailCode());
            BigDecimal bigDecimal = auditAmount = auditAmount == null ? BigDecimal.ZERO : auditAmount;
            if (maxAuditAmount.compareTo(auditAmount.add(item3.getCurrentAmount())) < 0) {
                throw new BusinessException("\u7b2c" + lineNo + "\u884c,\u672c\u6b21\u6838\u9500\u91d1\u989d+\u5df2\u6838\u9500\u91d1\u989d,\u5df2\u5927\u4e8e\u6700\u5927\u6838\u9500\u91d1\u989d.");
            }
            ++lineNo;
        }
        actDetaillist.stream().filter(ad -> StringUtils.isBlank((CharSequence)ad.getAuditDetailCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
            item.setAuditDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_detail.name()));
        });
        this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(actDetaillist);
    }

    @Override
    public void doAuditCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        List<ListAuditActVo> list;
        String id = activitiCallBackVo.getBusinessObjId();
        this.subAuditAndUpdateAct(id, activitiCallBackVo.getBpmStatus());
        if (StringUtils.equals((CharSequence)activitiCallBackVo.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.PASS.getValue()) && !CollectionUtils.isEmpty(list = this.ttAuditActDao.ListAuditAct(id))) {
            ArrayList<FeeUseBudgutParam> feeUseBudgutParams = new ArrayList<FeeUseBudgutParam>(list.size());
            for (ListAuditActVo listAuditActVo : list) {
                if (listAuditActVo.getAuditAmount().compareTo(listAuditActVo.getAmount()) != -1) continue;
                FeeUseBudgutParam fee = new FeeUseBudgutParam();
                fee.setAmount(listAuditActVo.getAmount().subtract(listAuditActVo.getAuditAmount()));
                fee.setType(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
                fee.setBusinessCode(listAuditActVo.getActCode());
                fee.setBusinessCodeAttached(listAuditActVo.getActDetailCode());
                fee.setNote("\u6838\u9500\u9000\u56de");
                fee.setCustName(listAuditActVo.getCustomerName());
                fee.setBusinessName(listAuditActVo.getActName());
                feeUseBudgutParams.add(fee);
            }
            if (!CollectionUtils.isEmpty(feeUseBudgutParams)) {
                this.ttBudgetDetailFeign.releaseFeeBudgutDetail(feeUseBudgutParams);
            }
        }
        if (this.ttAuditActivitiCallExtend != null) {
            this.ttAuditActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    public void updateAuditActDetail(String saveDatas) {
        JSONArray jsonArray;
        if (StringUtils.isNotBlank((CharSequence)saveDatas) && (jsonArray = JSON.parseArray((String)saveDatas)) != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActDetailEntity> list = new ArrayList<TtAuditActDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtAuditActDetailVo vo = (TtAuditActDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtAuditActDetailVo.class);
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38");
                }
                list.add(entity);
            }
            this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(list);
        }
    }

    private void checkAuditAmount(List<TtAuditActDetailEntity> entityList, TtAuditEntity ttAuditEntity) {
        if (CollectionUtils.isEmpty(entityList) || null == ttAuditEntity) {
            return;
        }
        boolean rollbackFlag = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (TtAuditActDetailEntity ttAuditActDetailEntity : entityList) {
            BigDecimal amount = ttAuditActDetailEntity.getAmount();
            BigDecimal auditAmount = ttAuditActDetailEntity.getCurrentAmount();
            if (null == amount || null == auditAmount) {
                rollbackFlag = true;
                break;
            }
            if (amount.compareTo(auditAmount) != -1) continue;
            AjaxJson aj = this.ttBudgetDetailFeign.getMaiListByParam(ttAuditActDetailEntity.getActCode(), ttAuditActDetailEntity.getActDetailCode(), ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
            if (!aj.isSuccess() || CollectionUtils.isEmpty((Collection)aj.getObjList())) {
                rollbackFlag = true;
                break;
            }
            List list = aj.getObjList();
            TtBudgutDetailEntity ttBudgutDetailEntity = (TtBudgutDetailEntity)JSON.parseObject((String)JSON.toJSONString(list.get(0)), TtBudgutDetailEntity.class);
            FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
            feeUseBudgutParam.setBugetCode(ttBudgutDetailEntity.getBudgetCode());
            feeUseBudgutParam.setAmount(auditAmount.subtract(amount));
            feeUseBudgutParam.setFromAddress("tt_audit");
            feeUseBudgutParam.setBusinessCode(ttAuditEntity.getAuditCode());
            feeUseBudgutParam.setBusinessCodeAttached(ttAuditActDetailEntity.getAuditDetailCode());
            feeUseBudgutParam.setBusinessName(ttAuditEntity.getAuditName());
            feeUseBudgutParam.setNote("\u6838\u9500\u5360\u7528\u9884\u7b97");
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
            feeUseBudgutParam.setCustCode(ttAuditActDetailEntity.getCustomerCode());
            feeUseBudgutParam.setCustName(ttAuditActDetailEntity.getCustomerName());
            feeUseBudgutParam.setOrgCode(ttAuditActDetailEntity.getOrgCode());
            feeUseBudgutParam.setOrgName(ttAuditActDetailEntity.getOrgName());
            try {
                AjaxJson ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
                if (ajaxJson.isSuccess()) continue;
                rollbackFlag = true;
                stringBuffer.append(ajaxJson.getMsg());
            }
            catch (Exception e) {
                rollbackFlag = true;
                stringBuffer.append("\u64cd\u4f5c\u5931\u8d25");
            }
            break;
        }
        if (rollbackFlag) {
            FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
            feeUseBudgutParam1.setBusinessCode(ttAuditEntity.getAuditCode());
            this.ttBudgetDetailFeign.rollBackFeeBudgutDetail(feeUseBudgutParam1);
            throw new BusinessException(stringBuffer.toString());
        }
    }

    @Override
    public AjaxJson subAuditAndUpdateAct(String id, String status) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditEntity entity = new TtAuditEntity();
        entity.setId(id);
        entity.setBpmStatus(status);
        this.ttAuditDao.updateByPrimaryKeySelective(entity);
        List<TtAuditActDetailEntity> entityList = this.ttAuditActDetailService.getDetailsByCodeAndId(null, id);
        TtAuditEntity ttAuditEntity = (TtAuditEntity)this.ttAuditDao.selectByPrimaryKey(id);
        if (ConstantEnum.bpmStatus.APPROVAL.getValue().equals(status)) {
            this.checkAuditAmount(entityList, ttAuditEntity);
            entityList.forEach(item -> {
                this.auditActService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "1");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
                String ymonth = formatter.format(new Date());
                item.setYmonth(ymonth);
            });
            this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective(entityList);
        } else if (ConstantEnum.bpmStatus.PASS.getValue().equals(status)) {
            for (TtAuditActDetailEntity item2 : entityList) {
                if (StringUtil.isBlank((CharSequence)item2.getActDetailCode())) continue;
                TtActDetailEntity detail = this.auditActService.getActDetailEntity(null, item2.getActDetailCode());
                detail.setActDetailCode(item2.getActDetailCode());
                if (ConstantEnum.YesNoEnum.ZERO.getValue().equals(item2.getAuditStatus())) {
                    detail.setAuditStatus(ConstantEnum.YesNoEnum.TWO.getValue());
                } else if (ConstantEnum.YesNoEnum.ONE.getValue().equals(item2.getAuditStatus())) {
                    detail.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
                } else {
                    throw new BusinessException("\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + item2.getAuditDetailCode() + "\u53c2\u6570\u9519\u8bef");
                }
                this.auditActDetailDao.updateByPrimaryKeySelective(detail);
            }
        } else {
            entityList.forEach(item -> this.auditActService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "0"));
            FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
            feeUseBudgutParam1.setBusinessCode(ttAuditEntity.getAuditCode());
            this.ttBudgetDetailFeign.rollBackFeeBudgutDetail(feeUseBudgutParam1);
        }
        return ajaxJson;
    }

    @Override
    public TtAuditEntity getEntity(String id, String auditCode) {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (TtAuditEntity)this.ttAuditDao.selectByPrimaryKey(id);
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            Example example = new Example(TtAuditEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("auditCode", (Object)auditCode);
            List list = this.ttAuditDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                return (TtAuditEntity)list.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getTargetData(String id) {
        String json = "[]";
        return json;
    }
}

