/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.estimate.util;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.audit.dto.ListAuditDetailDto;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.pay.estimate.entity.TtEstimateExtractEntity;
import com.biz.eisp.pay.withholding.CacheEntity;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class TtEstimateExtractUtil {
    public static String redisTaskKeyPre = "withholding";

    public static String getRedisKey() {
        return redisTaskKeyPre + DateUtils.format((Date)DateUtils.getDate(), (String)"yyyyMM");
    }

    public static CacheEntity findFromCache(List<Object> caches, String type) {
        if (CollectionUtils.isEmpty(caches)) {
            return null;
        }
        for (Object obj : caches) {
            CacheEntity cacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
            if (!cacheEntity.getType().equals(type)) continue;
            return cacheEntity;
        }
        return null;
    }

    public static String transTypeFromVo(Integer type) {
        String typeStr = "";
        switch (type) {
            case 0: {
                typeStr = TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode();
                break;
            }
            case 1: {
                typeStr = TtEstimateExtractEntity.ESTIMATETYPE.APPLYNOEXAMINE.getCode();
                break;
            }
            case 2: {
                typeStr = TtEstimateExtractEntity.ESTIMATETYPE.EXAMINENOBOOKS.getCode();
                break;
            }
            case 3: {
                typeStr = TtEstimateExtractEntity.ESTIMATETYPE.PARTEXAMINENOBOOKS.getCode();
                break;
            }
        }
        return typeStr;
    }

    public static TtEstimateExtractEntity packageEntities(TtFeePoolDetailEntity other, String code, BigDecimal estimateAmount) {
        TtEstimateExtractEntity entity = new TtEstimateExtractEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setEstimateType(TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode());
        entity.setCustCode(other.getCustCode());
        entity.setCustName(other.getCustName());
        entity.setEstimateCode(code);
        entity.setBudgetSubjectsCode(other.getSubjectCode());
        entity.setBudgetSubjectsName(other.getSubjectName());
        entity.setYear(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setCategoriesCode(other.getCategoriesCode());
        entity.setCategoriesName(other.getCategoriesName());
        entity.setActYear(other.getYmonth());
        entity.setFineCode(other.getFineCode());
        entity.setFineName(other.getFineName());
        entity.setProductLevelCode(other.getProductLevel());
        entity.setProductLevelName(other.getProductLevelName());
        entity.setActDetailCode(other.getActDetailCode());
        entity.setActName(other.getActName());
        entity.setPayType(other.getPayType());
        entity.setEstimateAmount(estimateAmount);
        return entity;
    }

    public static TtEstimateExtractEntity packageEntities(TtActDetailEntity ttActDetailEntity, String code, BigDecimal estimateAmount) {
        TtEstimateExtractEntity entity = new TtEstimateExtractEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setEstimateType(TtEstimateExtractEntity.ESTIMATETYPE.APPLYNOEXAMINE.getCode());
        entity.setCustCode(ttActDetailEntity.getCustomerCode());
        entity.setCustName(ttActDetailEntity.getCustomerName());
        entity.setEstimateCode(code);
        entity.setYear(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setCategoriesCode(ttActDetailEntity.getCategoriesCode());
        entity.setCategoriesName(ttActDetailEntity.getCategoriesName());
        entity.setActYear(ttActDetailEntity.getActYearMonth());
        entity.setFineCode(ttActDetailEntity.getActSubclassCode());
        entity.setFineName(ttActDetailEntity.getActSubclassName());
        entity.setActDetailCode(ttActDetailEntity.getActDetailCode());
        entity.setActName(ttActDetailEntity.getActName());
        entity.setPayType(ttActDetailEntity.getPayType());
        entity.setEstimateAmount(estimateAmount);
        return entity;
    }

    public static TtEstimateExtractEntity packageEntities(TtAuditActDetailEntity ttAuditActDetailEntity, String code, BigDecimal estimateAmount) {
        TtEstimateExtractEntity entity = new TtEstimateExtractEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setEstimateType(TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode());
        entity.setCustCode(ttAuditActDetailEntity.getCustomerCode());
        entity.setCustName(ttAuditActDetailEntity.getCustomerName());
        entity.setEstimateCode(code);
        entity.setYear(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setCategoriesCode(ttAuditActDetailEntity.getCategoriesCode());
        entity.setCategoriesName(ttAuditActDetailEntity.getCategoriesName());
        entity.setFineCode(ttAuditActDetailEntity.getActSubclassCode());
        entity.setFineName(ttAuditActDetailEntity.getActSubclassName());
        entity.setActDetailCode(ttAuditActDetailEntity.getActDetailCode());
        entity.setActName(ttAuditActDetailEntity.getActName());
        entity.setPayType(ttAuditActDetailEntity.getPayType());
        entity.setEstimateAmount(estimateAmount);
        return entity;
    }

    public static TtEstimateExtractEntity packageEntitiesForPart(TtActDetailEntity ttActDetailEntity, String code, BigDecimal estimateAmount) {
        TtEstimateExtractEntity entity = new TtEstimateExtractEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setEstimateType(TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode());
        entity.setCustCode(ttActDetailEntity.getCustomerCode());
        entity.setCustName(ttActDetailEntity.getCustomerName());
        entity.setEstimateCode(code);
        entity.setYear(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        entity.setCategoriesCode(ttActDetailEntity.getCategoriesCode());
        entity.setCategoriesName(ttActDetailEntity.getCategoriesName());
        entity.setFineCode(ttActDetailEntity.getActSubclassCode());
        entity.setFineName(ttActDetailEntity.getActSubclassName());
        entity.setActDetailCode(ttActDetailEntity.getActDetailCode());
        entity.setActName(ttActDetailEntity.getActName());
        entity.setPayType(ttActDetailEntity.getPayType());
        entity.setEstimateAmount(estimateAmount);
        return entity;
    }

    public static BigDecimal findAuditByActDetailCode(List<ListAuditDetailDto> amonts, String actDetailCode) {
        if (com.biz.eisp.tk.utils.CollectionUtils.isEmpty(amonts) || StringUtils.isEmpty((Object)actDetailCode)) {
            return null;
        }
        for (ListAuditDetailDto entity : amonts) {
            if (StringUtils.isEmpty((Object)entity.getActDetailCode()) || !entity.getActDetailCode().equals(actDetailCode)) continue;
            return entity.getAmount();
        }
        return null;
    }

    public static TmProductEntity findProductByPeoductLevelCode(List<TmProductEntity> list, String productLevelCode) {
        if (com.biz.eisp.tk.utils.CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)productLevelCode)) {
            return null;
        }
        TmProductEntity tmProductEntity = null;
        for (TmProductEntity entity : list) {
            if (StringUtils.isEmpty((Object)entity.getProductLevel()) || !entity.getProductLevel().equals(productLevelCode)) continue;
            tmProductEntity = entity;
        }
        if (null == tmProductEntity) {
            return null;
        }
        while (StringUtils.isEmpty((Object)tmProductEntity.getCostRate())) {
            if ("1".equals(tmProductEntity.getParentId())) {
                return null;
            }
            if (null != (tmProductEntity = TtEstimateExtractUtil.findProductByParentId(list, tmProductEntity.getParentId()))) continue;
            return null;
        }
        return tmProductEntity;
    }

    public static TmProductEntity findProductByParentId(List<TmProductEntity> list, String parentId) {
        for (TmProductEntity tmProductEntity : list) {
            if (StringUtils.isEmpty((Object)tmProductEntity.getId()) || !tmProductEntity.getId().equals(parentId)) continue;
            return tmProductEntity;
        }
        return null;
    }

    public static BigDecimal calBalanceCostPool(TtFeePoolDetailEntity ttFeePoolDetailEntity, TmProductEntity tmProductEntity) {
        if (ttFeePoolDetailEntity.getFeeUsableAmount() == null) {
            return null;
        }
        if (null == tmProductEntity || StringUtils.isEmpty((Object)tmProductEntity.getCostRate())) {
            return null;
        }
        return ttFeePoolDetailEntity.getFeeUsableAmount().multiply(new BigDecimal(tmProductEntity.getCostRate()));
    }
}

