/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.controller;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.act.vo.TtActDetailVo;
import com.biz.eisp.act.vo.TtActVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.act.ActData;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auditActController"})
public class AuditActController {
    private static final Logger log = LoggerFactory.getLogger(AuditActController.class);
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;

    @PostMapping(value={"saveActData"})
    public AjaxJson saveActData(@RequestBody ActData actData) {
        AjaxJson ajaxJson = new AjaxJson();
        this.auditActService.saveActData(actData);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtActPage"})
    public DataGrid findTtActPage(HttpServletRequest request, TtActVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtActVo> info = null;
        vo.setBpmStatus(ConstantEnum.bpmStatus.PASS.getValue());
        if (StringUtil.isNotEmpty((CharSequence)vo.getIsAuditStr())) {
            ArrayList<String> actTypes = new ArrayList<String>();
            String[] is_audit = vo.getIsAuditStr().split(",");
            if (is_audit != null && is_audit.length > 0) {
                for (int i = 0; i < is_audit.length; ++i) {
                    actTypes.add(is_audit[i]);
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(actTypes)) {
                vo.setActTypes(actTypes);
            }
        }
        info = this.auditActService.findTtActSelectPage(vo, (Page)page);
        return new DataGrid(info);
    }

    @RequestMapping(value={"findTtActDetailPage"})
    public DataGrid findTtActDetailPage(HttpServletRequest request, TtActDetailVo vo) {
        Map<String, TtCostTypeFineEntity> ttCostTypeFineEntitys = this.ttCostTypeFeign.getFineEntityByActMethodCodes((List)Lists.newArrayList((Object[])new String[]{ConstantEnum.ActMethodEnum.DDFY.getValue(), ConstantEnum.ActMethodEnum.HFFY.getValue()})).getObjList().stream().collect(Collectors.toMap(TtCostTypeFineEntity::getFineCode, v -> v, (t, t2) -> t2));
        EuPage page = new EuPage(request);
        vo.setActSubclassCodes((List)Lists.newArrayList(ttCostTypeFineEntitys.keySet()));
        PageInfo<TtActDetailVo> info = this.auditActService.getActDetailByTempUuid(vo.getTempUuid(), vo, (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)info.getList())) {
            info.getList().forEach(item -> {
                TtCostTypeFineEntity ttCostTypeFineEntity = (TtCostTypeFineEntity)ttCostTypeFineEntitys.get(item.getActSubclassCode());
                if (ttCostTypeFineEntity != null) {
                    String isMultipleAudit = StringUtil.isEmpty((String)ttCostTypeFineEntity.getIsMultipleAudit()) ? "0" : ttCostTypeFineEntity.getIsMultipleAudit();
                    item.setIsMultipleAudit(isMultipleAudit);
                }
            });
        }
        return new DataGrid(info);
    }

    @GetMapping(value={"findAuditActDetailByCodes"})
    public AjaxJson<TtActDetailEntity> findAuditActDetailByCodes(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtActDetailEntity> entities = this.auditActService.findAuditActDetailByCodes(codes);
        ajaxJson.setObjList(entities);
        return ajaxJson;
    }
}

