/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.controller;

import com.biz.eisp.act.vo.ActivitiQuotaVo;
import com.biz.eisp.activiti.ActivitiFeign;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjExtend;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.vo.TtAuditVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ActivitiBusinessVo;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.configure.vo.FormTableVo;
import com.biz.eisp.kernel.KnlDictDataFeign;
import com.biz.eisp.kernel.KnlFormConfigFeign;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditActService;
import com.biz.eisp.pay.audit.service.TtAuditActivitiAfterCommitExtend;
import com.biz.eisp.pay.audit.service.TtAuditActivitiBeforeCommitExtend;
import com.biz.eisp.pay.audit.service.TtAuditDingtalkBusDataExtend;
import com.biz.eisp.pay.audit.service.TtAuditService;
import com.biz.eisp.pay.audit.service.TtPayAuditActivitiTargetTextExtend;
import com.biz.eisp.pay.audit.service.TtPayAuditActivitiVariablesExtend;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"\u6838\u9500\u7533\u8bf7"})
@RestController
@RequestMapping(value={"/ttAuditController"})
public class TtAuditController {
    @Autowired
    private TtAuditService ttAuditService;
    @Autowired
    private TtAuditActService ttAuditActService;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private ActivitiFeign activitiFeign;
    @Autowired(required=false)
    private TtPayAuditActivitiVariablesExtend ttPayAuditActivitiVariablesExtend;
    @Autowired(required=false)
    private TtPayAuditActivitiTargetTextExtend ttPayAuditActivitiTargetTextExtend;
    @Autowired(required=false)
    private TtAuditActivitiBeforeCommitExtend ttAuditActivitiBeforeCommitExtend;
    @Autowired(required=false)
    private TtAuditActivitiAfterCommitExtend ttAuditActivitiAfterCommitExtend;
    @Autowired(required=false)
    private TtAuditDingtalkBusDataExtend ttAuditDingtalkBusDataExtend;
    @Autowired
    private KnlFormConfigFeign knlFormConfigFeign;
    @Autowired
    private KnlDictDataFeign knlDictDataFeign;

    @PostMapping(value={"insertSelective"})
    @ResponseBody
    public AjaxJson insertSelective(@RequestBody TtAuditEntity ttAuditEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        Integer i = this.ttAuditService.insertSelective(ttAuditEntity);
        if (i < 0) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u6dfb\u52a0\u6838\u9500\u603b\u8868\u5931\u8d25");
        }
        return ajaxJson;
    }

    @GetMapping(value={"selectByPrimaryKey"})
    @ResponseBody
    public AjaxJson<TtAuditEntity> selectByPrimaryKey(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditEntity entity = (TtAuditEntity)this.ttAuditService.selectByPrimaryKey(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"findTtAuditPage"})
    @ResponseBody
    public DataGrid findTtAuditPage(HttpServletRequest request, TtAuditVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TtAuditVo> info = this.ttAuditService.findTtAuditPage(vo, (Page)page);
        return new DataGrid(info);
    }

    @RequestMapping(value={"delSelectAct"})
    @ResponseBody
    public AjaxJson delSelectAct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isNotBlank((CharSequence)ids) && this.ttAuditActService.delByIds(ids) > 0) {
                j.setSuccess(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"saveAudit"})
    public AjaxJson saveAudit(HttpServletRequest request, TtAuditVo vo) {
        AjaxJson j = new AjaxJson();
        this.ttAuditService.saveAudit(vo);
        return j;
    }

    @ResponseBody
    @GetMapping(value={"loadAuditForDingtalkBusData"})
    public AjaxJson<TtAuditEntity> loadAuditForDingtalkBusData(@RequestParam(value="businessObjId") String businessObjId, @RequestParam(value="funid") String funid) {
        AjaxJson j = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)businessObjId)) {
            j.setErrMsg("\u8bf7\u6307\u5b9a\u4e1a\u52a1\u5bf9\u8c61ID");
            return j;
        }
        TtAuditEntity entity = (TtAuditEntity)this.ttAuditService.selectByPrimaryKey(businessObjId);
        if (null != this.ttAuditDingtalkBusDataExtend) {
            entity = this.ttAuditDingtalkBusDataExtend.doExtend(entity, businessObjId, funid);
        }
        if (null == entity) {
            j.setErrMsg("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55\u6838\u9500\u6570\u636e\uff0c\u8bf7\u91cd\u8bd5\u3002");
            return j;
        }
        this.convertData(funid, entity);
        j.setObj((Object)entity);
        return j;
    }

    private void convertData(String funid, TtAuditEntity entity) {
        if (StringUtil.isBlank((CharSequence)funid)) {
            return;
        }
        FormTableVo config = (FormTableVo)this.knlFormConfigFeign.getEnableConfigByFuncid(funid, null).getObj();
        Set dictTypeKeys = FormTableVo.takeDictTypeKeys((FormTableVo)config);
        if (dictTypeKeys.size() > 0) {
            Map dict = (Map)this.knlDictDataFeign.loadDictTypeKVByCodes(dictTypeKeys.stream().collect(Collectors.joining(","))).getObj();
            FormTableVo.convertDict((Map)dict, (FormTableVo)config, (Object)entity, null);
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5de5\u4f5c\u6d41")
    @RequestMapping(value={"subActiviti"})
    @ResponseBody
    public AjaxJson subActiviti(@RequestBody ActivitiQuotaVo vo) {
        Map<String, Object> variablesSelf;
        AjaxJson ajaxJson = new AjaxJson();
        vo.setBusinessUrl("/page/ttAuditController/goUpdateOrAdd?clickFunctionId=402880826c74f730016c75405c14000b&lookdetail=lookdetail");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("callback_service", "tpmAuditActivitiFeign");
        TtAuditEntity entity = (TtAuditEntity)this.ttAuditService.selectByPrimaryKey(vo.getBusinessObjId());
        this.subActivitiCheck(ajaxJson, entity);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        if (this.ttPayAuditActivitiVariablesExtend != null && (variablesSelf = this.ttPayAuditActivitiVariablesExtend.createActivitiVariablesExtend(entity, vo)) != null) {
            variables.putAll(variablesSelf);
        }
        if (!(ajaxJson = this.ttAuditService.subAuditAndUpdateAct(vo.getBusinessObjId(), ConstantEnum.bpmStatus.APPROVAL.getValue())).isSuccess()) {
            return ajaxJson;
        }
        String json = null;
        json = this.ttPayAuditActivitiTargetTextExtend != null ? this.ttPayAuditActivitiTargetTextExtend.createActivitiTargetText(entity, vo) : this.ttAuditService.getTargetData(vo.getBusinessObjId());
        ActivitiBusinessVo activitiBusinessVo = new ActivitiBusinessVo();
        BeanUtils.copyProperties((Object)vo, (Object)activitiBusinessVo);
        activitiBusinessVo.setBizType(TaBaseBusinessObjExtend.BizType.AUDIT.getCode());
        activitiBusinessVo.setClassName("com.biz.eisp.tpm.act.core.entity.TtActActivitiHeadEntity");
        activitiBusinessVo.setVariables(variables);
        activitiBusinessVo.setTargetText(json);
        if (null != this.ttAuditActivitiBeforeCommitExtend) {
            this.ttAuditActivitiBeforeCommitExtend.beforeCommit(activitiBusinessVo);
        }
        try {
            ajaxJson = this.activitiFeign.commit(activitiBusinessVo);
        }
        catch (Exception e) {
            ajaxJson.setErrMsg("\u63d0\u4ea4\u5931\u8d25");
        }
        if (ajaxJson.isSuccess()) {
            String processInstanceId = ajaxJson.getObj().toString();
            ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f\uff1a\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + processInstanceId);
            TtAuditEntity auditEntity = new TtAuditEntity();
            auditEntity.setId(entity.getId());
            auditEntity.setProcessKey(ajaxJson.getObj().toString());
            auditEntity.setApplyTime(DateUtils.dateNowStrHms());
            UserRedis userRedis = UserUtils.getUser();
            auditEntity.setApplyUserBy(userRedis.getUsername());
            auditEntity.setApplyUserName(userRedis.getRealname());
            this.ttAuditService.updateByPrimaryKeySelective(auditEntity);
            if (null != this.ttAuditActivitiAfterCommitExtend) {
                this.ttAuditActivitiAfterCommitExtend.afterCommit(activitiBusinessVo, processInstanceId);
            }
        } else {
            this.ttAuditService.subAuditAndUpdateAct(vo.getBusinessObjId(), ConstantEnum.bpmStatus.COMMIT.getValue());
        }
        return ajaxJson;
    }

    private void subActivitiCheck(AjaxJson ajaxJson, TtAuditEntity entity) {
        if (null == entity || StringUtil.isBlank((CharSequence)entity.getAuditCode())) {
            return;
        }
        Example param = new Example(TtAuditActDetailEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("auditCode", (Object)entity.getAuditCode());
        List details = this.ttAuditActDetailService.selectExample(param);
        if (CollectionUtils.isEmpty((Collection)details)) {
            return;
        }
        Set actDetailCodes = details.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(actDetailCodes)) {
            return;
        }
        Example paramAsActDetail = new Example(TtAuditActDetailEntity.class);
        Example.Criteria builderAsActDetail = paramAsActDetail.createCriteria();
        builderAsActDetail.andIn("actDetailCode", actDetailCodes);
        List allDetails = this.ttAuditActDetailService.selectExample(paramAsActDetail);
        if (CollectionUtils.isEmpty((Collection)allDetails)) {
            return;
        }
        Set allAuditCodes = allDetails.stream().map(TtAuditActDetailEntity::getAuditCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(allAuditCodes)) {
            return;
        }
        Example paramAsTtAudit = new Example(TtAuditEntity.class);
        Example.Criteria builderAsTtAudit = paramAsTtAudit.createCriteria();
        builderAsTtAudit.andIn("auditCode", allAuditCodes);
        builderAsTtAudit.andEqualTo("bpmStatus", (Object)Character.valueOf('2'));
        List entitys = this.ttAuditService.selectExample(paramAsTtAudit);
        if (CollectionUtils.isEmpty((Collection)entitys)) {
            return;
        }
        String codes = entitys.stream().map(TtAuditEntity::getAuditCode).collect(Collectors.joining(","));
        ajaxJson.setSuccess(false);
        ajaxJson.setErrMsg("\u6838\u9500\u7533\u8bf7[" + codes + "]\u5df2\u63d0\u4ea4\u76f8\u540c\u660e\u7ec6\u7684\u6d41\u7a0b\u3002");
    }
}

