/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.dao.AuditActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.service.AuditActDetailUpdateExtend;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.activiti.vo.ActivitiCallBackVo;
import com.biz.eisp.api.feign.TmRoleFeign;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditActEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.vo.ListAuditActVo;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.audit.vo.TtAuditVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.budget.fee.TtBudgetDetailFeign;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.dao.TtAuditActDao;
import com.biz.eisp.pay.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.pay.audit.dao.TtAuditDao;
import com.biz.eisp.pay.audit.service.AuditActivitiPassExtend;
import com.biz.eisp.pay.audit.service.AuditFindTtAuditPageAuthReplaceExtend;
import com.biz.eisp.pay.audit.service.AuditFindTtAuditPageExtend;
import com.biz.eisp.pay.audit.service.FindTtAuditPageExtend;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditActivitiCallExtend;
import com.biz.eisp.pay.audit.service.TtAuditBudgetDealExtend;
import com.biz.eisp.pay.audit.service.TtAuditSaveOrUpdateAfterExtend;
import com.biz.eisp.pay.audit.service.TtAuditSaveOrUpdateCheckExtend;
import com.biz.eisp.pay.audit.service.TtAuditService;
import com.biz.eisp.pay.saledata.service.TtRealSalesDataService;
import com.biz.eisp.role.TmRoleVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tk.utils.CollectionUtils;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditServiceImpl
extends BaseServiceImpl<TtAuditEntity>
implements TtAuditService {
    private static final Logger log = LoggerFactory.getLogger(TtAuditServiceImpl.class);
    @Autowired
    private TtAuditDao ttAuditDao;
    @Autowired
    private TtAuditActDao ttAuditActDao;
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtRealSalesDataService ttRealSalesDataService;
    @Autowired(required=false)
    private TtAuditActivitiCallExtend ttAuditActivitiCallExtend;
    @Autowired
    private TmRoleFeign tmRoleFeign;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private AuditFindTtAuditPageExtend auditFindTtAuditPageExtend;
    @Autowired(required=false)
    private AuditFindTtAuditPageAuthReplaceExtend auditFindTtAuditPageAuthReplaceExtend;
    @Autowired
    private TtBudgetDetailFeign ttBudgetDetailFeign;
    @Autowired
    private AuditActDetailDao auditActDetailDao;
    @Autowired(required=false)
    private TtAuditSaveOrUpdateAfterExtend ttAuditSaveOrUpdateAfterExtend;
    @Autowired(required=false)
    private TtAuditSaveOrUpdateCheckExtend ttAuditSaveOrUpdateCheckExtend;
    @Autowired(required=false)
    private TtAuditBudgetDealExtend ttAuditBudgetDealExtend;
    @Autowired(required=false)
    private AuditActDetailUpdateExtend auditActDetailUpdateExtend;
    @Autowired(required=false)
    private FindTtAuditPageExtend findTtAuditPageExtend;
    @Autowired(required=false)
    private AuditActivitiPassExtend auditActivitiPassExtend;

    @Override
    public PageInfo<TtAuditVo> findTtAuditPage(TtAuditVo vo, Page page) {
        String ttAuditPageExtend;
        String funId = ThreadLocalUtil.getVal();
        StringBuffer buffer = new StringBuffer();
        if (null != this.findTtAuditPageExtend && StringUtil.isNotEmpty((CharSequence)(ttAuditPageExtend = this.findTtAuditPageExtend.findTtAuditPageExtend(vo, page)))) {
            buffer.append(ttAuditPageExtend);
        }
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && null == this.auditFindTtAuditPageAuthReplaceExtend) {
            List authEntities;
            List roleVos = ApiResultUtil.listResult((AjaxJson)this.tmRoleFeign.getRolesByPos(userRedis.getPosId(), userRedis.getPosCode()), (boolean)true);
            Map<String, Object> roleValMap = roleVos.stream().collect(Collectors.toMap(TmRoleVo::getRoleCode, getRoleCode -> getRoleCode));
            if (!(roleValMap.containsKey(Globals.Admin_Name) && Globals.Admin_Name.equals(userRedis.getUsername()) || !CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true))))) {
                buffer.append(" and (");
                List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                    if (!OperationConfig.checAll((List)authobjs)) {
                        String expandSql;
                        String temp;
                        List codes;
                        Map<Object, Object> auValMap;
                        List items;
                        HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                        authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                        boolean flagOr = false;
                        if (auMap.containsKey("org")) {
                            flagOr = true;
                            buffer.append(" (");
                            items = (List)auMap.get("org");
                            auValMap = new HashMap();
                            auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                            if (auValMap.containsKey("20")) {
                                codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                                temp = SqlUtil.setSqlIn500((List)codes, (String)"a.org_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("30")) {
                                buffer.append("  a.org_code = '" + userRedis.getOrgCode() + "' ");
                            }
                            buffer.append(")");
                        }
                        if (auMap.containsKey("position")) {
                            if (flagOr) {
                                buffer.append(" or ");
                            }
                            flagOr = true;
                            buffer.append(" (");
                            items = (List)auMap.get("position");
                            auValMap = new HashMap();
                            auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                            if (auValMap.containsKey("40")) {
                                codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAllPosCodeByUser(userRedis.getId(), userRedis.getUsername(), Integer.valueOf(1)), (boolean)true);
                                if (!CollectionUtil.listNotEmptyNotSizeZero((List)codes)) {
                                    codes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500((List)codes, (String)"a.position_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("50")) {
                                buffer.append("  a.position_code = '" + userRedis.getPosCode() + "' ");
                            }
                            buffer.append(")");
                        }
                        if (this.auditFindTtAuditPageExtend != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.auditFindTtAuditPageExtend.findTtAuditPage(auMap, userRedis, flagOr, buffer)))) {
                            buffer.append(expandSql);
                        }
                    } else {
                        buffer.append(" 1=1");
                    }
                } else {
                    buffer.append("1=2");
                }
                buffer.append(" ) ");
            }
        } else if (null != this.auditFindTtAuditPageAuthReplaceExtend) {
            buffer.append(this.auditFindTtAuditPageAuthReplaceExtend.findTtAuditPage(vo, page));
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditDao.findTtAuditList(vo, aUsql), (Page)page);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtAuditServiceImpl.class)
    public void saveAudit(TtAuditVo vo) {
        BigDecimal maxAuditAmount;
        String extChar18;
        BigDecimal currentAmount;
        String extChar19;
        List<TtAuditActDetailEntity> actDetailEntities;
        BigDecimal extraAuditRatio;
        log.error("id:{},uuid:{},name:{}", new Object[]{vo.getId(), vo.getTempUuid(), vo.getAuditName()});
        if (null != this.ttAuditSaveOrUpdateCheckExtend) {
            this.ttAuditSaveOrUpdateCheckExtend.auditSaveOrUpdateCheck(vo);
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getExtChar7())) {
            DecimalFormat df = new DecimalFormat("#.00");
            String extChar7 = df.format(new BigDecimal(vo.getExtChar7()));
            vo.setExtChar7(extChar7);
        }
        TtAuditEntity entity = new TtAuditEntity();
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = (TtAuditEntity)this.selectByPrimaryKey(vo.getId());
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            this.updateByPrimaryKeySelective(entity);
        } else {
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5f02\u5e38");
            }
            entity.setBpmStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setAuditCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_head.name()));
            this.insertSelective(entity);
        }
        if (null == entity.getTempUuid()) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u552f\u4e00uuid");
        }
        Example example = new Example(TtAuditActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actlist = this.ttAuditActDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)actlist)) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8!");
        }
        String auditCode = entity.getAuditCode();
        actlist.stream().filter(act -> StringUtils.isBlank((CharSequence)act.getAuditCode())).forEach(item -> {
            item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            item.setAuditCode(auditCode);
        });
        this.ttAuditActDao.updateBatchByPrimaryKeySelective(actlist);
        this.updateAuditActDetail(vo.getUpdatedJsonData());
        Example exampleDetail = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andEqualTo("tempUuid", (Object)entity.getTempUuid());
        List actDetaillist = this.ttAuditActDetailDao.selectByExample(exampleDetail);
        if (CollectionUtil.listEmpty((List)actDetaillist)) {
            throw new BusinessException("\u672a\u63d0\u4ea4\u7533\u62a5\u6838\u9500\u6d3b\u52a8\u660e\u7ec6!");
        }
        List fineCodeList = actDetaillist.stream().map(TtAuditActDetailEntity::getActSubclassCode).distinct().collect(Collectors.toList());
        List ttCostTypeFineList = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeFeign.findFineListByCodes(fineCodeList));
        HashMap fineExtraAuditRatioMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttCostTypeFineList)) {
            ttCostTypeFineList.forEach(item -> fineExtraAuditRatioMap.put(item.getFineCode(), null != item.getExtraAuditRatio() ? item.getExtraAuditRatio() : BigDecimal.ZERO));
        }
        HashMap<String, TtActDetailEntity> actMap = new HashMap<String, TtActDetailEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetaillist)) {
            ArrayList<String> actCodes = new ArrayList();
            List<String> actSubclassCodes = new ArrayList();
            actCodes = actDetaillist.stream().map(TtAuditActDetailEntity::getActCode).collect(Collectors.toList());
            actSubclassCodes = actDetaillist.stream().map(TtAuditActDetailEntity::getActSubclassCode).collect(Collectors.toList());
            List<TtActDetailEntity> actDetails = this.auditActService.getActDetails(actCodes, actSubclassCodes);
            for (TtActDetailEntity ttActDetailEntity : actDetails) {
                TtActDetailEntity ttActDetailEntity2 = (TtActDetailEntity)actMap.get(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode());
                if (ttActDetailEntity2 == null) {
                    TtActDetailEntity detailEntity = new TtActDetailEntity();
                    detailEntity.setAmount(ttActDetailEntity.getAmount());
                    detailEntity.setActCode(ttActDetailEntity.getActCode());
                    detailEntity.setActSubclassCode(ttActDetailEntity.getActSubclassCode());
                    detailEntity.setActSubclassName(ttActDetailEntity.getActSubclassName());
                    actMap.put(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode(), detailEntity);
                    continue;
                }
                TtActDetailEntity detail = new TtActDetailEntity();
                detail.setActSubclassName(ttActDetailEntity2.getActSubclassName());
                detail.setActSubclassCode(ttActDetailEntity2.getActSubclassCode());
                detail.setActCode(ttActDetailEntity2.getActCode());
                detail.setAmount(ttActDetailEntity2.getAmount().add(ttActDetailEntity.getAmount()));
                actMap.put(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode(), detail);
            }
            List<TtAuditActDetailEntity> auditActDetailList = this.ttAuditActDetailService.getAuditActDetailList(actCodes, actSubclassCodes, null);
            for (TtAuditActDetailEntity actDetail : auditActDetailList) {
                TtAuditEntity ttAudit = this.ttAuditDao.findTtAudit(actDetail.getTempUuid());
                if (ttAudit == null || !ttAudit.getBpmStatus().equals(ConstantEnum.bpmStatus.APPROVAL.getValue()) && !ttAudit.getBpmStatus().equals(ConstantEnum.bpmStatus.PASS.getValue())) continue;
                TtActDetailEntity ttActDetailEntity = (TtActDetailEntity)actMap.get(actDetail.getActCode() + actDetail.getActSubclassCode());
                ttActDetailEntity.setAuditAmount(actDetail.getCurrentAmount());
                String extChar182 = ttActDetailEntity.getExtChar18();
                if (StringUtil.isEmpty((String)extChar182)) {
                    extraAuditRatio = (BigDecimal)fineExtraAuditRatioMap.get(actDetail.getActSubclassCode());
                    extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
                    BigDecimal ex = BigDecimal.ONE.add(extraAuditRatio.divide(new BigDecimal("100")));
                    BigDecimal mu = ex.multiply(ttActDetailEntity.getAmount());
                    BigDecimal maxAuditAmount2 = mu.subtract(ttActDetailEntity.getAuditAmount()).setScale(2, 1);
                    ttActDetailEntity.setExtChar18(maxAuditAmount2.toString());
                } else {
                    ttActDetailEntity.setExtChar18(new BigDecimal(extChar182).subtract(ttActDetailEntity.getAuditAmount()).setScale(2, 1).toString());
                }
                actMap.put(actDetail.getActCode() + actDetail.getActSubclassCode(), ttActDetailEntity);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(actDetailEntities = this.ttAuditActDetailDao.getAuditActDetail(vo.getTempUuid()))) {
            for (TtAuditActDetailEntity act2 : actDetailEntities) {
                void var18_26;
                TtActDetailEntity ttActDetailEntity = (TtActDetailEntity)actMap.get(act2.getActCode() + act2.getActSubclassCode());
                String string = ttActDetailEntity.getExtChar19();
                if (string == null) {
                    String string2 = "0";
                }
                BigDecimal decimal = new BigDecimal((String)var18_26);
                BigDecimal add = decimal.add(act2.getCurrentAmount());
                ttActDetailEntity.setExtChar19(add.toString());
                actMap.put(act2.getActCode() + act2.getActSubclassCode(), ttActDetailEntity);
            }
        }
        boolean checkAuditAmount = false;
        if (null != this.ttAuditSaveOrUpdateCheckExtend) {
            checkAuditAmount = this.ttAuditSaveOrUpdateCheckExtend.auditAmountCheck(vo, entity, actlist, actDetaillist);
        }
        StringBuilder exceptionMsg = new StringBuilder("");
        if (!checkAuditAmount) {
            for (TtActDetailEntity ttActDetailEntity : actMap.values()) {
                extChar19 = ttActDetailEntity.getExtChar19();
                if (StringUtil.isEmpty((String)extChar19)) continue;
                currentAmount = new BigDecimal(extChar19);
                extChar18 = ttActDetailEntity.getExtChar18();
                maxAuditAmount = null;
                if (StringUtil.isEmpty((String)extChar18)) {
                    extraAuditRatio = (BigDecimal)fineExtraAuditRatioMap.get(ttActDetailEntity.getActSubclassCode());
                    extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
                    maxAuditAmount = ttActDetailEntity.getAmount().multiply(BigDecimal.ONE.add(extraAuditRatio.divide(new BigDecimal("100"))));
                } else {
                    maxAuditAmount = new BigDecimal(extChar18);
                }
                String actSubclassName = ttActDetailEntity.getActSubclassName();
                if (maxAuditAmount.compareTo(currentAmount) >= 0) continue;
                exceptionMsg.append(ttActDetailEntity.getActCode() + ":" + actSubclassName + "\u8d85\u8fc7\u5141\u8bb8\u6700\u5927\u6838\u9500\u91d1\u989d\uff1a" + maxAuditAmount + " </br> ");
            }
        }
        actDetaillist.forEach(item -> {
            item.setAuditCode(auditCode);
            if (StringUtil.isEmpty((String)item.getEnableStatus())) {
                item.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            }
            if (StringUtil.isEmpty((String)item.getAuditDetailCode())) {
                item.setAuditDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.audit_detail.name()));
            }
            if (ConstantEnum.YesNoEnum.ONE.getValue().equals(item.getAuditStatus())) {
                TtActDetailEntity en = (TtActDetailEntity)actMap.get(item.getActCode() + item.getActSubclassCode());
                en.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
            }
        });
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetaillist)) {
            List partition = Lists.partition((List)actDetaillist, (int)400);
            partition.forEach(o -> this.ttAuditActDetailDao.updateActAuditDetail((List<TtAuditActDetailEntity>)o));
        }
        if (null != this.ttAuditSaveOrUpdateAfterExtend) {
            this.ttAuditSaveOrUpdateAfterExtend.doAfterSaveOrUpdateAudit(entity, actlist, actDetaillist);
        }
        for (TtActDetailEntity ttActDetailEntity : actMap.values()) {
            List<TtAuditActDetailEntity> collect;
            extChar19 = ttActDetailEntity.getExtChar19();
            if (StringUtil.isEmpty((String)extChar19)) continue;
            currentAmount = new BigDecimal(extChar19);
            extChar18 = ttActDetailEntity.getExtChar18();
            maxAuditAmount = null;
            if (StringUtil.isEmpty((String)extChar18)) {
                extraAuditRatio = (BigDecimal)fineExtraAuditRatioMap.get(ttActDetailEntity.getActSubclassCode());
                extraAuditRatio = extraAuditRatio == null ? BigDecimal.ZERO : extraAuditRatio;
                maxAuditAmount = ttActDetailEntity.getAmount().multiply(BigDecimal.ONE.add(extraAuditRatio.divide(new BigDecimal("100"))));
            } else {
                maxAuditAmount = new BigDecimal(extChar18);
            }
            if (maxAuditAmount.compareTo(currentAmount) != 0 && !ConstantEnum.YesNoEnum.ONE.getValue().equals(ttActDetailEntity.getAuditStatus()) || !CollectionUtil.listNotEmptyNotSizeZero(collect = actDetaillist.stream().filter(o -> o.getActCode().equals(actDetail.getActCode()) && o.getActSubclassCode().equals(actDetail.getActSubclassCode())).collect(Collectors.toList()))) continue;
            Example exampleDetail2 = new Example(TtAuditActDetailEntity.class);
            Example.Criteria criteriaDetail2 = exampleDetail2.createCriteria();
            criteriaDetail2.andEqualTo("actCode", (Object)ttActDetailEntity.getActCode());
            criteriaDetail2.andEqualTo("actSubclassCode", (Object)ttActDetailEntity.getActSubclassCode());
            criteriaDetail2.andNotEqualTo("tempUuid", (Object)entity.getTempUuid());
            List actDetaillist2 = this.ttAuditActDetailDao.selectByExample(exampleDetail2);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetaillist2)) {
                List uuids = actDetaillist2.stream().map(o -> o.getTempUuid()).distinct().collect(Collectors.toList());
                Example example2 = new Example(TtAuditEntity.class);
                Example.Criteria criteria2 = example2.createCriteria();
                criteria2.andIn("tempUuid", uuids);
                criteria2.andEqualTo("bpmStatus", (Object)"2");
                List list = this.ttAuditDao.selectByExample(example2);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    List uuidss = list.stream().map(o -> o.getTempUuid()).collect(Collectors.toList());
                    String collect1 = actDetaillist2.stream().filter(o -> uuidss.contains(o.getTempUuid())).map(o -> o.getActDetailCode()).distinct().collect(Collectors.joining(","));
                    exceptionMsg.append(collect1 + ":\u9700\u5ba1\u6279\u7ed3\u675f\u624d\u53ef\u6dfb\u52a0\u5b8c\u5168\u6838\u9500\u7684\u660e\u7ec6 </br> ");
                }
            }
            BigDecimal finalMaxAuditAmount = maxAuditAmount;
            collect.forEach(o -> {
                if (finalMaxAuditAmount.compareTo(currentAmount) == 0) {
                    o.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
                }
            });
            if (!CollectionUtil.listNotEmptyNotSizeZero(collect)) continue;
            List partition = Lists.partition(collect, (int)400);
            partition.forEach(o -> this.ttAuditActDetailDao.updateActAuditDetail((List<TtAuditActDetailEntity>)o));
        }
        if (exceptionMsg.length() > 1) {
            throw new BusinessException(exceptionMsg.toString());
        }
    }

    @Override
    public void doAuditCallBackEnd(ActivitiCallBackVo activitiCallBackVo) {
        String id = activitiCallBackVo.getBusinessObjId();
        this.subAuditAndUpdateAct(id, activitiCallBackVo.getBpmStatus());
        if (StringUtils.equals((CharSequence)activitiCallBackVo.getBpmStatus(), (CharSequence)ConstantEnum.bpmStatus.PASS.getValue())) {
            List<ListAuditActVo> list;
            boolean budgetrelease = false;
            if (null != this.ttAuditBudgetDealExtend) {
                budgetrelease = this.ttAuditBudgetDealExtend.auditBudgetPassReleaseExtend(activitiCallBackVo);
            }
            if (!budgetrelease && !CollectionUtils.isEmpty(list = this.ttAuditActDao.ListAuditAct(id))) {
                HashMap<String, TtActDetailEntity> actMap = new HashMap<String, TtActDetailEntity>();
                HashMap actDetailMap = new HashMap();
                HashMap auditActDetailMap = new HashMap();
                List<String> actCodes = list.stream().map(ListAuditActVo::getActCode).collect(Collectors.toList());
                List<String> actSubclassCodes = list.stream().map(ListAuditActVo::getActSubclassCode).collect(Collectors.toList());
                List<TtActDetailEntity> actDetails = this.auditActService.getActDetails(actCodes, actSubclassCodes);
                Map<String, TtActDetailEntity> collect = actDetails.stream().collect(Collectors.toMap(TtActDetailEntity::getActDetailCode, i -> i));
                for (TtActDetailEntity aud : actDetails) {
                    TtActDetailEntity ttActDetailEntity = (TtActDetailEntity)actMap.get(aud.getActCode() + aud.getActSubclassCode());
                    if (ttActDetailEntity == null) {
                        TtActDetailEntity detailEntity = new TtActDetailEntity();
                        detailEntity.setAmount(aud.getAmount());
                        detailEntity.setActCode(aud.getActCode());
                        detailEntity.setActSubclassCode(aud.getActSubclassCode());
                        detailEntity.setActSubclassName(aud.getActSubclassName());
                        actMap.put(aud.getActCode() + aud.getActSubclassCode(), detailEntity);
                        detailEntity.setAuditAmount(null == aud.getAuditAmount() ? BigDecimal.ZERO : aud.getAuditAmount());
                        HashMap<String, BigDecimal> actDetailAmountMap = new HashMap<String, BigDecimal>();
                        actDetailAmountMap.put(aud.getActDetailCode(), aud.getAmount());
                        actDetailMap.put(aud.getActCode() + aud.getActSubclassCode(), actDetailAmountMap);
                        HashMap<String, BigDecimal> actDetailAuditAmountMap = new HashMap<String, BigDecimal>();
                        actDetailAuditAmountMap.put(aud.getActDetailCode(), aud.getAuditAmount());
                        auditActDetailMap.put(aud.getActCode() + aud.getActSubclassCode(), actDetailAuditAmountMap);
                        continue;
                    }
                    TtActDetailEntity detail = new TtActDetailEntity();
                    detail.setActSubclassName(ttActDetailEntity.getActSubclassName());
                    detail.setActSubclassCode(ttActDetailEntity.getActSubclassCode());
                    detail.setActCode(ttActDetailEntity.getActCode());
                    detail.setAmount(ttActDetailEntity.getAmount().add(aud.getAmount()));
                    detail.setAuditAmount(ttActDetailEntity.getAuditAmount().add(aud.getAuditAmount()));
                    actMap.put(aud.getActCode() + aud.getActSubclassCode(), detail);
                    ((Map)actDetailMap.get(aud.getActCode() + aud.getActSubclassCode())).put(aud.getActDetailCode(), aud.getAmount());
                    ((Map)auditActDetailMap.get(aud.getActCode() + aud.getActSubclassCode())).put(aud.getActDetailCode(), aud.getAuditAmount());
                }
                ArrayList<FeeUseBudgutParam> feeUseBudgutParams = new ArrayList<FeeUseBudgutParam>(list.size());
                block1: for (TtActDetailEntity actDetail : actMap.values()) {
                    BigDecimal totalAmout = Optional.ofNullable(actDetail.getAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal totalAuditAmount = Optional.ofNullable(actDetail.getAuditAmount()).orElse(BigDecimal.ZERO);
                    if (totalAuditAmount.compareTo(totalAmout) >= 0) continue;
                    BigDecimal totalBackMoney = totalAmout.subtract(totalAuditAmount);
                    String key = actDetail.getActCode() + actDetail.getActSubclassCode();
                    Map stringBigDecimalMap = (Map)actDetailMap.get(key);
                    Map stringBigDecimalMap1 = (Map)auditActDetailMap.get(key);
                    if (null == stringBigDecimalMap) continue;
                    Set entries = stringBigDecimalMap.entrySet();
                    for (Map.Entry entry : entries) {
                        BigDecimal auditAmount;
                        if (totalBackMoney.compareTo(BigDecimal.ZERO) <= 0) continue block1;
                        String actDetailCode = (String)entry.getKey();
                        BigDecimal amount = (BigDecimal)entry.getValue();
                        BigDecimal backMoney = amount.subtract(auditAmount = (BigDecimal)stringBigDecimalMap1.get(actDetailCode));
                        if (backMoney.compareTo(BigDecimal.ZERO) <= 0) continue;
                        backMoney = backMoney.compareTo(totalBackMoney) > 0 ? totalBackMoney : backMoney;
                        totalBackMoney = totalBackMoney.subtract(backMoney);
                        FeeUseBudgutParam fee = new FeeUseBudgutParam();
                        fee.setAmount(backMoney);
                        fee.setType(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
                        fee.setBusinessCode(actDetail.getActCode());
                        fee.setBusinessCodeAttached(actDetailCode);
                        fee.setNote("\u6838\u9500\u9000\u56de");
                        fee.setCustName(collect.get(actDetailCode).getCustomerName());
                        fee.setBusinessName(actDetail.getActName());
                        feeUseBudgutParams.add(fee);
                    }
                }
                if (!CollectionUtils.isEmpty(feeUseBudgutParams)) {
                    this.ttBudgetDetailFeign.releaseFeeBudgutDetail(feeUseBudgutParams);
                }
            }
        }
        if (this.ttAuditActivitiCallExtend != null) {
            this.ttAuditActivitiCallExtend.doActivitiCallExtend(activitiCallBackVo);
        }
    }

    public void updateAuditActDetail(String saveDatas) {
        JSONArray jsonArray;
        if (StringUtils.isNotBlank((CharSequence)saveDatas) && (jsonArray = JSON.parseArray((String)saveDatas)) != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActDetailEntity> list = new ArrayList<TtAuditActDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtAuditActDetailVo vo = (TtAuditActDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtAuditActDetailVo.class);
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38");
                }
                list.add(entity);
            }
            List<String> checkPayTypes = Arrays.asList("70", "90");
            List<String> currentPayTypes = list.stream().map(o -> o.getPayType()).distinct().collect(Collectors.toList());
            AtomicBoolean flag = new AtomicBoolean(false);
            currentPayTypes.forEach(currentPayType -> {
                if (checkPayTypes.contains(currentPayType)) {
                    flag.set(true);
                }
            });
            if (flag.get() && currentPayTypes.size() > 1) {
                throw new BusinessException("\u4ed8\u6b3e\u65b9\u5f0f\u53ea\u80fd\u662f\u77ed\u4fc3\u6216\u8005\u5185\u8f6c\u5976");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                List partition = Lists.partition(list, (int)100);
                partition.forEach(o -> this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective((List)o));
            }
        }
    }

    private void checkAuditAmountNew(List<TtAuditActDetailEntity> entityList, TtAuditEntity ttAuditEntity) {
        boolean bl;
        String extChar19;
        if (CollectionUtils.isEmpty(entityList) || null == ttAuditEntity) {
            return;
        }
        HashMap<String, TtActDetailEntity> actMap = new HashMap<String, TtActDetailEntity>();
        HashMap actDetailMap = new HashMap();
        HashMap auditActDetailMap = new HashMap();
        HashMap<String, HashMap<String, BigDecimal>> currentAuditActDetailMap = new HashMap<String, HashMap<String, BigDecimal>>();
        List<String> actCodes = entityList.stream().map(TtAuditActDetailEntity::getActCode).collect(Collectors.toList());
        List<String> actSubclassCodes = entityList.stream().map(TtAuditActDetailEntity::getActSubclassCode).collect(Collectors.toList());
        List<TtActDetailEntity> actDetails = this.auditActService.getActDetails(actCodes, actSubclassCodes);
        for (TtActDetailEntity ttActDetailEntity : actDetails) {
            TtActDetailEntity ttActDetailEntity2 = (TtActDetailEntity)actMap.get(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode());
            if (ttActDetailEntity2 == null) {
                TtActDetailEntity detailEntity = new TtActDetailEntity();
                detailEntity.setAmount(ttActDetailEntity.getAmount());
                detailEntity.setActCode(ttActDetailEntity.getActCode());
                detailEntity.setActSubclassCode(ttActDetailEntity.getActSubclassCode());
                detailEntity.setActSubclassName(ttActDetailEntity.getActSubclassName());
                actMap.put(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode(), detailEntity);
                HashMap<String, BigDecimal> actDetailAmountMap = new HashMap<String, BigDecimal>();
                actDetailAmountMap.put(ttActDetailEntity.getActDetailCode(), ttActDetailEntity.getAmount());
                actDetailMap.put(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode(), actDetailAmountMap);
                continue;
            }
            TtActDetailEntity detail = new TtActDetailEntity();
            detail.setActSubclassName(ttActDetailEntity2.getActSubclassName());
            detail.setActSubclassCode(ttActDetailEntity2.getActSubclassCode());
            detail.setActCode(ttActDetailEntity2.getActCode());
            detail.setAmount(ttActDetailEntity2.getAmount().add(ttActDetailEntity.getAmount()));
            actMap.put(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode(), detail);
            ((Map)actDetailMap.get(ttActDetailEntity.getActCode() + ttActDetailEntity.getActSubclassCode())).put(ttActDetailEntity.getActDetailCode(), ttActDetailEntity.getAmount());
        }
        List<TtAuditActDetailEntity> auditActDetailList = this.ttAuditActDetailService.getAuditActDetailList(actCodes, actSubclassCodes, ttAuditEntity.getAuditCode());
        for (TtAuditActDetailEntity actDetail : auditActDetailList) {
            BigDecimal decimal;
            TtAuditEntity ttAudit = this.ttAuditDao.findTtAudit(actDetail.getTempUuid());
            if (ttAudit == null || !ttAudit.getBpmStatus().equals(ConstantEnum.bpmStatus.APPROVAL.getValue()) && !ttAudit.getBpmStatus().equals(ConstantEnum.bpmStatus.PASS.getValue())) continue;
            TtActDetailEntity ttActDetailEntity = (TtActDetailEntity)actMap.get(actDetail.getActCode() + actDetail.getActSubclassCode());
            ttActDetailEntity.setAuditAmount(actDetail.getCurrentAmount());
            String extChar18 = ttActDetailEntity.getExtChar18();
            if (StringUtil.isEmpty((String)extChar18)) {
                BigDecimal maxAuditAmount = ttActDetailEntity.getAmount().subtract(ttActDetailEntity.getAuditAmount()).setScale(2, 1);
                ttActDetailEntity.setExtChar18(maxAuditAmount.toString());
            } else {
                ttActDetailEntity.setExtChar18(new BigDecimal(extChar18).subtract(ttActDetailEntity.getAuditAmount()).setScale(2, 1).toString());
            }
            actMap.put(actDetail.getActCode() + actDetail.getActSubclassCode(), ttActDetailEntity);
            HashMap<String, BigDecimal> stringBigDecimalMap = (HashMap<String, BigDecimal>)auditActDetailMap.get(actDetail.getActCode() + actDetail.getActSubclassCode());
            if (null == stringBigDecimalMap) {
                stringBigDecimalMap = new HashMap<String, BigDecimal>();
                auditActDetailMap.put(actDetail.getActCode() + actDetail.getActSubclassCode(), stringBigDecimalMap);
            }
            if (null == (decimal = (BigDecimal)stringBigDecimalMap.get(actDetail.getActDetailCode()))) {
                stringBigDecimalMap.put(actDetail.getActDetailCode(), actDetail.getCurrentAmount());
                continue;
            }
            stringBigDecimalMap.put(actDetail.getActDetailCode(), actDetail.getCurrentAmount().add(decimal));
        }
        for (TtAuditActDetailEntity act : entityList) {
            TtActDetailEntity ttActDetailEntity = (TtActDetailEntity)actMap.get(act.getActCode() + act.getActSubclassCode());
            HashMap<String, BigDecimal> stringBigDecimalMap = (HashMap<String, BigDecimal>)currentAuditActDetailMap.get(act.getActCode() + act.getActSubclassCode());
            if (null == stringBigDecimalMap) {
                stringBigDecimalMap = new HashMap<String, BigDecimal>();
                currentAuditActDetailMap.put(act.getActCode() + act.getActSubclassCode(), stringBigDecimalMap);
            }
            stringBigDecimalMap.put(act.getActDetailCode(), act.getCurrentAmount());
            extChar19 = ttActDetailEntity.getExtChar19();
            if (extChar19 == null) {
                extChar19 = "0";
            }
            BigDecimal decimal = new BigDecimal(extChar19);
            BigDecimal add = decimal.add(act.getCurrentAmount());
            ttActDetailEntity.setExtChar19(add.toString());
            actMap.put(act.getActCode() + act.getActSubclassCode(), ttActDetailEntity);
        }
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (TtActDetailEntity actDetail : actMap.values()) {
            extChar19 = actDetail.getExtChar19();
            if (StringUtil.isEmpty((String)extChar19)) continue;
            BigDecimal currentAmount = new BigDecimal(extChar19);
            String extChar18 = actDetail.getExtChar18();
            BigDecimal maxAuditAmount = null;
            maxAuditAmount = StringUtil.isEmpty((String)extChar18) ? actDetail.getAmount() : new BigDecimal(extChar18);
            Boolean alreadyOverAudit = maxAuditAmount.compareTo(BigDecimal.ZERO) < 0;
            if (maxAuditAmount.compareTo(currentAmount) >= 0) continue;
            String key = actDetail.getActCode() + actDetail.getActSubclassCode();
            Map actDetailAmountMap = (Map)actDetailMap.get(key);
            Map actDetailAuditMap = (Map)auditActDetailMap.get(key);
            Map currentActDetailAuditMap = (Map)currentAuditActDetailMap.get(key);
            Set entries = actDetailAmountMap.entrySet();
            BigDecimal overAuditAmount = currentAmount.subtract(maxAuditAmount);
            for (Map.Entry entry : entries) {
                Optional<TtAuditActDetailEntity> first;
                BigDecimal currentAuditAmount;
                if (overAuditAmount.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                String actDetailCode = (String)entry.getKey();
                BigDecimal amount = (BigDecimal)entry.getValue();
                BigDecimal auditAmount = actDetailAuditMap == null || actDetailAuditMap.get(actDetailCode) == null ? BigDecimal.ZERO : (BigDecimal)actDetailAuditMap.get(actDetailCode);
                BigDecimal bigDecimal = currentAuditAmount = currentActDetailAuditMap.get(actDetailCode) == null ? BigDecimal.ZERO : (BigDecimal)currentActDetailAuditMap.get(actDetailCode);
                if (amount.compareTo(auditAmount.add(currentAuditAmount)) >= 0 && !alreadyOverAudit.booleanValue() || !(first = entityList.stream().filter(entity -> entity.getActCode().equals(actDetail.getActCode()) && entity.getActSubclassCode().equals(entity.getActSubclassCode()) && entity.getActDetailCode().equals(actDetailCode)).findFirst()).isPresent()) continue;
                TtAuditActDetailEntity ttAuditActDetailEntity = first.get();
                BigDecimal ocupyMoney = alreadyOverAudit != false ? currentAuditAmount : auditAmount.add(currentAuditAmount).subtract(amount);
                BigDecimal bigDecimal2 = ocupyMoney = ocupyMoney.compareTo(overAuditAmount) > 0 ? overAuditAmount : ocupyMoney;
                if (ocupyMoney.compareTo(BigDecimal.ZERO) <= 0) continue;
                overAuditAmount = overAuditAmount.subtract(ocupyMoney);
                AjaxJson aj = this.ttBudgetDetailFeign.getMaiListByParam(ttAuditActDetailEntity.getActCode(), ttAuditActDetailEntity.getActDetailCode(), ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
                if (!aj.isSuccess() || CollectionUtils.isEmpty((Collection)aj.getObjList())) {
                    bl = true;
                    continue block5;
                }
                List list = aj.getObjList();
                TtBudgutDetailEntity ttBudgutDetailEntity = (TtBudgutDetailEntity)JSON.parseObject((String)JSON.toJSONString(list.get(0)), TtBudgutDetailEntity.class);
                FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
                feeUseBudgutParam.setAmount(ocupyMoney);
                feeUseBudgutParam.setBugetCode(ttBudgutDetailEntity.getBudgetCode());
                feeUseBudgutParam.setFromAddress("tt_audit");
                feeUseBudgutParam.setBusinessCode(ttAuditEntity.getAuditCode());
                feeUseBudgutParam.setBusinessCodeAttached(ttAuditActDetailEntity.getAuditDetailCode());
                feeUseBudgutParam.setBusinessName(ttAuditEntity.getAuditName());
                feeUseBudgutParam.setNote("\u6838\u9500\u5360\u7528\u9884\u7b97");
                feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
                feeUseBudgutParam.setCustCode(ttAuditActDetailEntity.getCustomerCode());
                feeUseBudgutParam.setCustName(ttAuditActDetailEntity.getCustomerName());
                feeUseBudgutParam.setOrgCode(ttAuditActDetailEntity.getOrgCode());
                feeUseBudgutParam.setOrgName(ttAuditActDetailEntity.getOrgName());
                try {
                    AjaxJson ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
                    if (ajaxJson.isSuccess()) continue;
                    bl = true;
                    stringBuffer.append(ajaxJson.getMsg());
                }
                catch (Exception e) {
                    bl = true;
                    stringBuffer.append("\u64cd\u4f5c\u5931\u8d25");
                }
                continue block5;
            }
        }
        if (bl) {
            FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
            feeUseBudgutParam1.setBusinessCode(ttAuditEntity.getAuditCode());
            this.ttBudgetDetailFeign.rollBackFeeBudgutDetail(feeUseBudgutParam1);
            throw new BusinessException(stringBuffer.toString());
        }
    }

    private void checkAuditAmount(List<TtAuditActDetailEntity> entityList, TtAuditEntity ttAuditEntity) {
        if (CollectionUtils.isEmpty(entityList) || null == ttAuditEntity) {
            return;
        }
        boolean rollbackFlag = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (TtAuditActDetailEntity ttAuditActDetailEntity : entityList) {
            BigDecimal amount = ttAuditActDetailEntity.getAmount();
            BigDecimal auditAmount = ttAuditActDetailEntity.getCurrentAmount();
            if (null == amount || null == auditAmount) {
                rollbackFlag = true;
                break;
            }
            if (amount.compareTo(auditAmount) != -1) continue;
            AjaxJson aj = this.ttBudgetDetailFeign.getMaiListByParam(ttAuditActDetailEntity.getActCode(), ttAuditActDetailEntity.getActDetailCode(), ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
            if (!aj.isSuccess() || CollectionUtils.isEmpty((Collection)aj.getObjList())) {
                rollbackFlag = true;
                break;
            }
            List list = aj.getObjList();
            TtBudgutDetailEntity ttBudgutDetailEntity = (TtBudgutDetailEntity)JSON.parseObject((String)JSON.toJSONString(list.get(0)), TtBudgutDetailEntity.class);
            FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
            feeUseBudgutParam.setBugetCode(ttBudgutDetailEntity.getBudgetCode());
            feeUseBudgutParam.setAmount(auditAmount.subtract(amount));
            feeUseBudgutParam.setFromAddress("tt_audit");
            feeUseBudgutParam.setBusinessCode(ttAuditEntity.getAuditCode());
            feeUseBudgutParam.setBusinessCodeAttached(ttAuditActDetailEntity.getAuditDetailCode());
            feeUseBudgutParam.setBusinessName(ttAuditEntity.getAuditName());
            feeUseBudgutParam.setNote("\u6838\u9500\u5360\u7528\u9884\u7b97");
            feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
            feeUseBudgutParam.setCustCode(ttAuditActDetailEntity.getCustomerCode());
            feeUseBudgutParam.setCustName(ttAuditActDetailEntity.getCustomerName());
            feeUseBudgutParam.setOrgCode(ttAuditActDetailEntity.getOrgCode());
            feeUseBudgutParam.setOrgName(ttAuditActDetailEntity.getOrgName());
            try {
                AjaxJson ajaxJson = this.ttBudgetDetailFeign.saveFeeBudgutDetail(feeUseBudgutParam);
                if (ajaxJson.isSuccess()) continue;
                rollbackFlag = true;
                stringBuffer.append(ajaxJson.getMsg());
            }
            catch (Exception e) {
                rollbackFlag = true;
                stringBuffer.append("\u64cd\u4f5c\u5931\u8d25");
            }
            break;
        }
        if (rollbackFlag) {
            FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
            feeUseBudgutParam1.setBusinessCode(ttAuditEntity.getAuditCode());
            this.ttBudgetDetailFeign.rollBackFeeBudgutDetail(feeUseBudgutParam1);
            throw new BusinessException(stringBuffer.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AjaxJson subAuditAndUpdateAct(String id, String status) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditEntity entity = new TtAuditEntity();
        entity.setId(id);
        entity.setBpmStatus(status);
        this.ttAuditDao.updateByPrimaryKeySelective(entity);
        List<TtAuditActDetailEntity> entityList = this.ttAuditActDetailService.getDetailsByCodeAndId(null, id);
        TtAuditEntity ttAuditEntity = (TtAuditEntity)this.ttAuditDao.selectByPrimaryKey(id);
        if (ConstantEnum.bpmStatus.APPROVAL.getValue().equals(status)) {
            boolean checkAuditAmount = false;
            if (null != this.ttAuditBudgetDealExtend) {
                checkAuditAmount = this.ttAuditBudgetDealExtend.auditBudgetUseExtend(entityList, ttAuditEntity);
            }
            if (!checkAuditAmount) {
                this.checkAuditAmountNew(entityList, ttAuditEntity);
            }
            try {
                boolean updateActDetail = false;
                if (null != this.auditActDetailUpdateExtend) {
                    updateActDetail = this.auditActDetailUpdateExtend.updateActDetail(entityList, "1");
                }
                if (!updateActDetail) {
                    ArrayList<String> actCodes = new ArrayList();
                    ArrayList<String> actSubclassCodes = new ArrayList();
                    actCodes = entityList.stream().map(TtAuditActDetailEntity::getActCode).collect(Collectors.toList());
                    actSubclassCodes = entityList.stream().map(TtAuditActDetailEntity::getActSubclassCode).collect(Collectors.toList());
                    List<TtActDetailEntity> actDetails = this.auditActService.getActDetails(actCodes, actSubclassCodes);
                    this.auditActService.saveAuditAmountAct(actDetails, entityList);
                    entityList.forEach(item -> this.auditActService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "1"));
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
                String ymonth = formatter.format(new Date());
                entityList.forEach(item -> item.setYmonth(ymonth));
                if (!CollectionUtil.listNotEmptyNotSizeZero(entityList)) return ajaxJson;
                List partition = Lists.partition(entityList, (int)100);
                partition.forEach(o -> this.ttAuditActDetailDao.updateBatchByPrimaryKeySelective((List)o));
                return ajaxJson;
            }
            catch (Exception e) {
                FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
                feeUseBudgutParam1.setBusinessCode(ttAuditEntity.getAuditCode());
                this.ttBudgetDetailFeign.rollBackFeeBudgutDetail(feeUseBudgutParam1);
                throw e;
            }
        } else if (ConstantEnum.bpmStatus.PASS.getValue().equals(status)) {
            for (TtAuditActDetailEntity item2 : entityList) {
                if (StringUtil.isBlank((CharSequence)item2.getActDetailCode())) continue;
                TtActDetailEntity detail = this.auditActService.getActDetailEntity(null, item2.getActDetailCode());
                detail.setActDetailCode(item2.getActDetailCode());
                if (ConstantEnum.YesNoEnum.ZERO.getValue().equals(item2.getAuditStatus())) {
                    detail.setAuditStatus(ConstantEnum.YesNoEnum.TWO.getValue());
                } else {
                    if (!ConstantEnum.YesNoEnum.ONE.getValue().equals(item2.getAuditStatus())) throw new BusinessException("\u6838\u9500\u660e\u7ec6\u7f16\u7801:" + item2.getAuditDetailCode() + "\u53c2\u6570\u9519\u8bef");
                    detail.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
                }
                this.auditActDetailDao.updateByPrimaryKeySelective(detail);
            }
            if (null == this.auditActivitiPassExtend) return ajaxJson;
            this.auditActivitiPassExtend.subAuditAndUpdateActPass(entity, entityList);
            return ajaxJson;
        } else {
            boolean updateActDetail = false;
            if (null != this.auditActDetailUpdateExtend) {
                updateActDetail = this.auditActDetailUpdateExtend.updateActDetail(entityList, "0");
            }
            if (!updateActDetail) {
                entityList.forEach(item -> this.auditActService.saveAuditAmountForAct(item.getActDetailCode(), item.getCurrentAmount(), item.getAuditStatus(), "0"));
            }
            FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
            feeUseBudgutParam1.setBusinessCode(ttAuditEntity.getAuditCode());
            this.ttBudgetDetailFeign.rollBackFeeBudgutDetail(feeUseBudgutParam1);
        }
        return ajaxJson;
    }

    @Override
    public TtAuditEntity getEntity(String id, String auditCode) {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (TtAuditEntity)this.ttAuditDao.selectByPrimaryKey(id);
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            Example example = new Example(TtAuditEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("auditCode", (Object)auditCode);
            List list = this.ttAuditDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                return (TtAuditEntity)list.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getTargetData(String id) {
        String json = "[]";
        return json;
    }
}

