/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.pay.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.act.dao.AuditActDao;
import com.biz.eisp.act.dao.AuditActDetailDao;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.entity.TtActEntity;
import com.biz.eisp.act.service.AuditActService;
import com.biz.eisp.audit.dto.ListAuditDetailDto;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.audit.entity.TtAuditEntity;
import com.biz.eisp.audit.vo.TtAuditActDetailVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.TtCostTypeFeign;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.audit.dao.TtAuditActDetailDao;
import com.biz.eisp.pay.audit.service.TtAuditActDetailFindExpand;
import com.biz.eisp.pay.audit.service.TtAuditActDetailFindListExpand;
import com.biz.eisp.pay.audit.service.TtAuditActDetailSaveExpand;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.audit.service.TtAuditFindAuditDetailSelectPageExtend;
import com.biz.eisp.pay.audit.service.TtAuditService;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Transactional
@Service
public class TtAuditActDetailServiceImpl
extends BaseServiceImpl<TtAuditActDetailEntity>
implements TtAuditActDetailService {
    @Autowired
    private TtAuditActDetailDao ttAuditActDetailDao;
    @Autowired
    private AuditActDao auditActDao;
    @Autowired
    private AuditActDetailDao auditActDetailDao;
    @Autowired
    private TtAuditService ttAuditService;
    @Autowired
    private AuditActService auditActService;
    @Autowired
    private TtCostTypeFeign ttCostTypeFeign;
    @Autowired(required=false)
    private TtAuditFindAuditDetailSelectPageExtend ttAuditFindAuditDetailSelectPageExtend;
    @Autowired(required=false)
    private TtAuditActDetailSaveExpand ttAuditActDetailSaveExpand;
    @Autowired(required=false)
    private TtAuditActDetailFindExpand ttAuditActDetailFindExpand;
    @Autowired(required=false)
    private TtAuditActDetailFindListExpand ttAuditActDetailFindListExpand;

    @Override
    public List<TtAuditActDetailEntity> findTtAuditActDetailList(TtAuditActDetailVo vo) {
        return this.findTtAuditActDetailPageList(vo, null).getList();
    }

    @Override
    public PageInfo<TtAuditActDetailEntity> findTtAuditActDetailPageList(TtAuditActDetailVo vo, Page page) {
        PageInfo<TtAuditActDetailEntity> ttAuditActDetailEntities;
        if (null == page) {
            page = new EuPage();
            page.setRows(String.valueOf(Integer.MAX_VALUE));
            page.setPage("1");
        }
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("tempUuid", (Object)vo.getTempUuid());
        if (StringUtils.isNotBlank((CharSequence)vo.getCustomerName())) {
            criteria.andLike("customerName", "%" + vo.getCustomerName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getActSubclassName())) {
            criteria.andLike("actSubclassName", "%" + vo.getActSubclassName() + "%");
        }
        if (null != this.ttAuditActDetailFindListExpand) {
            this.ttAuditActDetailFindListExpand.expandSearch(example, criteria, vo);
        }
        PageInfo pageActDetailEntities = PageAutoHelperUtil.generatePage(() -> this.selectExample(example), (Page)page);
        List actDetailEntities = pageActDetailEntities.getList();
        if (null != this.ttAuditActDetailFindListExpand && null != (ttAuditActDetailEntities = this.ttAuditActDetailFindListExpand.expandList(vo, (PageInfo<TtAuditActDetailEntity>)pageActDetailEntities, page))) {
            return ttAuditActDetailEntities;
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)actDetailEntities)) {
            List fineCodeList = actDetailEntities.stream().map(TtAuditActDetailEntity::getActSubclassCode).distinct().collect(Collectors.toList());
            List ttCostTypeFineList = ApiResultUtil.listResult((AjaxJson)this.ttCostTypeFeign.findFineListByCodes(fineCodeList));
            HashMap<String, BigDecimal> fineExtraAuditRatioMap = new HashMap<String, BigDecimal>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)ttCostTypeFineList)) {
                ttCostTypeFineList.forEach(item -> fineExtraAuditRatioMap.put(item.getFineCode(), null != item.getExtraAuditRatio() ? item.getExtraAuditRatio() : BigDecimal.ZERO));
            }
            HashMap fineIsMultipleAuditMap = new HashMap();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)ttCostTypeFineList)) {
                ttCostTypeFineList.forEach(item -> fineIsMultipleAuditMap.put(item.getFineCode(), null != item.getIsMultipleAudit() ? item.getIsMultipleAudit() : ""));
            }
            List<String> actDetailCodes = actDetailEntities.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toList());
            List<TtActDetailEntity> entities = this.auditActService.getDetailList(actDetailCodes);
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (TtActDetailEntity item2 : entities) {
                BigDecimal tempAmount = item2.getAuditAmount() == null ? BigDecimal.ZERO : item2.getAuditAmount();
                map.put(item2.getActDetailCode(), tempAmount);
            }
            for (TtAuditActDetailEntity entity : actDetailEntities) {
                if (map.containsKey(entity.getActDetailCode()) && map.get(entity.getActDetailCode()) != null) {
                    entity.setAuditAmount((BigDecimal)map.get(entity.getActDetailCode()));
                } else {
                    entity.setAuditAmount(BigDecimal.ZERO);
                }
                if (Objects.nonNull(this.ttAuditActDetailFindExpand)) {
                    this.ttAuditActDetailFindExpand.expand(fineExtraAuditRatioMap, entity);
                } else if (fineExtraAuditRatioMap.containsKey(entity.getActSubclassCode())) {
                    BigDecimal extraAuditRatio = (BigDecimal)fineExtraAuditRatioMap.get(entity.getActSubclassCode());
                    BigDecimal maxAuditAmount = BigDecimal.ONE.add(extraAuditRatio.divide(new BigDecimal("100"))).multiply(entity.getAmount()).setScale(2, 1);
                    entity.setExtraAuditRatio(extraAuditRatio);
                    entity.setMaxAuditAmount(maxAuditAmount.subtract(entity.getAuditAmount()));
                } else {
                    entity.setExtraAuditRatio(BigDecimal.ZERO);
                    entity.setMaxAuditAmount(entity.getAmount().subtract(entity.getAuditAmount()));
                }
                if (fineIsMultipleAuditMap.containsKey(entity.getActSubclassCode())) {
                    String isMultipleAudit = (String)fineIsMultipleAuditMap.get(entity.getActSubclassCode());
                    entity.setIsMultipleAudit(isMultipleAudit);
                }
                entity.setOldCurrentAmount(entity.getCurrentAmount());
                if (null == entity.getAuditAmount()) {
                    entity.setAuditAmount(BigDecimal.ZERO);
                }
                if (null != entity.getAmount()) continue;
                entity.setAmount(BigDecimal.ZERO);
            }
        }
        return pageActDetailEntities;
    }

    @Override
    public PageInfo<TtAuditActDetailEntity> findAuditDetailSelectPage(TtAuditActDetailEntity entity, Page page) {
        String sql = null;
        if (this.ttAuditFindAuditDetailSelectPageExtend != null) {
            sql = this.ttAuditFindAuditDetailSelectPageExtend.findAuditDetailSelectPage(entity);
        }
        String auSql = sql;
        List<String> actDetailCodes = this.actDetailCodeFilter(entity);
        List<String> auditCodes = this.auditCodeFilter();
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditActDetailDao.findListForAccout(entity, actDetailCodes, auditCodes, auSql), (Page)page);
    }

    private List<String> auditCodeFilter() {
        Example example = new Example(TtAuditEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("bpmStatus", (Object)ConstantEnum.bpmStatus.PASS.getValue());
        Set auditCodes = this.ttAuditService.selectExample(example).stream().map(TtAuditEntity::getAuditCode).collect(Collectors.toSet());
        return Lists.newArrayList(auditCodes);
    }

    private List<String> actDetailCodeFilter(TtAuditActDetailEntity entity) {
        if (CollectionUtils.isEmpty((Collection)entity.getActTypes())) {
            return Lists.newArrayList();
        }
        Example example = new Example(TtActEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actType", (Iterable)entity.getActTypes());
        Set actCodes = this.auditActDao.selectByExample(example).stream().map(TtActEntity::getActCode).collect(Collectors.toSet());
        if (actCodes.size() == 0) {
            return Lists.newArrayList();
        }
        example = new Example(TtActDetailEntity.class);
        criteria = example.createCriteria();
        criteria.andIn("actCode", actCodes);
        Set actDetailCodes = this.auditActDetailDao.selectByExample(example).stream().map(TtActDetailEntity::getActDetailCode).collect(Collectors.toSet());
        return Lists.newArrayList(actDetailCodes);
    }

    @Override
    public void saveAuditActDetail(String tempUuid, String acts) {
        if (StringUtils.isBlank((CharSequence)tempUuid)) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u51fa\u9519\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff01");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)acts);
        if (jsonArray != null && jsonArray.size() > 0) {
            ArrayList<TtAuditActDetailEntity> list = new ArrayList<TtAuditActDetailEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                TtActDetailEntity ttActEntity = this.auditActService.getActDetailEntity(object.getString("id"), null);
                Example example = new Example(TtAuditActDetailEntity.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("actDetailCode", (Object)ttActEntity.getActDetailCode());
                criteria.andEqualTo("tempUuid", (Object)tempUuid);
                List tempList = this.ttAuditActDetailDao.selectByExample(example);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)tempList)) continue;
                String actName = object.get((Object)"actName") == null ? "" : object.get((Object)"actName").toString();
                TtAuditActDetailEntity entity = this.newAuditDetailByActDetail(tempUuid, actName, ttActEntity);
                list.add(entity);
            }
            List fineCodes = list.stream().map(TtAuditActDetailEntity::getActSubclassCode).distinct().collect(Collectors.toList());
            List finesEntity = this.ttCostTypeFeign.findFineListByCodes(fineCodes).getObjList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)finesEntity)) {
                for (Object item2 : finesEntity) {
                    if (!"0".equals(item2.getIsMultipleAudit())) continue;
                    map.put(item2.getFineCode(), item2);
                }
            }
            if (!map.isEmpty()) {
                List<String> actDetailCodes;
                List<TtAuditActDetailEntity> oldDetails;
                ArrayList<TtAuditActDetailEntity> items = new ArrayList<TtAuditActDetailEntity>();
                for (TtAuditActDetailEntity temp : list) {
                    if (!map.containsKey(temp.getActSubclassCode())) continue;
                    items.add(temp);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(items) && CollectionUtil.listNotEmptyNotSizeZero(oldDetails = this.ttAuditActDetailDao.getApproveEnd(actDetailCodes = items.stream().map(TtAuditActDetailEntity::getActDetailCode).collect(Collectors.toList())))) {
                    throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\uff1a" + oldDetails.get(0).getActDetailCode() + " \u5df2\u7ecf\u88ab" + oldDetails.get(0).getCreateName() + "\u4f7f\u7528,\u5355\u53f7:" + oldDetails.get(0).getAuditCode());
                }
            }
            list.forEach(item -> this.insertSelective(item));
        }
    }

    @Override
    public TtAuditActDetailEntity newAuditDetailByActDetail(String tempUuid, String actName, TtActDetailEntity ttActEntity) {
        TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
        entity.setActType(ttActEntity.getActType());
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setTempUuid(tempUuid);
        entity.setActDetailCode(ttActEntity.getActDetailCode());
        entity.setActSubclassCode(ttActEntity.getActSubclassCode());
        entity.setActSubclassName(ttActEntity.getActSubclassName());
        entity.setActRemarks(ttActEntity.getRemarks());
        entity.setAuditRemarks(ttActEntity.getRemarks());
        entity.setTerminalCode(ttActEntity.getTerminalCode());
        entity.setTerminalName(ttActEntity.getTerminalName());
        entity.setCustomerCode(ttActEntity.getCustomerCode());
        entity.setCustomerName(ttActEntity.getCustomerName());
        entity.setCurrentAmount(ttActEntity.getAmount());
        entity.setPayType(ttActEntity.getPayType());
        entity.setAmount(ttActEntity.getAmount());
        entity.setActCode(ttActEntity.getActCode());
        entity.setActName(actName);
        entity.setFeeUsed(BigDecimal.ZERO);
        entity.setAuditStatus(ConstantEnum.YesNoEnum.ONE.getValue());
        entity.setCategoriesName(ttActEntity.getCategoriesName());
        entity.setCategoriesCode(ttActEntity.getCategoriesCode());
        entity.setActYmonth(ttActEntity.getActYearMonth());
        if (Objects.nonNull(this.ttAuditActDetailSaveExpand)) {
            this.ttAuditActDetailSaveExpand.expand(ttActEntity, entity);
        }
        return entity;
    }

    @Override
    public void updateAuditActDetail(String saveDatas) {
        JSONArray jsonArray = JSON.parseArray((String)saveDatas);
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                TtAuditActDetailVo vo = (TtAuditActDetailVo)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(i), TtAuditActDetailVo.class);
                TtAuditActDetailEntity entity = new TtAuditActDetailEntity();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6570\u636e\u5f02\u5e38");
                }
                this.updateByPrimaryKeySelective(entity);
            }
        }
    }

    @Override
    public List<TtAuditActDetailEntity> getCodes(List<String> codes) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("auditDetailCode", codes);
        List list = this.selectExample(example);
        return list;
    }

    @Override
    public void updateUsedAmount(String code, BigDecimal feeUsed) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("auditDetailCode", (Object)code);
        List list = this.selectExample(example);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)list) || list.size() != 1) {
            throw new BusinessException("\u6838\u9500\u660e\u7ec6\u7f16\u53f7:" + code + "\u4e0d\u5b58\u5728");
        }
        TtAuditActDetailEntity entity = (TtAuditActDetailEntity)list.get(0);
        BigDecimal feeUsedOld = entity.getFeeUsed() == null ? BigDecimal.ZERO : entity.getFeeUsed();
        TtAuditActDetailEntity entityNew = new TtAuditActDetailEntity();
        entityNew.setId(entity.getId());
        entityNew.setFeeUsed(feeUsedOld.add(feeUsed));
        this.updateByPrimaryKeySelective(entityNew);
    }

    @Override
    public List<TtAuditActDetailEntity> getDetailsByCodeAndId(String auditCode, String id) {
        if (StringUtils.isBlank((CharSequence)auditCode) && StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            return this.getDetailsByCode(auditCode);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TtAuditEntity entity = this.ttAuditService.getEntity(id, auditCode);
            return this.getDetailsByCode(entity.getAuditCode());
        }
        return null;
    }

    private List<TtAuditActDetailEntity> getDetailsByCode(String auditCode) {
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("auditCode", (Object)auditCode);
        return this.selectExample(example);
    }

    @Override
    public PageInfo<TtAuditActDetailVo> findTtAuditActDetailListPage(TtAuditActDetailVo vo, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttAuditActDetailDao.findTtAuditActDetailListPage(vo), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            List<String> actDetailCodes = pageInfo.getList().stream().map(TtAuditActDetailVo::getActDetailCode).collect(Collectors.toList());
            List<TtActDetailEntity> entities = this.auditActService.getDetailList(actDetailCodes);
            Map<String, BigDecimal> map = entities.stream().collect(Collectors.toMap(TtActDetailEntity::getActDetailCode, TtActDetailEntity::getAuditAmount));
            for (TtAuditActDetailVo entity : pageInfo.getList()) {
                if (map.containsKey(entity.getActDetailCode()) && map.get(entity.getActDetailCode()) != null) {
                    entity.setAuditAmount(map.get(entity.getActDetailCode()));
                    continue;
                }
                entity.setAuditAmount(BigDecimal.ZERO);
            }
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TtAuditActDetailEntity> list(Integer pageNum, Integer pageSize, String auditDetailCode) {
        Page page = new Page();
        page.setPage(pageNum.toString());
        page.setRows(pageSize.toString());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttAuditActDetailDao.list(auditDetailCode), (Page)page);
        return pageInfo;
    }

    @Override
    public List<ListAuditDetailDto> listAuditDetail(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<ListAuditDetailDto>();
        }
        ArrayList reList = this.ttAuditActDetailDao.listAuditDetail(codes);
        return CollectionUtils.isEmpty(reList) ? new ArrayList() : reList;
    }

    @Override
    public TtAuditActDetailEntity getAuditActDetail(String id, String auditDetailCode) {
        List auditActDetailEntities;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)auditDetailCode)) {
            return null;
        }
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotBlank((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotBlank((CharSequence)auditDetailCode)) {
            criteria.andEqualTo("auditDetailCode", (Object)auditDetailCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(auditActDetailEntities = this.ttAuditActDetailDao.selectByExample(example)))) {
            return (TtAuditActDetailEntity)auditActDetailEntities.get(0);
        }
        return null;
    }

    @Override
    public List<TtAuditActDetailEntity> getAuditActDetailByIds(Set<String> ids, String auditDetailCode) {
        if (CollectionUtils.isEmpty(ids) && StringUtil.isEmpty((String)auditDetailCode)) {
            return null;
        }
        Example example = new Example(TtAuditActDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.andIn("id", ids);
        }
        if (StringUtil.isNotBlank((CharSequence)auditDetailCode)) {
            criteria.andEqualTo("auditDetailCode", (Object)auditDetailCode);
        }
        List auditActDetailEntities = this.ttAuditActDetailDao.selectByExample(example);
        return auditActDetailEntities;
    }
}

