/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.withholding.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.act.act.TtActProductFeign;
import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.vo.ActDetailListPartReq;
import com.biz.eisp.act.vo.ActListReq;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.audit.dto.ListAuditDetailDto;
import com.biz.eisp.audit.entity.TtAuditActDetailEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.vo.CacheEntityVo;
import com.biz.eisp.base.vo.WithholdingVo;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.pool.TtFeePoolDetailFeign;
import com.biz.eisp.fee.vo.TtFeePoolDetailApiListReq;
import com.biz.eisp.params.Constant;
import com.biz.eisp.pay.audit.service.TtAuditActDetailService;
import com.biz.eisp.pay.estimate.entity.TtEstimateExtractEntity;
import com.biz.eisp.pay.withholding.CacheEntity;
import com.biz.eisp.pay.withholding.entity.TtWithholding;
import com.biz.eisp.pay.withholding.vo.DelByParamReq;
import com.biz.eisp.pay.withholding.vo.ManualReq;
import com.biz.eisp.pay.withholding.vo.UdpateAmontByParamReq;
import com.biz.eisp.pay.withholding.vo.WithholdingByParamReq;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.websocket.WithHoldingFeign;
import com.biz.eisp.withholding.dao.WithholdingDao;
import com.biz.eisp.withholding.service.WithholdingService;
import com.biz.eisp.withholding.util.WithhodingUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

@Service(value="withholdingService")
public class WithholdingServiceImpl
implements WithholdingService {
    @Autowired
    private WithholdingDao withholdingDao;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private WithHoldingFeign withHoldingFeign;
    @Autowired
    private TtFeePoolDetailFeign ttFeePoolDetailFeign;
    @Autowired
    private TtActProductFeign ttActProductFeign;
    @Autowired
    private TtAuditActDetailService ttAuditActDetailService;

    @Override
    @Transactional
    public void manual(ManualReq manualReq) {
        TtWithholding entity = WithhodingUtil.voToEntity(manualReq);
        this.withholdingDao.insertSelective(entity);
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (ids.size() <= 500) {
            this.withholdingDao.delByIds(ids, Constant.enableStatus.enable.getValue());
            return;
        }
        int index = 0;
        int singleMaxNum = 500;
        ArrayList<String> singleIds = new ArrayList<String>(singleMaxNum);
        while (index < ids.size()) {
            for (int i = 0; i < singleMaxNum; ++i) {
                singleIds.add(ids.get(i));
                ++index;
            }
            this.withholdingDao.delByIds(singleIds, Constant.enableStatus.enable.getValue());
            singleIds.clear();
        }
    }

    @Override
    @Transactional
    public void delByParam(DelByParamReq delByParamReq) {
        this.withholdingDao.delByParam(delByParamReq, ConstantEnum.StatusEnum.DELETE.getValue());
    }

    @Override
    @Transactional
    public void updateAmontByIds(ArrayList<String> ids, BigDecimal finalAmount, String updateBy, String updateName) {
        if (-1 == finalAmount.compareTo(BigDecimal.ZERO)) {
            throw new BusinessException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.withholdingDao.updateAmontByIds(ids, finalAmount, updateBy, updateName, DateUtils.format((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss"), TtWithholding.MANUALFLAG.YES.getCode(), ConstantEnum.StatusEnum.UPDATE.getValue());
    }

    @Override
    @Transactional
    public void udpateAmontByParam(UdpateAmontByParamReq udpateAmontByParamReq, BigDecimal finalAmount, String updateBy, String updateName) {
        if (-1 == finalAmount.compareTo(BigDecimal.ZERO)) {
            throw new BusinessException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.withholdingDao.udpateAmontByParam(udpateAmontByParamReq, finalAmount, updateBy, updateName, DateUtils.format((Date)DateUtils.getDate(), (String)"yyyy-MM-dd HH:mm:ss"), TtWithholding.MANUALFLAG.YES.getCode(), ConstantEnum.StatusEnum.UPDATE.getValue());
    }

    @Override
    @Transactional
    public ArrayList<String> withholdingByParam(final WithholdingByParamReq withholdingByParamReq) {
        String reStr = "\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e...";
        final ArrayList<String> types = this.screenType(withholdingByParamReq);
        ArrayList reTypes = withholdingByParamReq.getTypes();
        reTypes.removeAll(types);
        if (reTypes.size() > 0) {
            for (String str : types) {
                reTypes.add(TtWithholding.TYPE.getValueByCode((String)str).getValue());
            }
        }
        if (CollectionUtils.isEmpty(types)) {
            return reTypes;
        }
        withholdingByParamReq.setTypes(types);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                List productEntities = null;
                if (types.contains(TtWithholding.TYPE.COSTPOOL.getCode())) {
                    productEntities = WithholdingServiceImpl.this.mdmApiFeign.list().getObjList();
                }
                WebApplicationContext ctx = ContextLoaderListener.getCurrentWebApplicationContext();
                WithholdingService withholdingService = (WithholdingService)ctx.getBean("withholdingService");
                withholdingService.withholdingDetail(withholdingByParamReq, productEntities);
            }
        });
        t.start();
        return reTypes;
    }

    @Override
    @Transactional
    public void withholdingDetail(final WithholdingByParamReq withholdingByParamReq, final List<TmProductEntity> productEntities) {
        final int computationNum = 1000;
        for (String type : withholdingByParamReq.getTypes()) {
            Thread t;
            if (type.equals(TtWithholding.TYPE.COSTPOOL.getCode())) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebApplicationContext ctx = ContextLoaderListener.getCurrentWebApplicationContext();
                        WithholdingService withholdingService = (WithholdingService)ctx.getBean("withholdingService");
                        withholdingService.withholdingCostPool(withholdingByParamReq, computationNum, productEntities);
                    }
                });
                t.start();
                continue;
            }
            if (type.equals(TtWithholding.TYPE.APPLYNOEXAMINE.getCode())) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebApplicationContext ctx = ContextLoaderListener.getCurrentWebApplicationContext();
                        WithholdingService withholdingService = (WithholdingService)ctx.getBean("withholdingService");
                        withholdingService.withholdingApplyNoExamine(computationNum);
                    }
                });
                t.start();
                continue;
            }
            if (type.equals(TtWithholding.TYPE.EXAMINENOBOOKS.getCode())) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebApplicationContext ctx = ContextLoaderListener.getCurrentWebApplicationContext();
                        WithholdingService withholdingService = (WithholdingService)ctx.getBean("withholdingService");
                        withholdingService.withholdingExamineNobooks(computationNum);
                    }
                });
                t.start();
                continue;
            }
            if (!type.equals(TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode())) continue;
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    WebApplicationContext ctx = ContextLoaderListener.getCurrentWebApplicationContext();
                    WithholdingService withholdingService = (WithholdingService)ctx.getBean("withholdingService");
                    withholdingService.withholdingPartExamineNobooks(computationNum);
                }
            });
            t.start();
        }
    }

    public ArrayList<String> screenType(WithholdingByParamReq withholdingByParamReq) {
        List caches = this.redisTemplate.opsForList().range((Object)WithhodingUtil.getRedisKey(), 0L, -1L);
        ArrayList types = new ArrayList();
        long outTimeNum = 10800000L;
        if (CollectionUtils.isEmpty((Collection)caches)) {
            types = withholdingByParamReq.getTypes();
        } else {
            for (String voType : withholdingByParamReq.getTypes()) {
                CacheEntity cacheEntity = WithhodingUtil.findFromCache(caches, voType);
                if (null == cacheEntity) {
                    types.add(voType);
                    continue;
                }
                if (cacheEntity.getComplateFlag().intValue() != CacheEntity.COMPLATEFLAG.OVER.getCode().intValue() && (cacheEntity.getComplateFlag().intValue() != CacheEntity.COMPLATEFLAG.ING.getCode().intValue() || DateUtils.getDate().getTime() - cacheEntity.getStartTime() <= outTimeNum)) continue;
                types.add(voType);
            }
        }
        return types;
    }

    @Override
    @Transactional
    public void withholdingCostPool(WithholdingByParamReq withholdingByParamReq, Integer num, List<TmProductEntity> productEntities) {
        TtFeePoolDetailApiListReq totalReq = new TtFeePoolDetailApiListReq();
        totalReq.setPageSize("1");
        totalReq.setPageNum("1");
        PageInfo pageInfoForTotal = this.ttFeePoolDetailFeign.list(totalReq);
        this.initCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.COSTPOOL.getCode(), pageInfoForTotal.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtWithholding.TYPE.COSTPOOL.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            TtFeePoolDetailApiListReq ttFeePoolDetailApiListReq = new TtFeePoolDetailApiListReq();
            ttFeePoolDetailApiListReq.setPageSize(num.toString());
            ttFeePoolDetailApiListReq.setPageNum(pageNum.toString());
            PageInfo pageInfo = this.ttFeePoolDetailFeign.list(ttFeePoolDetailApiListReq);
            List feeList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)feeList)) {
                this.dealWithholdingCostPool(feeList, productEntities);
            } else {
                flag = false;
            }
            this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.COSTPOOL.getCode(), CollectionUtils.isEmpty((Collection)feeList) ? Long.parseLong("0") : new Long(feeList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.COSTPOOL.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealWithholdingCostPool(List<TtFeePoolDetailEntity> feeList, List<TmProductEntity> productEntities) {
        ArrayList<TtWithholding> entities = new ArrayList<TtWithholding>(feeList.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)feeList.size());
        int i = 0;
        for (TtFeePoolDetailEntity entity : feeList) {
            String code = (String)codeList.get(i);
            if (StringUtils.isEmpty((CharSequence)entity.getPayType())) continue;
            if (entity.getPayType().equals("10")) {
                entities.add(WithhodingUtil.packageEntities(entity, code, entity.getFeeUsableAmount()));
            } else if (entity.getPayType().equals("30")) {
                TmProductEntity tmProductEntity = WithhodingUtil.findProductByPeoductLevelCode(productEntities, entity.getProductLevel());
                BigDecimal balance = WithhodingUtil.calBalanceCostPool(entity, tmProductEntity);
                entities.add(WithhodingUtil.packageEntities(entity, code, balance));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.withholdingDao.insertList(entities);
        }
    }

    @Override
    @Transactional
    public void withholdingApplyNoExamine(Integer num) {
        ActListReq totalReq = new ActListReq();
        totalReq.setPageSize("1");
        totalReq.setPageNum("1");
        PageInfo pageInfoForTotal = this.ttActProductFeign.list(totalReq);
        this.initCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.APPLYNOEXAMINE.getCode(), pageInfoForTotal.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtWithholding.TYPE.APPLYNOEXAMINE.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            ActListReq actListReq = new ActListReq();
            actListReq.setPageSize(num.toString());
            actListReq.setPageNum(pageNum.toString());
            PageInfo pageInfo = this.ttActProductFeign.list(actListReq);
            List applyNoExamineList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)applyNoExamineList)) {
                this.dealApplyNoExamine(applyNoExamineList);
            } else {
                flag = false;
            }
            this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.APPLYNOEXAMINE.getCode(), CollectionUtils.isEmpty((Collection)applyNoExamineList) ? Long.parseLong("0") : new Long(applyNoExamineList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.APPLYNOEXAMINE.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealApplyNoExamine(List<TtActDetailEntity> applyNoExamineList) {
        ArrayList<TtWithholding> entities = new ArrayList<TtWithholding>(applyNoExamineList.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)applyNoExamineList.size());
        int i = 0;
        for (TtActDetailEntity entity : applyNoExamineList) {
            String code = (String)codeList.get(i);
            if (!StringUtils.isEmpty((CharSequence)entity.getPayType()) && (entity.getPayType().equals("10") || entity.getPayType().equals("20"))) {
                entities.add(WithhodingUtil.packageEntities(entity, code, entity.getAmount()));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.withholdingDao.insertList(entities);
        }
    }

    @Override
    @Transactional
    public void withholdingExamineNobooks(Integer num) {
        PageInfo<TtAuditActDetailEntity> totalPageInfo = this.ttAuditActDetailService.list(1, 1, null);
        this.initCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.EXAMINENOBOOKS.getCode(), totalPageInfo.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtWithholding.TYPE.EXAMINENOBOOKS.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            PageInfo<TtAuditActDetailEntity> pageInfo = this.ttAuditActDetailService.list(pageNum, num, null);
            List examineNobooksList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)examineNobooksList)) {
                this.dealExamineNobooks(examineNobooksList);
            } else {
                flag = false;
            }
            this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.EXAMINENOBOOKS.getCode(), CollectionUtils.isEmpty((Collection)examineNobooksList) ? Long.parseLong("0") : new Long(examineNobooksList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.EXAMINENOBOOKS.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealExamineNobooks(List<TtAuditActDetailEntity> ttAuditActDetailEntities) {
        ArrayList<TtWithholding> entities = new ArrayList<TtWithholding>(ttAuditActDetailEntities.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)ttAuditActDetailEntities.size());
        int i = 0;
        for (TtAuditActDetailEntity entity : ttAuditActDetailEntities) {
            String code = (String)codeList.get(i);
            if (!StringUtils.isEmpty((CharSequence)entity.getPayType()) && (entity.getPayType().equals("10") || entity.getPayType().equals("20")) && entity.getCurrentAmount() != null && entity.getAmount() != null) {
                entities.add(WithhodingUtil.packageEntities(entity, code, entity.getCurrentAmount().subtract(entity.getAmount())));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.withholdingDao.insertList(entities);
        }
    }

    @Override
    @Transactional
    public void withholdingPartExamineNobooks(Integer num) {
        ActDetailListPartReq totalReq = new ActDetailListPartReq();
        totalReq.setPageNum("1".toString());
        totalReq.setPageSize("1");
        PageInfo pageInfoForTotal = this.ttActProductFeign.listPart(totalReq);
        this.initCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode(), pageInfoForTotal.getTotal(), DateUtils.getMillis());
        this.deleteByMonthAndType(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM), TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode());
        boolean flag = true;
        Integer pageNum = 1;
        while (flag) {
            ActDetailListPartReq req = new ActDetailListPartReq();
            req.setPageNum(pageNum.toString());
            req.setPageSize(num.toString());
            PageInfo pageInfo = this.ttActProductFeign.listPart(req);
            List examineNobooksList = pageInfo.getList();
            if (!CollectionUtils.isEmpty((Collection)examineNobooksList)) {
                this.dealPartExamineNobooks(examineNobooksList);
            } else {
                flag = false;
            }
            this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode(), CollectionUtils.isEmpty((Collection)examineNobooksList) ? Long.parseLong("0") : new Long(examineNobooksList.size()), CacheEntity.COMPLATEFLAG.ING);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        this.updateCacheTotal(WithhodingUtil.getRedisKey(), TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode(), Long.parseLong("0"), CacheEntity.COMPLATEFLAG.OVER);
    }

    private void dealPartExamineNobooks(List<TtActDetailEntity> ttActDetailEntities) {
        ArrayList<TtWithholding> entities = new ArrayList<TtWithholding>(ttActDetailEntities.size());
        List codeList = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.estimate_code.name(), (Integer)ttActDetailEntities.size());
        int i = 0;
        ArrayList<String> codes = new ArrayList<String>(ttActDetailEntities.size());
        for (TtActDetailEntity entity : ttActDetailEntities) {
            if (StringUtils.isEmpty((CharSequence)entity.getActDetailCode())) continue;
            codes.add(entity.getActDetailCode());
        }
        List<ListAuditDetailDto> amonts = this.ttAuditActDetailService.listAuditDetail(codes);
        for (TtActDetailEntity entity : ttActDetailEntities) {
            String code = (String)codeList.get(i);
            if (!StringUtils.isEmpty((CharSequence)entity.getPayType()) && (entity.getPayType().equals("10") || entity.getPayType().equals("20"))) {
                BigDecimal money = WithhodingUtil.findAuditByActDetailCode(amonts, entity.getActDetailCode());
                if (money == null) {
                    // empty if block
                }
                if (entity.getAmount() == null) {
                    // empty if block
                }
                entities.add(WithhodingUtil.packageEntitiesForPart(entity, code, entity.getAmount().subtract(money)));
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(entities)) {
            this.withholdingDao.insertList(entities);
        }
    }

    private void deleteByMonthAndType(String month, String type) {
        TtWithholding condition = new TtWithholding();
        condition.setWithholdingDate(DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM));
        condition.setType(TtEstimateExtractEntity.ESTIMATETYPE.COSTPOOL.getCode());
        this.withholdingDao.delete(condition);
    }

    private void initCacheTotal(String key, String type, Long total, Long startTime) {
        CacheEntity cacheEntity = new CacheEntity();
        cacheEntity.setComplateFlag(CacheEntity.COMPLATEFLAG.ING.getCode());
        cacheEntity.setComplateNum(Long.valueOf(Long.parseLong("0")));
        cacheEntity.setTotal(total);
        cacheEntity.setStartTime(startTime);
        cacheEntity.setType(type);
        List caches = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        ArrayList<String> newCaches = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)caches)) {
            newCaches.add(JSON.toJSONString((Object)cacheEntity));
        } else {
            for (Object obj : caches) {
                CacheEntity oldCacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
                if (oldCacheEntity.getType().equals(type)) continue;
                newCaches.add(JSON.toJSONString((Object)oldCacheEntity));
            }
            newCaches.add(JSON.toJSONString((Object)cacheEntity));
        }
        this.redisTemplate.delete((Object)key);
        newCaches.stream().forEach(cache -> this.redisTemplate.opsForList().rightPush((Object)key, cache));
        this.sendWebSocket();
    }

    private void updateCacheTotal(String key, String type, Long num, CacheEntity.COMPLATEFLAG complateflag) {
        if (null == num) {
            num = Long.parseLong("0");
        }
        List caches = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        ArrayList<String> newCaches = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)caches)) {
            for (Object obj : caches) {
                CacheEntity oldCacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
                if (!oldCacheEntity.getType().equals(type)) {
                    newCaches.add(JSON.toJSONString((Object)oldCacheEntity));
                    continue;
                }
                CacheEntity cacheEntity = oldCacheEntity;
                oldCacheEntity.setComplateFlag(complateflag.getCode());
                if (complateflag.getCode().intValue() == CacheEntity.COMPLATEFLAG.OVER.getCode().intValue()) {
                    oldCacheEntity.setComplateNum(oldCacheEntity.getTotal());
                } else {
                    oldCacheEntity.setComplateNum(Long.valueOf(null == oldCacheEntity.getComplateNum() ? num : num + oldCacheEntity.getComplateNum()));
                }
                newCaches.add(JSON.toJSONString((Object)oldCacheEntity));
            }
        }
        this.redisTemplate.delete((Object)key);
        newCaches.stream().forEach(cache -> this.redisTemplate.opsForList().rightPush((Object)key, cache));
        this.sendWebSocket();
    }

    private void sendWebSocket() {
        WithholdingVo withholdingVo = new WithholdingVo();
        ArrayList<Object> list = new ArrayList<Object>(4);
        List caches = this.redisTemplate.opsForList().range((Object)WithhodingUtil.getRedisKey(), 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)caches)) {
            for (Object obj : caches) {
                CacheEntity cacheEntity = (CacheEntity)JSON.parseObject((String)obj.toString(), CacheEntity.class);
                if (cacheEntity.getTotal() == 0L) {
                    cacheEntity.setRate(Integer.valueOf(100));
                    list.add(JSON.parseObject((String)JSON.toJSONString((Object)cacheEntity), CacheEntityVo.class));
                    continue;
                }
                BigDecimal a = BigDecimal.valueOf(cacheEntity.getComplateNum());
                BigDecimal b = BigDecimal.valueOf(cacheEntity.getTotal());
                BigDecimal c = a.multiply(BigDecimal.valueOf(100L)).divide(b, 0, 4);
                cacheEntity.setRate(Integer.valueOf(c.intValue()));
                list.add(JSON.parseObject((String)JSON.toJSONString((Object)cacheEntity), CacheEntityVo.class));
            }
        }
        withholdingVo.setList(list);
        withholdingVo.setSid("withholding");
        this.withHoldingFeign.pushExcelMessage(withholdingVo);
    }

    @Override
    @Transactional
    public void withholdingCostPoolByMonthAndCode(String Month, String poolDetailCode) {
        TtFeePoolDetailApiListReq ttFeePoolDetailApiListReq = new TtFeePoolDetailApiListReq();
        ttFeePoolDetailApiListReq.setPageSize("1");
        ttFeePoolDetailApiListReq.setPageNum("1");
        ttFeePoolDetailApiListReq.setPoolDetailCode(poolDetailCode);
        PageInfo pageInfo = this.ttFeePoolDetailFeign.list(ttFeePoolDetailApiListReq);
        List feeList = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)feeList)) {
            List productEntities = this.mdmApiFeign.list().getObjList();
            this.dealWithholdingCostPool(feeList, productEntities);
        }
    }

    @Override
    @Transactional
    public void withholdingApplyNoExamineByMonthAndCode(String Month, String actDetailCode) {
        ActListReq actListReq = new ActListReq();
        actListReq.setPageSize("1");
        actListReq.setPageNum("1");
        actListReq.setActDetailCode(actDetailCode);
        PageInfo pageInfo = this.ttActProductFeign.list(actListReq);
        List applyNoExamineList = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)applyNoExamineList)) {
            this.dealApplyNoExamine(applyNoExamineList);
        }
    }

    @Override
    @Transactional
    public void withholdingExamineNobooksByMonthAndCode(String Month, String auditDetailCode) {
        PageInfo<TtAuditActDetailEntity> pageInfo = this.ttAuditActDetailService.list(1, 1, auditDetailCode);
        List examineNobooksList = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)examineNobooksList)) {
            this.dealExamineNobooks(examineNobooksList);
        }
    }

    @Override
    @Transactional
    public void withholdingPartExamineNobooksByMonthAndCode(String Month, String actDetailCode) {
        ActDetailListPartReq req = new ActDetailListPartReq();
        req.setPageNum("1");
        req.setPageSize("1");
        req.setActDetailCode(actDetailCode);
        PageInfo pageInfo = this.ttActProductFeign.listPart(req);
        List examineNobooksList = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)examineNobooksList)) {
            this.dealPartExamineNobooks(examineNobooksList);
        }
    }

    @Override
    @Transactional
    public void withholdingByIds(ArrayList<String> ids) {
        List<TtWithholding> entities = this.withholdingDao.listByIds(ids, ConstantEnum.StatusEnum.DELETE.getValue());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        String mouth = DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyy_MM);
        for (TtWithholding entity : entities) {
            String type = entity.getType();
            if (type.equals(TtWithholding.TYPE.COSTPOOL.getCode())) {
                this.withholdingCostPoolByMonthAndCode(mouth, entity.getPoolDetailCode());
                continue;
            }
            if (type.equals(TtWithholding.TYPE.APPLYNOEXAMINE.getCode())) {
                this.withholdingApplyNoExamineByMonthAndCode(mouth, entity.getActDetailCode());
                continue;
            }
            if (type.equals(TtWithholding.TYPE.EXAMINENOBOOKS.getCode())) {
                this.withholdingExamineNobooksByMonthAndCode(mouth, entity.getAuditDetailCode());
                continue;
            }
            if (!type.equals(TtWithholding.TYPE.PARTEXAMINENOBOOKS.getCode())) continue;
            this.withholdingPartExamineNobooksByMonthAndCode(mouth, entity.getActDetailCode());
        }
    }
}

