/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.api.feign.KnlDictFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.bean.DataGridColumn;
import com.biz.eisp.base.common.tag.bean.FormColumn;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.FormEnum;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.configure.entity.KnlFormConfigEntity;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.configure.vo.KnlFormConfigVo;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.dict.entity.KnlDictAttributeConfEntity;
import com.biz.eisp.kernel.KnlTableConfigFeign;
import com.biz.eisp.service.RedisService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DealTableCofUtil {
    public static final String DICTDATACONFIG = "dictDataConfig";
    private static KnlTableConfigFeign knlTableConfigFeign;
    private static RedisService redisService;
    private static KnlDictFeign knlDictFeign;

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    public static void getKnlDictFeign() {
        String[] beanTypes;
        if (knlDictFeign == null && (beanTypes = SpringApplicationContextUtil.getApplicationContext().getBeanNamesForType(KnlDictFeign.class)).length > 0) {
            knlDictFeign = (KnlDictFeign)SpringApplicationContextUtil.getApplicationContext().getBean(KnlDictFeign.class);
        }
    }

    public static void getKnlTableConfigFeign() {
        String[] beanTypes;
        if (knlTableConfigFeign == null && (beanTypes = SpringApplicationContextUtil.getApplicationContext().getBeanNamesForType(KnlTableConfigFeign.class)).length > 0) {
            knlTableConfigFeign = (KnlTableConfigFeign)SpringApplicationContextUtil.getApplicationContext().getBean(KnlTableConfigFeign.class);
        }
    }

    public static void toDoCofTable(List<DataGridColumn> columnList, String tagConf, RedisService redisService) {
        if (StringUtils.isNotBlank((CharSequence)tagConf)) {
            Map confMap = redisService.hmget("TABLE_CONFIG_" + tagConf);
            if (confMap == null || confMap.size() == 0) {
                DealTableCofUtil.getKnlTableConfigFeign();
                KnlTableConfigVo vo = new KnlTableConfigVo();
                vo.setFunctionId(tagConf);
                vo.setIsInit(Boolean.valueOf(true));
                List configs = ApiResultUtil.listResult((AjaxJson)knlTableConfigFeign.getTableConfigByParam(vo), (boolean)true);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)configs)) {
                    for (KnlTableConfigEntity item2 : configs) {
                        confMap.put(item2.getField(), item2);
                    }
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(columnList) && confMap != null && confMap.size() > 0) {
                HashMap dataGridColumnMap = new HashMap(columnList.size());
                columnList.forEach(item -> dataGridColumnMap.put(item.getField(), item));
                ArrayList result = new ArrayList();
                confMap.values().forEach(item -> {
                    String field;
                    KnlTableConfigEntity entity = (KnlTableConfigEntity)item;
                    if (entity != null && StringUtil.isNotEmpty((CharSequence)(field = entity.getField())) && StringUtil.isNotEmpty((CharSequence)field.trim())) {
                        String title = entity.getTitle();
                        Integer showOrder = entity.getShowOrder();
                        String search = entity.getIsSearch();
                        String width = entity.getShowWidth();
                        String hide = entity.getIsHide();
                        DataGridColumn column = null;
                        column = dataGridColumnMap.containsKey(field) ? (DataGridColumn)dataGridColumnMap.get(field) : new DataGridColumn();
                        if (StringUtil.isEmpty((String)width)) {
                            width = "120";
                        }
                        column.setField(field);
                        column.setWidth(Integer.valueOf(width));
                        column.setHidden(ConstantEnum.YesNoEnum.ONE.getValue().equals(hide));
                        column.setQuery(ConstantEnum.YesNoEnum.ONE.getValue().equals(search));
                        if (StringUtil.isEmpty((String)title)) {
                            title = field;
                        }
                        column.setTitle(title);
                        if (showOrder == null) {
                            showOrder = 999;
                        }
                        column.setColumnOrder(showOrder);
                        column.setDictionary(entity.getDictionary());
                        if (StringUtil.isNotBlank((CharSequence)entity.getQueryMode())) {
                            column.setQueryMode(entity.getQueryMode());
                        }
                        if (StringUtil.isNotBlank((CharSequence)entity.getFormatter())) {
                            column.setFormatter(entity.getFormatter());
                        }
                        result.add(column);
                    }
                });
                columnList.forEach(item -> {
                    if (!confMap.containsKey(item.getField())) {
                        String title = item.getTitle();
                        Integer showOrder = item.getColumnOrder();
                        Boolean search = item.isQuery();
                        Integer width = item.getWidth();
                        Boolean hide = item.isHidden();
                        if (StringUtil.isEmpty((Object)width)) {
                            width = 120;
                        }
                        item.setWidth(width);
                        item.setHidden(hide == null ? false : hide);
                        item.setQuery(search == null ? false : search);
                        if (StringUtil.isEmpty((String)title)) {
                            title = item.getField();
                        }
                        item.setTitle(title);
                        if (showOrder == null) {
                            showOrder = 999;
                        }
                        item.setColumnOrder(showOrder);
                        result.add(item);
                    }
                });
                columnList.clear();
                Collections.sort(result, Comparator.comparing(DataGridColumn::getColumnOrder));
                columnList.addAll(result);
            }
        }
    }

    public static void setExtendColumn(List<DataGridColumn> columns, String extendTableName, RedisService redisService, String tagConf, boolean checkbox) {
        if (StringUtils.isNotBlank((CharSequence)extendTableName) && DICTDATACONFIG.equals(extendTableName)) {
            HashMap<Object, Object> confMap = redisService.hmget("DICT_CONF_" + tagConf);
            if (confMap == null || confMap.size() == 0) {
                DealTableCofUtil.getKnlDictFeign();
                List dalist = ApiResultUtil.listResult((AjaxJson)knlDictFeign.getDictAttribute(tagConf), (boolean)true);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)dalist)) {
                    HashMap<Object, Object> finalConfMap1 = confMap = new HashMap<Object, Object>();
                    dalist.forEach(item -> finalConfMap1.put(item.getFieldCode(), item));
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(columns)) {
                HashMap<Object, Object> finalConfMap = confMap;
                columns.stream().forEach(item -> {
                    if (finalConfMap != null && finalConfMap.containsKey(item.getField())) {
                        KnlDictAttributeConfEntity entity = (KnlDictAttributeConfEntity)finalConfMap.get(item.getField());
                        item.setTitle(entity.getFieldName());
                        item.setColumnOrder(entity.getShowOrder());
                        if (StringUtils.isNotBlank((CharSequence)entity.getDataDictType())) {
                            item.setDictionary(entity.getDataDictType());
                        }
                        finalConfMap.remove(item.getField());
                    }
                });
            }
            if (confMap.size() > 0) {
                confMap.forEach((k, v) -> {
                    KnlDictAttributeConfEntity entity = (KnlDictAttributeConfEntity)v;
                    DataGridColumn tmp = new DataGridColumn();
                    tmp.setColumnOrder(entity.getShowOrder());
                    tmp.setTitle(entity.getFieldName());
                    tmp.setField(entity.getFieldCode());
                    tmp.setTreefield(entity.getFieldCode());
                    if (StringUtils.isNotBlank((CharSequence)entity.getDataDictType())) {
                        tmp.setDictionary(entity.getDataDictType());
                    }
                    columns.add(tmp);
                });
            }
        }
    }

    public static void createColumn(List<FormColumn> columns, RedisService redisService, String tagConf) {
        HashMap<Object, Object> confMap = null;
        try {
            confMap = redisService.hmget("FORM_CONFIG_" + tagConf);
        }
        catch (Exception e) {
            redisService.del(new String[]{"FORM_CONFIG_" + tagConf});
            e.printStackTrace();
        }
        if (confMap == null || confMap.isEmpty()) {
            confMap = DealTableCofUtil.doCreateConfMap((Map<Object, Object>)confMap, tagConf);
        }
        HashMap<Object, Object> doconfMap = confMap == null ? new HashMap<Object, Object>() : confMap;
        HashMap<String, FormColumn> mapOld = new HashMap<String, FormColumn>();
        columns.forEach(item -> mapOld.put(item.getField(), (FormColumn)item));
        mapOld.forEach((k, v) -> {
            if (doconfMap.containsKey(k)) {
                doconfMap.remove(k);
            }
        });
        if (!doconfMap.isEmpty()) {
            doconfMap.forEach((k, v) -> {
                FormColumn formColumn = DealTableCofUtil.createFormColumn((KnlFormConfigEntity)v);
                columns.add(formColumn);
            });
        }
    }

    private static FormColumn createFormColumn(KnlFormConfigEntity entity) {
        FormColumn formColumn = new FormColumn();
        formColumn.setField(entity.getFieldCode());
        formColumn.setLabelName(entity.getFieldCode());
        if (StringUtil.equals((String)"1", (String)entity.getRequired())) {
            formColumn.setRequired(true);
        } else {
            formColumn.setRequired(false);
        }
        if (StringUtil.equals((String)"1", (String)entity.getShowModel())) {
            formColumn.setHidden(false);
        } else if (StringUtil.equals((String)"2", (String)entity.getShowModel())) {
            formColumn.setHidden(false);
            formColumn.setReadOnly(true);
        } else if (StringUtil.equals((String)"3", (String)entity.getShowModel())) {
            formColumn.setHidden(true);
        }
        return formColumn;
    }

    private static Map<Object, Object> doCreateConfMap(Map<Object, Object> confMap, String tagConf) {
        if (confMap == null || confMap.isEmpty()) {
            DealTableCofUtil.getKnlTableConfigFeign();
            KnlFormConfigVo vo = new KnlFormConfigVo();
            vo.setFunctionId(tagConf);
            List configs = ApiResultUtil.listResult((AjaxJson)knlTableConfigFeign.getFormConfigByParam(vo), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)configs)) {
                for (KnlFormConfigEntity entity : configs) {
                    confMap.put(entity.getFieldCode(), entity);
                }
            }
        }
        return confMap;
    }

    public static void setFormExtendColumn(List<FormColumn> columns, RedisService redisService, String tagConf) {
        Map<Object, Object> confMapAll = redisService.hmget("FORM_CONFIG_" + tagConf);
        if (confMapAll == null || confMapAll.isEmpty()) {
            confMapAll = DealTableCofUtil.doCreateConfMap(confMapAll, tagConf);
        }
        Map<Object, Object> confMap = confMapAll;
        if (CollectionUtil.listNotEmptyNotSizeZero(columns) && confMap != null && confMap.size() > 0) {
            columns.stream().forEach(item -> {
                if (confMap != null && confMap.containsKey(item.getField())) {
                    KnlFormConfigEntity entity = (KnlFormConfigEntity)confMap.get(item.getField());
                    item.setLabelName(entity.getFieldName());
                    item.setColumnOrder(StringUtils.isNotBlank((CharSequence)entity.getShowOrder()) ? Integer.valueOf(entity.getShowOrder()) : 0);
                    if (StringUtil.equals((String)"1", (String)entity.getRequired())) {
                        item.setRequired(true);
                    } else {
                        item.setRequired(false);
                    }
                    if (StringUtil.equals((String)"1", (String)entity.getShowModel())) {
                        item.setHidden(false);
                    } else if (StringUtil.equals((String)"2", (String)entity.getShowModel())) {
                        item.setHidden(false);
                        item.setReadOnly(true);
                    } else {
                        item.setHidden(true);
                    }
                    if (StringUtil.isNotEmpty((CharSequence)entity.getDictionary())) {
                        item.setTypeGroupCode(entity.getDictionary());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)entity.getDateFormat())) {
                        item.setDateFormat(entity.getDateFormat());
                    }
                    if (StringUtil.isNotEmpty((CharSequence)entity.getStyle())) {
                        item.setStyle(entity.getStyle());
                    }
                    String optionType = entity.getOptionType();
                    if (StringUtil.hasNumeric((String)entity.getFormTags()) || FormEnum.select.name().equals(optionType) || FormEnum.rich_text.name().equals(optionType)) {
                        item.setOptionType(optionType);
                    }
                    if (FormEnum.textarea.name().equals(optionType) || FormEnum.rich_text.name().equals(optionType)) {
                        String rows = "3";
                        String cols = "5";
                        if (StringUtil.isNotEmpty((CharSequence)rows)) {
                            rows = entity.getTextAreaRows();
                        }
                        if (StringUtil.isNotEmpty((CharSequence)cols)) {
                            cols = entity.getTextAreaCols();
                        }
                        item.setRows(rows);
                        item.setCols(cols);
                    }
                    if (StringUtil.isBlank((CharSequence)item.getDefaultVal()) && StringUtil.isNotBlank((CharSequence)entity.getDefaultVal())) {
                        item.setDefaultVal(entity.getDefaultVal());
                    }
                    item.setDataType(entity.getDataType());
                    String placeholder = "";
                    if (StringUtil.isNotEmpty((CharSequence)entity.getPlaceholder())) {
                        placeholder = entity.getPlaceholder();
                        placeholder = placeholder.replaceAll("\\s*", "");
                    }
                    item.setPlaceholder(placeholder);
                } else {
                    item.setColumnOrder(0);
                }
            });
            Collections.sort(columns, Comparator.comparing(FormColumn::getColumnOrder));
        }
    }

    public static List<DataGridColumn> getPersonSettin(List<DataGridColumn> columnList, String tagConf) {
        ArrayList<KnlTableConfigEntity> indatas = new ArrayList<KnlTableConfigEntity>();
        ArrayList<KnlTableConfigEntity> nodatas = new ArrayList<KnlTableConfigEntity>();
        DealTableCofUtil.getDataList(indatas, nodatas, tagConf, false);
        List<Object> result = new ArrayList();
        if (!CollectionUtil.listNotEmptyNotSizeZero(indatas)) {
            return columnList;
        }
        Map<String, KnlTableConfigEntity> map = indatas.stream().collect(Collectors.toMap(KnlTableConfigEntity::getField, KnlTableConfigEntity2 -> KnlTableConfigEntity2));
        result = columnList.stream().filter(dl -> map.containsKey(dl.getField())).collect(Collectors.toList());
        result.stream().forEach(item -> {
            KnlTableConfigEntity entity = (KnlTableConfigEntity)map.get(item.getField());
            if (entity.getShowOrder() != null) {
                item.setColumnOrder(entity.getShowOrder());
            }
            if (StringUtil.equals((String)"1", (String)entity.getIsSearch())) {
                item.setQuery(true);
            } else {
                item.setQuery(false);
            }
            if (StringUtil.isNotEmpty((CharSequence)entity.getIsHide())) {
                item.setHidden(Integer.valueOf(entity.getIsHide()) == 1);
            }
            item.setColumnOrder(entity.getShowOrder());
        });
        Collections.sort(result, Comparator.comparing(DataGridColumn::getColumnOrder));
        return result;
    }

    public static void getDataList(List<KnlTableConfigEntity> indatas, List<KnlTableConfigEntity> nodatas, String functionId, Boolean feignFlag) {
        DealTableCofUtil.getRedisService();
        String userName = UserUtils.getUser().getUsername();
        Map map = redisService.hmget("TABLE_CONFIG_" + userName + "_" + functionId);
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                String isSeachConf;
                KnlTableConfigEntity entity = (KnlTableConfigEntity)entry.getValue();
                if (StringUtils.isNotBlank((CharSequence)entity.getIsHide()) && "0".equals(entity.getIsHide())) {
                    isSeachConf = DealTableCofUtil.getIsSearchConf(entity, functionId);
                    entity.setIsSearchConf(isSeachConf);
                    indatas.add(entity);
                    continue;
                }
                isSeachConf = DealTableCofUtil.getIsSearchConf(entity, functionId);
                entity.setIsSearchConf(isSeachConf);
                nodatas.add(entity);
            }
        } else if (feignFlag.booleanValue() && (map == null || map.isEmpty())) {
            DealTableCofUtil.getKnlTableConfigFeign();
            KnlTableConfigVo tableConfigVo = new KnlTableConfigVo();
            tableConfigVo.setFunctionId(functionId);
            tableConfigVo.setUserName(userName);
            List list = ApiResultUtil.listResult((AjaxJson)knlTableConfigFeign.getTableConfigByParam(tableConfigVo));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                list.forEach(item -> {
                    if (StringUtils.isNotBlank((CharSequence)item.getIsHide()) && "0".equals(item.getIsHide())) {
                        String isSeachConf = DealTableCofUtil.getIsSearchConf(item, functionId);
                        item.setIsSearchConf(isSeachConf);
                        indatas.add((KnlTableConfigEntity)item);
                    } else {
                        String isSeachConf = DealTableCofUtil.getIsSearchConf(item, functionId);
                        item.setIsSearchConf(isSeachConf);
                        nodatas.add((KnlTableConfigEntity)item);
                    }
                });
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(indatas)) {
            Collections.sort(indatas, Comparator.comparing(KnlTableConfigEntity::getShowOrder));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(nodatas)) {
            Collections.sort(nodatas, Comparator.comparing(KnlTableConfigEntity::getShowOrder));
        }
    }

    private static String getIsSearchConf(KnlTableConfigEntity entity, String functionId) {
        String isSearchConf;
        block3: {
            block2: {
                Map confMap = redisService.hmget("TABLE_CONFIG_" + functionId);
                isSearchConf = null;
                if (confMap == null || confMap.isEmpty()) break block2;
                for (Map.Entry entry : confMap.entrySet()) {
                    if (!entity.getField().equals(entry.getKey())) continue;
                    KnlTableConfigEntity knlTableConfigEntity = (KnlTableConfigEntity)entry.getValue();
                    isSearchConf = knlTableConfigEntity.getIsSearch();
                }
                break block3;
            }
            KnlTableConfigVo vo = new KnlTableConfigVo();
            vo.setFunctionId(functionId);
            vo.setIsInit(Boolean.valueOf(true));
            List configs = ApiResultUtil.listResult((AjaxJson)knlTableConfigFeign.getTableConfigByParam(vo));
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)configs)) break block3;
            for (KnlTableConfigEntity knlTableConfigEntity : configs) {
                isSearchConf = knlTableConfigEntity.getIsSearch();
            }
        }
        return isSearchConf;
    }
}

