/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.policy.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.policy.entity.PayPolicyHeadEntity;
import com.biz.eisp.pay.policy.entity.PayProductPolicyAreaEntity;
import com.biz.eisp.pay.policy.entity.PayProductPolicyFormulaEntity;
import com.biz.eisp.pay.policy.entity.PayRMergeProdPolicyEntity;
import com.biz.eisp.pay.policy.entity.PayRProdPolicyProdEntity;
import com.biz.eisp.pay.policy.vo.PayPolicyVo;
import com.biz.eisp.policy.dao.PayPolicyDao;
import com.biz.eisp.policy.dao.PayProductPolicyAreaDao;
import com.biz.eisp.policy.dao.PayProductPolicyFormulaDao;
import com.biz.eisp.policy.dao.PayRMergeProdPolicyDao;
import com.biz.eisp.policy.dao.PayRProdPolicyProdDao;
import com.biz.eisp.policy.service.PayPolicyService;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jodd.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class PayPolicyServiceImpl
implements PayPolicyService {
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private PayPolicyDao payPolicyDao;
    @Autowired
    private PayRProdPolicyProdDao payRProdPolicyProdDao;
    @Autowired
    private PayRMergeProdPolicyDao payRMergeProdPolicyDao;
    @Autowired
    private PayProductPolicyAreaDao payProductPolicyAreaDao;
    @Autowired
    private PayProductPolicyFormulaDao payProductPolicyFormulaDao;

    @Override
    public PageInfo<PayPolicyVo> findPayPolicyList(PayPolicyVo dmsPolicyVo, Page page) {
        if (null == page) {
            page = new Page();
        }
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.payPolicyDao.findDmsPolicyList(dmsPolicyVo), (Page)page);
        return pageInfo;
    }

    @Override
    public PayPolicyVo getPayPolicyVoInfoById(String id) {
        if (StringUtil.isBlank((String)id)) {
            return null;
        }
        PayPolicyHeadEntity entity = (PayPolicyHeadEntity)this.payPolicyDao.selectByPrimaryKey(id);
        PayPolicyVo vo = this.apply(entity);
        return vo;
    }

    public PayPolicyVo apply(PayPolicyHeadEntity entity) {
        PayPolicyVo vo = new PayPolicyVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setAssessmentProItemsJson(this.getAssessmentProItemsJson(entity.getProductPolicyCode()));
        vo.setAssessmentMergeProItemsJson(this.getAssessmentMergeProItemsJson(entity.getProductPolicyCode()));
        vo.setPolicyAreaItemsJson_aex(this.getPolicyAreaItemsJson_aex(entity.getProductPolicyCode()));
        vo.setPolicyAreaItemsJson_ain(this.getPolicyAreaItemsJson_ain(entity.getProductPolicyCode()));
        vo.setPolicyAreaItemsJson_dex(this.getPolicyAreaItemsJson_dex(entity.getProductPolicyCode()));
        vo.setPolicyAreaItemsJson_din(this.getPolicyAreaItemsJson_din(entity.getProductPolicyCode()));
        vo.setPolicyFormulasJson(this.getPolicyFormulasJson(entity.getProductPolicyCode()));
        if (vo.getDmsCostRate() != null) {
            vo.setDmsCostRateStr(vo.getDmsCostRate().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString());
        }
        if (vo.getTpmCostRate() != null) {
            vo.setTpmCostRateStr(vo.getTpmCostRate().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString());
        }
        return vo;
    }

    private String getAssessmentProItemsJson(String productPolicyCode) {
        Example example = new Example(PayRProdPolicyProdEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        List entityList = this.payRProdPolicyProdDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayRProdPolicyProdEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("productCode", (Object)entity.getProductCode());
                obj.put("productName", (Object)entity.getProductName());
                obj.put("ratio", (Object)entity.getRatio());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    private String getAssessmentMergeProItemsJson(String productPolicyCode) {
        Example example = new Example(PayRMergeProdPolicyEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        List entityList = this.payRMergeProdPolicyDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayRMergeProdPolicyEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("productCode", (Object)entity.getProductCode());
                obj.put("productName", (Object)entity.getProductName());
                obj.put("ratio", (Object)entity.getRatio());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    private String getPolicyAreaItemsJson_ain(String productPolicyCode) {
        Example example = new Example(PayProductPolicyAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        criteria.andIsNotNull("orgCode");
        criteria.andIsNotNull("orgName");
        criteria.andEqualTo("protype", (Object)"1");
        List entityList = this.payProductPolicyAreaDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayProductPolicyAreaEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("orgCode", (Object)entity.getOrgCode());
                obj.put("orgName", (Object)entity.getOrgName());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    private String getPolicyAreaItemsJson_aex(String productPolicyCode) {
        Example example = new Example(PayProductPolicyAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        criteria.andIsNotNull("orgCode");
        criteria.andIsNotNull("orgName");
        criteria.andEqualTo("protype", (Object)"0");
        List entityList = this.payProductPolicyAreaDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayProductPolicyAreaEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("orgCode", (Object)entity.getOrgCode());
                obj.put("orgName", (Object)entity.getOrgName());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    private String getPolicyAreaItemsJson_din(String productPolicyCode) {
        Example example = new Example(PayProductPolicyAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        criteria.andIsNotNull("customerCode");
        criteria.andEqualTo("protype", (Object)"1");
        List entityList = this.payProductPolicyAreaDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayProductPolicyAreaEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("customerCode", (Object)entity.getCustomerCode());
                obj.put("customerName", (Object)entity.getCustomerName());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    private String getPolicyAreaItemsJson_dex(String productPolicyCode) {
        Example example = new Example(PayProductPolicyAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        criteria.andIsNotNull("customerCode");
        criteria.andEqualTo("protype", (Object)"0");
        List entityList = this.payProductPolicyAreaDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayProductPolicyAreaEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("customerCode", (Object)entity.getCustomerCode());
                obj.put("customerName", (Object)entity.getCustomerName());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    private String getPolicyFormulasJson(String productPolicyCode) {
        Example example = new Example(PayProductPolicyFormulaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        example.setOrderByClause("create_date asc");
        List entityList = this.payProductPolicyFormulaDao.selectByExample(example);
        JSONArray array = new JSONArray();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            for (PayProductPolicyFormulaEntity entity : entityList) {
                JSONObject obj = new JSONObject();
                obj.put("formulaCon", (Object)entity.getFormulaCon());
                obj.put("formulaVal", (Object)entity.getFormulaVal());
                obj.put("formulaConDesc", (Object)entity.getFormulaConDesc());
                obj.put("formulaValDesc", (Object)entity.getFormulaValDesc());
                array.add((Object)obj);
            }
        }
        return array.toJSONString();
    }

    @Override
    public AjaxJson savePayPolicy(PayPolicyVo payPolicyVo) {
        AjaxJson json = new AjaxJson();
        json.setSuccessMsg("\u4fdd\u5b58\u6210\u529f");
        UserRedis userRedis = UserUtils.getUser();
        String dateStr = DateUtils.datetimeFormat.format(new Date());
        PayPolicyHeadEntity entity = null;
        if (StringUtil.isNotEmpty((String)payPolicyVo.getId())) {
            entity = (PayPolicyHeadEntity)this.payPolicyDao.selectByPrimaryKey(payPolicyVo.getId());
            entity.setEnableStatus("003");
            entity.setUpdateDate(dateStr);
            entity.setUpdateName(userRedis.getUsername());
            entity.setProductPolicyName(payPolicyVo.getProductPolicyName());
            entity.setBeginDate(payPolicyVo.getBeginDate());
            entity.setEndDate(payPolicyVo.getEndDate());
            entity.setPolicyCycle(payPolicyVo.getPolicyCycle());
            entity.setApplyBeginDate(payPolicyVo.getApplyBeginDate());
            entity.setApplyEndDate(payPolicyVo.getApplyEndDate());
            entity.setPolicyDesc(payPolicyVo.getPolicyDesc());
            this.payPolicyDao.updateByPrimaryKey(entity);
        } else {
            TmOrgVo tmOrgVo;
            entity = new PayPolicyHeadEntity();
            BeanUtils.copyProperties((Object)payPolicyVo, (Object)entity, (String[])new String[]{"earlyPolicyCode", "earlyPolicyName"});
            entity.setId(null);
            String productPolicyCode = CodeRuleUtil.getKnlCodingRulesString((String)"dms_policy");
            entity.setProductPolicyCode(productPolicyCode);
            entity.setSuperimpositionFlag("N");
            entity.setEnableStatus("003");
            entity.setPositionCode(userRedis.getPosCode());
            entity.setPositionName(userRedis.getPosName());
            entity.setOrgCode(userRedis.getOrgCode());
            if (StringUtil.isNotEmpty((String)userRedis.getOrgId()) && null != (tmOrgVo = (TmOrgVo)ApiResultUtil.objResult((AjaxJson)this.mdmApiFeign.getOrgUpById(userRedis.getOrgId())))) {
                entity.setOrgCode(tmOrgVo.getOrgCode());
                entity.setOrgName(tmOrgVo.getOrgName());
            }
            entity.setCreateDate(dateStr);
            entity.setCreateName(userRedis.getUsername());
            entity.setUpdateDate(dateStr);
            entity.setUpdateName(userRedis.getUsername());
            entity.setProductPolicyName(payPolicyVo.getProductPolicyName());
            entity.setBeginDate(payPolicyVo.getBeginDate());
            entity.setEndDate(payPolicyVo.getEndDate());
            entity.setPolicyCycle(payPolicyVo.getPolicyCycle());
            entity.setApplyBeginDate(payPolicyVo.getApplyBeginDate());
            entity.setApplyEndDate(payPolicyVo.getApplyEndDate());
            entity.setPolicyDesc(payPolicyVo.getPolicyDesc());
            this.payPolicyDao.insertSelective(entity);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)payPolicyVo.getPolicyJson());
        this.saveTtRProdPolicyProd(entity, jsonObject.getString("assessmentProItemsJson"));
        this.saveTtRMergeProdPolicy(entity, jsonObject.getString("assessmentMergeProItemsJson"));
        this.saveTtProductPolicyArea(entity, jsonObject.getString("policyAreaItemsJson_din"), jsonObject.getString("policyAreaItemsJson_dex"), jsonObject.getString("policyAreaItemsJson_ain"), jsonObject.getString("policyAreaItemsJson_aex"));
        this.saveTtProductPolicyFormula(entity, jsonObject.getString("policyFormulasJson"));
        return json;
    }

    private void saveTtRProdPolicyProd(PayPolicyHeadEntity policyHead, String jsonArrayString) {
        this.deleteTtRProdPolicyProdByPolicy(policyHead.getProductPolicyCode());
        List<PayRProdPolicyProdEntity> entityList = this.buildTtRProdPolicyProdEntityList(policyHead, jsonArrayString);
        for (PayRProdPolicyProdEntity entity : entityList) {
            this.payRProdPolicyProdDao.insertSelective(entity);
        }
    }

    private List<PayRProdPolicyProdEntity> buildTtRProdPolicyProdEntityList(PayPolicyHeadEntity policyHead, String jsonData) {
        JSONArray jsonArray = JSONArray.parseArray((String)jsonData);
        ArrayList<PayRProdPolicyProdEntity> entityList = new ArrayList<PayRProdPolicyProdEntity>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            String productCode = obj.getString("productCode");
            String productName = obj.getString("productName");
            BigDecimal ratio = obj.getBigDecimal("ratio");
            PayRProdPolicyProdEntity entity = new PayRProdPolicyProdEntity();
            entity.setProductCode(productCode);
            entity.setProductName(productName);
            entity.setRatio(ratio);
            entity.setProductPolicyCode(policyHead.getProductPolicyCode());
            entity.setProductPolicyName(policyHead.getProductPolicyName());
            entityList.add(entity);
        }
        return entityList;
    }

    private void deleteTtRProdPolicyProdByPolicy(String productPolicyCode) {
        Example example = new Example(PayRProdPolicyProdEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        this.payRProdPolicyProdDao.deleteByExample(example);
    }

    private void saveTtRMergeProdPolicy(PayPolicyHeadEntity policyHead, String jsonArrayString) {
        this.deleteTtRMergeProdPolicyByPolicy(policyHead.getProductPolicyCode());
        List<PayRMergeProdPolicyEntity> entityList = this.buildTtRMergeProdPolicyEntityList(policyHead, jsonArrayString);
        for (PayRMergeProdPolicyEntity entity : entityList) {
            this.payRMergeProdPolicyDao.insertSelective(entity);
        }
    }

    private List<PayRMergeProdPolicyEntity> buildTtRMergeProdPolicyEntityList(PayPolicyHeadEntity policyHead, String jsonData) {
        JSONArray jsonArray = JSONArray.parseArray((String)jsonData);
        ArrayList<PayRMergeProdPolicyEntity> entityList = new ArrayList<PayRMergeProdPolicyEntity>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            String productCode = obj.getString("productCode");
            String productName = obj.getString("productName");
            BigDecimal ratio = obj.getBigDecimal("ratio");
            PayRMergeProdPolicyEntity entity = new PayRMergeProdPolicyEntity();
            entity.setProductCode(productCode);
            entity.setProductName(productName);
            entity.setRatio(ratio);
            entity.setProductPolicyCode(policyHead.getProductPolicyCode());
            entity.setProductPolicyName(policyHead.getProductPolicyName());
            entityList.add(entity);
        }
        return entityList;
    }

    private void deleteTtRMergeProdPolicyByPolicy(String productPolicyCode) {
        Example example = new Example(PayRMergeProdPolicyEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        this.payRMergeProdPolicyDao.deleteByExample(example);
    }

    private void saveTtProductPolicyArea(PayPolicyHeadEntity policyHead, String policyAreaItemsJson_din, String policyAreaItemsJson_dex, String policyAreaItemsJson_ain, String policyAreaItemsJson_aex) {
        this.deleteTtProductPolicyAreaByPolicy(policyHead.getProductPolicyCode());
        List<PayProductPolicyAreaEntity> dinList = this.buildTtProductPolicyAreaEntityList(policyHead, policyAreaItemsJson_din);
        List<PayProductPolicyAreaEntity> dexList = this.buildTtProductPolicyAreaEntityList(policyHead, policyAreaItemsJson_dex);
        List<PayProductPolicyAreaEntity> ainList = this.buildTtProductPolicyAreaEntityList(policyHead, policyAreaItemsJson_ain);
        List<PayProductPolicyAreaEntity> aexList = this.buildTtProductPolicyAreaEntityList(policyHead, policyAreaItemsJson_aex);
        for (PayProductPolicyAreaEntity entity : dinList) {
            entity.setOrgCode(null);
            entity.setOrgName(null);
            this.payProductPolicyAreaDao.insertSelective(entity);
        }
        for (PayProductPolicyAreaEntity entity : dexList) {
            entity.setOrgCode(null);
            entity.setOrgName(null);
            this.payProductPolicyAreaDao.insertSelective(entity);
        }
        for (PayProductPolicyAreaEntity entity : ainList) {
            this.payProductPolicyAreaDao.insertSelective(entity);
        }
        for (PayProductPolicyAreaEntity entity : aexList) {
            this.payProductPolicyAreaDao.insertSelective(entity);
        }
    }

    private List<PayProductPolicyAreaEntity> buildTtProductPolicyAreaEntityList(PayPolicyHeadEntity policyHead, String jsonData) {
        JSONArray jsonArray = JSONArray.parseArray((String)jsonData);
        ArrayList<PayProductPolicyAreaEntity> entityList = new ArrayList<PayProductPolicyAreaEntity>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            String orgCode = obj.getString("orgCode");
            String orgName = obj.getString("orgName");
            String customerCode = obj.getString("customerCode");
            String customerName = obj.getString("customerName");
            Integer protype = obj.getInteger("protype");
            PayProductPolicyAreaEntity entity = new PayProductPolicyAreaEntity();
            entity.setProductPolicyCode(policyHead.getProductPolicyCode());
            entity.setProductPolicyName(policyHead.getProductPolicyName());
            entity.setOrgCode(orgCode);
            entity.setOrgName(orgName);
            entity.setCustomerCode(customerCode);
            entity.setCustomerName(customerName);
            entity.setProtype(protype);
            entityList.add(entity);
        }
        return entityList;
    }

    private void deleteTtProductPolicyAreaByPolicy(String productPolicyCode) {
        Example example = new Example(PayProductPolicyAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        this.payProductPolicyAreaDao.deleteByExample(example);
    }

    private void saveTtProductPolicyFormula(PayPolicyHeadEntity policyHead, String policyFormulasJson) {
        this.deleteTtProductPolicyFormulaByPolicy(policyHead.getProductPolicyCode());
        List<PayProductPolicyFormulaEntity> entityList = this.buildTtProductPolicyFormulaEntityList(policyHead, policyFormulasJson);
        for (PayProductPolicyFormulaEntity entity : entityList) {
            this.payProductPolicyFormulaDao.insertSelective(entity);
        }
    }

    private List<PayProductPolicyFormulaEntity> buildTtProductPolicyFormulaEntityList(PayPolicyHeadEntity policyHead, String jsonData) {
        JSONArray jsonArray = JSONArray.parseArray((String)jsonData);
        ArrayList<PayProductPolicyFormulaEntity> entityList = new ArrayList<PayProductPolicyFormulaEntity>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            String formulaCon = obj.getString("formulaCon");
            String formulaVal = obj.getString("formulaVal");
            String formulaConDesc = obj.getString("formulaConDesc");
            String formulaValDesc = obj.getString("formulaValDesc");
            PayProductPolicyFormulaEntity entity = new PayProductPolicyFormulaEntity();
            entity.setFormulaCon(formulaCon);
            entity.setFormulaVal(formulaVal);
            entity.setFormulaConDesc(formulaConDesc);
            entity.setFormulaValDesc(formulaValDesc);
            entity.setProductPolicyCode(policyHead.getProductPolicyCode());
            entity.setProductPolicyName(policyHead.getProductPolicyName());
            entityList.add(entity);
        }
        return entityList;
    }

    private void deleteTtProductPolicyFormulaByPolicy(String productPolicyCode) {
        Example example = new Example(PayProductPolicyFormulaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        this.payProductPolicyFormulaDao.deleteByExample(example);
    }

    @Override
    public AjaxJson startPayProductPolicy(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u542f\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            PayPolicyHeadEntity dmsPolicyHeadEntity = (PayPolicyHeadEntity)this.payPolicyDao.selectByPrimaryKey(id);
            if (null == dmsPolicyHeadEntity || "009".equals(dmsPolicyHeadEntity.getEnableStatus())) continue;
            dmsPolicyHeadEntity.setEnableStatus("009");
            this.payPolicyDao.updateByPrimaryKey(dmsPolicyHeadEntity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson stopPayProductPolicy(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u505c\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            PayPolicyHeadEntity dmsPolicyHeadEntity = (PayPolicyHeadEntity)this.payPolicyDao.selectByPrimaryKey(id);
            if (null == dmsPolicyHeadEntity || "003".equals(dmsPolicyHeadEntity.getEnableStatus())) continue;
            dmsPolicyHeadEntity.setEnableStatus("003");
            this.payPolicyDao.updateByPrimaryKey(dmsPolicyHeadEntity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson deletePayProductPolicy(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u5220\u9664\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            this.payPolicyDao.deleteByPrimaryKey(id);
        }
        return ajaxJson;
    }
}

