/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.template.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.template.entity.TdTemplateConfigEntity;
import com.biz.eisp.pay.template.entity.TdTemplateEntity;
import com.biz.eisp.pay.template.entity.TdTemplatePartEntity;
import com.biz.eisp.pay.template.vo.TdTemplateConfigVo;
import com.biz.eisp.pay.template.vo.TdTemplatePartNoShowVo;
import com.biz.eisp.pay.template.vo.TdTemplatePartVo;
import com.biz.eisp.pay.template.vo.TdTemplateVo;
import com.biz.eisp.template.dao.TdTemplateConfigDao;
import com.biz.eisp.template.dao.TdTemplateDao;
import com.biz.eisp.template.dao.TdTemplatePartDao;
import com.biz.eisp.template.service.TdTemplateService;
import com.biz.eisp.template.transformer.TdTemplatePartVoToEntity;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="tdTemplateService")
public class TdTemplateServiceImpl
implements TdTemplateService {
    @Autowired
    private TdTemplateDao tdTemplateDao;
    @Autowired
    private TdTemplatePartDao tdTemplatePartDao;
    @Autowired
    private TdTemplateConfigDao tdTemplateConfigDao;

    @Override
    public TdTemplateEntity findTdTemplateEntity(String id) {
        return (TdTemplateEntity)this.tdTemplateDao.selectByPrimaryKey(id);
    }

    @Override
    public TdTemplatePartEntity findTdTemplatePartEntity(String id) {
        return (TdTemplatePartEntity)this.tdTemplatePartDao.selectByPrimaryKey(id);
    }

    @Override
    public TdTemplateConfigEntity findTdTemplateConfigEntity(String id) {
        return (TdTemplateConfigEntity)this.tdTemplateConfigDao.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<TdTemplateVo> findTdTemplateList(TdTemplateVo tdTemplateVo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tdTemplateDao.findTdTemplateList(tdTemplateVo), (Page)page);
    }

    @Override
    public PageInfo<TdTemplatePartVo> findTdTemplatePartList(TdTemplatePartVo tdTemplatePartVo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tdTemplateDao.findTdTemplatePartList(tdTemplatePartVo), (Page)page);
    }

    @Override
    public PageInfo<TdTemplateConfigVo> findTdTemplateConfigList(TdTemplateConfigVo tdTemplateConfigVo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tdTemplateDao.findTdTemplateConfigList(tdTemplateConfigVo), (Page)page);
    }

    @Override
    public void saveTdTemplate(TdTemplateEntity tdTemplateEntity) {
        String dateStr = DateUtils.datetimeFormat.format(new Date());
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtil.isNotEmpty((CharSequence)tdTemplateEntity.getId())) {
            TdTemplateEntity entity = (TdTemplateEntity)this.tdTemplateDao.selectByPrimaryKey(tdTemplateEntity.getId());
            entity.setTplPath(tdTemplateEntity.getTplPath());
            entity.setTplName(tdTemplateEntity.getTplName());
            entity.setTplXml(tdTemplateEntity.getTplXml());
            entity.setTplType(tdTemplateEntity.getTplType());
            entity.setRisk(tdTemplateEntity.getRisk());
            entity.setUpdateDate(dateStr);
            entity.setUpdateName(userRedis.getUsername());
            this.tdTemplateDao.updateByPrimaryKeySelective(entity);
        } else {
            tdTemplateEntity.setStatus(Integer.valueOf(1));
            tdTemplateEntity.setCreateDate(dateStr);
            tdTemplateEntity.setCreateName(userRedis.getUsername());
            tdTemplateEntity.setUpdateDate(dateStr);
            tdTemplateEntity.setUpdateName(userRedis.getUsername());
            this.tdTemplateDao.insertSelective(tdTemplateEntity);
        }
    }

    @Override
    public void saveTdTemplatePart(TdTemplatePartVo tdTemplatePartVo) {
        TdTemplatePartEntity tdTemplatePartEntity = new TdTemplatePartVoToEntity(this, this.tdTemplatePartDao).apply(tdTemplatePartVo);
        String dateStr = DateUtils.datetimeFormat.format(new Date());
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtil.isNotEmpty((CharSequence)tdTemplatePartEntity.getId())) {
            TdTemplatePartEntity entity = (TdTemplatePartEntity)this.tdTemplatePartDao.selectByPrimaryKey(tdTemplatePartEntity.getId());
            entity.setTplPartName(tdTemplatePartEntity.getTplPartName());
            entity.setTplPartTag(tdTemplatePartEntity.getTplPartTag());
            entity.setReplaceTag(tdTemplatePartEntity.getReplaceTag());
            entity.setTplId(tdTemplatePartEntity.getTplId());
            entity.setTplPartXml(tdTemplatePartEntity.getTplPartXml());
            entity.setIsPhoto(tdTemplatePartEntity.getIsPhoto());
            entity.setBannerPicId(tdTemplatePartEntity.getBannerPicId());
            entity.setImgElement(tdTemplatePartEntity.getImgElement());
            entity.setDisplaySort(tdTemplatePartEntity.getDisplaySort());
            entity.setRisk(tdTemplatePartEntity.getRisk());
            entity.setIsShow(tdTemplatePartEntity.getIsShow());
            entity.setUpdateDate(dateStr);
            entity.setUpdateName(userRedis.getUsername());
            this.tdTemplatePartDao.updateByPrimaryKeySelective(entity);
        } else {
            tdTemplatePartEntity.setStatus(Integer.valueOf(1));
            tdTemplatePartEntity.setCreateDate(dateStr);
            tdTemplatePartEntity.setCreateName(userRedis.getUsername());
            tdTemplatePartEntity.setUpdateDate(dateStr);
            tdTemplatePartEntity.setUpdateName(userRedis.getUsername());
            this.tdTemplatePartDao.insertSelective(tdTemplatePartEntity);
        }
    }

    @Override
    public AjaxJson startVisitGroup(String id, String status) {
        AjaxJson json = new AjaxJson();
        json.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        TdTemplatePartEntity tdTemplatePart = (TdTemplatePartEntity)this.tdTemplatePartDao.selectByPrimaryKey(id);
        if (null != tdTemplatePart) {
            tdTemplatePart.setStatus(Integer.valueOf(status));
            this.tdTemplatePartDao.updateByPrimaryKey(tdTemplatePart);
        }
        return json;
    }

    @Override
    public void saveTdTemplateConfig(TdTemplateConfigEntity tdTemplateConfigEntity) {
        if (StringUtil.isNotEmpty((CharSequence)tdTemplateConfigEntity.getId())) {
            this.tdTemplateConfigDao.updateByPrimaryKeySelective(tdTemplateConfigEntity);
        } else {
            this.tdTemplateConfigDao.insertSelective(tdTemplateConfigEntity);
        }
    }

    @Override
    @Cacheable(value={"templateCache"}, key="'TemplatePartKey'+#type")
    public List<TdTemplatePartNoShowVo> getTemplatePartByType(String type) {
        return this.tdTemplateDao.getTemplatePartListByType(type);
    }
}

