/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.template.service.impl;

import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.template.entity.TdOrgTemplatePartEntity;
import com.biz.eisp.pay.template.vo.TdOrgTemplatePartVo;
import com.biz.eisp.pay.template.vo.TdTemplatePartVo;
import com.biz.eisp.template.dao.TdOrgTemplatePartDao;
import com.biz.eisp.template.service.TdOrgTemplatePartService;
import com.biz.eisp.template.transformer.TdOrgTemplatePartVoToEntity;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="tdOrgTemplatePartService")
public class TdOrgTemplatePartServiceImpl
implements TdOrgTemplatePartService {
    @Autowired
    private TdOrgTemplatePartDao tdOrgTemplatePartDao;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    @Override
    public TdOrgTemplatePartEntity findTdOrgTemplatePartById(String id) {
        return (TdOrgTemplatePartEntity)this.tdOrgTemplatePartDao.selectByPrimaryKey(id);
    }

    @Override
    public List<TdOrgTemplatePartVo> findTdOrgTemplatePartList(TdOrgTemplatePartVo tdOrgTemplatePartVo) {
        return this.tdOrgTemplatePartDao.findTdOrgTemplatePartList(tdOrgTemplatePartVo);
    }

    @Override
    public void saveTdOrgTemplatePart(TdOrgTemplatePartVo tdOrgTemplatePartVo) {
        TdOrgTemplatePartEntity entity = new TdOrgTemplatePartVoToEntity(this, this.tdOrgTemplatePartDao).apply(tdOrgTemplatePartVo);
        TmOrgVo orgVo = (TmOrgVo)ApiResultUtil.objResult((AjaxJson)this.tmOrgFeign.getOrgByIdOrCode(null, tdOrgTemplatePartVo.getOrgCode()));
        if (null != orgVo) {
            tdOrgTemplatePartVo.setOrgName(orgVo.getOrgName());
        }
        if (StringUtil.isEmpty((String)entity.getId())) {
            this.tdOrgTemplatePartDao.insertSelective(entity);
        } else {
            this.tdOrgTemplatePartDao.updateByPrimaryKeySelective(entity);
        }
    }

    @Override
    public PageInfo<TdTemplatePartVo> findTdConfTemplatePartList(TdTemplatePartVo tdTemplatePartVo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tdOrgTemplatePartDao.findTdConfTemplatePartList(tdTemplatePartVo), (Page)page);
    }

    @Override
    public AjaxJson deleteAllList(String ids) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)ids)) {
            return ajaxJson;
        }
        try {
            int k = 0;
            int j = 0;
            for (String id : ids.split(",")) {
                try {
                    this.tdOrgTemplatePartDao.deleteByPrimaryKey(id);
                    ++k;
                }
                catch (Exception e) {
                    ++j;
                    e.printStackTrace();
                }
            }
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg("\u64cd\u4f5c\u6210\u529f" + k + "\u6761\u6570\u636e,\u5931\u8d25" + j + "\u6761");
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }
}

