/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.policy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.pay.policy.entity.PayPolicyCalculationProcessEntity;
import com.biz.eisp.pay.policy.entity.PayPolicyCalculationResultEntity;
import com.biz.eisp.pay.policy.entity.PayPolicyHeadEntity;
import com.biz.eisp.pay.policy.entity.PayProductPolicyAreaEntity;
import com.biz.eisp.pay.policy.entity.PayProductPolicyFormulaEntity;
import com.biz.eisp.pay.policy.entity.PayRMergeProdPolicyEntity;
import com.biz.eisp.pay.policy.entity.PayRProdPolicyProdEntity;
import com.biz.eisp.pay.policy.vo.PayPolicyCalculationParamVo;
import com.biz.eisp.policy.dao.PayPolicyCalculationProcessDao;
import com.biz.eisp.policy.dao.PayPolicyCalculationResultDao;
import com.biz.eisp.policy.dao.PayPolicyDao;
import com.biz.eisp.policy.dao.PayProductPolicyAreaDao;
import com.biz.eisp.policy.dao.PayProductPolicyFormulaDao;
import com.biz.eisp.policy.dao.PayRMergeProdPolicyDao;
import com.biz.eisp.policy.dao.PayRProdPolicyProdDao;
import com.biz.eisp.policy.service.PayPolicyCalcQueryCustomer;
import com.biz.eisp.policy.service.PayPolicyCalculationAsyncService;
import com.biz.eisp.policy.service.PayPolicyCalculationService;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class PayPolicyCalculationServiceImpl
implements PayPolicyCalculationService {
    @Autowired
    private PayPolicyDao payPolicyDao;
    @Autowired
    private PayRProdPolicyProdDao payRProdPolicyProdDao;
    @Autowired
    private PayRMergeProdPolicyDao payRMergeProdPolicyDao;
    @Autowired
    private PayProductPolicyAreaDao payProductPolicyAreaDao;
    @Autowired
    private PayProductPolicyFormulaDao payProductPolicyFormulaDao;
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired(required=false)
    private PayPolicyCalcQueryCustomer payPolicyCalcQueryCustomer;
    @Autowired
    private PayPolicyCalculationAsyncService payPolicyCalculationAsyncService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private PayPolicyCalculationProcessDao payPolicyCalculationProcessDao;
    @Autowired
    private PayPolicyCalculationResultDao payPolicyCalculationResultDao;

    @Override
    @Async
    public void calculation(final PayPolicyCalculationParamVo paramVo) {
        List<TmCustomerVo> customerList;
        String key = AppcenterUtil.getUserKey();
        if (StringUtil.isEmpty((String)key)) {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            map.put("loginUserToken", "18583662867_110120119");
            ThreadLocalUtil.stObj(map);
            UserRedis userRedis = new UserRedis();
            userRedis.setUsername("admin");
            userRedis.setId("40ac5eed7a7774a6e053f002a8c021c6");
            this.redisService.setDays("LOGIN_SUCCESS_18583662867_110120119", (Object)JSONObject.toJSONString((Object)userRedis), 2L);
        }
        if (Objects.isNull(paramVo.getProductPolicyCode())) {
            return;
        }
        PayPolicyHeadEntity payPolicyHeadEntity = new PayPolicyHeadEntity();
        payPolicyHeadEntity.setProductPolicyCode(paramVo.getProductPolicyCode());
        PayPolicyHeadEntity selectOne = (PayPolicyHeadEntity)this.payPolicyDao.selectOne(payPolicyHeadEntity);
        if (Objects.isNull(selectOne)) {
            return;
        }
        paramVo.setPolicyHeadEntity(selectOne);
        List<PayRProdPolicyProdEntity> policyProductList = this.doHandlerProduct(selectOne.getProductPolicyCode());
        List<PayRMergeProdPolicyEntity> policyMergeProductList = this.doHandlerMergeProduct(selectOne.getProductPolicyCode());
        List<TmCustomerVo> list = customerList = Objects.isNull(paramVo.getCustomerVo()) ? this.doHandlerCustomer(selectOne.getProductPolicyCode()) : new ArrayList<TmCustomerVo>(){
            {
                this.add(paramVo.getCustomerVo());
            }
        };
        if (CollectionUtil.listNotEmptyNotSizeZero((List)customerList)) {
            return;
        }
        List<PayProductPolicyFormulaEntity> policyFormulaList = this.doHandlerFormula(selectOne.getProductPolicyCode());
        if (CollectionUtil.listNotEmptyNotSizeZero(policyFormulaList)) {
            return;
        }
        List<PayPolicyCalculationParamVo> split = this.doHandlerSplit(policyProductList, policyMergeProductList, customerList, policyFormulaList, paramVo);
        split.stream().forEach(e -> this.payPolicyCalculationAsyncService.execute((PayPolicyCalculationParamVo)e));
    }

    private List<PayPolicyCalculationParamVo> doHandlerSplit(List<PayRProdPolicyProdEntity> policyProductList, List<PayRMergeProdPolicyEntity> policyMergeProductList, List<TmCustomerVo> customerList, List<PayProductPolicyFormulaEntity> policyFormulaList, PayPolicyCalculationParamVo paramVo) {
        ArrayList<PayPolicyCalculationParamVo> result = new ArrayList<PayPolicyCalculationParamVo>();
        customerList.stream().forEach(c -> policyFormulaList.stream().forEach(f -> {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)policyProductList)) {
                policyProductList.stream().forEach(p -> {
                    PayPolicyCalculationParamVo vo = new PayPolicyCalculationParamVo();
                    vo.setCalculationYearMonth(paramVo.getCalculationYearMonth());
                    vo.setProductPolicyCode(paramVo.getProductPolicyCode());
                    vo.setCustomerVo(c);
                    vo.setPolicyFormula(f);
                    vo.setProductPolicyName(vo.getPolicyHeadEntity().getProductPolicyName());
                    vo.setPolicyMergeProduct(policyMergeProductList);
                    vo.setPolicyProduct(p);
                    vo.setTtActEntity(paramVo.getTtActEntity());
                    vo.setPolicyHeadEntity(paramVo.getPolicyHeadEntity());
                    result.add(vo);
                });
            } else {
                PayPolicyCalculationParamVo vo = new PayPolicyCalculationParamVo();
                vo.setCalculationYearMonth(paramVo.getCalculationYearMonth());
                vo.setProductPolicyCode(paramVo.getProductPolicyCode());
                vo.setProductPolicyName(vo.getPolicyHeadEntity().getProductPolicyName());
                vo.setCustomerVo(c);
                vo.setPolicyFormula(f);
                vo.setPolicyMergeProduct(policyMergeProductList);
                vo.setTtActEntity(paramVo.getTtActEntity());
                vo.setPolicyHeadEntity(paramVo.getPolicyHeadEntity());
                result.add(vo);
            }
        }));
        return result;
    }

    private List<PayProductPolicyFormulaEntity> doHandlerFormula(String productPolicyCode) {
        Example example = new Example(PayProductPolicyFormulaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        List list = this.payProductPolicyFormulaDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return list;
        }
        return new ArrayList<PayProductPolicyFormulaEntity>();
    }

    private List<TmCustomerVo> doHandlerCustomer(String productPolicyCode) {
        Example example = new Example(PayProductPolicyAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        List list = this.payProductPolicyAreaDao.selectByExample(example);
        List include = list.stream().filter(e -> e.getProtype() == 1).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(include)) {
            HashMap excludeMap = new HashMap();
            List exclude = list.stream().filter(e -> e.getProtype() == 0).collect(Collectors.toList());
            exclude.stream().forEach(e -> {
                if (StringUtil.isNotEmpty((CharSequence)e.getCustomerCode())) {
                    excludeMap.put(e.getCustomerCode(), e.getCustomerCode());
                } else if (StringUtil.isNotEmpty((CharSequence)e.getOrgCode())) {
                    List<TmCustomerVo> customerVoList = this.doQueryCustomer(e.getOrgCode());
                    customerVoList.stream().forEach(c -> excludeMap.put(c.getCustomerCode(), c.getCustomerCode()));
                }
            });
            HashMap includeMap = new HashMap();
            include.stream().forEach(e -> {
                if (StringUtil.isNotEmpty((CharSequence)e.getCustomerCode()) && !excludeMap.containsKey(e.getCustomerCode())) {
                    TmCustomerVo vo = (TmCustomerVo)this.customerFeign.getCustomerByIdOrCode("", e.getCustomerCode()).getObj();
                    if (Objects.nonNull(vo)) {
                        includeMap.put(e.getCustomerCode(), vo);
                    }
                } else if (StringUtil.isNotEmpty((CharSequence)e.getOrgCode())) {
                    List<TmCustomerVo> customerVoList = this.doQueryCustomer(e.getOrgCode());
                    customerVoList.stream().forEach(c -> {
                        if (!excludeMap.containsKey(c.getCustomerCode())) {
                            includeMap.put(c.getCustomerCode(), c);
                        }
                    });
                }
            });
            if (includeMap.keySet().size() > 0) {
                ArrayList<TmCustomerVo> customers = new ArrayList<TmCustomerVo>();
                includeMap.entrySet().stream().forEach(k -> customers.add((TmCustomerVo)k.getValue()));
                return customers;
            }
        }
        return null;
    }

    private List<TmCustomerVo> doQueryCustomer(String orgCode) {
        List customerVoList;
        if (Objects.isNull(this.payPolicyCalcQueryCustomer)) {
            ArrayList<String> orgCodes = new ArrayList<String>();
            orgCodes.add(orgCode);
            customerVoList = this.customerFeign.findCustomerByOrgCodes(orgCodes).getObjList();
        } else {
            customerVoList = this.payPolicyCalcQueryCustomer.findCustomerByOrgCodes(orgCode).getObjList();
        }
        return customerVoList;
    }

    private List<PayRMergeProdPolicyEntity> doHandlerMergeProduct(String productPolicyCode) {
        Example example = new Example(PayRMergeProdPolicyEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        List list = this.payRMergeProdPolicyDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return list;
        }
        return new ArrayList<PayRMergeProdPolicyEntity>();
    }

    private List<PayRProdPolicyProdEntity> doHandlerProduct(String productPolicyCode) {
        Example example = new Example(PayRProdPolicyProdEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productPolicyCode", (Object)productPolicyCode);
        List list = this.payRProdPolicyProdDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return list;
        }
        return new ArrayList<PayRProdPolicyProdEntity>();
    }

    @Override
    public PageInfo<PayPolicyCalculationResultEntity> findPayPolicyCalculationResultList(PayPolicyCalculationResultEntity resultEntity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.payPolicyCalculationResultDao.findPayPolicyCalculationResultList(resultEntity), (Page)page);
    }

    @Override
    public PageInfo<PayPolicyCalculationProcessEntity> findPayPolicyCalculationProcessList(PayPolicyCalculationProcessEntity processEntity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.payPolicyCalculationProcessDao.findPayPolicyCalculationProcessList(processEntity), (Page)page);
    }
}

