/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.template.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.pay.template.entity.TdTemplateConfigEntity;
import com.biz.eisp.pay.template.entity.TdTemplateEntity;
import com.biz.eisp.pay.template.entity.TdTemplatePartEntity;
import com.biz.eisp.pay.template.vo.TdTemplateConfigVo;
import com.biz.eisp.pay.template.vo.TdTemplatePartNoShowVo;
import com.biz.eisp.pay.template.vo.TdTemplatePartVo;
import com.biz.eisp.pay.template.vo.TdTemplateVo;
import com.biz.eisp.template.service.TdTemplateService;
import com.biz.eisp.template.transformer.TdTemplateConfigVoToEntity;
import com.biz.eisp.template.transformer.TdTemplateVoToEntity;
import com.github.pagehelper.PageInfo;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tdTemplateController"})
public class TdTemplateController {
    private static final Logger log = LoggerFactory.getLogger(TdTemplateController.class);
    @Autowired
    private TdTemplateService tdTemplateService;

    @RequestMapping(value={"findTdTemplateList"})
    @ResponseBody
    public DataGrid findTdTemplateList(TdTemplateVo tdTemplateVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = null;
        PageInfo<TdTemplateVo> pageInfo = new PageInfo<TdTemplateVo>();
        try {
            page = new EuPage(request);
            pageInfo = this.tdTemplateService.findTdTemplateList(tdTemplateVo, (Page)page);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new DataGrid((PageInfo)pageInfo);
    }

    @RequestMapping(value={"findTdTemplatePartList"})
    @ResponseBody
    public DataGrid findTdTemplatePartList(TdTemplatePartVo tdTemplatePartVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = null;
        PageInfo<TdTemplatePartVo> pageInfo = new PageInfo<TdTemplatePartVo>();
        try {
            page = new EuPage(request);
            pageInfo = this.tdTemplateService.findTdTemplatePartList(tdTemplatePartVo, (Page)page);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new DataGrid((PageInfo)pageInfo);
    }

    @RequestMapping(value={"findTdTemplateConfigList"})
    @ResponseBody
    public DataGrid findTdTemplateConfigList(TdTemplateConfigVo tdTemplateConfigVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = null;
        PageInfo<TdTemplateConfigVo> pageInfo = new PageInfo<TdTemplateConfigVo>();
        try {
            page = new EuPage(request);
            pageInfo = this.tdTemplateService.findTdTemplateConfigList(tdTemplateConfigVo, (Page)page);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return new DataGrid((PageInfo)pageInfo);
    }

    @RequestMapping(value={"saveTdTemplate"})
    @ResponseBody
    public AjaxJson saveTdTemplate(TdTemplateVo tdTemplateVo, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            TdTemplateEntity entity = new TdTemplateVoToEntity().apply(tdTemplateVo);
            this.tdTemplateService.saveTdTemplate(entity);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveTdTemplatePart"})
    @ResponseBody
    public AjaxJson saveTdTemplatePart(TdTemplatePartVo tdTemplatePartVo, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tdTemplateService.saveTdTemplatePart(tdTemplatePartVo);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"/startOrstopPart"})
    @ResponseBody
    public AjaxJson startVisitGroup(String id, String status, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tdTemplateService.startVisitGroup(id, status);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return j;
    }

    @RequestMapping(value={"saveTdTemplateConfig"})
    @ResponseBody
    public AjaxJson saveTdTemplateConfig(TdTemplateConfigVo tdTemplateConfigVo, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            TdTemplateConfigEntity entity = new TdTemplateConfigVoToEntity(this.tdTemplateService).apply(tdTemplateConfigVo);
            this.tdTemplateService.saveTdTemplateConfig(entity);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"previewPage"})
    public void viewIndexPage(String id, HttpServletResponse response, HttpServletRequest request) {
        HashMap param = new HashMap();
        HashMap<String, Object> textMap = new HashMap<String, Object>();
        textMap.put("title", "dms\u5546\u57ce");
        String loginName = UserUtils.getUser().getUsername();
        textMap.put("loginName", loginName);
        TdTemplateEntity tdTemplateEntity = this.tdTemplateService.findTdTemplateEntity(id);
        List tdTemplatePartEntityList = tdTemplateEntity.getTdTemplatePartEntityList();
        Collections.sort(tdTemplatePartEntityList, new Comparator<TdTemplatePartEntity>(){

            @Override
            public int compare(TdTemplatePartEntity o1, TdTemplatePartEntity o2) {
                BigDecimal o1BigDecimal = BigDecimal.ZERO;
                if (StringUtil.isNotEmpty((Object)o1.getDisplaySort())) {
                    o1BigDecimal = new BigDecimal(o1.getDisplaySort());
                }
                BigDecimal o2BigDecimal = BigDecimal.ZERO;
                if (StringUtil.isNotEmpty((Object)o2.getDisplaySort())) {
                    o2BigDecimal = new BigDecimal(o2.getDisplaySort());
                }
                return o1BigDecimal.compareTo(o2BigDecimal);
            }
        });
        textMap.put("pageParts", tdTemplatePartEntityList);
        String indexPage = "";
        try {
            String templatePath = this.getClass().getResource("/template").getPath();
            Configuration _tplConfig = new Configuration();
            _tplConfig.setDirectoryForTemplateLoading(new File(templatePath));
            _tplConfig.setNumberFormat("#");
            StringWriter swriter = new StringWriter();
            Template mytpl = _tplConfig.getTemplate(tdTemplateEntity.getTplPath(), "utf-8");
            param.put("param", textMap);
            mytpl.process(param, (Writer)swriter);
            indexPage = swriter.toString();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            indexPage = e.toString();
        }
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter pw = response.getWriter();
            pw.write(indexPage);
            pw.flush();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    @RequestMapping(value={"getTemplatePartByType"})
    @ResponseBody
    public AjaxJson fetchTemplatePartByType(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        String type = request.getParameter("type");
        try {
            if (StringUtil.isNotEmpty((CharSequence)type)) {
                List<TdTemplatePartNoShowVo> rows = this.tdTemplateService.getTemplatePartByType(type);
                ajaxJson.setObj(rows);
            } else {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u7f3a\u5c11\u53c2\u6570");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"testDataList"})
    @ResponseBody
    public AjaxJson testDataList(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson dj = new AjaxJson();
        ArrayList<HashedMap> list = new ArrayList<HashedMap>();
        HashedMap map1 = new HashedMap();
        map1.put("name", "\u4f18\u9178\u4e73");
        map1.put("price", "100");
        map1.put("url", "/upload/meijiu.png.png");
        map1.put("id", new Date().getTime());
        map1.put("type", 0);
        list.add(map1);
        HashedMap map2 = new HashedMap();
        map2.put("name", "\u4f18\u9178\u4e73");
        map2.put("price", "100");
        map2.put("url", "/upload/meijiu.png.png");
        map2.put("id", new Date().getTime());
        map2.put("type", 0);
        list.add(map2);
        HashedMap map3 = new HashedMap();
        map3.put("name", "\u4f18\u9178\u4e73");
        map3.put("price", "100");
        map3.put("url", "/upload/meijiu.png.png");
        map3.put("id", new Date().getTime());
        map3.put("type", 0);
        list.add(map3);
        HashedMap map4 = new HashedMap();
        map4.put("name", "\u4f18\u9178\u4e73");
        map4.put("price", "100");
        map4.put("url", "/upload/meijiu.png.png");
        map4.put("id", new Date().getTime());
        map4.put("type", 0);
        list.add(map4);
        HashedMap map5 = new HashedMap();
        map5.put("name", "\u4f18\u9178\u4e73");
        map5.put("price", "100");
        map5.put("url", "/upload/meijiu.png.png");
        map5.put("id", new Date().getTime());
        map5.put("type", 0);
        list.add(map5);
        dj.setObj(list);
        dj.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        return dj;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTdTemplate"})
    public AjaxJson deleteTdTemplate(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.tdTemplateService.deleteTdTemplate(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"deleteTdTemplatePart"})
    public AjaxJson deleteTdTemplatePart(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.tdTemplateService.deleteTdTemplatePart(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

