/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.policy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.pay.policy.entity.PayPolicyCalculationProcessEntity;
import com.biz.eisp.pay.policy.entity.PayPolicyCalculationResultEntity;
import com.biz.eisp.pay.policy.vo.PayPolicyCalculationParamVo;
import com.biz.eisp.policy.dao.PayPolicyCalculationProcessDao;
import com.biz.eisp.policy.dao.PayPolicyCalculationResultDao;
import com.biz.eisp.policy.resolver.PayPolicyVariableResolver;
import com.biz.eisp.policy.service.PayPolicyCalculationAsyncService;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.template.util.ExpressionUtil;
import com.biz.eisp.template.util.RebateUtil;
import com.biz.eisp.thread.ThreadLocalUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.nfunk.jep.JEP;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PayPolicyCalculationAsyncServiceImpl
implements PayPolicyCalculationAsyncService {
    @Autowired(required=false)
    private Map<String, PayPolicyVariableResolver> payPolicyVariableResolver;
    @Autowired
    private PayPolicyCalculationProcessDao payPolicyCalculationProcessDao;
    @Autowired
    private RedisService redisService;
    @Autowired
    private PayPolicyCalculationResultDao payPolicyCalculationResultDao;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    @Override
    @Async
    public void execute(PayPolicyCalculationParamVo vo) {
        String key = AppcenterUtil.getUserKey();
        if (StringUtil.isEmpty((String)key)) {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            map.put("loginUserToken", "18583662867_110120119");
            ThreadLocalUtil.stObj(map);
            UserRedis userRedis = new UserRedis();
            userRedis.setUsername("admin");
            userRedis.setId("40ac5eed7a7774a6e053f002a8c021c6");
            this.redisService.setDays("LOGIN_SUCCESS_18583662867_110120119", (Object)JSONObject.toJSONString((Object)userRedis), 2L);
        }
        PayPolicyCalculationProcessEntity log = new PayPolicyCalculationProcessEntity();
        log.setConditionFormula(vo.getPolicyFormula().getFormulaCon());
        log.setActCode(Objects.isNull(vo.getTtActEntity()) ? null : vo.getTtActEntity().getActCode());
        log.setActName(Objects.isNull(vo.getTtActEntity()) ? null : vo.getTtActEntity().getActName());
        HashMap cache = new HashMap();
        List<String> condition = RebateUtil.getVariable(vo.getPolicyFormula().getFormulaCon());
        StringBuffer conditionBuffer = new StringBuffer();
        condition.stream().forEach(e -> {
            PayPolicyVariableResolver resolver = this.payPolicyVariableResolver.get(e);
            if (Objects.nonNull(resolver)) {
                try {
                    Object obj = resolver.resolver(vo);
                    conditionBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:" + String.valueOf(obj) + "<br/>");
                    cache.put(e, obj);
                }
                catch (Exception pt) {
                    conditionBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:\u51fa\u73b0\u5f02\u5e38" + pt.getMessage() + "<br/>");
                }
            } else {
                conditionBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u89e3\u6790\u5668<br/>");
            }
        });
        log.setConditionValue(conditionBuffer.toString());
        boolean bool = false;
        try {
            JEP jep = ExpressionUtil.getJEP(cache);
            bool = ExpressionUtil.workOutBool(jep, vo.getPolicyFormula().getFormulaCon());
            log.setConditionResult(bool ? "true" : "false");
        }
        catch (Exception e2) {
            log.setConditionResult("\u5f02\u5e38:" + e2.getMessage());
        }
        String resultId = null;
        if (bool) {
            List<String> value = RebateUtil.getVariable(vo.getPolicyFormula().getFormulaVal());
            HashMap formulaMap = new HashMap();
            StringBuffer formulaBuffer = new StringBuffer();
            value.stream().forEach(e -> {
                PayPolicyVariableResolver resolver = this.payPolicyVariableResolver.get(e);
                if (Objects.nonNull(resolver)) {
                    if (cache.containsKey(e)) {
                        formulaMap.put(e, cache.get(e));
                        formulaBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:" + String.valueOf(cache.get(e)) + "<br/>");
                    } else {
                        try {
                            Object obj = resolver.resolver(vo);
                            formulaMap.put(e, obj);
                            formulaBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:" + String.valueOf(obj) + "<br/>");
                        }
                        catch (Exception pt) {
                            formulaBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:\u51fa\u73b0\u5f02\u5e38" + pt.getMessage() + "<br/>");
                        }
                    }
                } else {
                    formulaBuffer.append("\u53d8\u91cf:" + e + ",\u53d6\u503c\u4e3a:\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u89e3\u6790\u5668<br/>");
                }
            });
            log.setFormula(vo.getPolicyFormula().getFormulaVal());
            log.setFormulaValue(formulaBuffer.toString());
            try {
                JEP jep = ExpressionUtil.getJEP(formulaMap);
                Object result = ExpressionUtil.workOutSingle(jep, vo.getPolicyFormula().getFormulaVal());
                log.setResultValue(String.valueOf(result));
                PayPolicyCalculationResultEntity entity = new PayPolicyCalculationResultEntity();
                entity.setResultValue(String.valueOf(result));
                entity.setConditionFormula(vo.getPolicyFormula().getFormulaCon());
                entity.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                entity.setCustomerCode(vo.getCustomerVo().getCustomerCode());
                entity.setCustomerName(vo.getCustomerVo().getCustomerName());
                entity.setFormula(vo.getPolicyFormula().getFormulaVal());
                entity.setPolicyCalculationYearMonth(vo.getCalculationYearMonth());
                entity.setPolicyProductCode(vo.getProductPolicyCode());
                entity.setProductCode(Objects.isNull(vo.getPolicyProduct()) ? null : vo.getPolicyProduct().getProductCode());
                entity.setProductName(Objects.isNull(vo.getPolicyProduct()) ? null : vo.getPolicyProduct().getProductName());
                entity.setActCode(Objects.isNull(vo.getTtActEntity()) ? null : vo.getTtActEntity().getActCode());
                entity.setActName(Objects.isNull(vo.getTtActEntity()) ? null : vo.getTtActEntity().getActName());
                entity.setStartDate(Objects.isNull(vo.getTtActEntity()) ? null : vo.getTtActEntity().getBeginDate());
                entity.setActDetailCode(Objects.isNull(vo.getTtActDetailEntity()) ? null : vo.getTtActDetailEntity().getActDetailCode());
                entity.setEndDate(Objects.isNull(vo.getTtActEntity()) ? null : vo.getTtActEntity().getEndDate());
                entity.setPolicyCycle(vo.getPolicyHeadEntity().getPolicyCycle());
                entity.setPolicyStartDate(vo.getPolicyHeadEntity().getBeginDate());
                entity.setPolicyEndDate(vo.getPolicyHeadEntity().getEndDate());
                entity.setFinalValue(entity.getResultValue());
                entity.setAdjustValue(null);
                entity.setUpdateBy("\u7cfb\u7edf\u8ba1\u7b97");
                entity.setUpdateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                entity.setUpdateName("\u7cfb\u7edf\u8ba1\u7b97");
                entity.setConfirmStatus(ConstantEnum.CONFIRM.NO.getValue());
                TmOrgVo orgVo = (TmOrgVo)this.tmOrgFeign.getOrgByIdOrCode(vo.getCustomerVo().getOrgId(), "").getObj();
                if (Objects.nonNull(orgVo)) {
                    entity.setOrgCode(orgVo.getOrgCode());
                    entity.setOrgName(orgVo.getOrgName());
                }
                this.payPolicyCalculationResultDao.insert(entity);
                resultId = entity.getId();
            }
            catch (Exception pt) {
                log.setResultValue("\u5f02\u5e38:" + pt.getMessage());
            }
        }
        log.setResultId(resultId);
        log.setCustomerCode(vo.getCustomerVo().getCustomerCode());
        log.setPolicyCalculationYearMonth(vo.getCalculationYearMonth());
        log.setPolicyProductCode(vo.getProductPolicyCode());
        this.payPolicyCalculationProcessDao.insert(log);
    }
}

