/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.policy.controller;

import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.api.feign.TmWareInfoFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.product.TmProductInfoVo;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.ware.vo.TmWareInfoVo;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payPolicyFormulaController"})
public class PayPolicyFormulaController {
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired
    private TmWareInfoFeign tmWareInfoFeign;

    @RequestMapping(value={"getTmOrgEntityTree"})
    @ResponseBody
    public List<TreeGrid> getTmOrgEntityTree(TmOrgVo tmOrgVo) {
        AjaxJson ajaxJson = this.mdmApiFeign.getTmOrgEntityTree(tmOrgVo);
        return ajaxJson.getObjList();
    }

    @RequestMapping(value={"findMatnrList"})
    @ResponseBody
    public DataGrid findMatnrList(TmProductInfoVo query, String page, String rows) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("productInfoCode", query.getProductCode());
        queryMap.put("productInfoName", query.getProductName());
        queryMap.put("page", page);
        queryMap.put("rows", rows);
        PageInfo pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.mdmApiFeign.findProductInfoByPage(queryMap));
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findWareInfoList"})
    @ResponseBody
    public DataGrid findWareInfoList(TmWareInfoVo query, String page, String rows) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("wareCode", query.getWareCode());
        queryMap.put("wareName", query.getWareName());
        queryMap.put("barCode", query.getBarCode());
        queryMap.put("productLevelCode", query.getProductLevelCode());
        queryMap.put("productLevelName", query.getProductLevelName());
        queryMap.put("specification", query.getSpecification());
        queryMap.put("shelfStatus", query.getShelfStatus());
        queryMap.put("rebateStatus", query.getRebateStatus());
        queryMap.put("isMarketMateriel", query.getIsMarketMateriel());
        queryMap.put("warePriority", query.getWarePriority());
        queryMap.put("meterUnit", query.getMeterUnit());
        queryMap.put("saleUnit", query.getSaleUnit());
        queryMap.put("composeType", query.getComposeType());
        queryMap.put("enableStatus", ConstantEnum.StatusEnum.NEW.getValue());
        queryMap.put("page", page);
        queryMap.put("rows", rows);
        PageInfo pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.tmWareInfoFeign.findTmWareInfoPage(queryMap));
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findCustomerList"})
    @ResponseBody
    public DataGrid findCustomerList(TmCustomerVo tmCustomerVo, String customerCodes, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerCode", tmCustomerVo.getCustomerCode());
        map.put("customerName", tmCustomerVo.getCustomerName());
        map.put("customerType", tmCustomerVo.getCustomerType());
        map.put("orgName", tmCustomerVo.getOrgName());
        if (StringUtil.isNotEmpty((CharSequence)customerCodes)) {
            List<String> notInCustomerCodes = Arrays.asList(customerCodes.split(","));
            map.put("notInCustomerCodes", notInCustomerCodes);
        }
        map.put("page", page.getPage());
        map.put("rows", page.getRows());
        PageInfo pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.customerFeign.getCustomerPage(map));
        return new DataGrid(pageInfo);
    }
}

