/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.parse.service.impl;

import com.biz.eisp.grpc.parse.mapper.AiProduceDateResultMapper;
import com.biz.eisp.grpc.parse.model.AiProduceDateResultEntity;
import com.biz.eisp.grpc.parse.service.impl.ActIdentifyAbstractServiceImpl;
import com.biz.eisp.grpc.service.ProduceDateIdentifyService;
import com.biz.eisp.picture.entity.TsPictureEntity;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actProduceDateIdentifyService")
@Transactional
public class ActProduceDateIdentifyServiceImpl
extends ActIdentifyAbstractServiceImpl {
    @Autowired
    private ProduceDateIdentifyService produceDateIdentifyService;
    @Autowired
    private AiProduceDateResultMapper aiProduceDateResultMapper;

    @Override
    public void identify(List<TsPictureEntity> tsPictures, String businessId, String appId, String modelName) {
        boolean success = true;
        String errorMsg = null;
        try {
            for (TsPictureEntity tsPicture : tsPictures) {
                String imgPath = tsPicture.getImgUrl();
                String produceDateStr = this.produceDateIdentifyService.identifyProduceDate(appId, modelName, imgPath);
                boolean insert = false;
                AiProduceDateResultEntity dateResultEntity = new AiProduceDateResultEntity();
                dateResultEntity.setImgId(tsPicture.getId() + "");
                AiProduceDateResultEntity aiProduceDateResult = (AiProduceDateResultEntity)this.aiProduceDateResultMapper.selectOne(dateResultEntity);
                if (null == aiProduceDateResult) {
                    aiProduceDateResult = new AiProduceDateResultEntity();
                    aiProduceDateResult.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    aiProduceDateResult.setImgId(tsPicture.getId() + "");
                    insert = true;
                }
                aiProduceDateResult.setCreatedTime(new Date());
                String produceDate = null;
                String factoryNumber = null;
                if (StringUtils.isNotEmpty((CharSequence)produceDateStr)) {
                    if (produceDateStr.length() >= 2) {
                        factoryNumber = produceDateStr.substring(produceDateStr.length() - 2);
                    }
                    if (produceDateStr.length() >= 8) {
                        produceDate = produceDateStr.substring(0, 8);
                    }
                }
                aiProduceDateResult.setProduceDate(produceDate);
                aiProduceDateResult.setFactoryNumber(factoryNumber);
                if (insert) {
                    this.aiProduceDateResultMapper.insert(aiProduceDateResult);
                    continue;
                }
                this.aiProduceDateResultMapper.updateByPrimaryKey(aiProduceDateResult);
            }
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            success = false;
        }
        this.updateStatus(businessId, true, errorMsg, true);
    }
}

