/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.utils;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.grpc.utils.ColorUtils;
import com.biz.eisp.grpc.vo.AiResultVo;
import com.biz.eisp.tk.utils.CollectionUtils;
import com.biz.eisp.util.SpringUtil;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.springframework.core.env.Environment;

public class PictureDealUtil {
    private static final String uploadPath;
    private static final String fileUrl;

    public static String reDrawAndUploadImage(AiResultVo resultVo) throws IOException {
        String picUrl = resultVo.getDetectionObject();
        BufferedImage bi = PictureDealUtil.getImageBufferedImageDealRotate(uploadPath + picUrl.replace(fileUrl, ""));
        if (null == bi) {
            return null;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        Graphics2D g = bi.createGraphics();
        Color color = g.getColor();
        List<Integer> detectionClasses = resultVo.getDetectionClasses();
        List<Double> points = resultVo.getDetectionBoxes();
        for (int i = 0; i < points.size(); i += 4) {
            int y1 = (int)(points.get(i) * (double)height);
            int x1 = (int)(points.get(i + 1) * (double)width);
            int y2 = (int)(points.get(i + 2) * (double)height);
            int x2 = (int)(points.get(i + 3) * (double)width);
            int detectionClass = detectionClasses.get(i / 4);
            int a = detectionClass % (ColorUtils.color.length - 1);
            Color thisColor = new Color(ColorUtils.color[a][0], ColorUtils.color[a][1], ColorUtils.color[a][2]);
            g.setColor(thisColor);
            g.setStroke(new BasicStroke(10.0f));
            g.drawRect(x1, y1, x2 - x1, y2 - y1);
            g.setColor(Color.white);
            Font font = new Font("\u9ed1\u4f53", 1, 30);
            g.setFont(font);
            g.drawString(detectionClass + "", x1, y1);
        }
        List<List<List<Integer>>> quadrangle = resultVo.getQuadrangle();
        if (!CollectionUtils.isEmpty(quadrangle)) {
            int x = 0;
            for (List<List<Integer>> quadList : quadrangle) {
                if (quadList.size() < 3) continue;
                g.setColor(Color.white);
                Font font = new Font("\u9ed1\u4f53", 1, 30);
                g.setFont(font);
                g.drawString("re", (int)quadList.get(0).get(0), (int)quadList.get(0).get(1));
                int a = x % (ColorUtils.color.length - 1);
                ++x;
                Color thisColor = new Color(ColorUtils.color[a][0], ColorUtils.color[a][1], ColorUtils.color[a][2]);
                g.setColor(thisColor);
                g.setStroke(new BasicStroke(10.0f));
                for (int i = 0; i < quadList.size(); ++i) {
                    int next = i + 1;
                    if (i == quadList.size() - 1) {
                        next = 0;
                    }
                    g.drawLine(quadList.get(i).get(0), quadList.get(i).get(1), quadList.get(next).get(0), quadList.get(next).get(1));
                }
                Polygon polygon = new Polygon();
                for (List<Integer> integers : quadList) {
                    polygon.addPoint(integers.get(0), integers.get(1));
                }
                thisColor = new Color(ColorUtils.color[a][0], ColorUtils.color[a][1], ColorUtils.color[a][2], 100);
                g.setColor(thisColor);
                g.fillPolygon(polygon);
            }
        }
        g.setColor(color);
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        File parentDir = new File(uploadPath + dateStr);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new BusinessException("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25!");
        }
        String fileName = UUID.randomUUID().toString() + ".jpg";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(parentDir + File.separator + fileName);
            if (ImageIO.write((RenderedImage)bi, "jpg", fos)) {
                String string = fileUrl + dateStr + File.separator + fileName;
                return string;
            }
            throw new BusinessException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
    }

    public static String drawAndUploadPersonnel(AiResultVo resultVo) throws IOException {
        String picUrl = resultVo.getDetectionObject();
        File file = new File(uploadPath + picUrl.replace(fileUrl, ""));
        BufferedImage bi = ImageIO.read(file);
        if (null == bi) {
            return null;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        Graphics2D g = bi.createGraphics();
        Color color = g.getColor();
        List<Integer> detectionClasses = resultVo.getDetectionClasses();
        List<Double> points = resultVo.getDetectionBoxes();
        for (int i = 0; i < points.size(); i += 4) {
            int y1 = (int)(points.get(i) * (double)height);
            int x1 = (int)(points.get(i + 1) * (double)width);
            int y2 = (int)(points.get(i + 2) * (double)height);
            int x2 = (int)(points.get(i + 3) * (double)width);
            int detectionClass = detectionClasses.get(i / 4);
            int a = detectionClass % (ColorUtils.color.length - 1);
            Color thisColor = new Color(ColorUtils.color[a][0], ColorUtils.color[a][1], ColorUtils.color[a][2]);
            g.setColor(thisColor);
            g.setStroke(new BasicStroke(10.0f));
            g.drawRect(x1, y1, x2 - x1, y2 - y1);
            g.setColor(Color.white);
            Font font = new Font("\u9ed1\u4f53", 1, 30);
            g.setFont(font);
            g.drawString(detectionClass + "", x1, y1);
        }
        List<List<List<Integer>>> quadrangle = resultVo.getQuadrangle();
        if (!CollectionUtils.isEmpty(quadrangle)) {
            int x = 0;
            for (List<List<Integer>> quadList : quadrangle) {
                if (quadList.size() < 3) continue;
                g.setColor(Color.white);
                Font font = new Font("\u9ed1\u4f53", 1, 30);
                g.setFont(font);
                g.drawString("re", (int)quadList.get(0).get(0), (int)quadList.get(0).get(1));
                int a = x % (ColorUtils.color.length - 1);
                ++x;
                Color thisColor = new Color(ColorUtils.color[a][0], ColorUtils.color[a][1], ColorUtils.color[a][2]);
                g.setColor(thisColor);
                g.setStroke(new BasicStroke(10.0f));
                for (int i = 0; i < quadList.size(); ++i) {
                    int next = i + 1;
                    if (i == quadList.size() - 1) {
                        next = 0;
                    }
                    g.drawLine(quadList.get(i).get(0), quadList.get(i).get(1), quadList.get(next).get(0), quadList.get(next).get(1));
                }
                Polygon polygon = new Polygon();
                for (List<Integer> integers : quadList) {
                    polygon.addPoint(integers.get(0), integers.get(1));
                }
                thisColor = new Color(ColorUtils.color[a][0], ColorUtils.color[a][1], ColorUtils.color[a][2], 100);
                g.setColor(thisColor);
                g.fillPolygon(polygon);
            }
        }
        g.setColor(color);
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        File parentDir = new File(uploadPath + dateStr);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new BusinessException("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25!");
        }
        String fileName = UUID.randomUUID().toString() + ".jpg";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(parentDir + File.separator + fileName);
            if (ImageIO.write((RenderedImage)bi, "jpg", fos)) {
                String string = fileUrl + dateStr + File.separator + fileName;
                return string;
            }
            throw new BusinessException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
    }

    public static BufferedImage getImageBufferedImageDealRotate(String fileName) {
        try {
            File file = new File(fileName);
            BufferedImage src = ImageIO.read(file);
            BufferedImage bi = null;
            if (src != null) {
                int angel = PictureDealUtil.getRotateAngleForPhoto(file);
                if (angel != 0) {
                    int src_width = src.getWidth(null);
                    int src_height = src.getHeight(null);
                    Rectangle rect_des = PictureDealUtil.CalcRotatedSize(new Rectangle(new Dimension(src_width, src_height)), angel);
                    bi = new BufferedImage(rect_des.width, rect_des.height, 1);
                    Graphics2D g2 = bi.createGraphics();
                    g2.translate((rect_des.width - src_width) / 2, (rect_des.height - src_height) / 2);
                    g2.rotate(Math.toRadians(angel), src_width / 2, src_height / 2);
                    g2.drawImage(src, null, null);
                } else {
                    bi = src;
                }
                return bi;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel > 90) {
            if (angel / 9 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    public static int getRotateAngleForPhoto(File file) {
        int angel = 0;
        try {
            Metadata metadata = JpegMetadataReader.readMetadata((File)file);
            Directory directory = metadata.getFirstDirectoryOfType(ExifDirectoryBase.class);
            if (directory != null && directory.containsTag(274)) {
                int orientation = directory.getInt(274);
                if (6 == orientation) {
                    angel = 90;
                } else if (3 == orientation) {
                    angel = 180;
                } else if (8 == orientation) {
                    angel = 270;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return angel;
    }

    public static String zipJpg(String url) throws IOException {
        File file = new File(url);
        if (file.exists()) {
            String newUrl;
            int targetHeight;
            int targetWidth;
            double rate = 0.7;
            BufferedImage sourceImage = ImageIO.read(file);
            BufferedImage bi = PictureDealUtil.resize(sourceImage, targetWidth = (int)((double)sourceImage.getWidth() * rate), targetHeight = (int)((double)sourceImage.getHeight() * rate));
            if (ImageIO.write((RenderedImage)bi, "jpg", new FileOutputStream(newUrl = uploadPath + UUID.randomUUID().toString() + ".jpg"))) {
                return newUrl;
            }
            throw new BusinessException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        return null;
    }

    private static BufferedImage resize(BufferedImage source, int targetWidth, int targetHeight) {
        double sy;
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)targetWidth / (double)source.getWidth();
        if (sx < (sy = (double)targetHeight / (double)source.getHeight())) {
            sx = sy;
            targetWidth = (int)(sx * (double)source.getWidth());
        } else {
            sy = sx;
            targetHeight = (int)(sy * (double)source.getHeight());
        }
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(targetWidth, targetHeight);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(targetWidth, targetHeight, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    static {
        String os = System.getProperty("os.name");
        String path = "upload.linux-path";
        if (os.startsWith("Windows")) {
            path = "upload.win-path";
        }
        uploadPath = ((Environment)SpringUtil.getApplicationContext().getBean(Environment.class)).getProperty(path) + "img" + File.separator;
        fileUrl = ((Environment)SpringUtil.getApplicationContext().getBean(Environment.class)).getProperty("upload.url-path");
    }
}

