/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.parse.service.impl;

import com.biz.eisp.grpc.parse.mapper.AiPriceTagResultMapper;
import com.biz.eisp.grpc.parse.model.AiPriceTagResultEntity;
import com.biz.eisp.grpc.parse.service.impl.ActIdentifyAbstractServiceImpl;
import com.biz.eisp.grpc.service.PriceTagIdentifyService;
import com.biz.eisp.picture.entity.TsPictureEntity;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actPriceTagIdentifyService")
@Transactional
public class ActPriceTagIdentifyServiceImpl
extends ActIdentifyAbstractServiceImpl {
    @Autowired
    private PriceTagIdentifyService priceTagIdentifyService;
    @Autowired
    private AiPriceTagResultMapper aiPriceTagResultMapper;

    @Override
    public void identify(List<TsPictureEntity> tsPictures, String businessId, String appId, String modelName) {
        String errorMsg = null;
        try {
            for (TsPictureEntity tsPicture : tsPictures) {
                String imgPath = tsPicture.getImgUrl();
                List<String> priceList = this.priceTagIdentifyService.identifyPriceTag(appId, modelName, imgPath);
                for (String price : priceList) {
                    AiPriceTagResultEntity aiPriceTagResult = new AiPriceTagResultEntity();
                    aiPriceTagResult.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    aiPriceTagResult.setImgId(businessId);
                    aiPriceTagResult.setCreatedTime(new Date());
                    aiPriceTagResult.setPrice(price);
                    this.aiPriceTagResultMapper.insert(aiPriceTagResult);
                }
            }
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
        this.updateStatus(businessId, true, errorMsg, true);
    }
}

