/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.parse.service.impl;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.grpc.parse.mapper.AiProductRedrawPictureMapper;
import com.biz.eisp.grpc.parse.mapper.AiProductResultMapper;
import com.biz.eisp.grpc.parse.model.AiProductRedrawPictureEntity;
import com.biz.eisp.grpc.parse.model.AiProductResultEntity;
import com.biz.eisp.grpc.parse.service.impl.ActIdentifyAbstractServiceImpl;
import com.biz.eisp.grpc.service.ProductIdentifyService;
import com.biz.eisp.grpc.utils.PictureDealUtil;
import com.biz.eisp.grpc.vo.AiResultVo;
import com.biz.eisp.picture.entity.TsPictureEntity;
import com.biz.eisp.product.TmProductInfoVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actProductIdentifyService")
@Transactional
public class ActProductIdentifyServiceImpl
extends ActIdentifyAbstractServiceImpl {
    @Autowired
    private ProductIdentifyService productIdentifyService;
    @Autowired
    private AiProductRedrawPictureMapper aiProductRedrawPictureMapper;
    @Autowired
    private AiProductResultMapper aiProductResultMapper;
    @Autowired
    private MdmApiFeign mdmApiFeign;

    @Override
    public void identify(List<TsPictureEntity> tsPictures, String businessId, String appId, String modelName) {
        boolean success = true;
        String errorMsg = null;
        try {
            ArrayList<AiResultVo> list = new ArrayList<AiResultVo>();
            for (TsPictureEntity tsPicture : tsPictures) {
                Iterator imgPath = tsPicture.getImgUrl();
                AiResultVo resultVo = this.productIdentifyService.displayIdentify(appId, modelName, (String)((Object)imgPath));
                list.add(resultVo);
            }
            AiProductRedrawPictureEntity tempResult = new AiProductRedrawPictureEntity();
            tempResult.setBusinessId(businessId);
            List tempList = this.aiProductRedrawPictureMapper.select(tempResult);
            for (AiProductRedrawPictureEntity temp : tempList) {
                this.aiProductRedrawPictureMapper.delete(temp);
            }
            for (AiResultVo resultVo : list) {
                String string = PictureDealUtil.reDrawAndUploadImage(resultVo);
                AiProductRedrawPictureEntity aiProductRedrawPicture = new AiProductRedrawPictureEntity();
                aiProductRedrawPicture.setImgPath(string);
                aiProductRedrawPicture.setBusinessId(businessId);
                aiProductRedrawPicture.setCreatedTime(new Date());
                this.aiProductRedrawPictureMapper.insert(aiProductRedrawPicture);
            }
            HashMap<Integer, Integer> prodCountMap = new HashMap<Integer, Integer>();
            for (AiResultVo aiResultVo : list) {
                List<Integer> detectionClasses = aiResultVo.getDetectionClasses();
                for (Integer detectionClass : detectionClasses) {
                    if (prodCountMap.containsKey(detectionClass)) {
                        prodCountMap.put(detectionClass, (Integer)prodCountMap.get(detectionClass) + 1);
                        continue;
                    }
                    prodCountMap.put(detectionClass, 1);
                }
            }
            for (Map.Entry entry : prodCountMap.entrySet()) {
                TmProductInfoVo productInfoVo = (TmProductInfoVo)ApiResultUtil.objResult((AjaxJson)this.mdmApiFeign.getProductInfoDetailByAiCode(((Integer)entry.getKey()).toString()));
                if (null == productInfoVo) continue;
                AiProductResultEntity aiProductResult = new AiProductResultEntity();
                aiProductResult.setCreatedTime(new Date());
                aiProductResult.setProductCode(productInfoVo.getProductInfoCode());
                aiProductResult.setProductName(productInfoVo.getProductInfoName());
                aiProductResult.setProductType(productInfoVo.getProductInfoType());
                aiProductResult.setAiCode(((Integer)entry.getKey()).toString());
                aiProductResult.setProductCount((Integer)entry.getValue());
                aiProductResult.setBusinessId(businessId);
                this.aiProductResultMapper.insert(aiProductResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
            errorMsg = e.getMessage();
        }
        this.updateStatus(businessId, success, errorMsg, false);
    }
}

