/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.grpc.service.PersonnelIdentifyService;
import com.biz.eisp.grpc.service.impl.AiIdentifyAbstractService;
import com.biz.eisp.grpc.vo.AiResultVo;
import java.util.Collections;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="personnelIdentifyService")
@Transactional
public class PersonnelIdentifyServiceImpl
extends AiIdentifyAbstractService
implements PersonnelIdentifyService {
    @Override
    public AiResultVo identifyPersonnel(String appId, String modelName, String imgUrl) {
        String pushContent = null;
        String receiveContent = null;
        try {
            pushContent = this.newRequestBody(appId, modelName, Collections.singletonList(imgUrl));
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, true, null);
            AiResultVo result = (AiResultVo)jsonObject.getObject("result", AiResultVo.class);
            result.setDetectionObject(imgUrl);
            return result;
        }
        catch (BusinessException e) {
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
    }
}

