/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ai.display.service.impl;

import com.biz.eisp.ai.display.dao.TsAiDisplayConfDao;
import com.biz.eisp.ai.display.dao.TsAiDisplayRulesDao;
import com.biz.eisp.ai.display.dao.TsAiDisplayScopeDao;
import com.biz.eisp.ai.display.dao.TsAiDisplayStandardDao;
import com.biz.eisp.ai.display.enity.TsAiDisplayConfEntity;
import com.biz.eisp.ai.display.enity.TsAiDisplayRulesEntity;
import com.biz.eisp.ai.display.enity.TsAiDisplayScopeEntity;
import com.biz.eisp.ai.display.enity.TsAiDisplayStandardEntity;
import com.biz.eisp.ai.display.service.TsAiDisplayConfService;
import com.biz.eisp.ai.display.vo.TsAiDisplayConfVo;
import com.biz.eisp.ai.display.vo.TsAiDisplayRulesVo;
import com.biz.eisp.ai.display.vo.TsAiDisplayScopeVo;
import com.biz.eisp.ai.display.vo.TsAiDisplayStandardVo;
import com.biz.eisp.api.feign.CustomerFeign;
import com.biz.eisp.api.feign.TmTerminalFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TsAiDisplayConfServiceImpl
extends BaseServiceImpl<TsAiDisplayConfEntity>
implements TsAiDisplayConfService {
    private static final Logger log = LoggerFactory.getLogger(TsAiDisplayConfServiceImpl.class);
    @Autowired
    private TsAiDisplayRulesDao tsAiDisplayRulesDao;
    @Autowired
    private TsAiDisplayStandardDao tsAiDisplayStandardDao;
    @Autowired
    private TsAiDisplayScopeDao tsAiDisplayScopeDao;
    @Autowired
    private TmTerminalFeign tmTerminalFeign;
    @Autowired
    private CustomerFeign customerFeign;
    @Autowired
    private TsAiDisplayConfDao tsAiDisplayConfDao;

    @Override
    public PageInfo<TsAiDisplayConfEntity> findDisplayConfPage(Map<String, Object> param, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tsAiDisplayConfDao.findDisplayConfPage(param), (Page)page);
    }

    @Override
    public TsAiDisplayConfVo getDisplayConfId(Integer id) throws Exception {
        TsAiDisplayConfEntity entity = (TsAiDisplayConfEntity)this.selectByPrimaryKey(id);
        if (entity != null) {
            TsAiDisplayConfVo vo = new TsAiDisplayConfVo();
            MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)vo);
            this.getRules(vo, id);
            this.getScope(vo, id);
            this.getStandard(vo, id);
            return vo;
        }
        return null;
    }

    private void getRules(TsAiDisplayConfVo hvo, Integer disPlayId) {
        Example example = new Example(TsAiDisplayRulesEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("displayId", (Object)disPlayId);
        List list = this.tsAiDisplayRulesDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ArrayList vos = new ArrayList();
            list.forEach(item -> {
                TsAiDisplayRulesVo vo = new TsAiDisplayRulesVo();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)vo);
                    vos.add(vo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            });
            hvo.setRulues(vos);
        }
    }

    private void getScope(TsAiDisplayConfVo hvo, Integer disPlayId) {
        Example example = new Example(TsAiDisplayScopeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("displayId", (Object)disPlayId);
        List list = this.tsAiDisplayScopeDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ArrayList vos = new ArrayList();
            list.forEach(item -> {
                TsAiDisplayScopeVo vo = new TsAiDisplayScopeVo();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)vo);
                    vos.add(vo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            });
            hvo.setScopeVos(vos);
        }
    }

    private void getStandard(TsAiDisplayConfVo hvo, Integer disPlayId) {
        Example example = new Example(TsAiDisplayStandardEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("displayId", (Object)disPlayId);
        List list = this.tsAiDisplayStandardDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ArrayList vos = new ArrayList();
            list.forEach(item -> {
                TsAiDisplayStandardVo vo = new TsAiDisplayStandardVo();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)vo);
                    vos.add(vo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            });
            hvo.setStandardVos(vos);
        }
    }

    @Override
    public void saveOrUpdateDisplayConf(TsAiDisplayConfVo vo) throws Exception {
        TsAiDisplayConfEntity entity = new TsAiDisplayConfEntity();
        MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)entity);
        if (StringUtils.isBlank((CharSequence)entity.getDisplayCode())) {
            entity.setDisplayCode(CodeRuleUtil.getKnlCodingRulesString((String)"display_code"));
        }
        if (vo.getId() != null) {
            this.updateByPrimaryKeySelective(entity);
            this.deleteByCon(entity.getId());
        } else {
            this.insertSelective(entity);
        }
        List rulues = vo.getRulues();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)rulues)) {
            throw new BusinessException("\u8bc4\u5224\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList rulesEntities = new ArrayList();
        rulues.forEach(item -> {
            item.setDisplayId(entity.getId());
            TsAiDisplayRulesEntity entity1 = new TsAiDisplayRulesEntity();
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)entity1);
                rulesEntities.add(entity1);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
        this.tsAiDisplayRulesDao.insertList(rulesEntities);
        List scopeVos = vo.getScopeVos();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)scopeVos)) {
            throw new BusinessException("\u9648\u5217\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList scopeEntities = new ArrayList();
        scopeVos.forEach(item -> {
            item.setDisplayId(entity.getId());
            TsAiDisplayScopeEntity entity1 = new TsAiDisplayScopeEntity();
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)entity1);
                scopeEntities.add(entity1);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
        this.tsAiDisplayScopeDao.insertList(scopeEntities);
        List standardVos = vo.getStandardVos();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)standardVos)) {
            throw new BusinessException("\u9648\u5217\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList standardEntities = new ArrayList();
        standardVos.forEach(item -> {
            item.setDisplayId(entity.getId());
            TsAiDisplayStandardEntity entity1 = new TsAiDisplayStandardEntity();
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)item, (Object)entity1);
                standardEntities.add(entity1);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
        this.tsAiDisplayStandardDao.insertList(standardEntities);
    }

    @Override
    public void delDisplayConfId(String ids) {
        this.delByIds(ids);
        String[] arrid = ids.split(",");
        for (int i = 0; i < arrid.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)arrid[i])) continue;
            Integer disPlayId = Integer.parseInt(arrid[i]);
            this.deleteByCon(disPlayId);
        }
    }

    private void deleteByCon(Integer disPlayId) {
        Example example = new Example(TsAiDisplayStandardEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("displayId", (Object)disPlayId);
        this.tsAiDisplayStandardDao.deleteByExample(example);
        Example example1 = new Example(TsAiDisplayScopeEntity.class);
        Example.Criteria criteria1 = example1.createCriteria();
        criteria1.andEqualTo("displayId", (Object)disPlayId);
        this.tsAiDisplayScopeDao.deleteByExample(example1);
        Example example2 = new Example(TsAiDisplayRulesEntity.class);
        Example.Criteria criteria2 = example2.createCriteria();
        criteria2.andEqualTo("displayId", (Object)disPlayId);
        this.tsAiDisplayRulesDao.deleteByExample(example2);
    }

    @Override
    public TsAiDisplayConfVo findOneDisPlayConfObj(String terminalCode) throws Exception {
        String nowDate = DateUtils.getDate((String)"yyyy-MM-dd");
        Example example = new Example(TsAiDisplayConfEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andLessThanOrEqualTo("beginDate", (Object)nowDate);
        criteria.andGreaterThanOrEqualTo("endDate", (Object)nowDate);
        example.orderBy("createDate").desc();
        List confs = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)confs)) {
            AtomicReference finalItem = new AtomicReference();
            confs.forEach(item -> {
                Example exampleScope = new Example(TsAiDisplayScopeEntity.class);
                Example.Criteria criteriaScope = exampleScope.createCriteria();
                criteriaScope.andEqualTo("displayId", (Object)item.getId());
                List list = this.tsAiDisplayScopeDao.selectByExample(exampleScope);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    Set setM = list.stream().filter(dd -> dd.getType().equals("02")).map(TsAiDisplayScopeEntity::getCode).collect(Collectors.toSet());
                    if (!setM.isEmpty() && setM.contains(terminalCode)) {
                        finalItem.set(item);
                    } else {
                        HashSet setM_;
                        List result;
                        List codes = list.stream().filter(dd -> dd.getType().equals("03")).map(TsAiDisplayScopeEntity::getCode).collect(Collectors.toList());
                        if (CollectionUtil.listNotEmptyNotSizeZero(codes) && CollectionUtil.listNotEmptyNotSizeZero((List)(result = ApiResultUtil.listResult((AjaxJson)this.tmTerminalFeign.findTerminalsByOrgCodes(codes)))) && (setM_ = new HashSet(result)) != null && setM_.contains(terminalCode)) {
                            finalItem.set(item);
                        }
                    }
                }
            });
            if (finalItem != null && finalItem.get() != null) {
                TsAiDisplayConfEntity entity = (TsAiDisplayConfEntity)finalItem.get();
                TsAiDisplayConfVo vo = new TsAiDisplayConfVo();
                MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)vo);
                this.getRules(vo, entity.getId());
                this.getStandard(vo, entity.getId());
                return vo;
            }
        }
        return null;
    }

    @Override
    public TsAiDisplayConfVo findOneDisPlayConfObjByCust(String custCode) {
        String nowDate = DateUtils.getDate((String)"yyyy-MM-dd");
        Example example = new Example(TsAiDisplayConfEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andLessThanOrEqualTo("beginDate", (Object)nowDate);
        criteria.andGreaterThanOrEqualTo("endDate", (Object)nowDate);
        example.orderBy("createDate").desc();
        List confs = this.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)confs)) {
            AtomicReference finalItem = new AtomicReference();
            confs.forEach(item -> {
                Example exampleScope = new Example(TsAiDisplayScopeEntity.class);
                Example.Criteria criteriaScope = exampleScope.createCriteria();
                criteriaScope.andEqualTo("displayId", (Object)item.getId());
                List list = this.tsAiDisplayScopeDao.selectByExample(exampleScope);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                    Set setM = list.stream().filter(dd -> dd.getType().equals("01")).map(TsAiDisplayScopeEntity::getCode).collect(Collectors.toSet());
                    if (setM != null && setM.contains(custCode)) {
                        finalItem.set(item);
                    } else {
                        List codes = list.stream().filter(dd -> dd.getType().equals("03")).map(TsAiDisplayScopeEntity::getCode).collect(Collectors.toList());
                        if (CollectionUtil.listNotEmptyNotSizeZero(codes)) {
                            HashSet setM_;
                            List customerEntities = ApiResultUtil.listResult((AjaxJson)this.customerFeign.getCustListByOrgCodes(codes));
                            List<Object> result = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                result = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            }
                            if (CollectionUtil.listNotEmptyNotSizeZero(result) && (setM_ = new HashSet(result)) != null && setM_.contains(custCode)) {
                                finalItem.set(item);
                            }
                        }
                    }
                }
            });
            if (finalItem != null && finalItem.get() != null) {
                TsAiDisplayConfEntity entity = (TsAiDisplayConfEntity)finalItem.get();
                TsAiDisplayConfVo vo = new TsAiDisplayConfVo();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)vo);
                }
                catch (Exception e) {
                    throw new BusinessException("\u5bf9\u8c61\u590d\u5236\u5931\u8d25");
                }
                this.getRules(vo, entity.getId());
                this.getStandard(vo, entity.getId());
                return vo;
            }
        }
        return null;
    }
}

