/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.parse.service.impl;

import com.biz.eisp.grpc.parse.mapper.AiPersonnelRedrawPictureMapper;
import com.biz.eisp.grpc.parse.mapper.AiPersonnelResultMapper;
import com.biz.eisp.grpc.parse.model.AiPersonnelRedrawPictureEntity;
import com.biz.eisp.grpc.parse.model.AiPersonnelResultEntity;
import com.biz.eisp.grpc.parse.service.impl.ActIdentifyAbstractServiceImpl;
import com.biz.eisp.grpc.service.PersonnelIdentifyService;
import com.biz.eisp.grpc.utils.PictureDealUtil;
import com.biz.eisp.grpc.vo.AiResultVo;
import com.biz.eisp.picture.entity.TsPictureEntity;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="actPersonnelIdentifyService")
@Transactional
public class ActPersonnelIdentifyServiceImpl
extends ActIdentifyAbstractServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ActPersonnelIdentifyServiceImpl.class);
    @Autowired
    private PersonnelIdentifyService personnelIdentifyService;
    @Autowired
    private AiPersonnelResultMapper aiPersonnelResultMapper;
    @Autowired
    private AiPersonnelRedrawPictureMapper aiPersonnelRedrawPictureMapper;

    @Override
    public void identify(List<TsPictureEntity> tsPictures, String businessId, String appId, String modelName) {
        boolean success = true;
        String errorMsg = null;
        try {
            for (TsPictureEntity tsPicture : tsPictures) {
                String imgPath = tsPicture.getImgUrl();
                AiResultVo resultVo = this.personnelIdentifyService.identifyPersonnel(appId, modelName, imgPath);
                String newImgPath = PictureDealUtil.drawAndUploadPersonnel(resultVo);
                AiPersonnelRedrawPictureEntity personnelRedrawPicture = new AiPersonnelRedrawPictureEntity();
                personnelRedrawPicture.setImgPath(newImgPath);
                personnelRedrawPicture.setBusinessId(businessId);
                personnelRedrawPicture.setCreatedTime(new Date());
                this.aiPersonnelRedrawPictureMapper.insert(personnelRedrawPicture);
                AiPersonnelResultEntity aiPersonnelResultEntity = new AiPersonnelResultEntity();
                aiPersonnelResultEntity.setImgId(personnelRedrawPicture.getId());
                aiPersonnelResultEntity.setCreatedTime(new Date());
                aiPersonnelResultEntity.setPersonnelNum(Integer.valueOf(resultVo.getDetectionClasses().size()));
                this.aiPersonnelResultMapper.insert(aiPersonnelResultEntity);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            success = false;
            errorMsg = e.getMessage();
        }
        this.updateStatus(businessId, success, errorMsg, false);
    }
}

