/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.grpc.service.SceneIdentifyService;
import com.biz.eisp.grpc.service.impl.AiIdentifyAbstractService;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sceneIdentifyService")
@Transactional
public class SceneIdentifyServiceImpl
extends AiIdentifyAbstractService
implements SceneIdentifyService {
    private static final Logger log = LoggerFactory.getLogger(SceneIdentifyServiceImpl.class);

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String sceneIdentify(String appId, String modelName, String imgPath) {
        String pushContent = null;
        String receiveContent = null;
        try {
            pushContent = this.newRequestBody(appId, modelName, Collections.singletonList(imgPath));
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(imgPath, modelName, null, pushContent, receiveContent, true, null);
            JSONArray jsonArray = jsonObject.getJSONObject("result").getJSONArray("classes");
            if (jsonArray.size() > 0) {
                return jsonArray.getString(0);
            }
        }
        catch (BusinessException e) {
            this.addLog(imgPath, "scene", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.addLog(imgPath, "scene", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        return null;
    }
}

