/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.grpc.service.TerminalIdentifyService;
import com.biz.eisp.grpc.service.impl.AiIdentifyAbstractService;
import com.biz.eisp.grpc.vo.AiTerminalResultVo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalIdentifyService")
@Transactional
public class TerminalIdentifyServiceImpl
extends AiIdentifyAbstractService
implements TerminalIdentifyService {
    private static final Logger log = LoggerFactory.getLogger(TerminalIdentifyServiceImpl.class);

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public AiTerminalResultVo identifyTerminalInfo(String appId, String modelName, String imgUrl) {
        AiTerminalResultVo result = new AiTerminalResultVo();
        String pushContent = null;
        String receiveContent = null;
        try {
            JSONObject extendArgs = new JSONObject();
            extendArgs.put("project", (Object)"\u767e\u5a01POC");
            JSONObject others = new JSONObject();
            others.put("content", (Object)"\u95e8\u5934\u724c");
            extendArgs.put("others", (Object)others);
            pushContent = this.newRequestBody(appId, Collections.singletonList(imgUrl), extendArgs);
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(imgUrl, modelName, null, pushContent, receiveContent, true, null);
            JSONArray ocrArray = jsonObject.getJSONArray("result");
            for (int i = 0; i < ocrArray.size(); ++i) {
                JSONObject ocrInfo = ocrArray.getJSONObject(i);
                List ocrList = JSONObject.parseArray((String)ocrInfo.getString("ocr"), String.class);
                String field = ocrInfo.getString("field");
                if ("\u7535\u8bdd".equals(field)) {
                    result.setTerminalTel(String.join((CharSequence)",", ocrList));
                    continue;
                }
                if ("\u4e3b\u4f53\u6587\u5b57".equals(field)) {
                    result.setTerminalName(String.join((CharSequence)",", ocrList));
                    continue;
                }
                if (!"\u5730\u5740".equals(field)) continue;
                result.setTerminalAddress(String.join((CharSequence)",", ocrList));
            }
            return result;
        }
        catch (BusinessException e) {
            this.addLog(imgUrl, "terminal_info", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.addLog(imgUrl, "terminal_info", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean identifyTerminalLogo(String imgUrl) {
        String pushContent = null;
        String receiveContent = null;
        try {
            pushContent = this.newRequestBody("tensorflow", "baiwei_dianzhao", Collections.singletonList(imgUrl));
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(imgUrl, "terminal_logo", null, pushContent, receiveContent, true, null);
            JSONArray detectionClasses = jsonObject.getJSONObject("result").getJSONArray("detection_classes");
            boolean hasLogo = false;
            for (int i = 0; i < detectionClasses.size(); ++i) {
                int detectionClassesIntValue = detectionClasses.getIntValue(i);
                if (detectionClassesIntValue != 1) continue;
                hasLogo = true;
                break;
            }
            return hasLogo;
        }
        catch (BusinessException e) {
            this.addLog(imgUrl, "terminal_logo", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.addLog(imgUrl, "terminal_logo", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String identifyTerminalColor(String imgUrl) {
        String pushContent = null;
        String receiveContent = null;
        try {
            pushContent = this.newRequestBody("shop_signboard_color", Collections.singletonList(imgUrl));
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            this.addLog(imgUrl, "terminal_color", null, pushContent, receiveContent, true, null);
            JSONArray array = jsonObject.getJSONArray("result");
            if (array.size() == 0) {
                return null;
            }
            JSONArray mainColor = array.getJSONObject(0).getJSONArray("main_color");
            if (mainColor.size() == 0) {
                return null;
            }
            return mainColor.getJSONObject(0).getString("color_name");
        }
        catch (BusinessException e) {
            this.addLog(imgUrl, "terminal_color", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.addLog(imgUrl, "terminal_color", null, pushContent, receiveContent, false, e.getMessage());
            throw e;
        }
    }
}

