/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.grpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.grpc.service.PriceTagIdentifyService;
import com.biz.eisp.grpc.service.impl.AiIdentifyAbstractService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="priceTagIdentifyService")
@Transactional
public class PriceTagIdentifyServiceImpl
extends AiIdentifyAbstractService
implements PriceTagIdentifyService {
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<String> identifyPriceTag(String appId, String modelName, String imgPath) {
        String pushContent = null;
        String receiveContent = null;
        try {
            JSONObject extendArgs = new JSONObject();
            extendArgs.put("project", (Object)"\u767e\u5a01POC");
            JSONObject others = new JSONObject();
            others.put("content", (Object)"\u4ef7\u7b7e");
            extendArgs.put("others", (Object)others);
            pushContent = this.newRequestBody(appId, Collections.singletonList(imgPath), extendArgs);
            JSONObject jsonObject = this.aiIdentify(pushContent);
            receiveContent = jsonObject.toJSONString();
            if (jsonObject.containsKey((Object)"error_msg")) {
                throw new BusinessException(jsonObject.getString("error_msg"));
            }
            JSONArray resultArray = jsonObject.getJSONArray("result");
            if (resultArray.size() == 0) {
                return new ArrayList<String>();
            }
            this.addLog(imgPath, modelName, null, pushContent, receiveContent, true, null);
            ArrayList<String> priceList = new ArrayList<String>();
            for (int i = 0; i < resultArray.size(); ++i) {
                JSONArray orrArray = resultArray.getJSONObject(i).getJSONArray("ocr");
                if (orrArray.size() <= 0) continue;
                priceList.addAll(JSONObject.parseArray((String)orrArray.toString(), String.class));
            }
            return priceList;
        }
        catch (Exception e) {
            this.addLog(imgPath, modelName, null, pushContent, receiveContent, true, e.getMessage());
            throw e;
        }
    }
}

