/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.order;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.order.service.TsOrderService;
import com.biz.eisp.order.vo.TsCompetitiveGoodsVo;
import com.biz.eisp.order.vo.TsOrderItemVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tsOrderController"})
public class TsOrderController {
    @Autowired
    TsOrderService tsOrderService;

    @RequestMapping(value={"goOrderMain"})
    public String goOrderMain(HttpServletRequest request, Model model) {
        return "order/goOrderMain";
    }

    @RequestMapping(value={"goCompetitiveMain"})
    public String goCompetitiveMain(HttpServletRequest request, Model model) {
        return "order/goCompetitiveMain";
    }

    @RequestMapping(value={"findOrderItemList"})
    @ResponseBody
    public DataGrid findOrderItemList(HttpServletRequest request, TsOrderItemVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsOrderItemVo> ttSalesPlansVoPageInfo = this.tsOrderService.findOrderItemList(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"findCompetitiveList"})
    @ResponseBody
    public DataGrid findCompetitiveList(HttpServletRequest request, TsCompetitiveGoodsVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<TsCompetitiveGoodsVo> ttSalesPlansVoPageInfo = this.tsOrderService.findCompetitiveList(vo, (Page)page);
        if (ttSalesPlansVoPageInfo != null) {
            return new DataGrid(ttSalesPlansVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"toAddPage"})
    public String toAddPage(HttpServletRequest request, TsCompetitiveGoodsVo vo, Model model) {
        if (StringUtil.isNotEmpty((CharSequence)vo.getId())) {
            TsCompetitiveGoodsVo tsFreesignConfigVo = this.tsOrderService.findCompetitiveInfoById(vo.getId());
            model.addAttribute("vo", (Object)tsFreesignConfigVo);
        } else {
            model.addAttribute("vo", (Object)new TsCompetitiveGoodsVo());
        }
        return "order/toAddPage";
    }

    @RequestMapping(value={"addCompetitiveGoods"})
    @ResponseBody
    public AjaxJson addCompetitiveGoods(TsCompetitiveGoodsVo vo) {
        AjaxJson ajaxJson = this.tsOrderService.addCompetitiveGoods(vo);
        return ajaxJson;
    }
}

