/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktrack;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.worktrack.service.TsWorkTrackService;
import com.biz.eisp.worktrack.util.TimeUtils;
import com.biz.eisp.worktrack.vo.AddTerminalPointVo;
import com.biz.eisp.worktrack.vo.AddTerminalVo;
import com.biz.eisp.worktrack.vo.BaiduYingyanQueryTerminalVo;
import com.biz.eisp.worktrack.vo.GetTrackPramsVo;
import com.biz.eisp.worktrack.vo.GetTrackVo;
import com.biz.eisp.worktrack.vo.TrackByDateAndTypePramsVo;
import com.biz.eisp.worktrack.vo.TrackByDatePramsVo;
import com.biz.eisp.worktrack.vo.TrackDistancePramsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u4f5c\u8f68\u8ff9"})
@RestController
@RequestMapping(value={"/sfaApi/tsWorkTrackApiController"})
public class TsWorkTrackApiController {
    @Autowired
    private TsWorkTrackService tsWorkTrackService;

    @PostMapping(value={"getWorkTrackEnterpriseUsers"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u4f01\u4e1a\u7528\u6237", notes="\u67e5\u8be2\u6240\u6709\u4f01\u4e1a\u7528\u6237", httpMethod="POST")
    public AjaxJson getWorkTrackEnterpriseUsers(@RequestBody BaiduYingyanQueryTerminalVo vo) {
        AjaxJson j = this.tsWorkTrackService.listWorkTrackEntity(vo);
        return j;
    }

    @PostMapping(value={"addWorkTrackEntity"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec8\u7aef", notes="\u4fdd\u5b58\u7ec8\u7aef", httpMethod="POST")
    public AjaxJson addWorkTrackEntity(@RequestBody AddTerminalVo vo) {
        AjaxJson j = this.tsWorkTrackService.addWorkTrackEntity(vo);
        return j;
    }

    @PostMapping(value={"updateWorkTrackEntity"})
    @ApiOperation(value="\u66f4\u65b0\u7ec8\u7aef", notes="\u66f4\u65b0\u7ec8\u7aef", httpMethod="POST")
    public AjaxJson updateWorkTrackEntity(@RequestBody AddTerminalVo vo) {
        AjaxJson j = this.tsWorkTrackService.updateWorkTrackEntity(vo);
        return j;
    }

    @PostMapping(value={"deleteWorkTrackEntity"})
    @ApiOperation(value="\u5220\u9664\u7ec8\u7aef", notes="\u4f20\u5165\u7528\u6237ID", httpMethod="POST")
    public AjaxJson deleteWorkTrackEntity(@RequestBody String entity_name) {
        AjaxJson j = this.tsWorkTrackService.deleteWorkTrackEntity(entity_name);
        return j;
    }

    @PostMapping(value={"addPoints"})
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u8f68\u8ff9\u70b9", notes="\u4e0a\u4f20\u7528\u6237\u8f68\u8ff9\u70b9\uff0c\u9700\u8981\u4e0a\u4f20\u7528\u6237\u4fe1\u606f\u53ca\u5176\u7ecf\u7eac\u5ea6", httpMethod="POST")
    public AjaxJson addPoints(@RequestBody AddTerminalPointVo vo) {
        AjaxJson j = new AjaxJson();
        if (UserUtils.getUser() == null && StringUtil.isEmpty((String)UserUtils.getUser().getId())) {
            j.setSuccess(false);
            j.setMsg("\u8bf7\u767b\u5f55\uff01");
            return j;
        }
        j = this.tsWorkTrackService.addWorkTrackPoints(vo);
        String ss = DictUtil.getDictDataVal((String)"sfa_upload_time", (String)"S");
        j.setObj((Object)ss);
        return j;
    }

    @PostMapping(value={"getTrack"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u8f68\u8ff9\u70b9", notes="\u4e0a\u4f20\u7528\u6237\u4fe1\u606f\uff0c\u8d77\u59cb\u65f6\u95f4\u6233", httpMethod="POST")
    public AjaxJson getTrack(@RequestBody GetTrackPramsVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getDateTime())) {
            j.setSuccess(false);
            j.setMsg("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return j;
        }
        if (StringUtil.isEmpty((String)vo.getEntityName())) {
            j.setSuccess(false);
            j.setMsg("\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return j;
        }
        String userId = UserUtils.getUser().getId();
        if (StringUtil.isEmpty((String)userId)) {
            j.setSuccess(false);
            j.setMsg("\u8bf7\u767b\u5f55\uff01\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            return j;
        }
        GetTrackVo v = new GetTrackVo();
        v.setEntity_name(vo.getEntityName());
        v.setStart_time(DateUtils.Date2TimeStamp((String)TimeUtils.dateStartStr(vo.getDateTime()), (String)"yyyy-MM-dd HH:mm:ss"));
        v.setEnd_time(DateUtils.Date2TimeStamp((String)TimeUtils.dateEndStr(vo.getDateTime()), (String)"yyyy-MM-dd HH:mm:ss"));
        try {
            j = this.tsWorkTrackService.getTrack(v);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @PostMapping(value={"getTrackArea"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u884c\u653f\u533a\u4eba\u5458\u5206\u5e03\u60c5\u51b5", notes="\u67e5\u8be2\u6240\u6709\u884c\u653f\u533a\u4eba\u5458\u5206\u5e03\u60c5\u51b5", httpMethod="POST")
    public AjaxJson getTrackArea() {
        AjaxJson j = this.tsWorkTrackService.getTrackArea();
        return j;
    }

    @PostMapping(value={"getTrackDistanceByEntityName"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6700\u8fd120\u5929\u7684\u8f68\u8ff9\u8ddd\u79bb", notes="\u4e0a\u4f20\u7528\u6237\u4fe1\u606f", httpMethod="POST")
    public AjaxJson getTrackDistanceByEntityName(@RequestBody TrackDistancePramsVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getEntityName())) {
            j.setSuccess(false);
            j.setMsg("\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return j;
        }
        try {
            j = this.tsWorkTrackService.getTrackDistanceByEntityName(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @PostMapping(value={"getTrackByDate"})
    @ApiOperation(value="\u8f68\u8ff9\u5206\u6790\u67e5\u8be2\u6839\u636e\u5e74\u6708\u65e5\u67e5\u8be2\u5f53\u5929\u7684\u8f68\u8ff9\u7c7b\u578b\u6570\u636e", notes="\u65e5\u671f\uff08yyyy-MM-dd\uff09", httpMethod="POST")
    public AjaxJson getTrackByDate(@RequestBody TrackByDatePramsVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getDateStr())) {
            j.setSuccess(false);
            j.setMsg("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            return j;
        }
        try {
            j = this.tsWorkTrackService.getTrackByDate(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @PostMapping(value={"getTrackByDateAndType"})
    @ApiOperation(value="\u8f68\u8ff9\u5206\u6790\u6839\u636e\u548c\u8f68\u8ff9\u7c7b\u578b\u660e\u7ec6\u6570\u636e", notes="\u65e5\u671f\uff08yyyy-MM-dd\uff09\u548c\u8f68\u8ff9\u7c7b\u578b", httpMethod="POST")
    public AjaxJson getTrackByDateAndType(@RequestBody TrackByDateAndTypePramsVo vo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isEmpty((String)vo.getDateStr())) {
            j.setSuccess(false);
            j.setMsg("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            return j;
        }
        try {
            j = this.tsWorkTrackService.getTrackByDateAndType(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }
}

