/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.worktrack.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.worktrack.model.LatLng;
import com.biz.eisp.worktrack.model.TrackPoint;
import com.biz.eisp.worktrack.util.CommonUtils;
import com.biz.eisp.worktrack.util.HttpUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TrackUtils {
    public static boolean checkLatLng(LatLng latLng) {
        if (null == latLng) {
            throw new BusinessException("latLng can not be null");
        }
        if (Math.abs(latLng.getLatitude()) > 90.0 || Math.abs(latLng.getLongitude()) > 180.0) {
            throw new BusinessException("latLng is invalid value");
        }
        return true;
    }

    public static void packPoint(TrackPoint trackPoint, StringBuilder parameters) {
        LatLng location = trackPoint.getLocation();
        if (TrackUtils.checkLatLng(location)) {
            parameters.append("&latitude=").append(location.getLatitude());
            parameters.append("&longitude=").append(location.getLongitude());
        }
        parameters.append("&loc_time=").append(trackPoint.getLocTime());
        if (null == trackPoint.getCoordType()) {
            throw new BusinessException("coordType can not be null.");
        }
        parameters.append("&coord_type_input=").append(trackPoint.getCoordType().name());
        parameters.append("&speed=").append(trackPoint.getSpeed());
        parameters.append("&direction=").append(trackPoint.getDirection());
        parameters.append("&height=").append(trackPoint.getHeight());
        parameters.append("&radius=").append(trackPoint.getRadius());
        if (!CommonUtils.isNullOrEmpty(trackPoint.getObjectKey())) {
            parameters.append("&_obejct_key=").append(HttpUtils.urlEncode(trackPoint.getObjectKey()));
        }
        if (null != trackPoint.getColumns()) {
            TrackUtils.packColumns((Map<String, String>)trackPoint.getColumns(), parameters);
        }
    }

    public static void packPoints(List<TrackPoint> points, StringBuilder parameters) {
        if (null == points) {
            throw new BusinessException("track points can not be null.");
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (TrackPoint trackPoint : points) {
                if (null == trackPoint) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("entity_name", (Object)trackPoint.getEntityName());
                jsonObject.put("loc_time", (Object)trackPoint.getLocTime());
                LatLng location = trackPoint.getLocation();
                if (TrackUtils.checkLatLng(location)) {
                    jsonObject.put("latitude", (Object)location.getLatitude());
                    jsonObject.put("longitude", (Object)location.getLongitude());
                }
                if (null == trackPoint.getCoordType()) {
                    throw new BusinessException("coordType can not be null.");
                }
                jsonObject.put("coord_type_input", (Object)trackPoint.getCoordType().name());
                jsonObject.put("speed", (Object)trackPoint.getSpeed());
                jsonObject.put("direction", (Object)trackPoint.getDirection());
                jsonObject.put("height", (Object)trackPoint.getHeight());
                jsonObject.put("radius", (Object)trackPoint.getRadius());
                Map columns = trackPoint.getColumns();
                if (null != columns) {
                    TrackUtils.packColumns((Map<String, String>)columns, jsonObject);
                }
                jsonArray.add((Object)jsonObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BusinessException("\u4e0a\u4f20\u5de5\u4f5c\u8f68\u8ff9\u70b9\u7ec4\u7ec7\u6570\u636e\u5931\u8d25!");
        }
        parameters.append("&point_list=").append(jsonArray.toString());
    }

    public static void packColumns(Map<String, String> columns, StringBuilder parameters) {
        for (Map.Entry<String, String> entry : columns.entrySet()) {
            parameters.append("&").append(entry.getKey()).append("=").append(HttpUtils.urlEncode(entry.getValue()));
        }
    }

    private static void packColumns(Map<String, String> columns, JSONObject jsonObject) {
        for (Map.Entry<String, String> column : columns.entrySet()) {
            if (StringUtils.isEmpty((String)column.getKey()) || StringUtils.isEmpty((String)column.getValue())) continue;
            try {
                jsonObject.put(column.getKey(), (Object)HttpUtils.urlEncode(column.getValue()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

